/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.InstructionDetails;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;

public class Trace
extends SystemFunction {
    public int getSpecialProperties(Expression[] arguments) {
        return arguments[0].getSpecialProperties();
    }

    public int getCardinality(Expression[] arguments) {
        return arguments[0].getCardinality();
    }

    public void notifyListener(String label, Sequence val, SourceLocator loc, XPathContext context) {
        InstructionDetails info = new InstructionDetails();
        info.setConstructType(2041);
        info.setLineNumber(loc.getLineNumber());
        info.setSystemId(loc.getSystemId());
        info.setProperty("label", label);
        info.setProperty("value", val);
        TraceListener listener = context.getController().getTraceListener();
        listener.enter(info, context);
        listener.leave(info);
    }

    public static void traceItem(Item val, String label, Logger out) {
        if (val == null) {
            out.info(label);
        } else if (val instanceof NodeInfo) {
            out.info(label + ": " + Type.displayTypeName(val) + ": " + Navigator.getPath((NodeInfo)val));
        } else if (val instanceof AtomicValue || val instanceof ObjectValue) {
            out.info(label + ": " + Type.displayTypeName(val) + ": " + val.getStringValue());
        } else if (val instanceof ArrayItem || val instanceof MapItem) {
            out.info(label + ": " + val.toString());
        } else if (val instanceof Function) {
            StructuredQName name = ((Function)val).getFunctionName();
            out.info(label + ": function " + (name == null ? "(anon)" : name.getDisplayName()) + "#" + ((Function)val).getArity());
        }
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String label;
        Controller controller = context.getController();
        String string = label = arguments.length == 1 ? "*" : arguments[1].head().getStringValue();
        if (controller.isTracing()) {
            GroundedValue value = SequenceExtent.makeSequenceExtent(arguments[0].iterate());
            this.notifyListener(label, value, null, context);
            return value;
        }
        Logger out = controller.getTraceFunctionDestination();
        if (out == null) {
            return arguments[0];
        }
        return SequenceTool.toLazySequence(new TracingIterator(arguments[0].iterate(), label, out));
    }

    private class TracingIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private String label;
        private Logger out;
        private boolean empty = true;
        private int position = 0;

        public TracingIterator(SequenceIterator base, String label, Logger out) {
            this.base = base;
            this.label = label;
            this.out = out;
        }

        public Item next() throws XPathException {
            Item n = this.base.next();
            ++this.position;
            if (n == null) {
                if (this.empty) {
                    Trace.traceItem(null, this.label + ": empty sequence", this.out);
                }
            } else {
                Trace.traceItem(n, this.label + " [" + this.position + ']', this.out);
                this.empty = false;
            }
            return n;
        }

        public void close() {
            this.base.close();
        }

        public TracingIterator getAnother() throws XPathException {
            return new TracingIterator(this.base.getAnother(), this.label, this.out);
        }

        public int getProperties() {
            return 0;
        }
    }
}

