/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CastToUnion;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;

public class CastableToUnion
extends UnaryExpression {
    private UnionType targetType;
    private boolean allowEmpty;

    public CastableToUnion(Expression source, UnionType targetType, boolean allowEmpty) {
        super(source);
        this.targetType = targetType;
        this.allowEmpty = allowEmpty;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public UnionType getTargetType() {
        return this.targetType;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getRetainedStaticContext();
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        Expression operand = this.getBaseExpression();
        if (operand instanceof Literal) {
            GroundedValue literalOperand = ((Literal)operand).getValue();
            if (literalOperand instanceof AtomicValue) {
                BooleanValue av = this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext());
                return Literal.makeLiteral(av);
            }
            if (literalOperand.getLength() == 0) {
                return Literal.makeLiteral(BooleanValue.get(this.allowEmpty));
            }
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e2 = super.optimize(visitor, contextInfo);
        if (e2 != this) {
            return e2;
        }
        if (!Cardinality.allowsZero(this.getBaseExpression().getCardinality())) {
            this.allowEmpty = false;
            this.resetLocalStaticProperties();
        }
        return this;
    }

    public int computeCardinality() {
        return this.allowEmpty && Cardinality.allowsZero(this.getBaseExpression().getCardinality()) ? 24576 : 16384;
    }

    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy() {
        CastableToUnion c = new CastableToUnion(this.getBaseExpression().copy(), this.targetType, this.allowEmpty);
        ExpressionTool.copyLocationInfo(this, c);
        return c;
    }

    public int getImplementationMethod() {
        return 1;
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        Item item;
        int count = 0;
        SequenceIterator iter = this.getBaseExpression().iterate(context);
        while ((item = iter.next()) != null) {
            if (item instanceof NodeInfo) {
                AtomicValue av;
                AtomicSequence atomizedValue = item.atomize();
                int length = SequenceTool.getLength(atomizedValue);
                if ((count += length) > 1) {
                    return false;
                }
                if (length == 0 || CastToUnion.castable(av = atomizedValue.head(), this.targetType, this.getRetainedStaticContext(), context)) continue;
                return false;
            }
            if (item instanceof AtomicValue) {
                AtomicValue av = (AtomicValue)item;
                if (++count > 1) {
                    return false;
                }
                if (CastToUnion.castable(av, this.targetType, this.getRetainedStaticContext(), context)) continue;
                return false;
            }
            throw new XPathException("Input to 'castable' operator cannot be atomized", "XPTY0004");
        }
        return count != 0 || this.allowEmpty;
    }

    public boolean equals(Object other) {
        return super.equals(other) && other instanceof CastableToUnion && this.targetType == ((CastableToUnion)other).targetType && this.allowEmpty == ((CastableToUnion)other).allowEmpty;
    }

    public int hashCode() {
        return super.hashCode() ^ this.targetType.hashCode();
    }

    public String toString() {
        return this.getBaseExpression().toString() + " castable as " + this.targetType.getEQName();
    }

    public void export(ExpressionPresenter out) {
        out.startElement("castableToUnion", this);
        out.emitAttribute("as", this.targetType.getEQName());
        this.getBaseExpression().export(out);
        out.endElement();
    }
}

