/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jxls.controller.SheetTransformationController;
import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.formula.ListRange;
import net.sf.jxls.parser.Property;
import net.sf.jxls.transformation.ResultTransformation;
import net.sf.jxls.transformer.BaseRowTransformer;
import net.sf.jxls.transformer.Configuration;
import net.sf.jxls.transformer.Row;
import net.sf.jxls.transformer.RowCollection;
import net.sf.jxls.transformer.SheetTransformer;
import net.sf.jxls.transformer.SimpleRowTransformer;
import net.sf.jxls.util.Util;

public class CollectionRowTransformer
extends BaseRowTransformer {
    private Configuration configuration;
    private List cellProcessors = new ArrayList();
    List rowCollections = new ArrayList();
    private ResultTransformation resultTransformation;
    private Set fixedSizeCollections = new HashSet();

    public CollectionRowTransformer(Row row, Set fixedSizeCollections, List cellProcessors, List rowProcessors, Configuration configuration) {
        this.fixedSizeCollections = fixedSizeCollections;
        this.cellProcessors = cellProcessors;
        this.configuration = configuration;
        this.row = row;
    }

    public ResultTransformation getTransformationResult() {
        return this.resultTransformation;
    }

    void addRowCollection(RowCollection rowCollection) {
        this.rowCollections.add(rowCollection);
    }

    public ResultTransformation transform(SheetTransformationController stc, SheetTransformer sheetTransformer, Map beans, ResultTransformation previousTransformation) {
        try {
            SimpleRowTransformer simpleRowTransformer = new SimpleRowTransformer(this.row, this.cellProcessors, this.configuration);
            simpleRowTransformer.transform(stc, sheetTransformer, beans, null);
            this.resultTransformation = this.processRowCollections(stc, sheetTransformer, beans);
            sheetTransformer.groupRows(this.row.getSheet());
        }
        catch (ParsePropertyException e) {
            e.printStackTrace();
            this.resultTransformation = new ResultTransformation(0);
        }
        return this.resultTransformation;
    }

    ResultTransformation processRowCollections(SheetTransformationController sheetTransformationController, SheetTransformer sheetTransformer, Map beans) throws ParsePropertyException {
        int maxShiftNumber = 0;
        int rowNum = this.row.getPoiRow().getRowNum();
        HashSet keys = new HashSet(beans.keySet());
        int c = this.row.getRowCollections().size();
        for (int i = 0; i < c; ++i) {
            RowCollection rowCollection = (RowCollection)this.row.getRowCollections().get(i);
            if (!rowCollection.getCollectionProperty().getCollection().isEmpty()) {
                Property collectionProperty = rowCollection.getCollectionProperty();
                String collectionItem = this.generateCollectionItem(collectionProperty.getFullCollectionName(), keys);
                rowCollection.setCollectionItemName(collectionItem);
                keys.add(collectionItem);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("----collection-property--------->" + collectionProperty.getCollectionName()));
                }
                ListRange listRange = new ListRange(rowNum, rowNum + collectionProperty.getCollection().size() - 1, 0);
                listRange.setListName(collectionProperty.getCollectionName());
                listRange.setListAlias(rowCollection.getCollectionItemName());
                this.addListRange(this.row.getSheet(), rowCollection.getCollectionItemName(), listRange);
                this.addListRange(this.row.getSheet(), collectionProperty.getFullCollectionName(), listRange);
                if (!this.fixedSizeCollections.contains(collectionProperty.getCollectionName())) {
                    Util.prepareCollectionPropertyInRowForDuplication(rowCollection, rowCollection.getCollectionItemName());
                    sheetTransformationController.duplicateRow(rowCollection);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Fixed size collection found: " + collectionProperty.getCollectionName()));
                }
                if (rowCollection.getDependentRowNumber() != 0) {
                    log.warn((Object)"Dependent rows for fixed size collections are not supported.");
                }
                Util.prepareCollectionPropertyInRowForContentDuplication(rowCollection);
                Util.duplicateRowCollectionProperty(rowCollection);
                continue;
            }
            Util.removeRowCollectionPropertiesFromRow(rowCollection);
        }
        if (this.row.getRowCollections().size() > 0) {
            int i;
            RowCollection maxSizeCollection = this.row.getMaxSizeCollection();
            int minDependentRowNumber = this.row.getMinDependentRowNumber();
            int mainShiftNumber = 0;
            int c2 = this.row.getRowCollections().size();
            for (i = 0; i < c2; ++i) {
                RowCollection rowCollection = (RowCollection)this.row.getRowCollections().get(i);
                rowCollection.createIterator(minDependentRowNumber);
            }
            for (int k = 0; k < maxSizeCollection.getCollectionProperty().getCollection().size(); ++k) {
                int c3 = this.row.getRowCollections().size();
                for (int i2 = 0; i2 < c3; ++i2) {
                    RowCollection rowCollection = (RowCollection)this.row.getRowCollections().get(i2);
                    if (!rowCollection.hasNextObject()) continue;
                    Object o = rowCollection.getNextObject();
                    beans.put(rowCollection.getCollectionItemName(), o);
                }
                ResultTransformation processResult = sheetTransformer.processRows(sheetTransformationController, this.row.getSheet(), rowNum + (minDependentRowNumber + 1) * k, rowNum + (minDependentRowNumber + 1) * k + minDependentRowNumber, beans, this.row);
                int shiftNumber = processResult.getNextRowShift();
                mainShiftNumber += shiftNumber + 1;
                rowNum += shiftNumber;
            }
            c = this.row.getRowCollections().size();
            for (i = 0; i < c; ++i) {
                RowCollection rowCollection = (RowCollection)this.row.getRowCollections().get(i);
                beans.remove(rowCollection.getCollectionItemName());
            }
            if (mainShiftNumber - 1 > maxShiftNumber) {
                maxShiftNumber = mainShiftNumber - 1;
            }
        }
        return new ResultTransformation(maxShiftNumber, maxShiftNumber);
    }

    private String generateCollectionItem(String collectionName, Set keys) {
        String origKey = collectionName.replace('.', '_');
        String key = origKey + "_JxLsC_";
        int index = 0;
        while (keys.contains(key)) {
            key = origKey + index++ + "_JxLsC_";
        }
        return key;
    }
}

