/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.xml.lib;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import net.revelc.code.formatter.xml.lib.FormattingPreferences;
import net.revelc.code.formatter.xml.lib.Mode;

public class XMLTagFormatter {
    public String format(String tagText, String indent, String lineDelimiter, FormattingPreferences prefs) {
        Tag tag;
        if (tagText.startsWith("</") || tagText.startsWith("<%") || tagText.startsWith("<?") || tagText.startsWith("<[")) {
            return tagText;
        }
        try {
            tag = new TagParser().parse(tagText);
        }
        catch (ParseException e) {
            return tagText;
        }
        return new TagFormatter(prefs).format(tag, indent, lineDelimiter);
    }

    protected static class TagParser {
        private String fElementName;
        private String fParseText;

        protected TagParser() {
        }

        protected List<AttributePair> getAttibutes(String elementText) throws ParseException {
            ArrayList<AttributePair> attributePairs = new ArrayList<AttributePair>();
            StringCharacterIterator iter = new StringCharacterIterator(elementText.substring(this.getElementName(elementText).length() + 2));
            Mode mode = new Mode();
            mode.setAttributeNameSearching();
            char attributeQuote = '\"';
            StringBuilder currentAttributeName = null;
            StringBuilder currentAttributeValue = null;
            char c = iter.first();
            while (iter.getIndex() < iter.getEndIndex()) {
                switch (c) {
                    case '\"': 
                    case '\'': {
                        if (mode.isAttributeValueSearching()) {
                            attributeQuote = c;
                            mode.setAttributeValueFound();
                            currentAttributeValue = new StringBuilder(1024);
                            break;
                        }
                        if (mode.isAttributeValueFound() && attributeQuote == c) {
                            assert (currentAttributeName != null);
                            assert (currentAttributeValue != null);
                            AttributePair pair = new AttributePair(currentAttributeName.toString(), currentAttributeValue.toString(), attributeQuote);
                            attributePairs.add(pair);
                            mode.setAttributeNameSearching();
                            break;
                        }
                        if (mode.isAttributeValueFound() && attributeQuote != c) {
                            assert (currentAttributeValue != null);
                            currentAttributeValue.append(c);
                            break;
                        }
                        this.parseException(elementText, c);
                        break;
                    }
                    case '=': {
                        if (mode.isAttributeValueFound()) {
                            assert (currentAttributeValue != null);
                            currentAttributeValue.append(c);
                            break;
                        }
                        if (mode.isAttributeNameFound()) {
                            mode.setAttributeValueSearching();
                            break;
                        }
                        this.parseException(elementText, c);
                        break;
                    }
                    case '/': 
                    case '>': {
                        if (mode.isAttributeValueFound()) {
                            assert (currentAttributeValue != null);
                            currentAttributeValue.append(c);
                            break;
                        }
                        if (mode.isAttributeNameSearching()) {
                            mode.setFinished();
                            break;
                        }
                        if (mode.isFinished()) break;
                        this.parseException(elementText, c);
                        break;
                    }
                    default: {
                        if (mode.isAttributeValueFound()) {
                            assert (currentAttributeValue != null);
                            currentAttributeValue.append(c);
                            break;
                        }
                        if (mode.isFinished()) {
                            if (Character.isWhitespace(c)) break;
                            this.parseException(elementText, c);
                            break;
                        }
                        if (Character.isWhitespace(c)) break;
                        if (mode.isAttributeNameSearching()) {
                            mode.setAttributeNameFound();
                            currentAttributeName = new StringBuilder(255);
                            currentAttributeName.append(c);
                            break;
                        }
                        if (!mode.isAttributeNameFound()) break;
                        assert (currentAttributeName != null);
                        currentAttributeName.append(c);
                    }
                }
                c = iter.next();
            }
            if (!mode.isFinished()) {
                throw new ParseException("Element did not complete normally.");
            }
            return attributePairs;
        }

        private void parseException(String elementText, char c) throws ParseException {
            throw new ParseException("Unexpected '" + c + "' when parsing:\n\t" + elementText);
        }

        protected String getElementName(String tagText) throws ParseException {
            if (!tagText.equals(this.fParseText) || this.fElementName == null) {
                int endOfTag = this.tagEnd(tagText);
                if (tagText.length() <= 2 || endOfTag <= 1) {
                    throw new ParseException("No element name for the tag:\n\t" + tagText);
                }
                this.fParseText = tagText;
                this.fElementName = tagText.substring(1, endOfTag);
            }
            return this.fElementName;
        }

        protected boolean isClosed(String tagText) {
            return tagText.charAt(tagText.lastIndexOf(62) - 1) == '/';
        }

        public Tag parse(String tagText) throws ParseException {
            Tag tag = new Tag();
            tag.setElementName(this.getElementName(tagText));
            tag.setAttributes(this.getAttibutes(tagText));
            tag.setClosed(this.isClosed(tagText));
            return tag;
        }

        private int tagEnd(String text) {
            for (int i = 1; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (Character.isLetterOrDigit(c) || c == ':' || c == '.' || c == '-' || c == '_') continue;
                return i;
            }
            return -1;
        }
    }

    protected static class Tag {
        private List<AttributePair> fAttributes = new ArrayList<AttributePair>();
        private boolean fClosed;
        private String fElementName;

        protected Tag() {
        }

        public void addAttribute(String attribute, String value, char quote) {
            this.fAttributes.add(new AttributePair(attribute, value, quote));
        }

        public int attributeCount() {
            return this.fAttributes.size();
        }

        public AttributePair getAttributePair(int i) {
            return this.fAttributes.get(i);
        }

        public String getElementName() {
            return this.fElementName;
        }

        public void setElementName(String elementName) {
            this.fElementName = elementName;
        }

        public boolean isClosed() {
            return this.fClosed;
        }

        public void setClosed(boolean closed) {
            this.fClosed = closed;
        }

        public int minimumLength() {
            int length = 2;
            if (this.isClosed()) {
                ++length;
            }
            length += this.getElementName().length();
            if (this.attributeCount() > 0 || this.isClosed()) {
                ++length;
            }
            for (int i = 0; i < this.attributeCount(); ++i) {
                AttributePair attributePair = this.getAttributePair(i);
                length += attributePair.getAttribute().length();
                length += attributePair.getValue().length();
                length += 4;
            }
            if (this.attributeCount() > 0 && !this.isClosed()) {
                --length;
            }
            return length;
        }

        public void setAttributes(List<AttributePair> attributePair) {
            this.fAttributes.clear();
            this.fAttributes.addAll(attributePair);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(500);
            sb.append('<');
            sb.append(this.getElementName());
            if (this.attributeCount() > 0 || this.isClosed()) {
                sb.append(' ');
            }
            for (int i = 0; i < this.attributeCount(); ++i) {
                AttributePair attributePair = this.getAttributePair(i);
                sb.append(attributePair.getAttribute());
                sb.append('=');
                sb.append(attributePair.getQuote());
                sb.append(attributePair.getValue());
                sb.append(attributePair.getQuote());
                if (!this.isClosed() && i == this.attributeCount() - 1) continue;
                sb.append(' ');
            }
            if (this.isClosed()) {
                sb.append('/');
            }
            sb.append('>');
            return sb.toString();
        }
    }

    protected static class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ParseException(String message) {
            super(message);
        }
    }

    protected class TagFormatter {
        private final FormattingPreferences prefs;

        public TagFormatter(FormattingPreferences prefs) {
            this.prefs = prefs;
        }

        private int countChar(char searchChar, String inTargetString) {
            StringCharacterIterator iter = new StringCharacterIterator(inTargetString);
            int i = 0;
            if (iter.first() == searchChar) {
                ++i;
            }
            while (iter.getIndex() < iter.getEndIndex()) {
                if (iter.next() != searchChar) continue;
                ++i;
            }
            return i;
        }

        protected void openTag(StringBuilder sb, Tag tag) {
            sb.append('<');
            sb.append(tag.getElementName());
        }

        protected void closeTag(StringBuilder sb, Tag tag) {
            if (tag.isClosed()) {
                sb.append(' ');
                sb.append('/');
            }
            sb.append('>');
        }

        public String format(Tag tag, String indent, String lineDelimiter) {
            if (this.prefs.isSplitMultiAttrs()) {
                StringBuilder sb = new StringBuilder(1024);
                this.openTag(sb, tag);
                String extraIndent = indent + this.prefs.getCanonicalIndent();
                for (int i = 0; i < tag.attributeCount(); ++i) {
                    AttributePair pair = tag.getAttributePair(i);
                    sb.append(lineDelimiter);
                    sb.append(extraIndent);
                    sb.append(pair.getAttribute());
                    sb.append('=');
                    sb.append(pair.getQuote());
                    sb.append(pair.getValue());
                    sb.append(pair.getQuote());
                }
                this.closeTag(sb, tag);
                return sb.toString();
            }
            if (this.prefs.wrapLongTags() && this.lineRequiresWrap(indent + tag.toString(), this.prefs.getMaximumLineWidth(), this.prefs.getTabWidth())) {
                return this.wrapTag(tag, indent, lineDelimiter);
            }
            return tag.toString();
        }

        protected boolean lineRequiresWrap(String line, int lineWidth, int tabWidth) {
            return this.tabExpandedLineWidth(line, tabWidth) > lineWidth;
        }

        protected int tabExpandedLineWidth(String line, int tabWidth) {
            int tabCount = this.countChar('\t', line);
            return line.length() - tabCount + tabCount * tabWidth;
        }

        protected String wrapTag(Tag tag, String indent, String lineDelimiter) {
            StringBuilder sb = new StringBuilder(1024);
            this.openTag(sb, tag);
            String extraIndent = indent + this.prefs.getCanonicalIndent();
            int currLineLength = this.tabExpandedLineWidth(indent, this.prefs.getTabWidth()) + sb.length();
            for (int i = 0; i < tag.attributeCount(); ++i) {
                AttributePair pair = tag.getAttributePair(i);
                StringBuilder pairBuffer = new StringBuilder(1024);
                pairBuffer.append(pair.getAttribute());
                pairBuffer.append('=');
                pairBuffer.append(pair.getQuote());
                pairBuffer.append(pair.getValue());
                pairBuffer.append(pair.getQuote());
                if (currLineLength + pairBuffer.length() < this.prefs.getMaximumLineWidth()) {
                    sb.append(' ');
                    sb.append((CharSequence)pairBuffer);
                    currLineLength += pairBuffer.length() + 1;
                    continue;
                }
                sb.append(lineDelimiter);
                sb.append(extraIndent);
                sb.append((CharSequence)pairBuffer);
                currLineLength = extraIndent.length() + pairBuffer.length();
            }
            this.closeTag(sb, tag);
            return sb.toString();
        }
    }

    public static class AttributePair {
        private String fAttribute;
        private String fValue;
        private char fQuote;

        public AttributePair(String attribute, String value, char attributeQuote) {
            this.fAttribute = attribute;
            this.fValue = value;
            this.fQuote = attributeQuote;
        }

        public String getAttribute() {
            return this.fAttribute;
        }

        public String getValue() {
            return this.fValue;
        }

        public char getQuote() {
            return this.fQuote;
        }
    }
}

