/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype.TtfInstructions.instructions.graphic;

import java.io.IOException;
import java.util.List;
import org.mabb.fontverter.FontVerterUtils;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.opentype.TtfInstructions.InstructionStack;
import org.mabb.fontverter.opentype.TtfInstructions.TtfGraphicsState;
import org.mabb.fontverter.opentype.TtfInstructions.instructions.TtfInstruction;

public class ScanConversionControlInstruction
extends TtfInstruction {
    @Override
    public int[] getCodeRanges() {
        return new int[]{133};
    }

    @Override
    public void read(FontDataInputStream in) throws IOException {
    }

    @Override
    public void execute(InstructionStack stack) throws IOException {
        long flags = stack.popNumber().longValue();
        List<TtfGraphicsState.ScanDropoutMode> modes = this.vm.getGraphicsState().dropoutControlModes;
        modes.clear();
        if (FontVerterUtils.isBitSet(8, flags)) {
            modes.add(TtfGraphicsState.ScanDropoutMode.TRUE_IF_PPEM_LESS_THAN_THRESHOLD);
        }
        if (FontVerterUtils.isBitSet(9, flags)) {
            modes.add(TtfGraphicsState.ScanDropoutMode.TRUE_IF_GLYPH_IS_ROTATED);
        }
        if (FontVerterUtils.isBitSet(10, flags)) {
            modes.add(TtfGraphicsState.ScanDropoutMode.TRUE_IF_GLYPH_STRETCHED);
        }
        if (FontVerterUtils.isBitSet(11, flags)) {
            modes.add(TtfGraphicsState.ScanDropoutMode.FALSE_UNLESS_PPEM_LESS_THAN_THRESHOLD);
        }
        if (FontVerterUtils.isBitSet(12, flags)) {
            modes.add(TtfGraphicsState.ScanDropoutMode.FALSE_UNLESS_STRETCHED);
        }
        if (FontVerterUtils.isBitSet(13, flags)) {
            modes.add(TtfGraphicsState.ScanDropoutMode.FALSE_UNLESS_STRETCHED);
        }
        this.vm.getGraphicsState().droputThreshold = flags & 0xFFL;
    }
}

