/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype.TtfInstructions;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.mabb.fontverter.opentype.ControlValueTable;
import org.mabb.fontverter.opentype.OpenTypeFont;
import org.mabb.fontverter.opentype.TtfInstructions.graphicsengine.RoundSettings;

public class TtfGraphicsState {
    public RoundSettings.RoundState roundState = RoundSettings.RoundState.ROUND;
    public RoundSettings roundSettings = new RoundSettings();
    public Long angleWeight = 0L;
    public ScanConverterMode scanConverterMode = ScanConverterMode.DROPOUT_WITH_STUBS;
    public List<ScanDropoutMode> dropoutControlModes = new ArrayList<ScanDropoutMode>();
    public long droputThreshold = 1L;
    public List<Short> cvtValues;
    public Float cvtCutInValue = Float.valueOf(0.0f);
    public Long deltaBase = 9L;
    public Long deltaShift = 3L;
    public Float minimumDistance = Float.valueOf(1.0f);
    public long singleWidth = 0L;
    public long singleWidthCutIn = 0L;
    public Point2D.Double freedomVector = new Point2D.Double(1.0, 1.0);
    public Point2D.Double projectionVector = new Point2D.Double(1.0, 1.0);
    public Long referencePoint0Id = 0L;
    public Long referencePoint1Id = 0L;
    public Long referencePoint2Id = 0L;
    public Long zone0Id = 0L;
    public Long zone1Id = 0L;
    public Long zone2Id = 0L;

    public void initialize(OpenTypeFont font) {
        if (font != null && font.getCvt() != null) {
            this.cvtValues = new ArrayList<Short>(font.getCvt().getValues());
        }
    }

    public Short getCvtValue(Long index) throws ControlValueTable.CvtValueNotFoundException {
        if (index > (long)this.cvtValues.size()) {
            throw new ControlValueTable.CvtValueNotFoundException();
        }
        return this.cvtValues.get(index.intValue());
    }

    public void setCvtValue(Long index, Long number) throws ControlValueTable.CvtValueNotFoundException {
        if (index > (long)this.cvtValues.size()) {
            throw new ControlValueTable.CvtValueNotFoundException();
        }
        this.cvtValues.set(index.intValue(), number.shortValue());
    }

    public Float round(Float number) {
        return Float.valueOf(Math.round(number.floatValue()));
    }

    public static enum ScanConverterMode {
        DROPOUT_WITH_STUBS(0),
        DROPOUT_EXCLUDING_STUBS(1),
        NON_DROPOUT(2);

        public final int id;

        private ScanConverterMode(int id) {
            this.id = id;
        }

        public short getId() {
            return (short)this.id;
        }

        public static ScanConverterMode fromValue(int code) {
            for (ScanConverterMode val : ScanConverterMode.values()) {
                if (val.id != code) continue;
                return val;
            }
            return DROPOUT_WITH_STUBS;
        }
    }

    public static enum ScanDropoutMode {
        TRUE_IF_PPEM_LESS_THAN_THRESHOLD,
        TRUE_IF_GLYPH_IS_ROTATED,
        TRUE_IF_GLYPH_STRETCHED,
        FALSE_UNLESS_PPEM_LESS_THAN_THRESHOLD,
        FALSE_UNLESS_ROTATED,
        FALSE_UNLESS_STRETCHED;

    }
}

