/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.TimeZone;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.JsonWritingUtils;
import net.logstash.logback.encoder.org.apache.commons.lang.time.FastDateFormat;
import net.logstash.logback.fieldnames.LogstashCommonFieldNames;

public abstract class FormattedTimestampJsonProvider<Event extends DeferredProcessingAware, FieldNames extends LogstashCommonFieldNames>
extends AbstractFieldJsonProvider<Event>
implements FieldNamesAware<FieldNames> {
    public static final String FIELD_TIMESTAMP = "@timestamp";
    public static final String UNIX_TIMESTAMP_AS_NUMBER = "[UNIX_TIMESTAMP_AS_NUMBER]";
    public static final String UNIX_TIMESTAMP_AS_STRING = "[UNIX_TIMESTAMP_AS_STRING]";
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    private static final TimeZone DEFAULT_TIMEZONE = null;
    private String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    private TimeZone timeZone = DEFAULT_TIMEZONE;
    private TimestampWriter timestampWriter = new PatternTimestampWriter(FastDateFormat.getInstance(this.pattern, this.timeZone));

    public FormattedTimestampJsonProvider() {
        this.setFieldName(FIELD_TIMESTAMP);
    }

    @Override
    public void setFieldNames(FieldNames fieldNames) {
        this.setFieldName(((LogstashCommonFieldNames)fieldNames).getTimestamp());
    }

    @Override
    public void writeTo(JsonGenerator generator, Event event) throws IOException {
        this.timestampWriter.writeTo(generator, this.getFieldName(), this.getTimestampAsMillis(event));
    }

    protected String getFormattedTimestamp(Event event) {
        return this.timestampWriter.getTimestampAsString(this.getTimestampAsMillis(event));
    }

    protected abstract long getTimestampAsMillis(Event var1);

    private void updateTimestampWriter() {
        this.timestampWriter = UNIX_TIMESTAMP_AS_NUMBER.equals(this.pattern) ? new NumberTimestampWriter() : (UNIX_TIMESTAMP_AS_STRING.equals(this.pattern) ? new StringTimestampWriter() : new PatternTimestampWriter(FastDateFormat.getInstance(this.pattern, this.timeZone)));
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.updateTimestampWriter();
    }

    public String getTimeZone() {
        return this.timeZone.getID();
    }

    public void setTimeZone(String timeZoneId) {
        this.timeZone = TimeZone.getTimeZone(timeZoneId);
        this.updateTimestampWriter();
    }

    private static class StringTimestampWriter
    implements TimestampWriter {
        private StringTimestampWriter() {
        }

        @Override
        public void writeTo(JsonGenerator generator, String fieldName, long timestampInMillis) throws IOException {
            JsonWritingUtils.writeStringField(generator, fieldName, this.getTimestampAsString(timestampInMillis));
        }

        @Override
        public String getTimestampAsString(long timestampInMillis) {
            return Long.toString(timestampInMillis);
        }
    }

    private static class NumberTimestampWriter
    implements TimestampWriter {
        private NumberTimestampWriter() {
        }

        @Override
        public void writeTo(JsonGenerator generator, String fieldName, long timestampInMillis) throws IOException {
            JsonWritingUtils.writeNumberField(generator, fieldName, timestampInMillis);
        }

        @Override
        public String getTimestampAsString(long timestampInMillis) {
            return Long.toString(timestampInMillis);
        }
    }

    private static class PatternTimestampWriter
    implements TimestampWriter {
        private final FastDateFormat formatter;

        public PatternTimestampWriter(FastDateFormat formatter) {
            this.formatter = formatter;
        }

        @Override
        public void writeTo(JsonGenerator generator, String fieldName, long timestampInMillis) throws IOException {
            JsonWritingUtils.writeStringField(generator, fieldName, this.getTimestampAsString(timestampInMillis));
        }

        @Override
        public String getTimestampAsString(long timestampInMillis) {
            return this.formatter.format(timestampInMillis);
        }
    }

    private static interface TimestampWriter {
        public void writeTo(JsonGenerator var1, String var2, long var3) throws IOException;

        public String getTimestampAsString(long var1);
    }
}

