/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.kaczmarzyk.spring.data.jpa.domain.Conjunction;
import net.kaczmarzyk.spring.data.jpa.web.EnhancerUtil;
import net.kaczmarzyk.spring.data.jpa.web.MethodParameterUtil;
import net.kaczmarzyk.spring.data.jpa.web.RecursiveHandlerMethodArgumentResolver;
import net.kaczmarzyk.spring.data.jpa.web.SpecificationArgumentResolver;
import net.kaczmarzyk.spring.data.jpa.web.WebRequestQueryContext;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Join;
import net.kaczmarzyk.spring.data.jpa.web.annotation.JoinFetch;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Joins;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

class JoinsSpecificationResolver
implements RecursiveHandlerMethodArgumentResolver {
    private SpecificationArgumentResolver parent;

    public JoinsSpecificationResolver(SpecificationArgumentResolver parent) {
        this.parent = parent;
    }

    public boolean supportsParameter(MethodParameter param) {
        Class paramType = param.getParameterType();
        return paramType.isInterface() && Specification.class.isAssignableFrom(paramType) && MethodParameterUtil.isAnnotatedWith(Joins.class, param);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        return this.resolveArgument(parameter, mavContainer, webRequest, binderFactory, new ArrayList<HandlerMethodArgumentResolver>());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory, List<HandlerMethodArgumentResolver> recursiveCallers) throws Exception {
        Conjunction spec;
        recursiveCallers.add(this);
        Conjunction joins = this.resolveJoins(parameter, webRequest);
        Specification regularSpec = (Specification)this.parent.resolveArgument(parameter, mavContainer, webRequest, binderFactory, recursiveCallers);
        Conjunction conjunction = spec = regularSpec == null ? joins : new Conjunction(Arrays.asList(joins, regularSpec));
        if (Specification.class == parameter.getParameterType()) {
            return spec;
        }
        return EnhancerUtil.wrapWithIfaceImplementation(parameter.getParameterType(), spec);
    }

    private Specification<Object> resolveJoins(MethodParameter parameter, NativeWebRequest webRequest) {
        ArrayList joins = new ArrayList();
        joins.addAll(this.resolveJoinFetches(parameter));
        joins.addAll(this.resolveRegularJoins(parameter, webRequest));
        return new Conjunction<Object>(joins);
    }

    private Collection<? extends Specification<Object>> resolveRegularJoins(MethodParameter parameter, NativeWebRequest webRequest) {
        Joins joinsDef = MethodParameterUtil.getAnnotation(Joins.class, parameter);
        ArrayList<net.kaczmarzyk.spring.data.jpa.domain.Join<Object>> joins = new ArrayList<net.kaczmarzyk.spring.data.jpa.domain.Join<Object>>();
        for (Join joinDef : joinsDef.value()) {
            joins.add(this.newJoin(joinDef, webRequest));
        }
        return joins;
    }

    private net.kaczmarzyk.spring.data.jpa.domain.Join<Object> newJoin(Join joinDef, NativeWebRequest request) {
        return new net.kaczmarzyk.spring.data.jpa.domain.Join<Object>(new WebRequestQueryContext(request), joinDef.path(), joinDef.alias(), joinDef.type(), joinDef.distinct());
    }

    private Collection<? extends Specification<Object>> resolveJoinFetches(MethodParameter parameter) {
        Joins joinsDef = MethodParameterUtil.getAnnotation(Joins.class, parameter);
        ArrayList<net.kaczmarzyk.spring.data.jpa.domain.JoinFetch<Object>> joins = new ArrayList<net.kaczmarzyk.spring.data.jpa.domain.JoinFetch<Object>>();
        for (JoinFetch fetchDef : joinsDef.fetch()) {
            joins.add(this.newJoinFetch(fetchDef));
        }
        return joins;
    }

    private net.kaczmarzyk.spring.data.jpa.domain.JoinFetch<Object> newJoinFetch(JoinFetch fetchDef) {
        return new net.kaczmarzyk.spring.data.jpa.domain.JoinFetch<Object>(fetchDef.paths(), fetchDef.joinType());
    }
}

