/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;
import org.springframework.data.jpa.domain.Specification;

public abstract class PathSpecification<T>
implements Specification<T> {
    protected String path;
    private QueryContext queryContext;

    public PathSpecification(QueryContext queryContext, String path) {
        this.queryContext = queryContext;
        this.path = path;
    }

    protected <F> Path<F> path(Root<T> root) {
        Path expr = null;
        for (String field : this.path.split("\\.")) {
            if (expr == null) {
                if (this.queryContext != null && this.queryContext.get(field) != null) {
                    expr = (Path)this.queryContext.get(field);
                    continue;
                }
                expr = root.get(field);
                continue;
            }
            expr = expr.get(field);
        }
        return expr;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.queryContext == null ? 0 : this.queryContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathSpecification other = (PathSpecification)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.queryContext == null ? other.queryContext != null : !this.queryContext.equals(other.queryContext));
    }
}

