/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerFilter;

@Singleton
public class FxWebInterceptor
implements InvokerFilter {
    private static ThreadLocal<Invoker> invokerThreadLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doInvoke(Invoker invoker, InvokerChain chain) throws Throwable {
        try {
            invokerThreadLocal.set(invoker);
            Object object = chain.doNext(invoker);
            return object;
        }
        finally {
            invokerThreadLocal.remove();
        }
    }

    public static Invoker invoker() {
        return invokerThreadLocal.get();
    }

    public static Map<String, String> headerMap() {
        Invoker invoker = FxWebInterceptor.invoker();
        if (invoker == null) {
            return Collections.emptyMap();
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        Enumeration headerNames = httpRequest.getHeaderNames();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            headerMap.put(header, httpRequest.getHeader(header));
        }
        return headerMap;
    }

    public static Map<String, List<String>> headerArrayMap() {
        Invoker invoker = FxWebInterceptor.invoker();
        if (invoker == null) {
            return Collections.emptyMap();
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        Enumeration headerNames = httpRequest.getHeaderNames();
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            Enumeration headers = httpRequest.getHeaders(header);
            ArrayList headerValue = new ArrayList();
            while (headers.hasMoreElements()) {
                headerValue.add(headers.nextElement());
            }
            headerMap.put(header, headerValue);
        }
        return headerMap;
    }

    public static Map<String, String> cookieMap() {
        Cookie[] cookies;
        Invoker invoker = FxWebInterceptor.invoker();
        if (invoker == null) {
            return Collections.emptyMap();
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        for (Cookie cookie : cookies = httpRequest.getCookies()) {
            String cookieName = cookie.getName();
            cookieMap.put(cookieName, cookie.getValue());
        }
        return cookieMap;
    }

    public static Map<String, List<String>> cookieArrayMap() {
        Cookie[] cookies;
        Invoker invoker = FxWebInterceptor.invoker();
        if (invoker == null) {
            return Collections.emptyMap();
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        HashMap<String, List<String>> cookieMap = new HashMap<String, List<String>>();
        for (Cookie cookie : cookies = httpRequest.getCookies()) {
            String cookieName = cookie.getName();
            List cookieValue = cookieMap.computeIfAbsent(cookieName, key -> new ArrayList());
            cookieValue.add(cookie.getValue());
        }
        return cookieMap;
    }

    public static HttpSession servletSession() {
        Invoker invoker = FxWebInterceptor.invoker();
        if (invoker == null) {
            return null;
        }
        return invoker.getHttpRequest().getSession();
    }
}

