/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.encryt;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Singleton;
import net.hasor.dataql.UdfSourceAssembly;
import net.hasor.utils.ArrayUtils;

@Singleton
public class HmacUdfSource
implements UdfSourceAssembly {
    public static String hmacMD5_string(String signKey, String content) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(SignType.HmacMD5.getSignType());
        mac.init(new SecretKeySpec(signKey.getBytes(), SignType.HmacMD5.getSignType()));
        byte[] rawHmac = mac.doFinal(content.getBytes());
        return Base64.getEncoder().encodeToString(rawHmac);
    }

    public static String hmacMD5_bytes(String signKey, List<Byte> content) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(SignType.HmacMD5.getSignType());
        mac.init(new SecretKeySpec(signKey.getBytes(), SignType.HmacMD5.getSignType()));
        Byte[] bytes = content.toArray(new Byte[0]);
        byte[] rawHmac = mac.doFinal(ArrayUtils.toPrimitive((Byte[])bytes));
        return Base64.getEncoder().encodeToString(rawHmac);
    }

    public static String hmacSHA1_string(String signKey, String content) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(SignType.HmacSHA1.getSignType());
        mac.init(new SecretKeySpec(signKey.getBytes(), SignType.HmacSHA1.getSignType()));
        byte[] rawHmac = mac.doFinal(content.getBytes());
        return Base64.getEncoder().encodeToString(rawHmac);
    }

    public static String hmacSHA1_bytes(String signKey, List<Byte> content) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(SignType.HmacSHA1.getSignType());
        mac.init(new SecretKeySpec(signKey.getBytes(), SignType.HmacSHA1.getSignType()));
        Byte[] bytes = content.toArray(new Byte[0]);
        byte[] rawHmac = mac.doFinal(ArrayUtils.toPrimitive((Byte[])bytes));
        return Base64.getEncoder().encodeToString(rawHmac);
    }

    public static String hmacSHA256_string(String signKey, String content) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(SignType.HmacSHA256.getSignType());
        mac.init(new SecretKeySpec(signKey.getBytes(), SignType.HmacSHA256.getSignType()));
        byte[] rawHmac = mac.doFinal(content.getBytes());
        return Base64.getEncoder().encodeToString(rawHmac);
    }

    public static String hmacSHA256_bytes(String signKey, List<Byte> content) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(SignType.HmacSHA256.getSignType());
        mac.init(new SecretKeySpec(signKey.getBytes(), SignType.HmacSHA256.getSignType()));
        Byte[] bytes = content.toArray(new Byte[0]);
        byte[] rawHmac = mac.doFinal(ArrayUtils.toPrimitive((Byte[])bytes));
        return Base64.getEncoder().encodeToString(rawHmac);
    }

    public static String hmacSHA512_string(String signKey, String content) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(SignType.HmacSHA512.getSignType());
        mac.init(new SecretKeySpec(signKey.getBytes(), SignType.HmacSHA512.getSignType()));
        byte[] rawHmac = mac.doFinal(content.getBytes());
        return Base64.getEncoder().encodeToString(rawHmac);
    }

    public static String hmacSHA512_bytes(String signKey, List<Byte> content) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(SignType.HmacSHA512.getSignType());
        mac.init(new SecretKeySpec(signKey.getBytes(), SignType.HmacSHA512.getSignType()));
        Byte[] bytes = content.toArray(new Byte[0]);
        byte[] rawHmac = mac.doFinal(ArrayUtils.toPrimitive((Byte[])bytes));
        return Base64.getEncoder().encodeToString(rawHmac);
    }

    private static enum SignType {
        HmacMD5("HmacMD5"),
        HmacSHA1("HmacSHA1"),
        HmacSHA256("HmacSHA256"),
        HmacSHA512("HmacSHA512");

        private String signType;

        private SignType(String signType) {
            this.signType = signType;
        }

        public String getSignType() {
            return this.signType;
        }
    }
}

