/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.encryt;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import javax.inject.Singleton;
import net.hasor.dataql.UdfSourceAssembly;
import net.hasor.utils.ArrayUtils;
import net.hasor.utils.CommonCodeUtils;

@Singleton
public class HexUdfSource
implements UdfSourceAssembly {
    public static String byteToHex(List<Byte> content) {
        if (content == null || content.size() == 0) {
            return null;
        }
        Byte[] bytes = content.toArray(new Byte[0]);
        return CommonCodeUtils.HexConversion.byte2HexStr((byte[])ArrayUtils.toPrimitive((Byte[])bytes));
    }

    public static byte[] hexToByte(String content) {
        if (content == null || content.equals("")) {
            return new byte[0];
        }
        return CommonCodeUtils.HexConversion.hexStr2Bytes((String)content);
    }

    public static String byteToString(List<Byte> content, String charset) {
        if (content == null || content.size() == 0) {
            return null;
        }
        Byte[] bytes = content.toArray(new Byte[0]);
        return new String(ArrayUtils.toPrimitive((Byte[])bytes), Charset.forName(charset));
    }

    public static byte[] stringToByte(String content, String charset) throws UnsupportedEncodingException {
        if (content == null || content.equals("")) {
            return new byte[0];
        }
        return content.getBytes(charset);
    }
}

