/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.encryt;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.inject.Singleton;
import net.hasor.dataql.UdfSourceAssembly;
import net.hasor.utils.ArrayUtils;

@Singleton
public class DigestUdfSource
implements UdfSourceAssembly {
    public static byte[] digestBytes(DigestType digestType, List<Byte> content) throws NoSuchAlgorithmException {
        if (content == null) {
            return null;
        }
        MessageDigest mdTemp = MessageDigest.getInstance(digestType.getDigestDesc());
        Byte[] bytes = content.toArray(new Byte[0]);
        mdTemp.update(ArrayUtils.toPrimitive((Byte[])bytes));
        return mdTemp.digest();
    }

    public static byte[] digestString(DigestType digestType, String content) throws NoSuchAlgorithmException {
        if (content == null) {
            return null;
        }
        MessageDigest mdTemp = MessageDigest.getInstance(digestType.getDigestDesc());
        mdTemp.update(content.getBytes());
        return mdTemp.digest();
    }

    public static byte[] md5_bytes(List<Byte> content) throws NoSuchAlgorithmException {
        return DigestUdfSource.digestBytes(DigestType.MD5, content);
    }

    public static byte[] md5_string(String content) throws NoSuchAlgorithmException {
        return DigestUdfSource.digestString(DigestType.MD5, content);
    }

    public static byte[] sha_bytes(List<Byte> content) throws NoSuchAlgorithmException {
        return DigestUdfSource.digestBytes(DigestType.SHA, content);
    }

    public static byte[] sha_string(String content) throws NoSuchAlgorithmException {
        return DigestUdfSource.digestString(DigestType.SHA, content);
    }

    public static byte[] sha1_bytes(List<Byte> content) throws NoSuchAlgorithmException {
        return DigestUdfSource.digestBytes(DigestType.SHA1, content);
    }

    public static byte[] sha1_string(String content) throws NoSuchAlgorithmException {
        return DigestUdfSource.digestString(DigestType.SHA1, content);
    }

    public static byte[] sha256_bytes(List<Byte> content) throws NoSuchAlgorithmException {
        return DigestUdfSource.digestBytes(DigestType.SHA256, content);
    }

    public static byte[] sha256_string(String content) throws NoSuchAlgorithmException {
        return DigestUdfSource.digestString(DigestType.SHA256, content);
    }

    public static byte[] sha512_bytes(List<Byte> content) throws NoSuchAlgorithmException {
        return DigestUdfSource.digestBytes(DigestType.SHA512, content);
    }

    public static byte[] sha512_string(String content) throws NoSuchAlgorithmException {
        return DigestUdfSource.digestString(DigestType.SHA512, content);
    }

    private static enum DigestType {
        MD5("MD5"),
        SHA("SHA"),
        SHA1("SHA1"),
        SHA256("SHA-256"),
        SHA512("SHA-512");

        private String digestDesc;

        private DigestType(String digestDesc) {
            this.digestDesc = digestDesc;
        }

        public String getDigestDesc() {
            return this.digestDesc;
        }
    }
}

