/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.hasor.dataql.fx.db.parser.DefaultMemberAccess;
import net.hasor.dataql.fx.db.parser.GenericTokenParser;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.StringUtils;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;

public class FxSql
implements Cloneable {
    private StringBuilder sqlStringOri = new StringBuilder("");
    private List<Object> sqlStringPlan = new LinkedList<Object>();
    private List<String> paramEl = new LinkedList<String>();
    private boolean havePlaceholder = false;
    private AtomicReference<Object> tempObject = new AtomicReference();
    private Supplier<Object> objectSupplier = () -> this.tempObject.get();

    public void insertString(String append) {
        this.sqlStringOri.insert(0, append);
        this.sqlStringPlan.add(0, append);
    }

    public void appendString(String append) {
        Object ss;
        this.sqlStringOri.append(append);
        if (!this.sqlStringPlan.isEmpty() && (ss = this.sqlStringPlan.get(this.sqlStringPlan.size() - 1)) instanceof StringBuilder) {
            ((StringBuilder)ss).append(append);
            return;
        }
        this.sqlStringPlan.add(new StringBuilder(append));
    }

    public void insertValueExpr(String exprString) {
        this.sqlStringOri.insert(0, "#{" + exprString + "}");
        this.sqlStringPlan.add("?");
        this.paramEl.add(exprString);
    }

    public void appendValueExpr(String exprString) {
        this.sqlStringOri.append("#{" + exprString + "}");
        this.sqlStringPlan.add("?");
        this.paramEl.add(exprString);
    }

    public void insertPlaceholderExpr(String exprString) {
        this.sqlStringOri.insert(0, "${" + exprString + "}");
        this.sqlStringPlan.add(0, new EvalCharSequence(exprString, this.objectSupplier));
        this.havePlaceholder = true;
    }

    public void appendPlaceholderExpr(String exprString) {
        this.sqlStringOri.append("${" + exprString + "}");
        this.sqlStringPlan.add(new EvalCharSequence(exprString, this.objectSupplier));
        this.havePlaceholder = true;
    }

    public boolean isHavePlaceholder() {
        return this.havePlaceholder;
    }

    public StringBuilder getOriSqlString() {
        return this.sqlStringOri;
    }

    public String buildSqlString(Object context) {
        try {
            this.tempObject.set(context);
            String string = StringUtils.join((Object[])this.sqlStringPlan.toArray());
            return string;
        }
        finally {
            this.tempObject.set(null);
        }
    }

    public List<Object> buildParameterSource(Object context) {
        return this.paramEl.stream().map(exprString -> FxSql.evalOgnl(exprString, context)).collect(Collectors.toList());
    }

    private static Object evalOgnl(String exprString, Object root) {
        try {
            OgnlContext context = new OgnlContext(null, null, (MemberAccess)new DefaultMemberAccess(true));
            return Ognl.getValue((String)exprString, (Map)context, (Object)root);
        }
        catch (Exception e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }

    public static FxSql analysisSQL(String fragmentString) {
        FxSql fxSql = new FxSql();
        String result = new GenericTokenParser(new String[]{"#{", "${"}, "}", (builder, token, content) -> {
            fxSql.appendString(builder.toString());
            if (token.equalsIgnoreCase("${")) {
                fxSql.appendPlaceholderExpr(content);
            }
            if (token.equalsIgnoreCase("#{")) {
                fxSql.appendValueExpr(content);
            }
            builder.delete(0, builder.length());
            return "";
        }).parse(fragmentString);
        fxSql.appendString(result);
        return fxSql;
    }

    public FxSql clone() {
        return FxSql.analysisSQL(this.sqlStringOri.toString());
    }

    private static class EvalCharSequence {
        private String exprString;
        private Supplier<Object> exprContext;

        public EvalCharSequence(String exprString, Supplier<Object> exprContext) {
            this.exprString = exprString;
            this.exprContext = exprContext;
        }

        public String toString() {
            return String.valueOf(FxSql.evalOgnl(this.exprString, this.exprContext.get()));
        }
    }
}

