/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.servlet;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.contextfw.web.application.component.Component;
import net.contextfw.web.application.internal.servlet.InitServlet;

public abstract class UriMapping
implements Comparable<UriMapping> {
    private Map<String, Pattern> variables;
    private final Type type;
    private final String path;
    private final Class<? extends Component> viewClass;
    private final InitServlet initServlet;

    public UriMapping(Class<? extends Component> viewClass, String path, InitServlet initServlet, Type type, Map<String, Pattern> variables) {
        this.initServlet = initServlet;
        this.viewClass = viewClass;
        this.path = path;
        this.type = type;
        this.initServlet.setMapping(this);
        this.variables = variables;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UriMapping) {
            UriMapping other = (UriMapping)o;
            if (this.getType() == other.getType()) {
                return this.path.equals(other.path);
            }
        }
        return false;
    }

    @Override
    public int compareTo(UriMapping other) {
        if (this.getType() == Type.SERVLET && other.getType() == Type.REGEX) {
            return -1;
        }
        if (this.getType() == Type.REGEX && other.getType() == Type.SERVLET) {
            return 1;
        }
        String myUri = this.getMatcherUri();
        String otherUri = other.getMatcherUri();
        if (myUri == null && otherUri == null) {
            return other.path.compareTo(this.path);
        }
        if (myUri == null) {
            return 1;
        }
        if (otherUri == null) {
            return -1;
        }
        return otherUri.compareTo(myUri);
    }

    private String getMatcherUri() {
        return this.extractPath(this.path);
    }

    public String getPath() {
        return this.path;
    }

    public Class<? extends Component> getViewClass() {
        return this.viewClass;
    }

    public InitServlet getInitServlet() {
        return this.initServlet;
    }

    public String findValue(String path, String name) {
        if (!this.variables.containsKey(name)) {
            return null;
        }
        Matcher m = this.variables.get(name).matcher(path);
        m.find();
        return m.group(1);
    }

    public abstract boolean matches(String var1);

    public abstract String extractPath(String var1);

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        SERVLET,
        REGEX;

    }
}

