/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.development;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.internal.development.ReloadingClassLoaderConf;
import org.apache.commons.io.IOUtils;

public class ReloadingClassLoader
extends ClassLoader {
    private final ReloadingClassLoaderConf conf;
    private final Map<String, Class<?>> cache = new HashMap();

    public ReloadingClassLoader(ReloadingClassLoaderConf conf) {
        super(Thread.currentThread().getContextClassLoader());
        this.conf = conf;
        for (Class<?> cl : conf.getExcludedClasses()) {
            this.cache.put(cl.getName(), cl);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.conf.isInReloadablePackage(name)) {
            if (!this.cache.containsKey(name)) {
                this.cache.put(name, this.findReloadableClass(name));
            }
            return this.cache.get(name);
        }
        return super.loadClass(name);
    }

    public Class<?> findReloadableClass(String s) throws ClassNotFoundException {
        try {
            byte[] bytes = this.loadClassData(s);
            if (bytes != null) {
                return this.defineClass(s, bytes, 0, bytes.length);
            }
            return super.loadClass(s);
        }
        catch (LinkageError le) {
            throw new WebApplicationException("Linkage error while trying to load class '" + s + "' from reloadable package. Make sure that" + " class is not accessed from non-reloadable package.", le);
        }
        catch (IOException ioe) {
            return super.loadClass(s);
        }
    }

    private byte[] loadClassData(String className) throws IOException {
        InputStream stream = super.getResourceAsStream(className.replaceAll("\\.", "/") + ".class");
        if (stream != null) {
            DataInputStream dis = new DataInputStream(stream);
            byte[] buff = IOUtils.toByteArray((InputStream)stream);
            dis.close();
            return buff;
        }
        return null;
    }
}

