/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.internal.component.ComponentBuilder;
import net.contextfw.web.application.internal.configuration.KeyValue;
import net.contextfw.web.application.serialize.AttributeSerializer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public final class DOMBuilder {
    private final Document document;
    private final AttributeSerializer<Object> serializer;
    private final Element root;
    private final ComponentBuilder componentBuilder;

    public DOMBuilder(String rootName, AttributeSerializer<Object> serializer, ComponentBuilder componentBuilder, Collection<KeyValue<String, String>> namespaces) {
        this.serializer = serializer;
        this.root = DocumentHelper.createElement((String)rootName);
        this.document = DocumentHelper.createDocument();
        this.document.setRootElement(this.root);
        for (KeyValue<String, String> namespace : namespaces) {
            this.root.add(DocumentHelper.createNamespace((String)namespace.getKey(), (String)namespace.getValue()));
        }
        this.componentBuilder = componentBuilder;
    }

    private DOMBuilder(Document document, Element root, AttributeSerializer<Object> serializer, ComponentBuilder componentBuilder) {
        this.document = document;
        this.root = root;
        this.serializer = serializer;
        this.componentBuilder = componentBuilder;
    }

    public DOMBuilder attr(String name, Object value) {
        this.root.addAttribute(name, this.serializer.serialize(value));
        return this;
    }

    public DOMBuilder child(Node element) {
        this.root.add(element);
        return this;
    }

    public DOMBuilder child(Object object, Object ... buildins) {
        this.componentBuilder.build(this, object, buildins);
        return this;
    }

    public Element getCurrentRoot() {
        return this.root;
    }

    public DOMBuilder findByXPath(String xpath) {
        Element element = (Element)this.root.selectSingleNode(xpath);
        if (element != null) {
            return new DOMBuilder(this.document, element, this.serializer, this.componentBuilder);
        }
        return null;
    }

    public DOMBuilder getByXPath(String xpath) {
        DOMBuilder b = this.findByXPath(xpath);
        if (b == null) {
            throw new WebApplicationException("Element for xpath '" + xpath + "' was not found");
        }
        return b;
    }

    public List<DOMBuilder> listByXPath(String xpath) {
        ArrayList<DOMBuilder> rv = new ArrayList<DOMBuilder>();
        List elements = this.root.selectNodes(xpath);
        for (Element element : elements) {
            rv.add(new DOMBuilder(this.document, element, this.serializer, this.componentBuilder));
        }
        return rv;
    }

    public Document toDocument() {
        return this.document;
    }

    public DOMBuilder text(Object value) {
        if (value != null) {
            this.root.addText(this.serializer.serialize(value));
        }
        return this;
    }

    public DOMBuilder descend(String elementName) {
        return new DOMBuilder(this.document, this.root.addElement(elementName), this.serializer, this.componentBuilder);
    }
}

