/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.publish;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.model.LabradorRetriever;
import net.bull.javamelody.internal.publish.MetricsPublisher;

class InfluxDB
extends MetricsPublisher {
    private static final char SEPARATOR = ' ';
    private final URL influxDbUrl;
    private final String prefix;
    private final String tags;
    private final Map<String, String> httpHeaders = Collections.singletonMap("Content-Type", "plain/text");
    private final DecimalFormat decimalFormat = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.US));
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final Writer bufferWriter = new OutputStreamWriter((OutputStream)this.buffer, StandardCharsets.UTF_8);
    private long lastTime;
    private String lastTimestamp;

    InfluxDB(URL influxDbUrl, String prefix, String tags) {
        assert (influxDbUrl != null);
        assert (prefix != null);
        assert (tags != null);
        this.influxDbUrl = influxDbUrl;
        this.prefix = prefix;
        this.tags = tags;
    }

    static InfluxDB getInstance(String contextPath, String hostName) {
        String influxDbUrl = Parameter.INFLUXDB_URL.getValue();
        if (influxDbUrl != null) {
            assert (contextPath != null);
            assert (hostName != null);
            String prefix = "javamelody.";
            String tags = (",application=" + contextPath + ",host=" + hostName).replace(' ', '_');
            try {
                return new InfluxDB(new URL(influxDbUrl + "&precision=s"), "javamelody.", tags);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    @Override
    public synchronized void addValue(String metric, double value) throws IOException {
        long timeInSeconds = System.currentTimeMillis() / 1000L;
        if (this.lastTime != timeInSeconds) {
            this.lastTimestamp = String.valueOf(timeInSeconds);
            this.lastTime = timeInSeconds;
        }
        this.bufferWriter.append(this.prefix).append(metric).append(this.tags).append(' ');
        this.bufferWriter.append("value=").append(this.decimalFormat.format(value)).append(' ');
        this.bufferWriter.append(this.lastTimestamp).append('\n');
    }

    @Override
    public synchronized void send() throws IOException {
        try {
            this.bufferWriter.flush();
            new LabradorRetriever(this.influxDbUrl, this.httpHeaders).post(this.buffer);
        }
        catch (Exception e) {
            LOG.warn(e.toString(), e);
        }
        finally {
            this.buffer.reset();
        }
    }

    @Override
    public void stop() {
    }
}

