/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.common;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.Parameters;

public final class I18N {
    private static final String RESOURCE_BUNDLE_BASE_NAME = Parameters.getResourcePath("translations").replace('/', '.').substring(1);
    private static final ThreadLocal<Locale> LOCALE_CONTEXT = new ThreadLocal();
    private static final Locale ROOT_LOCALE = Locale.ROOT;
    private static final Locale FIXED_LOCALE = I18N.getFixedLocale();

    private I18N() {
    }

    public static void bindLocale(Locale locale) {
        LOCALE_CONTEXT.set(locale);
    }

    public static Locale getCurrentLocale() {
        if (FIXED_LOCALE != null) {
            return FIXED_LOCALE;
        }
        Locale currentLocale = LOCALE_CONTEXT.get();
        if (currentLocale == null) {
            return Locale.getDefault();
        }
        return currentLocale;
    }

    public static ResourceBundle getResourceBundle() {
        Locale currentLocale = I18N.getCurrentLocale();
        if (Locale.ENGLISH.getLanguage().equals(currentLocale.getLanguage())) {
            return ResourceBundle.getBundle(RESOURCE_BUNDLE_BASE_NAME, ROOT_LOCALE);
        }
        return ResourceBundle.getBundle(RESOURCE_BUNDLE_BASE_NAME, currentLocale);
    }

    public static void unbindLocale() {
        LOCALE_CONTEXT.remove();
    }

    public static String getString(String key) {
        return I18N.getResourceBundle().getString(key);
    }

    public static String getFormattedString(String key, Object ... arguments) {
        String string = I18N.getString(key).replace("'", "''");
        return new MessageFormat(string, I18N.getCurrentLocale()).format(arguments);
    }

    public static String urlEncode(String text) {
        return text.replace("\\", "\\\\").replace("\n", "\\n").replace("\"", "%22").replace("'", "%27");
    }

    public static String htmlEncode(String text, boolean encodeSpace, boolean encodeNewLine) {
        String result = text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("'", "&apos;").replace("\"", "&quot;");
        if (encodeSpace) {
            result = result.replace(" ", "&nbsp;");
        }
        if (encodeNewLine) {
            result = result.replace("\n", "<br/>");
        }
        return result;
    }

    public static String htmlEncode(String text, boolean encodeSpace) {
        return I18N.htmlEncode(text, encodeSpace, true);
    }

    public static void writeTo(String html, Writer writer) throws IOException {
        int index = html.indexOf(35);
        if (index == -1) {
            writer.write(html);
        } else {
            ResourceBundle resourceBundle = I18N.getResourceBundle();
            int begin = 0;
            while (index != -1) {
                writer.write(html, begin, index - begin);
                int nextIndex = html.indexOf(35, index + 1);
                String key = html.substring(index + 1, nextIndex);
                writer.write(resourceBundle.getString(key));
                begin = nextIndex + 1;
                index = html.indexOf(35, begin);
            }
            writer.write(html, begin, html.length() - begin);
        }
    }

    public static void writelnTo(String html, Writer writer) throws IOException {
        I18N.writeTo(html, writer);
        writer.write(10);
    }

    public static DecimalFormat createIntegerFormat() {
        return new DecimalFormat("#,##0", I18N.getDecimalFormatSymbols());
    }

    public static DecimalFormat createPercentFormat() {
        return new DecimalFormat("0.00", I18N.getDecimalFormatSymbols());
    }

    private static DecimalFormatSymbols getDecimalFormatSymbols() {
        return DecimalFormatSymbols.getInstance(I18N.getCurrentLocale());
    }

    public static DateFormat createDateFormat() {
        return DateFormat.getDateInstance(3, I18N.getCurrentLocale());
    }

    public static DateFormat createDateAndTimeFormat() {
        return DateFormat.getDateTimeInstance(3, 3, I18N.getCurrentLocale());
    }

    public static DateFormat createDurationFormat() {
        DateFormat durationFormat = DateFormat.getTimeInstance(2, Locale.FRENCH);
        durationFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return durationFormat;
    }

    public static String getCurrentDate() {
        return I18N.createDateFormat().format(new Date());
    }

    public static String getCurrentDateAndTime() {
        return I18N.createDateAndTimeFormat().format(new Date());
    }

    private static Locale getFixedLocale() {
        String locale = Parameter.LOCALE.getValue();
        if (locale != null) {
            for (Locale l : Locale.getAvailableLocales()) {
                if (!l.toString().equals(locale)) continue;
                return l;
            }
        }
        return null;
    }
}

