/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class DataInput {
    private InputStream in;
    private ByteOrder endian;
    private byte[] buf = new byte[4];
    private int count = 0;

    public DataInput(InputStream inputStream) {
        this.endian = ByteOrder.nativeOrder();
        this.in = inputStream;
    }

    public DataInput(InputStream inputStream, ByteOrder byteOrder) {
        if (byteOrder != ByteOrder.BIG_ENDIAN && byteOrder != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException();
        }
        this.in = inputStream;
        this.endian = byteOrder;
    }

    public int readByte() throws IOException, EOFException {
        if (this.in.read(this.buf, 0, 1) == 1) {
            ++this.count;
            return 0xFF & this.buf[0];
        }
        throw new EOFException();
    }

    public int readInt16() throws IOException, EOFException {
        if (this.in.read(this.buf, 0, 2) == 2) {
            int n = 0;
            if (this.endian == ByteOrder.BIG_ENDIAN) {
                n = (short)(n | 0xFF & this.buf[1]);
                n = (short)(n | (0xFF & this.buf[0]) << 8);
            } else {
                n = (short)(n | 0xFF & this.buf[0]);
                n = (short)(n | (0xFF & this.buf[1]) << 8);
            }
            this.count += 2;
            return n;
        }
        throw new EOFException();
    }

    public int readInt32() throws IOException, EOFException {
        if (this.in.read(this.buf, 0, 4) == 4) {
            int n = 0;
            if (this.endian == ByteOrder.BIG_ENDIAN) {
                n |= 0xFF & this.buf[3];
                n |= (0xFF & this.buf[2]) << 8;
                n |= (0xFF & this.buf[1]) << 16;
                n |= (0xFF & this.buf[0]) << 24;
            } else {
                n |= 0xFF & this.buf[0];
                n |= (0xFF & this.buf[1]) << 8;
                n |= (0xFF & this.buf[2]) << 16;
                n |= (0xFF & this.buf[3]) << 24;
            }
            this.count += 4;
            return n;
        }
        throw new EOFException();
    }

    public int readUint16() throws IOException, EOFException {
        if (this.in.read(this.buf, 0, 2) == 2) {
            int n = 0;
            if (this.endian == ByteOrder.BIG_ENDIAN) {
                n |= 0xFF & this.buf[1];
                n |= (0xFF & this.buf[0]) << 8;
            } else {
                n |= 0xFF & this.buf[0];
                n |= (0xFF & this.buf[1]) << 8;
            }
            this.count += 2;
            return n;
        }
        throw new EOFException();
    }

    public long readUint32() throws IOException, EOFException {
        if (this.in.read(this.buf, 0, 4) == 4) {
            long l = 0L;
            if (this.endian == ByteOrder.BIG_ENDIAN) {
                l |= (long)(0xFF & this.buf[3]);
                l |= (long)((0xFF & this.buf[2]) << 8);
                l |= (long)((0xFF & this.buf[1]) << 16);
                l |= (long)((0xFF & this.buf[0]) << 24);
            } else {
                l |= (long)(0xFF & this.buf[0]);
                l |= (long)((0xFF & this.buf[1]) << 8);
                l |= (long)((0xFF & this.buf[2]) << 16);
                l |= (long)((0xFF & this.buf[3]) << 24);
            }
            this.count += 4;
            return l;
        }
        throw new EOFException();
    }

    public byte[] readBytes(int n) throws IOException, EOFException {
        byte[] byArray = new byte[n];
        if (this.in.read(byArray) == n) {
            this.count += n;
            return byArray;
        }
        throw new EOFException();
    }

    public void setCount(int n) {
        this.count = n;
    }

    public int getCount() {
        return this.count;
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

