/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.module.utils;

import com.ibm.icu.text.Normalizer;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nc.ird.module.utils.AssertTools;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;

public final class StringTools {
    public static <O1, O2> String couplesToString(Map<O1, O2> map, String string, String string2) {
        AssertTools.assertNotNull(map);
        AssertTools.assertNotNull(string);
        AssertTools.assertNotNull(string2);
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<O1, O2> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey() + string + entry.getValue() + string2);
        }
        return StringUtils.stripToNull((String)StringTools.truncate(stringBuilder, string2));
    }

    public static String listToString(List<? extends Object> list, String string) {
        AssertTools.assertNotNull(list);
        AssertTools.assertNotEmpty(string);
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<? extends Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            stringBuilder.append(object.toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static int length(String string) {
        return string == null ? -1 : string.length();
    }

    public static Iterator<String> lineIterator(String string) {
        AssertTools.assertNotNull(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        LineIterator lineIterator = new LineIterator((Reader)new StringReader(string));
        while (lineIterator.hasNext()) {
            String string2 = StringUtils.trimToNull((String)lineIterator.nextLine());
            if (string2 == null) continue;
            arrayList.add(string2);
        }
        return arrayList.iterator();
    }

    public static Iterator<String> lineIterator(StringBuilder stringBuilder) {
        AssertTools.assertNotNull(stringBuilder);
        return StringTools.lineIterator(stringBuilder.toString());
    }

    public static String replaceAccents(String string) {
        return StringUtils.isEmpty((String)string) ? string : Normalizer.decompose((String)string, (boolean)false, (int)0).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public static String replaceConsecutiveWhitespaces(String string) {
        return StringUtils.isEmpty((String)string) ? string : string.replaceAll("\\p{Space}+", " ");
    }

    public static String replaceConsecutiveWhitespacesByUnderscore(String string) {
        return StringUtils.isEmpty((String)string) ? string : string.replaceAll("\\p{Space}+", "_");
    }

    public static String replaceNonAlpha(String string) {
        return StringUtils.isEmpty((String)string) ? string : string.replaceAll("[^\\p{Alpha}]", " ");
    }

    public static String truncate(String string, String string2) {
        AssertTools.assertNotNull(string2);
        String string3 = string;
        if (!StringUtils.isEmpty((String)string) && string.length() >= string2.length() && string2.equals(string.substring(string.length() - string2.length(), string.length()))) {
            string3 = string.substring(0, string.length() - string2.length());
        }
        return string3;
    }

    public static String truncate(StringBuilder stringBuilder, String string) {
        return stringBuilder != null ? StringTools.truncate(stringBuilder.toString(), string) : null;
    }

    private StringTools() {
    }

    public static <T> Comparator<T> createStringComparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                String string = t == null ? "" : t.toString();
                String string2 = t2 == null ? "" : t2.toString();
                return string.compareTo(string2);
            }
        };
    }
}

