/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.module.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import nc.ird.module.utils.AssertTools;

public final class NumberTools {
    private NumberTools() {
    }

    public static <N extends Number> N nullIfZero(N n) {
        return n == null || n.doubleValue() == 0.0 ? null : (N)n;
    }

    public static Double parseDouble(String string, Locale locale, int n) {
        AssertTools.assertNotEmpty(string);
        AssertTools.assertNotNull(locale);
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(locale);
        decimalFormat.setMaximumFractionDigits(n);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = (Number)decimalFormat.parseObject(string, parsePosition);
        if (parsePosition.getIndex() != string.length()) {
            if (string.charAt(parsePosition.getIndex()) == '.') {
                DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
                decimalFormatSymbols.setDecimalSeparator('.');
                decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
                parsePosition = new ParsePosition(0);
                number = (Number)decimalFormat.parseObject(string, parsePosition);
                if (parsePosition.getIndex() != string.length()) {
                    throw new NumberFormatException("Cannot convert '" + string + "' to Double. Parse failed at position " + parsePosition.getIndex() + ".");
                }
            } else {
                throw new NumberFormatException("Cannot convert '" + string + "' to Double. Parse failed at position " + parsePosition.getIndex() + ".");
            }
        }
        return number.doubleValue();
    }

    public static BigDecimal parseBigDecimal(String string, Locale locale, int n, int n2) {
        AssertTools.assertNotEmpty(string);
        AssertTools.assertNotNull(locale);
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        decimalFormat.setMaximumFractionDigits(n);
        decimalFormat.setMaximumIntegerDigits(n2);
        decimalFormat.setParseBigDecimal(true);
        ParsePosition parsePosition = new ParsePosition(0);
        BigDecimal bigDecimal = (BigDecimal)decimalFormat.parseObject(string, parsePosition);
        if (parsePosition.getIndex() != string.length()) {
            if (string.charAt(parsePosition.getIndex()) == '.') {
                DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
                decimalFormatSymbols.setDecimalSeparator('.');
                decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
                parsePosition = new ParsePosition(0);
                bigDecimal = (BigDecimal)decimalFormat.parseObject(string, parsePosition);
                if (parsePosition.getIndex() != string.length()) {
                    throw new NumberFormatException("Cannot convert '" + string + "' to BigDecimal. Parse failed at position " + parsePosition.getIndex() + ".");
                }
            } else {
                throw new NumberFormatException("Cannot convert '" + string + "' to BigDecimal. Parse failed at position " + parsePosition.getIndex() + ".");
            }
        }
        return bigDecimal;
    }

    public static String doubleToString(Double d, Locale locale, int n, int n2) {
        AssertTools.assertNotNull(d);
        AssertTools.assertNotNull(locale);
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        if (numberFormat != null) {
            numberFormat.setMinimumFractionDigits(n);
            numberFormat.setMaximumFractionDigits(n2);
            numberFormat.setRoundingMode(RoundingMode.HALF_UP);
            return numberFormat.format(d);
        }
        return d.toString();
    }

    public static String bigDecimalToString(BigDecimal bigDecimal, Locale locale, int n, int n2, int n3) {
        AssertTools.assertNotNull(bigDecimal);
        AssertTools.assertNotNull(locale);
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        if (numberFormat != null) {
            numberFormat.setMinimumFractionDigits(n);
            numberFormat.setMaximumFractionDigits(n2);
            numberFormat.setMaximumIntegerDigits(n3);
            numberFormat.setRoundingMode(RoundingMode.HALF_UP);
            return numberFormat.format(bigDecimal);
        }
        return bigDecimal.toString();
    }
}

