/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.module.utils;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;

public class GenerateCsv {
    private char columnsSeparator;
    private String copyright;
    private String encoding;
    private static final String DEFAULT_COPYRIGHT = "\u00a9IRD tous droits r\u00e9serv\u00e9s";
    public static final String CHARSET_UTF_8 = "UTF-8";
    public static final String CHARSET_ISO_8859_1 = "ISO-8859-1";

    public GenerateCsv() {
        this(';', CHARSET_UTF_8);
    }

    public GenerateCsv(String string) {
        this(';', string);
    }

    public GenerateCsv(char c, String string) {
        this.setColumnsSeparator(c);
        this.setEncoding(string);
        this.setCopyright(DEFAULT_COPYRIGHT);
    }

    public ByteArrayOutputStream writeCSV(List<String[]> list, boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, this.encoding);
        CSVWriter cSVWriter = new CSVWriter((Writer)outputStreamWriter, this.getColumnsSeparator());
        cSVWriter.writeAll(list);
        if (bl) {
            cSVWriter.writeNext(new String[]{this.getCopyright()});
        }
        cSVWriter.close();
        return byteArrayOutputStream;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String string) {
        this.copyright = string;
    }

    public char getColumnsSeparator() {
        return this.columnsSeparator;
    }

    public void setColumnsSeparator(char c) {
        this.columnsSeparator = c;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }
}

