/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.module.utils;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.NumberTools;
import org.apache.commons.lang.StringUtils;

public final class CoordTools {
    public static final char DEGREES = '\u00b0';
    public static final int LATITUDE_LENGTH = 11;
    public static final int LATITUDE_MAX_DEGREES = 90;
    public static final String LATITUDE_MAX_MINUTES_STRING = "59.999";
    public static final BigDecimal LATITUDE_MAX_MINUTES;
    public static final int LATITUDE_MIN_DEGREES = 0;
    public static final String LATITUDE_MIN_MINUTES_STRING = "00.000";
    public static final BigDecimal LATITUDE_MIN_MINUTES;
    public static final Character[] LATITUDE_ORIENTATIONS;
    private static final Pattern LATITUDE_PATTERN;
    public static final int LONGITUDE_LENGTH = 12;
    public static final int LONGITUDE_MAX_DEGREES = 180;
    public static final String LONGITUDE_MAX_MINUTES_STRING = "59.999";
    public static final BigDecimal LONGITUDE_MAX_MINUTES;
    public static final int LONGITUDE_MIN_DEGREES = 0;
    public static final String LONGITUDE_MIN_MINUTES_STRING = "00.000";
    public static final BigDecimal LONGITUDE_MIN_MINUTES;
    public static final Character[] LONGITUDE_ORIENTATIONS;
    private static final Pattern LONGITUDE_PATTERN;
    public static final char MINUTES = '\'';
    private static final char MINUTES_BLANK = '0';
    private static final int MINUTES_DECIMAL_LENGTH;
    private static final int MINUTES_INTEGER_LENGTH;
    public static final char MINUTES_SEPARATOR = '.';
    private static final String MINUTES_SEPARATOR_PATTERN = "\\.";

    public static String latitude(Integer n, BigDecimal bigDecimal, Character c) {
        AssertTools.assertGreaterOrEquals(n, 0);
        AssertTools.assertLowerOrEquals(n, 90);
        AssertTools.assertGreaterOrEquals(bigDecimal, LATITUDE_MIN_MINUTES);
        AssertTools.assertLowerOrEquals(bigDecimal, LATITUDE_MAX_MINUTES);
        AssertTools.assertIn(Character.valueOf(Character.toUpperCase(c.charValue())), LATITUDE_ORIENTATIONS);
        String[] stringArray = NumberTools.bigDecimalToString(bigDecimal, Locale.ENGLISH, MINUTES_DECIMAL_LENGTH, MINUTES_DECIMAL_LENGTH, 2).split(MINUTES_SEPARATOR_PATTERN);
        return StringUtils.leftPad((String)String.valueOf(n), (int)String.valueOf(90).length()) + '\u00b0' + StringUtils.leftPad((String)String.valueOf(stringArray[0]), (int)MINUTES_INTEGER_LENGTH, (char)'0') + '.' + StringUtils.rightPad((String)stringArray[1], (int)MINUTES_DECIMAL_LENGTH, (char)'0') + '\'' + Character.toUpperCase(c.charValue());
    }

    public static Integer latitudeDegrees(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Matcher matcher = LATITUDE_PATTERN.matcher(string);
        matcher.lookingAt();
        return Integer.valueOf(matcher.group(1).trim());
    }

    public static BigDecimal latitudeMinutes(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Matcher matcher = LATITUDE_PATTERN.matcher(string);
        matcher.lookingAt();
        return NumberTools.parseBigDecimal(matcher.group(2) + '.' + matcher.group(3), Locale.ENGLISH, MINUTES_DECIMAL_LENGTH, 2);
    }

    public static Character latitudeOrientation(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Matcher matcher = LATITUDE_PATTERN.matcher(string);
        matcher.lookingAt();
        return Character.valueOf(matcher.group(4).charAt(0));
    }

    public static String longitude(Integer n, BigDecimal bigDecimal, Character c) {
        AssertTools.assertGreaterOrEquals(n, 0);
        AssertTools.assertLowerOrEquals(n, 180);
        AssertTools.assertGreaterOrEquals(bigDecimal, LONGITUDE_MIN_MINUTES);
        AssertTools.assertLowerOrEquals(bigDecimal, LONGITUDE_MAX_MINUTES);
        AssertTools.assertIn(Character.valueOf(Character.toUpperCase(c.charValue())), LONGITUDE_ORIENTATIONS);
        String[] stringArray = NumberTools.bigDecimalToString(bigDecimal, Locale.ENGLISH, MINUTES_DECIMAL_LENGTH, MINUTES_DECIMAL_LENGTH, 3).split(MINUTES_SEPARATOR_PATTERN);
        return StringUtils.leftPad((String)String.valueOf(n), (int)String.valueOf(180).length()) + '\u00b0' + StringUtils.leftPad((String)String.valueOf(stringArray[0]), (int)MINUTES_INTEGER_LENGTH, (char)'0') + '.' + StringUtils.rightPad((String)stringArray[1], (int)MINUTES_DECIMAL_LENGTH, (char)'0') + '\'' + Character.toUpperCase(c.charValue());
    }

    public static Integer longitudeDegrees(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Matcher matcher = LONGITUDE_PATTERN.matcher(string);
        matcher.lookingAt();
        return Integer.valueOf(matcher.group(1).trim());
    }

    public static BigDecimal longitudeMinutes(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Matcher matcher = LONGITUDE_PATTERN.matcher(string);
        matcher.lookingAt();
        return NumberTools.parseBigDecimal(matcher.group(2) + '.' + matcher.group(3), Locale.ENGLISH, MINUTES_DECIMAL_LENGTH, 3);
    }

    public static Character longitudeOrientation(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Matcher matcher = LONGITUDE_PATTERN.matcher(string);
        matcher.lookingAt();
        return Character.valueOf(matcher.group(4).charAt(0));
    }

    public static boolean validateLatitude(String string) {
        AssertTools.assertNotEmpty(string);
        Matcher matcher = LATITUDE_PATTERN.matcher(string);
        if (matcher.lookingAt()) {
            int n = Integer.valueOf(matcher.group(1).trim());
            BigDecimal bigDecimal = NumberTools.parseBigDecimal(matcher.group(2) + '.' + matcher.group(3), Locale.ENGLISH, MINUTES_DECIMAL_LENGTH, 2);
            return n >= 0 && n <= 90 && LATITUDE_MIN_MINUTES.compareTo(bigDecimal) <= 0 && LATITUDE_MAX_MINUTES.compareTo(bigDecimal) >= 0 && (n != 90 || new BigDecimal("0.000").compareTo(bigDecimal) == 0);
        }
        return false;
    }

    public static boolean validateLongitude(String string) {
        AssertTools.assertNotEmpty(string);
        Matcher matcher = LONGITUDE_PATTERN.matcher(string);
        if (matcher.lookingAt()) {
            int n = Integer.valueOf(matcher.group(1).trim());
            BigDecimal bigDecimal = NumberTools.parseBigDecimal(matcher.group(2) + '.' + matcher.group(3), Locale.ENGLISH, MINUTES_DECIMAL_LENGTH, 3);
            return n >= 0 && n <= 180 && LONGITUDE_MIN_MINUTES.compareTo(bigDecimal) <= 0 && LATITUDE_MAX_MINUTES.compareTo(bigDecimal) >= 0 && (n != 180 || new BigDecimal("0.000").compareTo(bigDecimal) == 0);
        }
        return false;
    }

    private CoordTools() {
    }

    static {
        int n;
        char c;
        int n2;
        int n3;
        LATITUDE_MAX_MINUTES = new BigDecimal("59.999");
        LATITUDE_MIN_MINUTES = new BigDecimal("00.000");
        LATITUDE_ORIENTATIONS = new Character[]{Character.valueOf('N'), Character.valueOf('S')};
        LONGITUDE_MAX_MINUTES = new BigDecimal("59.999");
        LONGITUDE_MIN_MINUTES = new BigDecimal("00.000");
        LONGITUDE_ORIENTATIONS = new Character[]{Character.valueOf('E'), Character.valueOf('W')};
        String[] stringArray = "59.999".split(MINUTES_SEPARATOR_PATTERN);
        MINUTES_INTEGER_LENGTH = stringArray[0].length();
        MINUTES_DECIMAL_LENGTH = stringArray[1].length();
        String string = "[0-9]";
        String string2 = "[ 0-9]";
        StringBuilder stringBuilder = new StringBuilder("^(");
        for (n3 = 0; n3 < String.valueOf(90).length(); ++n3) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(')');
        stringBuilder.append('\u00b0');
        stringBuilder.append('(');
        for (n3 = 0; n3 < MINUTES_INTEGER_LENGTH; ++n3) {
            stringBuilder.append(string);
        }
        stringBuilder.append(")");
        stringBuilder.append(MINUTES_SEPARATOR_PATTERN);
        stringBuilder.append('(');
        for (n3 = 0; n3 < MINUTES_DECIMAL_LENGTH; ++n3) {
            stringBuilder.append(string);
        }
        stringBuilder.append(')');
        stringBuilder.append('\'');
        stringBuilder.append("([");
        Character[] characterArray = LATITUDE_ORIENTATIONS;
        int n4 = characterArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            c = characterArray[n2].charValue();
            stringBuilder.append(c);
        }
        stringBuilder.append("])$");
        LATITUDE_PATTERN = Pattern.compile(stringBuilder.toString());
        stringBuilder = new StringBuilder("^(");
        for (n = 0; n < String.valueOf(180).length(); ++n) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(')');
        stringBuilder.append('\u00b0');
        stringBuilder.append('(');
        for (n = 0; n < MINUTES_INTEGER_LENGTH; ++n) {
            stringBuilder.append(string);
        }
        stringBuilder.append(")");
        stringBuilder.append(MINUTES_SEPARATOR_PATTERN);
        stringBuilder.append('(');
        for (n = 0; n < MINUTES_DECIMAL_LENGTH; ++n) {
            stringBuilder.append(string);
        }
        stringBuilder.append(')');
        stringBuilder.append('\'');
        stringBuilder.append("([");
        Character[] characterArray2 = LONGITUDE_ORIENTATIONS;
        n4 = characterArray2.length;
        for (n2 = 0; n2 < n4; ++n2) {
            c = characterArray2[n2].charValue();
            stringBuilder.append(c);
        }
        stringBuilder.append("])$");
        LONGITUDE_PATTERN = Pattern.compile(stringBuilder.toString());
    }
}

