/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.module.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.BeanTools;
import org.apache.commons.lang.ObjectUtils;

public final class CollectionTools {
    public static <T> boolean containsOnlySameValue(Collection<T> collection, T t) {
        AssertTools.assertNotNull(collection);
        if (collection.isEmpty()) {
            return false;
        }
        boolean bl = true;
        Iterator<T> iterator = collection.iterator();
        while (bl && iterator.hasNext()) {
            T t2 = iterator.next();
            if (ObjectUtils.equals(t2, t)) continue;
            bl = false;
        }
        return bl;
    }

    public static <T> Set<T> intersect(Set<T> set, Set<T> set2) {
        HashSet hashSet = set == null ? new HashSet() : new HashSet<T>(set);
        hashSet.retainAll(set2);
        return hashSet;
    }

    public static <T> void setter(Collection<T> collection, Collection<T> collection2) {
        AssertTools.assertNotNull(collection);
        collection.clear();
        if (collection2 != null) {
            collection.addAll(collection2);
        }
    }

    public static boolean containsWithValue(Collection<? extends Object> collection, String string, BeanTools.AccessType accessType, Object object) {
        AssertTools.assertNotNull(collection);
        AssertTools.assertNotEmpty(string);
        for (Object object2 : collection) {
            Object object3 = BeanTools.getValueFromPath(object2, accessType, string);
            if (!object3.equals(object)) continue;
            return true;
        }
        return false;
    }

    public static int countWithValue(Collection<? extends Object> collection, String string, BeanTools.AccessType accessType, Object object) {
        AssertTools.assertNotNull(collection);
        AssertTools.assertNotEmpty(string);
        int n = 0;
        for (Object object2 : collection) {
            Object object3 = BeanTools.getValueFromPath(object2, accessType, string);
            if (!object.equals(object3)) continue;
            ++n;
        }
        return n;
    }

    public static <T> T findWithValue(List<T> list, String string, BeanTools.AccessType accessType, Object object) {
        AssertTools.assertNotNull(list);
        AssertTools.assertNotEmpty(string);
        for (T t : list) {
            Object object2 = BeanTools.getValueFromPath(t, accessType, string);
            if (!object.equals(object2)) continue;
            return t;
        }
        return null;
    }

    public static boolean removeWithValue(Collection<? extends Object> collection, String string, BeanTools.AccessType accessType, Object object) {
        AssertTools.assertNotNull(collection);
        AssertTools.assertNotEmpty(string);
        boolean bl = false;
        Iterator<? extends Object> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            Object object3 = BeanTools.getValueFromPath(object2, accessType, string);
            if (!object.equals(object3)) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static boolean removeAllWithValue(Collection<? extends Object> collection, String string, BeanTools.AccessType accessType, Collection<? extends Object> collection2) {
        AssertTools.assertNotNull(collection);
        AssertTools.assertNotEmpty(string);
        boolean bl = false;
        Iterator<? extends Object> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Object object2 = BeanTools.getValueFromPath(object, accessType, string);
            if (object2 == null || !collection2.contains(object2)) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static List<Object> valuesFromList(Collection<? extends Object> collection, String string, BeanTools.AccessType accessType) {
        AssertTools.assertNotNull(collection);
        AssertTools.assertNotEmpty(string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : collection) {
            Object object2 = BeanTools.getValueFromPath(object, accessType, string);
            arrayList.add(object2);
        }
        return arrayList;
    }

    private CollectionTools() {
    }
}

