/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.module.utils;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nc.ird.module.utils.AssertTools;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;

public final class BeanTools {
    private static final String ANNOTATION = "Argument of type %s must have a field annotated with %s";
    private static final String FIELD = "Argument of type %s must have an accessible %s property";
    private static final Object[] PARAMETERS = new Object[0];

    public static boolean equals(Object object, Object object2, AccessType accessType, String ... stringArray) {
        AssertTools.assertNotNull(object);
        AssertTools.assertNotEmpty(stringArray);
        AssertTools.assertArrayNotNull(stringArray);
        if (object == object2) {
            return true;
        }
        if (object2 != null && object != null && (object.getClass().isAssignableFrom(object2.getClass()) || object2.getClass().isAssignableFrom(object.getClass()))) {
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            for (String string : stringArray) {
                try {
                    Object object3 = BeanTools.getValue(object, accessType, string);
                    Object object4 = BeanTools.getValue(object2, accessType, string);
                    if (object3 != null && object4 != null && !equalsBuilder.append(object3.hashCode(), object4.hashCode()).isEquals()) {
                        return false;
                    }
                    if (equalsBuilder.append(object3, object4).isEquals()) continue;
                    return false;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format(FIELD, object.getClass(), string), exception);
                }
            }
            return equalsBuilder.isEquals();
        }
        return false;
    }

    public static boolean equals(Object object, Object object2, Field ... fieldArray) {
        AssertTools.assertNotNull(object);
        AssertTools.assertNotEmpty(fieldArray);
        AssertTools.assertArrayNotNull(fieldArray);
        if (object == object2) {
            return true;
        }
        if (object2 != null && object != null && (object.getClass().isAssignableFrom(object2.getClass()) || object2.getClass().isAssignableFrom(object.getClass()))) {
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            for (Field field : fieldArray) {
                try {
                    Object object3 = field.get(object);
                    Object object4 = field.get(object2);
                    if (object3 != null && object4 != null && !equalsBuilder.append(object3.hashCode(), object4.hashCode()).isEquals()) {
                        return false;
                    }
                    if (equalsBuilder.append(object3, object4).isEquals()) continue;
                    return false;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format(FIELD, object.getClass(), field.getName()), exception);
                }
            }
            return equalsBuilder.isEquals();
        }
        return false;
    }

    public static Field getAnnotatedPublicField(Object object, Class<? extends Annotation> ... classArray) throws NoSuchFieldException {
        AssertTools.assertNotNull(object);
        return BeanTools.getAnnotatedPublicField(object.getClass(), classArray);
    }

    public static Field getAnnotatedPrivateField(Class<?> clazz, Class<? extends Annotation> ... classArray) throws NoSuchFieldException {
        AssertTools.assertNotNull(clazz);
        AssertTools.assertNotEmpty(classArray);
        AssertTools.assertArrayNotNull(classArray);
        Field[] fieldArray = clazz.getDeclaredFields();
        Field field = null;
        for (int i = 0; field == null && i < fieldArray.length; ++i) {
            for (int j = 0; field == null && j < classArray.length; ++j) {
                if (!fieldArray[i].isAnnotationPresent(classArray[j])) continue;
                field = fieldArray[i];
            }
        }
        if (field == null) {
            if (clazz.getSuperclass() == null) {
                throw new NoSuchFieldException(String.format(ANNOTATION, clazz.getName(), Arrays.toString(classArray)));
            }
            return BeanTools.getAnnotatedInheritedField(clazz, clazz.getSuperclass(), classArray);
        }
        return field;
    }

    private static Field getAnnotatedInheritedField(Class<?> clazz, Class<?> clazz2, Class<? extends Annotation> ... classArray) throws NoSuchFieldException {
        AssertTools.assertNotNull(clazz);
        AssertTools.assertNotEmpty(classArray);
        AssertTools.assertArrayNotNull(classArray);
        Field[] fieldArray = clazz2.getDeclaredFields();
        Field field = null;
        for (int i = 0; field == null && i < fieldArray.length; ++i) {
            for (int j = 0; field == null && j < classArray.length; ++j) {
                if (!fieldArray[i].isAnnotationPresent(classArray[j]) || !Modifier.isProtected(fieldArray[i].getModifiers()) && !Modifier.isPublic(fieldArray[i].getModifiers()) && !Modifier.isPrivate(fieldArray[i].getModifiers())) continue;
                field = fieldArray[i];
            }
        }
        if (field == null) {
            if (clazz2.getSuperclass() == null) {
                throw new NoSuchFieldException(String.format(ANNOTATION, clazz.getName(), Arrays.toString(classArray)));
            }
            BeanTools.getAnnotatedInheritedField(clazz, clazz2.getSuperclass(), classArray);
        }
        return field;
    }

    public static Field getAnnotatedPublicField(Class<?> clazz, Class<? extends Annotation> ... classArray) throws NoSuchFieldException {
        AssertTools.assertNotNull(clazz);
        AssertTools.assertNotEmpty(classArray);
        AssertTools.assertArrayNotNull(classArray);
        Field[] fieldArray = clazz.getFields();
        Field field = null;
        for (int i = 0; field == null && i < fieldArray.length; ++i) {
            for (int j = 0; field == null && j < classArray.length; ++j) {
                if (!fieldArray[i].isAnnotationPresent(classArray[j])) continue;
                field = fieldArray[i];
            }
        }
        if (field == null) {
            throw new NoSuchFieldException(String.format(ANNOTATION, clazz.getName(), Arrays.toString(classArray)));
        }
        return field;
    }

    public static <A extends Annotation> A getAnnotationOnProperty(Class<?> clazz, Class<A> clazz2, String string) throws NoSuchFieldException {
        AssertTools.assertNotNull(clazz);
        AssertTools.assertNotNull(clazz2);
        return clazz.getField(string).getAnnotation(clazz2);
    }

    public static Object getValue(Object object, AccessType accessType, String string) {
        Object object2;
        AssertTools.assertNotNull(object);
        AssertTools.assertNotNull((Object)accessType);
        AssertTools.assertNotEmpty(string);
        switch (accessType) {
            case GETTER: {
                try {
                    object2 = new PropertyDescriptor(string, object.getClass(), "is" + StringUtils.capitalize((String)string), null).getReadMethod().invoke(object, PARAMETERS);
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(exception);
                }
            }
            case FIELD: {
                try {
                    object2 = object.getClass().getField(string).get(object);
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(exception);
                }
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return object2;
    }

    public static Object getValueFromPath(Object object, AccessType accessType, String string) {
        AssertTools.assertNotNull(object);
        AssertTools.assertNotNull((Object)accessType);
        AssertTools.assertNotEmpty(string);
        List<String> list = BeanTools.createAccessBeanList(string);
        Object object2 = object;
        for (String string2 : list) {
            object2 = BeanTools.getValue(object2, AccessType.GETTER, string2);
        }
        return object2;
    }

    private static List<String> createAccessBeanList(String string) {
        Matcher matcher = Pattern.compile("\\w+").matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            arrayList.add(string.substring(matcher.start(), matcher.end()));
        }
        return arrayList;
    }

    public static int hashCode(Object object, Field ... fieldArray) {
        int n;
        AssertTools.assertNotNull(object);
        AssertTools.assertNotEmpty(fieldArray);
        AssertTools.assertArrayNotNull(fieldArray);
        int n2 = n = object.getClass().hashCode();
        for (Field field : fieldArray) {
            Object object2;
            try {
                object2 = field.get(object);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(String.format(FIELD, object.getClass(), field.getName()), exception);
            }
            n2 += object2 != null ? n ^ object2.hashCode() : 0;
        }
        return n2;
    }

    public static int hashCode(Object object, Object ... objectArray) {
        int n;
        AssertTools.assertNotNull(object);
        AssertTools.assertNotEmpty(objectArray);
        AssertTools.assertNotNull(objectArray);
        int n2 = n = object.getClass().hashCode();
        for (Object object2 : objectArray) {
            n2 += object2 != null ? n ^ object2.hashCode() : 0;
        }
        return n2;
    }

    public static <A extends Annotation> boolean isAnnotationOnProperty(Class<?> clazz, Class<A> clazz2, String string) throws NoSuchFieldException {
        return BeanTools.getAnnotationOnProperty(clazz, clazz2, string) != null;
    }

    public static String toString(Object object, String string, AccessType accessType, String ... stringArray) {
        AssertTools.assertNotNull(object);
        AssertTools.assertNotEmpty(string);
        AssertTools.assertArrayNotNull(stringArray);
        Class<?> clazz = object.getClass();
        StringBuilder stringBuilder = new StringBuilder(clazz.getName());
        for (String string2 : stringArray) {
            try {
                Object object2 = BeanTools.getValueFromPath(object, accessType, string2);
                stringBuilder.append(string + string2 + ": " + (object2 != null ? object2.toString() : "<null>"));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(String.format(FIELD, clazz, string2), exception);
            }
        }
        return stringBuilder.toString();
    }

    public static String toString(Object object, AccessType accessType, String ... stringArray) {
        return BeanTools.toString(object, "\n- ", accessType, stringArray);
    }

    private BeanTools() {
    }

    public static String beanListToString(List<? extends Object> list, AccessType accessType, String ... stringArray) {
        return BeanTools.beanListToString(list, "\n", ", ", accessType, stringArray);
    }

    public static String beanListToString(List<? extends Object> list, String string, String string2, AccessType accessType, String ... stringArray) {
        AssertTools.assertNotNull(list);
        AssertTools.assertNotEmpty(string2);
        AssertTools.assertNotEmpty(string);
        AssertTools.assertNotNull((Object)accessType);
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<? extends Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            stringBuilder.append(BeanTools.toString(object, string2, accessType, stringArray));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static <T> Comparator<T> createPropertyComparator(String string) {
        return new BeanComparator(string);
    }

    public static <T> Comparator<T> createPropertyComparator(String string, Comparator<T> comparator) {
        return new BeanComparator(string, comparator);
    }

    public static enum AccessType {
        FIELD,
        GETTER;

    }
}

