/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.module.utils;

import java.util.Arrays;
import java.util.Collection;

public final class AssertTools {
    private static final String CLASS = "Argument must be of type %s";
    private static final String EQUALS = "Argument must be equals to %s";
    private static final String GREATER = "Argument must be greater than %s";
    private static final String GREATER_OR_EQUALS = "Argument must be greater than or equals to %s";
    private static final String IN = "Argument must be in %s";
    private static final String LOWER = "Argument must be lower than %s";
    private static final String LOWER_OR_EQUALS = "Argument must be lower than or equals to %s";
    private static final String NOT_EMPTY = "Argument must not be empty";
    private static final String NOT_EQUALS = "Argument must not be equals to %s";
    private static final String NOT_NULL = "Argument must not be null";

    public static void assertArrayNotEmpty(String[] stringArray) {
        AssertTools.assertNotNull(stringArray);
        for (String string : stringArray) {
            AssertTools.assertNotEmpty(string);
        }
    }

    public static void assertArrayNotNull(Object[] objectArray) {
        AssertTools.assertNotNull(objectArray);
        for (Object object : objectArray) {
            AssertTools.assertNotNull(object);
        }
    }

    public static void assertClassOrInterface(Object object, Class<?> clazz) {
        AssertTools.assertNotNull(object);
        AssertTools.assertNotNull(clazz);
        assert (clazz.isAssignableFrom(object.getClass())) : String.format("Argument must be of type %s", clazz.getName());
    }

    public static void assertCollectionNotNull(Collection<?> collection) {
        AssertTools.assertNotNull(collection);
        for (Object obj : collection) {
            AssertTools.assertNotNull(obj);
        }
    }

    public static <N extends Number> void assertEquals(N n, N n2) {
        assert (n.doubleValue() == n2.doubleValue()) : String.format("Argument must be equals to %s", n2);
    }

    public static <N extends Number> void assertGreater(N n, N n2) {
        assert (n.doubleValue() > n2.doubleValue()) : String.format("Argument must be greater than %s", n2);
    }

    public static <N extends Number> void assertGreaterOrEquals(N n, N n2) {
        assert (n.doubleValue() >= n2.doubleValue()) : String.format("Argument must be greater than or equals to %s", n2);
    }

    public static <O> void assertIn(O o, Collection<O> collection) {
        AssertTools.assertNotNull(o);
        AssertTools.assertNotEmpty(collection);
        assert (collection.contains(o)) : String.format("Argument must be in %s", o);
    }

    public static <O> void assertIn(O o, O ... OArray) {
        AssertTools.assertNotEmpty(OArray);
        AssertTools.assertIn(o, Arrays.asList(OArray));
    }

    public static <N extends Number> void assertLower(N n, N n2) {
        assert (n.doubleValue() < n2.doubleValue()) : String.format("Argument must be lower than %s", n2);
    }

    public static <N extends Number> void assertLowerOrEquals(N n, N n2) {
        assert (n.doubleValue() <= n2.doubleValue()) : String.format("Argument must be lower than or equals to %s", n2);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        AssertTools.assertNotNull(collection);
        assert (!collection.isEmpty()) : "Argument must not be empty";
    }

    public static void assertNotEmpty(Object[] objectArray) {
        AssertTools.assertNotNull(objectArray);
        assert (objectArray.length > 0) : "Argument must not be empty";
    }

    public static void assertNotEmpty(String string) {
        AssertTools.assertNotNull(string);
        assert (!string.isEmpty()) : "Argument must not be empty";
    }

    public static <N extends Number> void assertNotEquals(N n, N n2) {
        assert (n.doubleValue() != n2.doubleValue()) : String.format("Argument must not be equals to %s", n2);
    }

    public static <N extends Number> void assertNotNegative(N n) {
        AssertTools.assertGreaterOrEquals(n, 0);
    }

    public static void assertNotNull(Object object) {
        assert (object != null) : "Argument must not be null";
    }

    public static <N extends Number> void assertPositive(N n) {
        AssertTools.assertGreater(n, 0);
    }

    private AssertTools() {
    }
}

