/*
 * Cantharella, Pharmacochemical database of natural substances - http://sourceforge.net/p/cantharella/ 
 * 
 * Copyright (C) 2009-2012 IRD (Institut de Recherche pour le Developpement) and by respective authors (see below)
 *
 * Cantharella is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * Cantharella is distributed in the hope that it will be useful,but WITHOUT ANY WARRANTY; without even the implied 
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more 
 * details.
 *
 * You should have received a copy of the GNU General Public License along with Cantharella.  If not, see 
 * <http://www.gnu.org/licenses/>.
 */
package nc.ird.module.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Tools for logging
 * @author Mickael Tricot
 * @author Adrien Cheype
 */
public final class LogTools {

	/**
	 * Create a logger by retrieving the caller class. This method is expensive, so you may use it only once in each
	 * class.
	 * @return Logger
	 */
	public static Log getLog() {
		//old methode to get the class in a static methode
		//new LogConfigurationException().fillInStackTrace().getStackTrace()[1].getClassName()
		return LogFactory.getLog(GenericsTools.getCallerClass());
	}

	/**
	 * Constructor (prevents from instantiation)
	 */
	private LogTools() {
		//
	}
}
