/*
 * Cantharella, Pharmacochemical database of natural substances - http://sourceforge.net/p/cantharella/ 
 * 
 * Copyright (C) 2009-2012 IRD (Institut de Recherche pour le Developpement) and by respective authors (see below)
 *
 * Cantharella is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * Cantharella is distributed in the hope that it will be useful,but WITHOUT ANY WARRANTY; without even the implied 
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more 
 * details.
 *
 * You should have received a copy of the GNU General Public License along with Cantharella.  If not, see 
 * <http://www.gnu.org/licenses/>.
 */
package nc.ird.module.utils;

import sun.reflect.Reflection;

/**
 * Tools for generics classes
 * @author Mickael Tricot
 * @author Adrien Cheype
 */
@SuppressWarnings("restriction")
public final class GenericsTools {

	/**
	 * Object cast
	 * @param <I> Input type
	 * @param <O> Output type
	 * @param i Input object
	 * @return Output object
	 */
	@SuppressWarnings("unchecked")
	public static <I, O extends I> O cast(I i) {
		return (O) i;
	}

	/**
	 * Constructor (prevents instantiation)
	 */
	private GenericsTools() {
		//
	}
	
	/**
	 * Return the class where this method is called 
	 * @return this class
	 */
	public static Class<?> getCallerClass(){
		// Warning, access type of this method is forbidden (you must configure your IDE tu use it)
		// work only with SUN JVM
		return Reflection.getCallerClass(1);
	}
	
}
