/*
 * Cantharella, Pharmacochemical database of natural substances - http://sourceforge.net/p/cantharella/ 
 * 
 * Copyright (C) 2009-2012 IRD (Institut de Recherche pour le Developpement) and by respective authors (see below)
 *
 * Cantharella is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * Cantharella is distributed in the hope that it will be useful,but WITHOUT ANY WARRANTY; without even the implied 
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more 
 * details.
 *
 * You should have received a copy of the GNU General Public License along with Cantharella.  If not, see 
 * <http://www.gnu.org/licenses/>.
 */
package nc.ird.module.utils;

import nc.ird.module.utils.BeanTools.AccessType;

import org.apache.commons.lang.text.StrLookup;

/**
 * Retrieve a bean field value from the bean field name
 * @author Mickael Tricot
 * @author Adrien Cheype
 */
public final class BeanLookup extends StrLookup {

	/** Access type */
	private final AccessType accessType;

	/** Bean */
	private final Object bean;

	/**
	 * Constructor
	 * @param bean Bean
	 * @param accessType Access type
	 */
	public BeanLookup(Object bean, AccessType accessType) {
		super();
		AssertTools.assertNotNull(bean);
		AssertTools.assertNotNull(accessType);
		this.bean = bean;
		this.accessType = accessType;
	}

	/** {@inheritDoc} */
	@Override
	public String lookup(String key) {
		AssertTools.assertNotNull(key);
		Object value;
		try {
			value = BeanTools.getValue(bean, accessType, key);
		} catch (IllegalArgumentException e) {
			value = null;
		}
		return value != null ? value.toString() : null;
	}
}