/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.testBio;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.ErreurTestBio;
import nc.ird.cantharella.data.model.MethodeTestBio;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.data.model.ResultatTestBio;
import nc.ird.cantharella.data.model.TestBio;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.service.services.ProduitService;
import nc.ird.cantharella.service.services.TestBioService;
import nc.ird.cantharella.utils.BeanTools;
import nc.ird.cantharella.utils.CollectionTools;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.document.panel.ManageListDocumentsPanel;
import nc.ird.cantharella.web.pages.domain.testBio.ManageTestBioPage;
import nc.ird.cantharella.web.pages.renderers.PersonneRenderer;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.AutoCompleteTextFieldString;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.panels.SimpleTooltipPanel;
import nc.ird.cantharella.web.utils.renderers.EnumChoiceRenderer;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.StringValueConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthRoles(value={AuthRole.ADMIN, AuthRole.USER})
public final class ManageTestBioPage
extends TemplatePage {
    private static final Logger LOG = LoggerFactory.getLogger(ManageTestBioPage.class);
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_UPDATE = "Update";
    private static final String ACTION_DELETE = "Delete";
    private final IModel<TestBio> testBioModel;
    private Model<ResultatTestBio> newResultatModel;
    @SpringBean
    private TestBioService testBioService;
    @SpringBean
    private PersonneService personneService;
    @SpringBean
    private ProduitService produitService;
    private final List<Personne> personnes;
    private final List<MethodeTestBio> methodes;
    private final List<String> organismes;
    private final List<String> produitsTemoins;
    private final List<Produit> produits;
    private final List<ErreurTestBio> erreurs;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private final CallerPage callerPage;
    private boolean multipleEntry;
    Button addResultatButton;
    MarkupContainer descriptionMethoContainer;
    MarkupContainer paramsMethoContainer;
    TextField<BigDecimal> concMasseDefautInput;
    DropDownChoice<ResultatTestBio.UniteConcMasse> uniteConcMasseDefautInput;
    TextField<BigInteger> concMasseInput;
    DropDownChoice<ResultatTestBio.UniteConcMasse> uniteConcMasseInput;
    DropDownChoice<ResultatTestBio.Stade> stadeInput;

    public ManageTestBioPage(CallerPage callerPage, boolean multipleEntry) {
        this(null, null, callerPage, multipleEntry);
    }

    public ManageTestBioPage(Integer idManip, CallerPage callerPage) {
        this(idManip, null, callerPage, false);
    }

    public ManageTestBioPage(TestBio manip, CallerPage callerPage) {
        this(null, manip, callerPage, true);
    }

    private ManageTestBioPage(Integer idManip, TestBio manip, CallerPage callerPage, boolean multipleEntry) {
        super(ManageTestBioPage.class);
        boolean createMode;
        assert (idManip == null || manip == null);
        this.callerPage = callerPage;
        CallerPage currentPage = new CallerPage((TemplatePage)this);
        this.multipleEntry = multipleEntry;
        this.newResultatModel = new Model((Serializable)new ResultatTestBio());
        try {
            this.testBioModel = new Model((Serializable)(idManip == null && manip == null ? new TestBio() : (manip != null ? manip : this.testBioService.loadTestBio(idManip))));
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        boolean bl = createMode = idManip == null;
        if (createMode) {
            ((TestBio)this.testBioModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.personnes = this.personneService.listPersonnes();
        this.methodes = this.testBioService.listMethodesTestBio();
        this.produits = this.produitService.listProduits(this.getSession().getUtilisateur());
        this.erreurs = this.testBioService.listErreursTestBio();
        if (manip != null) {
            ((TestBio)this.testBioModel.getObject()).setManipulateur((Personne)CollectionTools.findWithValue((List)this.personnes, (String)"idPersonne", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((TestBio)this.testBioModel.getObject()).getManipulateur().getIdPersonne()));
            ((TestBio)this.testBioModel.getObject()).setMethode((MethodeTestBio)CollectionTools.findWithValue((List)this.methodes, (String)"idMethodeTest", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((TestBio)this.testBioModel.getObject()).getMethode().getIdMethodeTest()));
        }
        this.organismes = this.personneService.listPersonneOrganismes();
        this.produitsTemoins = this.testBioService.listProduitsTemoins();
        Form formView = new Form("Form");
        this.initPrincipalFields(formView);
        this.initMethodeFields(formView);
        this.initResultatsFields(formView);
        ManageListDocumentsPanel manageListDocumentsPanel = new ManageListDocumentsPanel("ManageListDocumentsPanel", this.testBioModel, currentPage);
        formView.add(new Component[]{manageListDocumentsPanel});
        SubmittableButton createButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        createButton.setVisibilityAllowed(createMode);
        formView.add(new Component[]{createButton});
        SubmittableButton updateButton = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        updateButton.setVisibilityAllowed(!createMode);
        formView.add(new Component[]{updateButton});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(!createMode);
        deleteButton.setDefaultFormProcessing(false);
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        formView.add(new Component[]{deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.setDefaultButton((IFormSubmittingComponent)this.addResultatButton);
        this.add(new Component[]{formView});
    }

    private void initPrincipalFields(Form<Void> formView) {
        formView.add(new Component[]{new TextField("TestBio.ref", (IModel)new PropertyModel((Object)this.testBioModel, "ref"))});
        formView.add(new Component[]{new DropDownChoice("TestBio.manipulateur", (IModel)new PropertyModel((Object)this.testBioModel, "manipulateur"), this.personnes, (IChoiceRenderer)new PersonneRenderer()).setNullValid(false)});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{new AutoCompleteTextFieldString("TestBio.organismeTesteur", (IModel)new PropertyModel((Object)this.testBioModel, "organismeTesteur"), this.organismes, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        formView.add(new Component[]{new DateTextField("TestBio.date", (IModel)new PropertyModel((Object)this.testBioModel, "date")).add(new Behavior[]{new DatePicker()})});
        this.concMasseDefautInput = new TextField("TestBio.concMasseDefaut", (IModel)new PropertyModel((Object)this.testBioModel, "concMasseDefaut"));
        this.concMasseDefautInput.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{this.concMasseDefautInput});
        this.uniteConcMasseDefautInput = new DropDownChoice("TestBio.uniteConcMasseDefaut", (IModel)new PropertyModel((Object)this.testBioModel, "uniteConcMasseDefaut"), Arrays.asList(ResultatTestBio.UniteConcMasse.values()), (IChoiceRenderer)new EnumChoiceRenderer((TemplatePage)this));
        this.uniteConcMasseDefautInput.setNullValid(true);
        this.uniteConcMasseDefautInput.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{this.uniteConcMasseDefautInput});
        DropDownChoice stadeDefautInput = new DropDownChoice("TestBio.stadeDefaut", (IModel)new PropertyModel((Object)this.testBioModel, "stadeDefaut"), Arrays.asList(ResultatTestBio.Stade.values()), (IChoiceRenderer)new EnumChoiceRenderer((TemplatePage)this));
        stadeDefautInput.setNullValid(true);
        stadeDefautInput.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{stadeDefautInput});
        formView.add(new Component[]{new TextArea("TestBio.complement", (IModel)new PropertyModel((Object)this.testBioModel, "complement"))});
        formView.add(new Component[]{new TextField("TestBio.createur", (IModel)new PropertyModel((Object)this.testBioModel, "createur")).setEnabled(false)});
    }

    private void initMethodeFields(Form<Void> formView) {
        WebMarkupContainer methodeCont = new WebMarkupContainer("TestBio.methode");
        methodeCont.setOutputMarkupId(true);
        formView.add(new Component[]{methodeCont});
        this.descriptionMethoContainer = new /* Unavailable Anonymous Inner Class!! */;
        this.descriptionMethoContainer.setOutputMarkupId(true);
        this.descriptionMethoContainer.setOutputMarkupPlaceholderTag(true);
        methodeCont.add(new Component[]{this.descriptionMethoContainer});
        Label methodeCible = new Label("TestBio.cibleMethode", (IModel)new PropertyModel((Object)this.testBioModel, "methode.cible"));
        this.descriptionMethoContainer.add(new Component[]{methodeCible});
        Label methodeDomaine = new Label("TestBio.domaineMethode", (IModel)new PropertyModel((Object)this.testBioModel, "methode.domaine"));
        this.descriptionMethoContainer.add(new Component[]{methodeDomaine});
        MultiLineLabel methodeDesc = new MultiLineLabel("TestBio.descriptionMethode", (IModel)new PropertyModel((Object)this.testBioModel, "methode.description"));
        this.descriptionMethoContainer.add(new Component[]{methodeDesc});
        Label methodeValeurMesuree = new Label("TestBio.valeurMesureeMethode", (IModel)new PropertyModel((Object)this.testBioModel, "methode.valeurMesuree"));
        this.descriptionMethoContainer.add(new Component[]{methodeValeurMesuree});
        Label methodeCritereActivite = new Label("TestBio.critereActiviteMethode", (IModel)new PropertyModel((Object)this.testBioModel, "methode.critereActivite"));
        this.descriptionMethoContainer.add(new Component[]{methodeCritereActivite});
        Label methodeUniteResultat = new Label("TestBio.uniteResultatMethode", (IModel)new PropertyModel((Object)this.testBioModel, "methode.uniteResultat"));
        this.descriptionMethoContainer.add(new Component[]{methodeUniteResultat});
        DropDownChoice methodeChoice = new DropDownChoice("TestBio.nomMethode", (IModel)new PropertyModel((Object)this.testBioModel, "methode"), this.methodes);
        methodeChoice.setNullValid(false);
        methodeChoice.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        methodeCont.add(new Component[]{methodeChoice});
    }

    private void initResultatsFields(Form<Void> formView) {
        WebMarkupContainer testsBioTable = new WebMarkupContainer("TestBio.resultats.Table");
        testsBioTable.setOutputMarkupId(true);
        testsBioTable.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        testsBioTable.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        13 typeResultatChoice = new /* Unavailable Anonymous Inner Class!! */;
        typeResultatChoice.setNullValid(false);
        testsBioTable.add(new Component[]{typeResultatChoice});
        14 produitChoice = new /* Unavailable Anonymous Inner Class!! */;
        produitChoice.setOutputMarkupId(true);
        produitChoice.setOutputMarkupPlaceholderTag(true);
        testsBioTable.add(new Component[]{produitChoice});
        15 produitTemoinInput = new /* Unavailable Anonymous Inner Class!! */;
        produitTemoinInput.setOutputMarkupId(true);
        produitTemoinInput.setOutputMarkupPlaceholderTag(true);
        testsBioTable.add(new Component[]{produitTemoinInput});
        this.concMasseInput = new TextField("TestBio.resultats.concMasse", (IModel)new PropertyModel((Object)this.newResultatModel, "concMasse"));
        this.concMasseInput.setOutputMarkupId(true);
        this.concMasseInput.setOutputMarkupPlaceholderTag(true);
        testsBioTable.add(new Component[]{this.concMasseInput});
        this.uniteConcMasseInput = new DropDownChoice("TestBio.resultats.uniteConcMasse", (IModel)new PropertyModel((Object)this.newResultatModel, "uniteConcMasse"), Arrays.asList(ResultatTestBio.UniteConcMasse.values()), (IChoiceRenderer)new EnumChoiceRenderer((TemplatePage)this));
        this.uniteConcMasseInput.setOutputMarkupId(true);
        this.uniteConcMasseInput.setOutputMarkupPlaceholderTag(true);
        this.uniteConcMasseInput.setNullValid(true);
        testsBioTable.add(new Component[]{this.uniteConcMasseInput});
        this.stadeInput = new /* Unavailable Anonymous Inner Class!! */;
        this.stadeInput.setOutputMarkupId(true);
        this.stadeInput.setOutputMarkupPlaceholderTag(true);
        testsBioTable.add(new Component[]{this.stadeInput});
        testsBioTable.add(new Component[]{new CheckBox("TestBio.resultats.actif", (IModel)new PropertyModel((Object)this.newResultatModel, "actif"))});
        DropDownChoice erreurChoice = new DropDownChoice("TestBio.resultats.erreur", (IModel)new PropertyModel((Object)this.newResultatModel, "erreur"), this.erreurs);
        erreurChoice.setNullValid(true);
        testsBioTable.add(new Component[]{erreurChoice});
        SimpleTooltipPanel infoBulle = new SimpleTooltipPanel("TestBio.resultats.erreur.info", (IModel)new PropertyModel((Object)this.newResultatModel, "erreur.description"));
        infoBulle.setVisibilityAllowed(false);
        infoBulle.setOutputMarkupId(true);
        infoBulle.setOutputMarkupPlaceholderTag(true);
        testsBioTable.add(new Component[]{infoBulle});
        17 valeurInput = new /* Unavailable Anonymous Inner Class!! */;
        valeurInput.setOutputMarkupId(true);
        valeurInput.setOutputMarkupPlaceholderTag(true);
        testsBioTable.add(new Component[]{valeurInput});
        typeResultatChoice.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        erreurChoice.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        this.addResultatButton = new /* Unavailable Anonymous Inner Class!! */;
        testsBioTable.add(new Component[]{this.addResultatButton});
        formView.add(new Component[]{testsBioTable});
        ((ResultatTestBio)this.newResultatModel.getObject()).setTypeResultat(ResultatTestBio.TypeResultat.PRODUIT);
        this.activeInputsForProduitType((DropDownChoice)produitChoice, (TextField)produitTemoinInput, this.concMasseInput, this.uniteConcMasseInput, this.stadeInput, false, null);
    }

    protected void onBeforeRender() {
        this.refreshModel();
        super.onBeforeRender();
    }

    private void redirect() {
        if (this.multipleEntry) {
            TestBio nextManip = new TestBio();
            nextManip.setManipulateur(((TestBio)this.testBioModel.getObject()).getManipulateur());
            nextManip.setOrganismeTesteur(((TestBio)this.testBioModel.getObject()).getOrganismeTesteur());
            nextManip.setMethode(((TestBio)this.testBioModel.getObject()).getMethode());
            this.setResponsePage((Page)new ManageTestBioPage(nextManip, this.callerPage));
        } else if (this.callerPage != null) {
            this.callerPage.addPageParameter(TestBio.class.getSimpleName(), this.testBioModel.getObject());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void refreshModel() {
        String key = Personne.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(key)) {
            CollectionTools.setter((Collection)this.personnes, (Collection)this.personneService.listPersonnes());
            try {
                Personne createdPersonne = this.personneService.loadPersonne(Integer.valueOf(this.getPageParameters().get(key).toInt()));
                ((TestBio)this.testBioModel.getObject()).setManipulateur(createdPersonne);
            }
            catch (StringValueConversionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            catch (DataNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            this.getPageParameters().remove(key, new String[0]);
        }
    }

    private void activeInputsForBlancType(DropDownChoice<Produit> produitChoice, TextField<String> produitTemoinInput, TextField<BigInteger> concMasseInput, DropDownChoice<ResultatTestBio.UniteConcMasse> uniteConcMasseChoice, DropDownChoice<ResultatTestBio.Stade> stadeChoice, AjaxRequestTarget target) {
        produitChoice.setNullValid(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setProduit(null);
        produitChoice.setVisibilityAllowed(false);
        ((ResultatTestBio)this.newResultatModel.getObject()).setProduitTemoin(null);
        produitTemoinInput.setVisibilityAllowed(false);
        ((ResultatTestBio)this.newResultatModel.getObject()).setConcMasse(null);
        concMasseInput.setVisibilityAllowed(false);
        ((ResultatTestBio)this.newResultatModel.getObject()).setUniteConcMasse(null);
        uniteConcMasseChoice.setVisibilityAllowed(false);
        stadeChoice.setNullValid(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setStade(null);
        stadeChoice.setVisibilityAllowed(false);
        target.add(new Component[]{produitChoice, produitTemoinInput, concMasseInput, uniteConcMasseChoice, stadeChoice});
    }

    private void activeInputsForTemoinType(DropDownChoice<Produit> produitChoice, TextField<String> produitTemoinInput, TextField<BigInteger> concMasseInput, DropDownChoice<ResultatTestBio.UniteConcMasse> uniteConcMasseChoice, DropDownChoice<ResultatTestBio.Stade> stadeChoice, AjaxRequestTarget target) {
        produitChoice.setNullValid(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setProduit(null);
        produitChoice.setVisibilityAllowed(false);
        stadeChoice.setNullValid(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setStade(null);
        stadeChoice.setVisibilityAllowed(false);
        produitTemoinInput.setVisibilityAllowed(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setConcMasse((BigDecimal)this.concMasseDefautInput.getModelObject());
        concMasseInput.setVisibilityAllowed(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setUniteConcMasse(((TestBio)this.testBioModel.getObject()).getUniteConcMasseDefaut());
        uniteConcMasseChoice.setVisibilityAllowed(true);
        target.add(new Component[]{produitChoice, produitTemoinInput, concMasseInput, uniteConcMasseChoice, stadeChoice});
    }

    private void activeInputsForProduitType(DropDownChoice<Produit> produitChoice, TextField<String> produitTemoinInput, TextField<BigInteger> concMasseInput, DropDownChoice<ResultatTestBio.UniteConcMasse> uniteConcMasseChoice, DropDownChoice<ResultatTestBio.Stade> stadeChoice, boolean isAjaxRequete, AjaxRequestTarget target) {
        ((ResultatTestBio)this.newResultatModel.getObject()).setProduitTemoin(null);
        produitTemoinInput.setVisibilityAllowed(false);
        produitChoice.setNullValid(false);
        produitChoice.setVisibilityAllowed(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setConcMasse(((TestBio)this.testBioModel.getObject()).getConcMasseDefaut());
        concMasseInput.setVisibilityAllowed(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setUniteConcMasse(((TestBio)this.testBioModel.getObject()).getUniteConcMasseDefaut());
        uniteConcMasseChoice.setVisibilityAllowed(true);
        stadeChoice.setNullValid(false);
        ((ResultatTestBio)this.newResultatModel.getObject()).setStade(((TestBio)this.testBioModel.getObject()).getStadeDefaut());
        stadeChoice.setVisibilityAllowed(true);
        if (isAjaxRequete) {
            target.add(new Component[]{produitChoice, produitTemoinInput, concMasseInput, uniteConcMasseChoice, stadeChoice});
        }
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.testBioModel.getObject(), this.getSession().getLocale(), new String[0]));
        if (!CollectionTools.containsWithValue((Collection)((TestBio)this.testBioModel.getObject()).getResultats(), (String)"typeResultat", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)ResultatTestBio.TypeResultat.PRODUIT)) {
            this.error((Serializable)((Object)this.getString("TestBio.resultats.noProduit")));
        }
        if (!this.testBioService.isTestBioUnique((TestBio)this.testBioModel.getObject())) {
            this.error((Serializable)((Object)this.getString("TestBio.notUnique")));
        }
    }

    static /* synthetic */ IModel access$000(ManageTestBioPage x0) {
        return x0.testBioModel;
    }

    static /* synthetic */ TestBioService access$100(ManageTestBioPage x0) {
        return x0.testBioService;
    }

    static /* synthetic */ void access$200(ManageTestBioPage x0) {
        x0.redirect();
    }

    static /* synthetic */ void access$300(ManageTestBioPage x0) {
        x0.validateModel();
    }

    static /* synthetic */ Model access$400(ManageTestBioPage x0) {
        return x0.newResultatModel;
    }

    static /* synthetic */ void access$500(ManageTestBioPage x0, DropDownChoice x1, TextField x2, TextField x3, DropDownChoice x4, DropDownChoice x5, AjaxRequestTarget x6) {
        x0.activeInputsForBlancType(x1, x2, x3, x4, x5, x6);
    }

    static /* synthetic */ void access$600(ManageTestBioPage x0, DropDownChoice x1, TextField x2, TextField x3, DropDownChoice x4, DropDownChoice x5, AjaxRequestTarget x6) {
        x0.activeInputsForTemoinType(x1, x2, x3, x4, x5, x6);
    }

    static /* synthetic */ void access$700(ManageTestBioPage x0, DropDownChoice x1, TextField x2, TextField x3, DropDownChoice x4, DropDownChoice x5, boolean x6, AjaxRequestTarget x7) {
        x0.activeInputsForProduitType(x1, x2, x3, x4, x5, x6, x7);
    }

    static /* synthetic */ ModelValidator access$800(ManageTestBioPage x0) {
        return x0.validator;
    }

    static /* synthetic */ Logger access$900() {
        return LOG;
    }
}

