/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.columns;

import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.utils.BeanTools;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.utils.columns.LinkPropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;

public abstract class LinkProduitPropertyColumn<T, S>
extends LinkPropertyColumn<T, S> {
    private final TemplatePage page;

    public LinkProduitPropertyColumn(IModel<String> displayModel, S sortProperty, String propertyExpression, TemplatePage page) {
        super(displayModel, sortProperty, propertyExpression);
        this.page = page;
    }

    public void onClick(Item<ICellPopulator<T>> item, String componentId, IModel<T> model) {
        if (model.getObject() != null) {
            Produit prod = (Produit)BeanTools.getValue((Object)model.getObject(), (BeanTools.AccessType)BeanTools.AccessType.GETTER, (String)"produit");
            if (prod.isExtrait()) {
                Extrait extrait = (Extrait)prod;
                this.onClickIfExtrait(extrait);
            } else {
                Fraction fraction = (Fraction)prod;
                this.onClickIfFraction(fraction);
            }
        }
    }

    public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> model) {
        if (model.getObject() != null) {
            Produit prod = (Produit)BeanTools.getValue((Object)model.getObject(), (BeanTools.AccessType)BeanTools.AccessType.GETTER, (String)"produit");
            this.linkTitle = prod.isExtrait() ? this.page.getStringModel("ReadExtraction", new Object[0]) : this.page.getStringModel("ReadPurification", new Object[0]);
        }
        super.populateItem(item, componentId, model);
    }

    public abstract void onClickIfExtrait(Extrait var1);

    public abstract void onClickIfFraction(Fraction var1);
}

