/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.CampagneService;
import nc.ird.cantharella.service.services.ExtractionService;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.cantharella.service.services.MoleculeService;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.service.services.PurificationService;
import nc.ird.cantharella.service.services.SpecimenService;
import nc.ird.cantharella.service.services.StationService;
import nc.ird.cantharella.service.services.TestBioService;
import nc.ird.cantharella.web.pages.HomePage;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.utilisateur.RegisterPage;
import nc.ird.cantharella.web.pages.domain.utilisateur.ResetPasswordPage;
import nc.ird.cantharella.web.pages.model.LoginModel;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.security.AuthContainer;
import nc.ird.cantharella.web.utils.security.AuthRole;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HomePage
extends TemplatePage {
    private static final Logger LOG = LoggerFactory.getLogger(HomePage.class);
    private static final String ACTION_LOGIN = "Login";
    @SpringBean
    private PersonneService personneService;
    @SpringBean
    private CampagneService campagneService;
    @SpringBean
    private StationService stationService;
    @SpringBean
    private SpecimenService specimenService;
    @SpringBean
    private LotService lotService;
    @SpringBean
    private ExtractionService extractionService;
    @SpringBean
    private PurificationService purificationService;
    @SpringBean
    private MoleculeService moleculeService;
    @SpringBean
    private TestBioService testBioService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;

    public HomePage() {
        super(HomePage.class);
        this.addVisitorContent();
        this.addUserContent();
        this.addAdminContent();
    }

    private void addAdminContent() {
        AuthContainer adminContent = new AuthContainer("Content.ADMIN", new AuthRole[]{AuthRole.ADMIN});
        if (adminContent.isAuthorized()) {
            WebMarkupContainer invalidUtilisateursView = new WebMarkupContainer("InvalidUtilisateurs.List");
            invalidUtilisateursView.setOutputMarkupId(true);
            List utilisateursInvalid = this.personneService.listUtilisateursInvalid();
            invalidUtilisateursView.setVisibilityAllowed(!utilisateursInvalid.isEmpty());
            if (invalidUtilisateursView.isVisibilityAllowed()) {
                invalidUtilisateursView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
            }
            adminContent.add(new Component[]{invalidUtilisateursView});
        }
        this.add(new Component[]{adminContent});
    }

    private void addUserContent() {
        AuthContainer userContent = new AuthContainer("Content.USER", new AuthRole[]{AuthRole.USER, AuthRole.ADMIN});
        if (userContent.isAuthorized()) {
            userContent.add(new Component[]{new Label(this.getResource() + ".Statistics.Personnes", String.valueOf(this.personneService.countPersonnes()))});
            userContent.add(new Component[]{new Label(this.getResource() + ".Statistics.Campagnes", String.valueOf(this.campagneService.countCampagnes()))});
            userContent.add(new Component[]{new Label(this.getResource() + ".Statistics.Stations", String.valueOf(this.stationService.countStations()))});
            userContent.add(new Component[]{new Label(this.getResource() + ".Statistics.Specimens", String.valueOf(this.specimenService.countSpecimens()))});
            userContent.add(new Component[]{new Label(this.getResource() + ".Statistics.Lots", String.valueOf(this.lotService.countLots()))});
            userContent.add(new Component[]{new Label(this.getResource() + ".Statistics.Extractions", String.valueOf(this.extractionService.countExtractions()))});
            userContent.add(new Component[]{new Label(this.getResource() + ".Statistics.Purifications", String.valueOf(this.purificationService.countPurifications()))});
            userContent.add(new Component[]{new Label(this.getResource() + ".Statistics.Molecules", String.valueOf(this.moleculeService.countMolecules()))});
            userContent.add(new Component[]{new Label(this.getResource() + ".Statistics.TestsBio", String.valueOf(this.testBioService.countResultatsTestsBio()))});
            2 detailsRight = new /* Unavailable Anonymous Inner Class!! */;
            userContent.add(new Component[]{detailsRight});
            if (this.getSession().getUtilisateur().getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
                userContent.add(new Component[]{new Label("HomePage.Rights.User1", this.getStringModel("HomePage.Rights.Admin", new Object[0]))});
                detailsRight.setVisibilityAllowed(false);
                EmptyPanel rights2 = new EmptyPanel("HomePage.Rights.User2");
                rights2.setVisibilityAllowed(false);
                userContent.add(new Component[]{rights2});
            } else {
                Integer nbCampagnesDroits = this.getSession().getUtilisateur().getCampagnesDroits().size();
                Integer nbLotsDroits = this.getSession().getUtilisateur().getLotsDroits().size();
                String msgRights = MessageFormat.format(this.getString("HomePage.Rights.User"), nbCampagnesDroits, nbLotsDroits);
                userContent.add(new Component[]{new Label("HomePage.Rights.User1", msgRights)});
                Integer nbCampagnesCrees = this.getSession().getUtilisateur().getCampagnesCreees().size();
                String msgRights2 = MessageFormat.format(this.getString("HomePage.Rights.User2"), nbCampagnesCrees);
                Label rights2 = new Label("HomePage.Rights.User2", msgRights2);
                rights2.setVisibilityAllowed(nbCampagnesCrees != 0);
                userContent.add(new Component[]{rights2});
            }
        }
        this.add(new Component[]{userContent});
    }

    private void addVisitorContent() {
        AuthContainer visitorContent = new AuthContainer("Content.VISITOR", new AuthRole[]{AuthRole.VISITOR});
        if (visitorContent.isAuthorized()) {
            Model loginModel = new Model((Serializable)new LoginModel());
            Model utilisateurModel = new Model((Serializable)new Utilisateur());
            Form formView = new Form("Form");
            formView.add(new Component[]{new TextField("Personne.courriel", (IModel)new PropertyModel((Object)utilisateurModel, "courriel"))});
            formView.add(new Component[]{new PasswordTextField("LoginModel.password", (IModel)new PropertyModel((Object)loginModel, "password")).setRequired(false)});
            formView.add(new Component[]{new CheckBox("LoginModel.rememberMe", (IModel)new PropertyModel((Object)loginModel, "rememberMe"))});
            formView.add(new Component[]{new SubmittableButton(ACTION_LOGIN, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */)});
            formView.add(new Component[]{new BookmarkablePageLink(ResetPasswordPage.class.getSimpleName(), ResetPasswordPage.class)});
            visitorContent.add(new Component[]{new BookmarkablePageLink(RegisterPage.class.getSimpleName(), RegisterPage.class)});
            visitorContent.add(new Component[]{formView});
        }
        this.add(new Component[]{visitorContent});
    }

    static /* synthetic */ PersonneService access$000(HomePage x0) {
        return x0.personneService;
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    static /* synthetic */ ModelValidator access$200(HomePage x0) {
        return x0.validator;
    }
}

