/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.config;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.validation.ValidatorFactory;
import nc.ird.cantharella.data.config.DataContext;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.data.validation.utils.ModelValidatorImpl;
import nc.ird.cantharella.service.config.ServiceContext;
import nc.ird.cantharella.utils.CantharellaConfig;
import nc.ird.cantharella.utils.Pair;
import nc.ird.cantharella.utils.StringTools;
import nc.ird.cantharella.web.config.WebApplicationImpl;
import nc.ird.cantharella.web.utils.resources.WebMessages;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.time.Duration;
import org.nuiton.config.ArgumentsParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.util.Log4jConfigurer;

@Import(value={ServiceContext.class})
@Configuration
public abstract class WebContext {
    private static final Logger LOG = LoggerFactory.getLogger(WebContext.class);
    public static final String AUTH_COOKIE_KEY = "LoggedIn";
    public static final int AUTH_COOKIE_MAX_AGE = (int)Duration.days((int)1).seconds();
    public static final Map<Locale, Map<String, String>> COUNTRIES;
    public static final Map<Locale, List<String>> COUNTRY_CODES;
    public static final Map<Locale, Map<String, String>> LANGUAGES;
    public static final Map<Locale, List<String>> LANGUAGE_CODES;
    public static final Duration HTTP_CACHE_DURATION;
    public static final Bytes HTTP_MAXIMUM_UPLOAD;
    public static final int HTTP_REQUEST_LOGGER_WINDOW_SIZE = 2000;
    public static final int HTTP_SESSION_MAX_PAGE_MAPS = 5;
    public static final Duration HTTP_TIME_OUT;
    public static final List<Integer> REFERENTIEL_CODES;
    public static final int PERCENT_PRECISION = 2;
    public static final int DOUBLE_MAX_FRACTION_DIGIT = 3;
    public static final int ROWS_PER_PAGE = 20;
    @Resource(name="dataMessageSource")
    private MessageSourceAccessor dataMessageSource;
    @Resource(name="validatorFactory")
    private ValidatorFactory validatorFactory;
    @Value(value="${app.debug}")
    protected boolean appDebugProperty;
    @Value(value="${app.optimize}")
    protected boolean appOptimizeProperty;
    @Value(value="${wicket.configuration}")
    protected String wicketConfiguration;
    @Value(value="${log4j.config}")
    protected String log4jConfig;

    @Bean
    public MessageSourceAccessor webMessageSource() {
        ReloadableResourceBundleMessageSource source = new ReloadableResourceBundleMessageSource();
        source.setBasename("web");
        source.setDefaultEncoding(DataContext.ENCODING);
        source.setCacheSeconds(-1);
        return new MessageSourceAccessor((MessageSource)source);
    }

    @Bean
    public ModelValidator webModelValidator() {
        return new ModelValidatorImpl(this.validatorFactory, new MessageSourceAccessor[]{this.webMessageSource(), this.dataMessageSource});
    }

    @Bean
    public WebApplication webApplication() {
        RuntimeConfigurationType runtimeWicketConf = RuntimeConfigurationType.valueOf((String)this.wicketConfiguration.toUpperCase());
        return new WebApplicationImpl(this.appDebugProperty, this.appOptimizeProperty, runtimeWicketConf, new IStringResourceLoader[]{new WebMessages(this.dataMessageSource), new WebMessages(this.webMessageSource())});
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer properties() {
        PropertySourcesPlaceholderConfigurer pspc = new PropertySourcesPlaceholderConfigurer();
        try {
            pspc.setProperties(CantharellaConfig.getProperties());
        }
        catch (ArgumentsParserException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        pspc.setIgnoreUnresolvablePlaceholders(true);
        return pspc;
    }

    @PostConstruct
    public void initLog4j() throws FileNotFoundException {
        Log4jConfigurer.initLogging((String)this.log4jConfig);
    }

    static {
        HTTP_CACHE_DURATION = Duration.days((int)1);
        HTTP_MAXIMUM_UPLOAD = Bytes.megabytes((long)1L);
        HTTP_TIME_OUT = Duration.seconds((int)30);
        REFERENTIEL_CODES = new ArrayList(DataContext.REFERENTIELS.keySet());
        HashMap countries = new HashMap(DataContext.LOCALES.size());
        HashMap languages = new HashMap(DataContext.LOCALES.size());
        HashMap countryCodes = new HashMap(DataContext.LOCALES.size());
        HashMap languageCodes = new HashMap(DataContext.LOCALES.size());
        for (Locale locale : DataContext.LOCALES) {
            ArrayList<Pair> sortedCountryList = new ArrayList<Pair>(DataContext.COUNTRY_CODES.size());
            for (String countryCode : DataContext.COUNTRY_CODES) {
                String countryName = new Locale(locale.getLanguage(), countryCode).getDisplayCountry(locale);
                sortedCountryList.add(new Pair((Object)countryCode, (Object)new Pair((Object)StringTools.replaceAccents((String)countryName), (Object)countryName)));
            }
            ArrayList<Pair> sortedLanguageList = new ArrayList<Pair>(DataContext.LANGUAGE_CODES.size());
            for (String languageCode : DataContext.LANGUAGE_CODES) {
                String languageName = new Locale(languageCode, locale.getCountry()).getDisplayLanguage(locale);
                sortedLanguageList.add(new Pair((Object)languageCode, (Object)new Pair((Object)StringTools.replaceAccents((String)languageName), (Object)languageName)));
            }
            Collections.sort(sortedCountryList, new /* Unavailable Anonymous Inner Class!! */);
            Collections.sort(sortedLanguageList, new /* Unavailable Anonymous Inner Class!! */);
            LinkedHashMap<Object, Object> sortedCountryMap = new LinkedHashMap<Object, Object>(sortedCountryList.size());
            ArrayList<Object> sortedCountryCodesList = new ArrayList<Object>(sortedCountryList.size());
            for (Pair countryPair : sortedCountryList) {
                sortedCountryMap.put(countryPair.getKey(), ((Pair)countryPair.getValue()).getValue());
                sortedCountryCodesList.add(countryPair.getKey());
            }
            countries.put(locale, Collections.unmodifiableMap(sortedCountryMap));
            countryCodes.put(locale, Collections.unmodifiableList(sortedCountryCodesList));
            LinkedHashMap<Object, Object> sortedLanguageMap = new LinkedHashMap<Object, Object>(sortedCountryList.size());
            ArrayList<Object> sortedLanguageCodesList = new ArrayList<Object>(sortedCountryList.size());
            for (Pair languagePair : sortedLanguageList) {
                sortedLanguageMap.put(languagePair.getKey(), ((Pair)languagePair.getValue()).getValue());
                sortedLanguageCodesList.add(languagePair.getKey());
            }
            languages.put(locale, Collections.unmodifiableMap(sortedLanguageMap));
            languageCodes.put(locale, Collections.unmodifiableList(sortedLanguageCodesList));
        }
        COUNTRIES = Collections.unmodifiableMap(countries);
        COUNTRY_CODES = Collections.unmodifiableMap(countryCodes);
        LANGUAGES = Collections.unmodifiableMap(languages);
        LANGUAGE_CODES = Collections.unmodifiableMap(languageCodes);
    }
}

