// %%Ignore-License
// ChemDoodle Web Components 5.1.0
//
// http://web.chemdoodle.com
//
// Copyright 2009-2013 iChemLabs, LLC.  All rights reserved.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// As a special exception to the GPL, any HTML file in a public website
// or any free web service which merely makes function calls to this
// code, and for that purpose includes it by reference, shall be deemed
// a separate work for copyright law purposes. If you modify this code,
// you may extend this exception to your version of the code, but you
// are not obligated to do so. If you do not wish to do so, delete this
// exception statement from your version.
//
// As an additional exception to the GPL, you may distribute this
// packed form of the code without the copy of the GPL license normally
// required, provided you include this license notice and a URL through
// which recipients can access the corresponding unpacked source code.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// Please contact iChemLabs <http://www.ichemlabs.com/contact-us> for
// alternate licensing options.
//
ChemDoodle.sketcher=function(){var a={actions:{},gui:{}};a.gui.desktop={};a.gui.mobile={};a.states={};a.tools={};return a}();(function(a){a._Action=function(){};a=a._Action.prototype;a.forward=function(a){this.innerForward();this.checks(a)};a.reverse=function(a){this.innerReverse();this.checks(a)};a.checks=function(a){for(var e=0,b=a.molecules.length;e<b;e++)a.molecules[e].check();a.lasso&&a.lasso.isActive()&&a.lasso.setBounds();a.repaint()}})(ChemDoodle.sketcher.actions);
(function(a,f,e){e.AddAction=function(b,c,a,j){this.sketcher=b;this.a=c;this.as=a;this.bs=j};e=e.AddAction.prototype=new e._Action;e.innerForward=function(){var b=this.sketcher.getMoleculeByAtom(this.a);b||(b=new f.Molecule,this.sketcher.molecules.push(b));if(this.as)for(var c=0,a=this.as.length;c<a;c++)b.atoms.push(this.as[c]);if(this.bs){for(var j=[],c=0,a=this.bs.length;c<a;c++){var g=this.bs[c];if(-1===b.atoms.indexOf(g.a1)){var m=this.sketcher.getMoleculeByAtom(g.a1);-1===j.indexOf(m)&&j.push(m)}-1===
b.atoms.indexOf(g.a2)&&(m=this.sketcher.getMoleculeByAtom(g.a2),-1===j.indexOf(m)&&j.push(m));b.bonds.push(g)}c=0;for(a=j.length;c<a;c++)g=j[c],this.sketcher.removeMolecule(g),b.atoms=b.atoms.concat(g.atoms),b.bonds=b.bonds.concat(g.bonds)}};e.innerReverse=function(){var b=this.sketcher.getMoleculeByAtom(this.a);if(this.as){for(var c=[],d=0,j=b.atoms.length;d<j;d++)-1===this.as.indexOf(b.atoms[d])&&c.push(b.atoms[d]);b.atoms=c}if(this.bs){c=[];d=0;for(j=b.bonds.length;d<j;d++)-1===this.bs.indexOf(b.bonds[d])&&
c.push(b.bonds[d]);b.bonds=c}if(0===b.atoms.length)this.sketcher.removeMolecule(b);else if(c=(new a.Splitter).split(b),1<c.length){this.sketcher.removeMolecule(b);d=0;for(j=c.length;d<j;d++)this.sketcher.molecules.push(c[d])}}})(ChemDoodle.informatics,ChemDoodle.structures,ChemDoodle.sketcher.actions);(function(a){a.AddShapeAction=function(a,e){this.sketcher=a;this.s=e};a=a.AddShapeAction.prototype=new a._Action;a.innerForward=function(){this.sketcher.shapes.push(this.s)};a.innerReverse=function(){this.sketcher.removeShape(this.s)}})(ChemDoodle.sketcher.actions);
(function(a,f){a.ChangeBondAction=function(b,c,a){this.b=b;this.orderBefore=b.bondOrder;this.stereoBefore=b.stereo;c?(this.orderAfter=c,this.stereoAfter=a):(this.orderAfter=b.bondOrder+1,3<this.orderAfter&&(this.orderAfter=1),this.stereoAfter=f.STEREO_NONE)};var e=a.ChangeBondAction.prototype=new a._Action;e.innerForward=function(){this.b.bondOrder=this.orderAfter;this.b.stereo=this.stereoAfter};e.innerReverse=function(){this.b.bondOrder=this.orderBefore;this.b.stereo=this.stereoBefore}})(ChemDoodle.sketcher.actions,
ChemDoodle.structures.Bond);
(function(a,f){a.ChangeBracketAttributeAction=function(a,c){this.s=a;this.type=c};var e=a.ChangeBracketAttributeAction.prototype=new a._Action;e.innerForward=function(){var a=0<this.type?1:-1;switch(f.abs(this.type)){case 1:this.s.charge+=a;break;case 2:this.s.repeat+=a;break;case 3:this.s.mult+=a}};e.innerReverse=function(){var a=0<this.type?-1:1;switch(f.abs(this.type)){case 1:this.s.charge+=a;break;case 2:this.s.repeat+=a;break;case 3:this.s.mult+=a}}})(ChemDoodle.sketcher.actions,Math);
(function(a){a.ChangeChargeAction=function(a,e){this.a=a;this.delta=e};a=a.ChangeChargeAction.prototype=new a._Action;a.innerForward=function(){this.a.charge+=this.delta};a.innerReverse=function(){this.a.charge-=this.delta}})(ChemDoodle.sketcher.actions);
(function(a){a.ChangeCoordinatesAction=function(a,e){this.as=a;this.recs=[];for(var b=0,c=this.as.length;b<c;b++)this.recs[b]={xo:this.as[b].x,yo:this.as[b].y,xn:e[b].x,yn:e[b].y}};a=a.ChangeCoordinatesAction.prototype=new a._Action;a.innerForward=function(){for(var a=0,e=this.as.length;a<e;a++)this.as[a].x=this.recs[a].xn,this.as[a].y=this.recs[a].yn};a.innerReverse=function(){for(var a=0,e=this.as.length;a<e;a++)this.as[a].x=this.recs[a].xo,this.as[a].y=this.recs[a].yo}})(ChemDoodle.sketcher.actions);
(function(a){a.ChangeLabelAction=function(a,e){this.a=a;this.before=a.label;this.after=e};a=a.ChangeLabelAction.prototype=new a._Action;a.innerForward=function(){this.a.label=this.after};a.innerReverse=function(){this.a.label=this.before}})(ChemDoodle.sketcher.actions);(function(a){a.ChangeLonePairAction=function(a,e){this.a=a;this.delta=e};a=a.ChangeLonePairAction.prototype=new a._Action;a.innerForward=function(){this.a.numLonePair+=this.delta};a.innerReverse=function(){this.a.numLonePair-=this.delta}})(ChemDoodle.sketcher.actions);
(function(a){a.ChangeRadicalAction=function(a,e){this.a=a;this.delta=e};a=a.ChangeRadicalAction.prototype=new a._Action;a.innerForward=function(){this.a.numRadical+=this.delta};a.innerReverse=function(){this.a.numRadical-=this.delta}})(ChemDoodle.sketcher.actions);(function(a){a.ChangeRgroupAction=function(a,e){this.a=a;this.rbefore=a.rgroup;this.rafter=e};a=a.ChangeRgroupAction.prototype=new a._Action;a.innerForward=function(){this.a.rgroup=this.rafter};a.innerReverse=function(){this.a.rgroup=this.rbefore}})(ChemDoodle.sketcher.actions);
(function(a,f){f.ClearAction=function(b){this.sketcher=b;this.beforeMols=this.sketcher.molecules;this.beforeShapes=this.sketcher.shapes;this.sketcher.clear();this.sketcher.oneMolecule&&(this.afterMol=new a.Molecule,this.afterMol.atoms.push(new a.Atom),this.sketcher.molecules.push(this.afterMol),this.sketcher.center(),this.sketcher.repaint())};var e=f.ClearAction.prototype=new f._Action;e.innerForward=function(){this.sketcher.molecules=[];this.sketcher.shapes=[];this.sketcher.oneMolecule&&this.sketcher.molecules.push(this.afterMol)};
e.innerReverse=function(){this.sketcher.molecules=this.beforeMols;this.sketcher.shapes=this.beforeShapes}})(ChemDoodle.structures,ChemDoodle.sketcher.actions);
(function(a){a.DeleteAction=function(a,b,c,d){this.sketcher=a;this.a=b;this.as=c;this.bs=d;this.ss=[]};var f=a.DeleteAction.prototype=new a._Action;f.innerForwardAReverse=a.AddAction.prototype.innerReverse;f.innerReverseAForward=a.AddAction.prototype.innerForward;f.innerForward=function(){this.innerForwardAReverse();for(var a=0,b=this.ss.length;a<b;a++)this.sketcher.removeShape(this.ss[a])};f.innerReverse=function(){this.innerReverseAForward();0<this.ss.length&&(this.sketcher.shapes=this.sketcher.shapes.concat(this.ss))}})(ChemDoodle.sketcher.actions);
(function(a,f){f.DeleteContentAction=function(a,c,d){this.sketcher=a;this.as=c;this.ss=d;this.bs=[];a=0;for(c=this.sketcher.molecules.length;a<c;a++){d=this.sketcher.molecules[a];for(var j=0,g=d.bonds.length;j<g;j++){var m=d.bonds[j];m.a1.isLassoed&&m.a2.isLassoed&&this.bs.push(m)}}};var e=f.DeleteContentAction.prototype=new f._Action;e.innerForward=function(){for(var b=0,c=this.ss.length;b<c;b++)this.sketcher.removeShape(this.ss[b]);for(var d=[],j=[],b=0,c=this.sketcher.molecules.length;b<c;b++){for(var g=
this.sketcher.molecules[b],m=0,h=g.atoms.length;m<h;m++){var k=g.atoms[m];-1===this.as.indexOf(k)&&d.push(k)}m=0;for(h=g.bonds.length;m<h;m++)k=g.bonds[m],-1===this.bs.indexOf(k)&&j.push(k)}this.sketcher.molecules=(new a.Splitter).split({atoms:d,bonds:j})};e.innerReverse=function(){this.sketcher.shapes=this.sketcher.shapes.concat(this.ss);for(var b=[],c=[],d=0,j=this.sketcher.molecules.length;d<j;d++)var g=this.sketcher.molecules[d],b=b.concat(g.atoms),c=c.concat(g.bonds);this.sketcher.molecules=
(new a.Splitter).split({atoms:b.concat(this.as),bonds:c.concat(this.bs)})}})(ChemDoodle.informatics,ChemDoodle.sketcher.actions);(function(a){a.DeleteShapeAction=function(a,b){this.sketcher=a;this.s=b};var f=a.DeleteShapeAction.prototype=new a._Action;f.innerForward=a.AddShapeAction.prototype.innerReverse;f.innerReverse=a.AddShapeAction.prototype.innerForward})(ChemDoodle.sketcher.actions);
(function(a){a.FlipBondAction=function(a){this.b=a};a=a.FlipBondAction.prototype=new a._Action;a.innerForward=function(){var a=this.b.a1;this.b.a1=this.b.a2;this.b.a2=a};a.innerReverse=function(){this.innerForward()}})(ChemDoodle.sketcher.actions);(function(a){a.MoveAction=function(a,e){this.ps=a;this.dif=e};a=a.MoveAction.prototype=new a._Action;a.innerForward=function(){for(var a=0,e=this.ps.length;a<e;a++)this.ps[a].add(this.dif)};a.innerReverse=function(){for(var a=0,e=this.ps.length;a<e;a++)this.ps[a].sub(this.dif)}})(ChemDoodle.sketcher.actions);
(function(a,f){f.NewMoleculeAction=function(a,c,d){this.sketcher=a;this.as=c;this.bs=d};var e=f.NewMoleculeAction.prototype=new f._Action;e.innerForward=function(){var b=new a.Molecule;b.atoms=b.atoms.concat(this.as);b.bonds=b.bonds.concat(this.bs);b.check();this.sketcher.addMolecule(b)};e.innerReverse=function(){this.sketcher.removeMolecule(this.sketcher.getMoleculeByAtom(this.as[0]))}})(ChemDoodle.structures,ChemDoodle.sketcher.actions);
(function(a,f){a.RotateAction=function(a,c,d){this.ps=a;this.dif=c;this.center=d};var e=a.RotateAction.prototype=new a._Action;e.innerForward=function(){for(var a=0,c=this.ps.length;a<c;a++){var d=this.ps[a],j=this.center.distance(d),g=this.center.angle(d)+this.dif;d.x=this.center.x+j*f.cos(g);d.y=this.center.y-j*f.sin(g)}};e.innerReverse=function(){for(var a=0,c=this.ps.length;a<c;a++){var d=this.ps[a],j=this.center.distance(d),g=this.center.angle(d)-this.dif;d.x=this.center.x+j*f.cos(g);d.y=this.center.y-
j*f.sin(g)}}})(ChemDoodle.sketcher.actions,Math);(function(a){a.SwitchMoleculeAction=function(a,e){this.sketcher=a;this.beforeMols=this.sketcher.molecules;this.beforeShapes=this.sketcher.shapes;this.molA=e};a=a.SwitchMoleculeAction.prototype=new a._Action;a.innerForward=function(){this.sketcher.loadMolecule(this.molA)};a.innerReverse=function(){this.sketcher.molecules=this.beforeMols;this.sketcher.shapes=this.beforeShapes}})(ChemDoodle.sketcher.actions);
(function(a){a.ToggleAnyAtomAction=function(a){this.a=a};var f=a.ToggleAnyAtomAction.prototype=new a._Action;f.innerForward=function(){this.a.any=!this.a.any};f.innerReverse=a.ToggleAnyAtomAction.prototype.innerForward})(ChemDoodle.sketcher.actions);
(function(a){a.HistoryManager=function(a){this.sketcher=a;this.undoStack=[];this.redoStack=[]};a=a.HistoryManager.prototype;a.undo=function(){if(0!==this.undoStack.length){this.sketcher.lasso&&this.sketcher.lasso.isActive()&&this.sketcher.lasso.empty();var a=this.undoStack.pop();a.reverse(this.sketcher);this.redoStack.push(a);0===this.undoStack.length&&this.sketcher.toolbarManager.buttonUndo.disable();this.sketcher.toolbarManager.buttonRedo.enable()}};a.redo=function(){if(0!==this.redoStack.length){this.sketcher.lasso&&
this.sketcher.lasso.isActive()&&this.sketcher.lasso.empty();var a=this.redoStack.pop();a.forward(this.sketcher);this.undoStack.push(a);this.sketcher.toolbarManager.buttonUndo.enable();0===this.redoStack.length&&this.sketcher.toolbarManager.buttonRedo.disable()}};a.pushUndo=function(a){a.forward(this.sketcher);this.undoStack.push(a);0!==this.redoStack.length&&(this.redoStack=[]);this.sketcher.toolbarManager.buttonUndo.enable();this.sketcher.toolbarManager.buttonRedo.disable()};a.clear=function(){0!==
this.undoStack.length&&(this.undoStack=[],this.sketcher.toolbarManager.buttonUndo.disable());0!==this.redoStack.length&&(this.redoStack=[],this.sketcher.toolbarManager.buttonRedo.disable())}})(ChemDoodle.sketcher.actions);
(function(a,f,e,b,c,d,j){b._State=function(){};b=b._State.prototype;b.setup=function(a){this.sketcher=a};b.clearHover=function(){this.sketcher.hovering&&(this.sketcher.hovering.isHover=!1,this.sketcher.hovering.isSelected=!1,this.sketcher.hovering=void 0)};b.findHoveredObject=function(a,c,h,k){this.clearHover();var d=Infinity,i,b=this.sketcher.specs.bondLength;this.sketcher.isMobile||(b/=this.sketcher.specs.scale);if(c){c=0;for(var j=this.sketcher.molecules.length;c<j;c++)for(var e=this.sketcher.molecules[c],
f=0,q=e.atoms.length;f<q;f++){var t=e.atoms[f];t.isHover=!1;var s=a.p.distance(t);s<b&&s<d&&(d=s,i=t)}}if(h){c=0;for(j=this.sketcher.molecules.length;c<j;c++){e=this.sketcher.molecules[c];f=0;for(q=e.bonds.length;f<q;f++)h=e.bonds[f],h.isHover=!1,s=a.p.distance(h.getCenter()),s<b&&s<d&&(d=s,i=h)}}if(k){c=0;for(j=this.sketcher.shapes.length;c<j;c++){k=this.sketcher.shapes[c];k.isHover=!1;k.hoverPoint=void 0;h=k.getPoints();f=0;for(q=h.length;f<q;f++)e=h[f],s=a.p.distance(e),s<b&&s<d&&(d=s,i=k,k.hoverPoint=
e)}if(!i){c=0;for(j=this.sketcher.shapes.length;c<j;c++)k=this.sketcher.shapes[c],k.isOver(a.p,b)&&(i=k)}}i&&(i.isHover=!0,this.sketcher.hovering=i)};b.getOptimumAngle=function(c){var d=this.sketcher.getMoleculeByAtom(c);c=d.getAngles(c);var h=0;if(0===c.length)h=j.PI/6;else if(1===c.length){for(var k,h=0,b=d.bonds.length;h<b;h++)d.bonds[h].contains(this.sketcher.hovering)&&(k=d.bonds[h]);3<=k.bondOrder?h=c[0]+j.PI:(d=2*(c[0]%j.PI),h=a.isBetween(d,0,j.PI/2)||a.isBetween(d,j.PI,3*j.PI/2)?c[0]+2*j.PI/
3:c[0]-2*j.PI/3)}else h=a.angleBetweenLargest(c).angle;return h};b.removeStartAtom=function(){this.sketcher.startAtom&&(this.sketcher.startAtom.x=-10,this.sketcher.startAtom.y=-10,this.sketcher.repaint())};b.enter=function(){this.innerenter&&this.innerenter()};b.exit=function(){this.innerexit&&this.innerexit()};b.click=function(a){this.innerclick&&this.innerclick(a)};b.rightclick=function(a){this.innerrightclick&&this.innerrightclick(a)};b.dblclick=function(a){this.innerdblclick&&this.innerdblclick(a);
if(!this.sketcher.hovering){a=new c.Point(this.sketcher.width/2,this.sketcher.height/2);var d=this.sketcher.getContentBounds();a.x-=(d.maxX+d.minX)/2;a.y-=(d.maxY+d.minY)/2;this.sketcher.historyManager.pushUndo(new e.MoveAction(this.sketcher.getAllPoints(),a))}};b.mousedown=function(a){this.sketcher.lastPoint=a.p;this.sketcher.isHelp||this.sketcher.isMobile&&10>a.op.distance(this.sketcher.helpPos)?(this.sketcher.isHelp=!1,this.sketcher.repaint(),window.open("http://web.chemdoodle.com/sketcher")):
this.innermousedown&&this.innermousedown(a)};b.rightmousedown=function(a){this.innerrightmousedown&&this.innerrightmousedown(a)};b.mousemove=function(a){this.innermousemove&&this.innermousemove(a);this.sketcher.repaint()};b.mouseout=function(a){this.innermouseout&&this.innermouseout(a);this.sketcher.hovering&&(this.sketcher.hovering=void 0,this.sketcher.repaint())};b.mouseover=function(a){this.innermouseover&&this.innermouseover(a)};b.mouseup=function(a){this.parentAction=void 0;this.innermouseup&&
this.innermouseup(a)};b.rightmouseup=function(a){this.innerrightmouseup&&this.innerrightmouseup(a)};b.mousewheel=function(a,c){this.innermousewheel&&this.innermousewheel(a);this.sketcher.specs.scale+=c/10;this.sketcher.checkScale();this.sketcher.repaint()};b.drag=function(a){this.innerdrag&&this.innerdrag(a);if(!this.sketcher.hovering&&this!==this.sketcher.stateManager.STATE_LASSO&&this!==this.sketcher.stateManager.STATE_SHAPE&&this!==this.sketcher.stateManager.STATE_PUSHER){if(f.SHIFT)if(this.parentAction){var d=
this.parentAction.center,h=d.angle(this.sketcher.lastPoint),b=d.angle(a.p),p=b-h;this.parentAction.dif+=p;h=0;for(b=this.parentAction.ps.length;h<b;h++){var i=this.parentAction.ps[h],l=d.distance(i),n=d.angle(i)+p;i.x=d.x+l*j.cos(n);i.y=d.y-l*j.sin(n)}h=0;for(b=this.sketcher.molecules.length;h<b;h++)this.sketcher.molecules[h].check()}else d=new c.Point(this.sketcher.width/2,this.sketcher.height/2),h=d.angle(this.sketcher.lastPoint),b=d.angle(a.p),this.parentAction=new e.RotateAction(this.sketcher.getAllPoints(),
b-h,d),this.sketcher.historyManager.pushUndo(this.parentAction);else{if(!this.sketcher.lastPoint)return;d=new c.Point(a.p.x,a.p.y);d.sub(this.sketcher.lastPoint);if(this.parentAction){this.parentAction.dif.add(d);h=0;for(b=this.parentAction.ps.length;h<b;h++)this.parentAction.ps[h].add(d);this.sketcher.lasso&&this.sketcher.lasso.isActive()&&(this.sketcher.lasso.bounds.minX+=d.x,this.sketcher.lasso.bounds.maxX+=d.x,this.sketcher.lasso.bounds.minY+=d.y,this.sketcher.lasso.bounds.maxY+=d.y);h=0;for(b=
this.sketcher.molecules.length;h<b;h++)this.sketcher.molecules[h].check()}else this.parentAction=new e.MoveAction(this.sketcher.getAllPoints(),d),this.sketcher.historyManager.pushUndo(this.parentAction)}this.sketcher.repaint()}this.sketcher.lastPoint=a.p};b.keydown=function(b){if(f.CANVAS_DRAGGING===this.sketcher)this.sketcher.lastPoint&&(b.p=this.sketcher.lastPoint,this.drag(b));else if(f.META)90===b.which?this.sketcher.historyManager.undo():89===b.which?this.sketcher.historyManager.redo():83===
b.which?this.sketcher.toolbarManager.buttonSave.getElement().click():79===b.which?this.sketcher.toolbarManager.buttonOpen.getElement().click():78===b.which?this.sketcher.toolbarManager.buttonClear.getElement().click():187===b.which||61===b.which?this.sketcher.toolbarManager.buttonScalePlus.getElement().click():189===b.which||109===b.which?this.sketcher.toolbarManager.buttonScaleMinus.getElement().click():65===b.which&&!this.sketcher.oneMolecule&&(this.sketcher.toolbarManager.buttonLasso.getElement().click(),
this.sketcher.lasso.select(this.sketcher.getAllAtoms(),this.sketcher.shapes));else if(9===b.which){if(!this.sketcher.oneMolecule)if(this.sketcher.lasso.block=!0,this.sketcher.toolbarManager.buttonLasso.getElement().click(),this.sketcher.lasso.block=!1,f.SHIFT){if(0<this.sketcher.shapes.length){var m=this.sketcher.shapes.length-1;0<this.sketcher.lasso.shapes.length&&(m=this.sketcher.shapes.indexOf(this.sketcher.lasso.shapes[0])+1);m===this.sketcher.shapes.length&&(m=0);this.sketcher.lasso.empty();
this.sketcher.lasso.select([],[this.sketcher.shapes[m]])}}else 0<this.sketcher.molecules.length&&(m=this.sketcher.molecules.length-1,0<this.sketcher.lasso.atoms.length&&(m=this.sketcher.getMoleculeByAtom(this.sketcher.lasso.atoms[0]),m=this.sketcher.molecules.indexOf(m)+1),m===this.sketcher.molecules.length&&(m=0),this.sketcher.lasso.select(this.sketcher.molecules[m].atoms,[]))}else if(32===b.which)this.sketcher.lasso&&this.sketcher.lasso.empty(),this.sketcher.toolbarManager.buttonSingle.getElement().click();
else if(37<=b.which&&40>=b.which){m=new c.Point;switch(b.which){case 37:m.x=-10;break;case 38:m.y=-10;break;case 39:m.x=10;break;case 40:m.y=10}this.sketcher.historyManager.pushUndo(new e.MoveAction(this.sketcher.lasso&&this.sketcher.lasso.isActive()?this.sketcher.lasso.getAllPoints():this.sketcher.getAllPoints(),m))}else if(187===b.which||189===b.which||61===b.which||109===b.which)this.sketcher.hovering&&this.sketcher.hovering instanceof c.Atom&&this.sketcher.historyManager.pushUndo(new e.ChangeChargeAction(this.sketcher.hovering,
187===b.which||61===b.which?1:-1));else if(8===b.which||127===b.which)this.sketcher.stateManager.STATE_ERASE.handleDelete();else if(48<=b.which&&57>=b.which){if(this.sketcher.hovering){var h=b.which-48,k=[],p=[];if(this.sketcher.hovering instanceof c.Atom)if(m=this.sketcher.hovering,f.SHIFT){if(2<h&&9>h){var i=this.sketcher.getMoleculeByAtom(this.sketcher.hovering),l=i.getAngles(this.sketcher.hovering),n=3*j.PI/2;0!==l.length&&(n=a.angleBetweenLargest(l).angle);l=this.sketcher.stateManager.STATE_NEW_RING.getRing(this.sketcher.hovering,
h,this.sketcher.specs.bondLength,n,!1);-1===i.atoms.indexOf(l[0])&&k.push(l[0]);this.sketcher.bondExists(this.sketcher.hovering,l[0])||p.push(new c.Bond(this.sketcher.hovering,l[0]));for(var o=1,r=l.length;o<r;o++)-1===i.atoms.indexOf(l[o])&&k.push(l[o]),this.sketcher.bondExists(l[o-1],l[o])||p.push(new c.Bond(l[o-1],l[o]));this.sketcher.bondExists(l[l.length-1],this.sketcher.hovering)||p.push(new c.Bond(l[l.length-1],this.sketcher.hovering))}}else{0===h&&(h=10);for(var q=new c.Point(this.sketcher.hovering.x,
this.sketcher.hovering.y),t=this.getOptimumAngle(this.sketcher.hovering),s=this.sketcher.hovering,v=0;v<h;v++){i=t+(1===v%2?j.PI/3:0);q.x+=this.sketcher.specs.bondLength*j.cos(i);q.y-=this.sketcher.specs.bondLength*j.sin(i);for(var u=new c.Atom("C",q.x,q.y),w=Infinity,x,o=0,r=this.sketcher.molecules.length;o<r;o++){i=this.sketcher.molecules[o];l=0;for(n=i.atoms.length;l<n;l++){var y=i.atoms[l],z=y.distance(u);z<w&&(w=z,x=y)}}5>w?u=x:k.push(u);this.sketcher.bondExists(s,u)||p.push(new c.Bond(s,u));
s=u}}else if(this.sketcher.hovering instanceof c.Bond)if(m=this.sketcher.hovering.a1,f.SHIFT){if(2<h&&9>h){l=this.sketcher.stateManager.STATE_NEW_RING.getOptimalRing(this.sketcher.hovering,h);h=this.sketcher.hovering.a2;n=this.sketcher.hovering.a1;i=this.sketcher.getMoleculeByAtom(h);l[0]===this.sketcher.hovering.a1&&(h=this.sketcher.hovering.a1,n=this.sketcher.hovering.a2);-1===i.atoms.indexof(l[1])&&k.push(l[1]);this.sketcher.bondExists(h,l[1])||p.push(new c.Bond(h,l[1]));o=2;for(r=l.length;o<r;o++)-1===
i.atoms.indexof(l[o])&&k.push(l[o]),this.sketcher.bondExists(l[o-1],l[o])||p.push(new c.Bond(l[o-1],l[o]));this.sketcher.bondExists(l[l.length-1],n)||p.push(new c.Bond(l[l.length-1],n))}}else 0<h&&(4>h&&this.sketcher.hovering.bondOrder!==h)&&this.sketcher.historyManager.pushUndo(new e.ChangeBondAction(this.sketcher.hovering,h,c.Bond.STEREO_NONE));(0!==k.length||0!==p.length)&&this.sketcher.historyManager.pushUndo(new e.AddAction(this.sketcher,m,k,p))}}else if(65<=b.which&&90>=b.which&&this.sketcher.hovering)if(this.sketcher.hovering instanceof
c.Atom){m=String.fromCharCode(b.which);i=!1;l=0;for(n=d.length;l<n;l++)if(this.sketcher.hovering.label.charAt(0)===m)d[l]===this.sketcher.hovering.label?i=!0:d[l].charAt(0)===m&&(i&&!p?p=d[l]:k||(k=d[l]));else if(d[l].charAt(0)===m){k=d[l];break}u="C";p?u=p:k&&(u=k);u!==this.sketcher.hovering.label&&this.sketcher.historyManager.pushUndo(new e.ChangeLabelAction(this.sketcher.hovering,u))}else this.sketcher.hovering instanceof c.Bond&&70===b.which&&this.sketcher.historyManager.pushUndo(new e.FlipBondAction(this.sketcher.hovering));
this.innerkeydown&&this.innerkeydown(b)};b.keypress=function(a){this.innerkeypress&&this.innerkeypress(a)};b.keyup=function(a){f.CANVAS_DRAGGING===this.sketcher&&this.sketcher.lastPoint&&(a.p=this.sketcher.lastPoint,this.sketcher.drag(a));this.innerkeyup&&this.innerkeyup(a)}})(ChemDoodle.math,ChemDoodle.monitor,ChemDoodle.sketcher.actions,ChemDoodle.sketcher.states,ChemDoodle.structures,ChemDoodle.SYMBOLS,Math);
(function(a,f,e,b){b.AtomQueryState=function(a){this.setup(a)};a=b.AtomQueryState.prototype=new b._State;a.mode=b.AtomQueryState.MODE_ANY;a.innermouseup=function(){if(this.mode===b.AtomQueryState.MODE_ANY)this.sketcher.historyManager.pushUndo(new f.ToggleAnyAtomAction(this.sketcher.hovering));else if(this.mode===b.AtomQueryState.MODE_RGROUP){var a=this,d=this.sketcher.hovering;this.sketcher.dialogManager.inputDialog.doneFunction=function(b){b.match(/[0-9]|\-/g)&&a.sketcher.historyManager.pushUndo(new f.ChangeRgroupAction(d,
parseInt(b)))};this.sketcher.dialogManager.inputDialog.getElement().dialog("open")}};a.innermousemove=function(a){this.findHoveredObject(a,!0)};b.AtomQueryState.MODE_ANY=1;b.AtomQueryState.MODE_RGROUP=2})(ChemDoodle.structures,ChemDoodle.sketcher.actions,ChemDoodle.sketcher.gui.DialogManager,ChemDoodle.sketcher.states);
(function(a,f){f.ChargeState=function(a){this.setup(a)};var e=f.ChargeState.prototype=new f._State;e.delta=1;e.innermouseup=function(){this.sketcher.hovering&&this.sketcher.historyManager.pushUndo(new a.ChangeChargeAction(this.sketcher.hovering,this.delta))};e.innermousemove=function(a){this.findHoveredObject(a,!0,!1)}})(ChemDoodle.sketcher.actions,ChemDoodle.sketcher.states);
(function(a,f,e,b){f.EraseState=function(a){this.setup(a)};f=f.EraseState.prototype=new f._State;f.handleDelete=function(){if(this.sketcher.lasso&&this.sketcher.lasso.isActive())this.sketcher.historyManager.pushUndo(new a.DeleteContentAction(this.sketcher,this.sketcher.lasso.atoms,this.sketcher.lasso.shapes)),this.sketcher.lasso.empty();else if(this.sketcher.hovering){if(this.sketcher.hovering instanceof e.Atom)if(this.sketcher.oneMolecule){for(var c=this.sketcher.molecules[0],d=0,j=c.atoms.length;d<
j;d++)c.atoms[d].visited=!1;var g=[],f=[];this.sketcher.hovering.visited=!0;d=0;for(j=c.bonds.length;d<j;d++){var h=c.bonds[d];if(h.contains(this.sketcher.hovering)){var k=[],p=[],i=new e.Queue;for(i.enqueue(h.getNeighbor(this.sketcher.hovering));!i.isEmpty();)if(h=i.dequeue(),!h.visited){h.visited=!0;k.push(h);for(var l=0,n=c.bonds.length;l<n;l++){var o=c.bonds[l];o.contains(h)&&!o.getNeighbor(h).visited&&(i.enqueue(o.getNeighbor(h)),p.push(o))}}g.push(k);f.push(p)}}l=h=-1;d=0;for(j=g.length;d<j;d++)g[d].length>
h&&(l=d,h=g[d].length);if(-1<l){for(var d=[],j=[],r,k=0,p=c.atoms.length;k<p;k++)h=c.atoms[k],-1===g[l].indexOf(h)?d.push(h):r||(r=h);k=0;for(p=c.bonds.length;k<p;k++)h=c.bonds[k],-1===f[l].indexOf(h)&&j.push(h);this.sketcher.historyManager.pushUndo(new a.DeleteAction(this.sketcher,r,d,j))}else this.sketcher.historyManager.pushUndo(new a.ClearAction(this.sketcher))}else c=this.sketcher.getMoleculeByAtom(this.sketcher.hovering),this.sketcher.historyManager.pushUndo(new a.DeleteAction(this.sketcher,
c.atoms[0],[this.sketcher.hovering],c.getBonds(this.sketcher.hovering)));else this.sketcher.hovering instanceof e.Bond?(!this.sketcher.oneMolecule||!this.sketcher.hovering.ring)&&this.sketcher.historyManager.pushUndo(new a.DeleteAction(this.sketcher,this.sketcher.hovering.a1,void 0,[this.sketcher.hovering])):this.sketcher.hovering instanceof b._Shape&&this.sketcher.historyManager.pushUndo(new a.DeleteShapeAction(this.sketcher,this.sketcher.hovering));this.sketcher.hovering=void 0;this.sketcher.repaint()}k=
0;for(p=this.sketcher.shapes.length;k<p;k++)if(f=this.sketcher.shapes[k],f instanceof b.Pusher){g=r=!1;d=0;for(j=this.sketcher.molecules.length;d<j;d++){c=this.sketcher.molecules[d];l=0;for(n=c.atoms.length;l<n;l++)h=c.atoms[l],h===f.o1?r=!0:h===f.o2&&(g=!0);l=0;for(n=c.bonds.length;l<n;l++)h=c.bonds[l],h===f.o1?r=!0:h===f.o2&&(g=!0)}if(!r||!g)this.sketcher.historyManager.undoStack[this.sketcher.historyManager.undoStack.length-1].ss.push(f),this.sketcher.removeShape(f)}};f.innermouseup=function(){this.handleDelete()};
f.innermousemove=function(a){this.findHoveredObject(a,!0,!0,!0)}})(ChemDoodle.sketcher.actions,ChemDoodle.sketcher.states,ChemDoodle.structures,ChemDoodle.structures.d2);
(function(a,f,e){e.LabelState=function(a){this.setup(a)};e=e.LabelState.prototype=new e._State;e.label="C";e.innermousedown=function(){this.newMolAllowed=!0};e.innermouseup=function(b){this.sketcher.hovering?this.label!==this.sketcher.hovering.label&&this.sketcher.historyManager.pushUndo(new f.ChangeLabelAction(this.sketcher.hovering,this.label)):!this.sketcher.oneMolecule&&this.newMolAllowed&&(this.sketcher.historyManager.pushUndo(new f.NewMoleculeAction(this.sketcher,[new a.Atom(this.label,b.p.x,
b.p.y)],[])),this.sketcher.isMobile||this.mousemove(b))};e.innermousemove=function(a){this.findHoveredObject(a,!0,!1)};e.innerdrag=function(){this.newMolAllowed=!1}})(ChemDoodle.structures,ChemDoodle.sketcher.actions,ChemDoodle.sketcher.states);
(function(a,f,e,b,c,d,j,g){d.LassoState=function(a){this.setup(a)};var m,h=!1;d=d.LassoState.prototype=new d._State;d.innerdrag=function(a){this.inDrag=!0;if(this.sketcher.lasso.isActive()&&m){if(this.sketcher.lastPoint)if(1===m){var d=new e.Point(a.p.x,a.p.y);d.sub(this.sketcher.lastPoint);if(this.parentAction){this.parentAction.dif.add(d);a=0;for(var i=this.parentAction.ps.length;a<i;a++)this.parentAction.ps[a].add(d);a=0;for(i=this.sketcher.molecules.length;a<i;a++)this.sketcher.molecules[a].check();
this.sketcher.lasso.bounds.minX+=d.x;this.sketcher.lasso.bounds.maxX+=d.x;this.sketcher.lasso.bounds.minY+=d.y;this.sketcher.lasso.bounds.maxY+=d.y;this.sketcher.repaint()}else this.parentAction=new c.MoveAction(this.sketcher.lasso.getAllPoints(),d),this.sketcher.historyManager.pushUndo(this.parentAction)}else if(2===m)if(this.parentAction){d=this.parentAction.center;i=d.angle(this.sketcher.lastPoint);a=d.angle(a.p);var h=a-i;this.parentAction.dif+=h;a=0;for(i=this.parentAction.ps.length;a<i;a++){var j=
this.parentAction.ps[a],o=d.distance(j),r=d.angle(j)+h;j.x=d.x+o*g.cos(r);j.y=d.y-o*g.sin(r)}a=0;for(i=this.sketcher.molecules.length;a<i;a++)this.sketcher.molecules[a].check();this.sketcher.lasso.setBounds();this.sketcher.repaint()}else d=new e.Point((this.sketcher.lasso.bounds.minX+this.sketcher.lasso.bounds.maxX)/2,(this.sketcher.lasso.bounds.minY+this.sketcher.lasso.bounds.maxY)/2),i=d.angle(this.sketcher.lastPoint),a=d.angle(a.p),this.parentAction=new c.RotateAction(this.sketcher.lasso.getAllPoints(),
a-i,d),this.sketcher.historyManager.pushUndo(this.parentAction)}else if(this.sketcher.hovering){if(this.sketcher.lastPoint)if(d=new e.Point(a.p.x,a.p.y),d.sub(this.sketcher.lastPoint),this.parentAction){this.parentAction.dif.add(d);a=0;for(i=this.parentAction.ps.length;a<i;a++)this.parentAction.ps[a].add(d);a=0;for(i=this.sketcher.molecules.length;a<i;a++)this.sketcher.molecules[a].check();this.sketcher.repaint()}else this.sketcher.hovering instanceof e.Atom?i=f.SHIFT?[this.sketcher.hovering]:this.sketcher.getMoleculeByAtom(this.sketcher.hovering).atoms:
this.sketcher.hovering instanceof e.Bond?i=[this.sketcher.hovering.a1,this.sketcher.hovering.a2]:this.sketcher.hovering instanceof b._Shape&&(i=this.sketcher.hovering.hoverPoint?[this.sketcher.hovering.hoverPoint]:this.sketcher.hovering.getPoints()),this.parentAction=new c.MoveAction(i,d),this.sketcher.historyManager.pushUndo(this.parentAction)}else this.sketcher.lasso.addPoint(a.p),this.sketcher.repaint()};d.innermousedown=function(c){this.inDrag=!1;if(this.sketcher.lasso.isActive()&&!f.SHIFT){m=
void 0;var d=25/this.sketcher.specs.scale;a.isBetween(c.p.x,this.sketcher.lasso.bounds.minX,this.sketcher.lasso.bounds.maxX)&&a.isBetween(c.p.y,this.sketcher.lasso.bounds.minY,this.sketcher.lasso.bounds.maxY)?m=1:a.isBetween(c.p.x,this.sketcher.lasso.bounds.minX-d,this.sketcher.lasso.bounds.maxX+d)&&a.isBetween(c.p.y,this.sketcher.lasso.bounds.minY-d,this.sketcher.lasso.bounds.maxY+d)&&(m=2)}else this.sketcher.hovering||(this.sketcher.lastPoint=void 0,this.sketcher.lasso.addPoint(c.p),this.sketcher.repaint())};
d.innermouseup=function(a){m||this.sketcher.hovering||this.sketcher.lasso.select();this.innermousemove(a)};d.innerclick=function(){if(!m&&!this.inDrag)if(this.sketcher.hovering){var a=[],c=[];this.sketcher.hovering instanceof e.Atom?a.push(this.sketcher.hovering):this.sketcher.hovering instanceof e.Bond?(a.push(this.sketcher.hovering.a1),a.push(this.sketcher.hovering.a2)):this.sketcher.hovering instanceof b._Shape&&c.push(this.sketcher.hovering);this.sketcher.lasso.select(a,c)}else this.sketcher.lasso.isActive()&&
this.sketcher.lasso.empty();m=void 0};d.innermousemove=function(c){if(this.sketcher.lasso.isActive()){if(!f.SHIFT){var d=!1,i=25/this.sketcher.specs.scale;if((!a.isBetween(c.p.x,this.sketcher.lasso.bounds.minX,this.sketcher.lasso.bounds.maxX)||!a.isBetween(c.p.y,this.sketcher.lasso.bounds.minY,this.sketcher.lasso.bounds.maxY))&&a.isBetween(c.p.x,this.sketcher.lasso.bounds.minX-i,this.sketcher.lasso.bounds.maxX+i)&&a.isBetween(c.p.y,this.sketcher.lasso.bounds.minY-i,this.sketcher.lasso.bounds.maxY+
i))d=!0;d!=h&&(h=d,this.sketcher.repaint())}}else d=this.sketcher.lasso.mode!==j.Lasso.MODE_LASSO_SHAPES,this.findHoveredObject(c,d,d,!0)};d.innerdblclick=function(){this.sketcher.lasso.isActive()&&this.sketcher.lasso.empty()};d.draw=function(a){if(h&&this.sketcher.lasso.bounds){a.fillStyle="rgba(0,0,255,.1)";var c=25/this.sketcher.specs.scale,i=this.sketcher.lasso.bounds;a.beginPath();a.rect(i.minX-c,i.minY-c,i.maxX-i.minX+2*c,c);a.rect(i.minX-c,i.maxY,i.maxX-i.minX+2*c,c);a.rect(i.minX-c,i.minY,
c,i.maxY-i.minY);a.rect(i.maxX,i.minY,c,i.maxY-i.minY);a.fill()}}})(ChemDoodle.math,ChemDoodle.monitor,ChemDoodle.structures,ChemDoodle.structures.d2,ChemDoodle.sketcher.actions,ChemDoodle.sketcher.states,ChemDoodle.sketcher.tools,Math);
(function(a,f){f.LonePairState=function(a){this.setup(a)};var e=f.LonePairState.prototype=new f._State;e.delta=1;e.innermouseup=function(){0>this.delta&&1>this.sketcher.hovering.numLonePair||this.sketcher.hovering&&this.sketcher.historyManager.pushUndo(new a.ChangeLonePairAction(this.sketcher.hovering,this.delta))};e.innermousemove=function(a){this.findHoveredObject(a,!0,!1)}})(ChemDoodle.sketcher.actions,ChemDoodle.sketcher.states);
(function(a,f,e){f.MoveState=function(a){this.setup(a)};f=f.MoveState.prototype=new f._State;f.action=void 0;f.innerdrag=function(b){if(this.sketcher.hovering)if(this.action){b=new e.Point(b.p.x,b.p.y);b.sub(this.sketcher.lastPoint);this.action.dif.add(b);for(var c=0,d=this.action.ps.length;c<d;c++)this.action.ps[c].add(b);c=0;for(d=this.sketcher.molecules.length;c<d;c++)this.sketcher.molecules[c].check();this.sketcher.repaint()}else c=[],b=new e.Point(b.p.x,b.p.y),this.sketcher.hovering instanceof
e.Atom?(b.sub(this.sketcher.hovering),c[0]=this.sketcher.hovering):this.sketcher.hovering instanceof e.Bond&&(b.sub(this.sketcher.lastPoint),c[0]=this.sketcher.hovering.a1,c[1]=this.sketcher.hovering.a2),this.action=new a.MoveAction(c,b),this.sketcher.historyManager.pushUndo(this.action)};f.innermousemove=function(a){this.findHoveredObject(a,!0,!0)};f.innermouseup=function(){this.action=void 0}})(ChemDoodle.sketcher.actions,ChemDoodle.sketcher.states,ChemDoodle.structures);
(function(a,f,e,b,c){e.NewBondState=function(a){this.setup(a)};e=e.NewBondState.prototype=new e._State;e.bondOrder=1;e.stereo=b.Bond.STEREO_NONE;e.incrementBondOrder=function(a){this.newMolAllowed=!1;1===this.bondOrder&&this.stereo===b.Bond.STEREO_NONE?this.sketcher.historyManager.pushUndo(new f.ChangeBondAction(a)):a.bondOrder===this.bondOrder&&a.stereo===this.stereo?(1===a.bondOrder&&a.stereo!==b.Bond.STEREO_NONE||2===a.bondOrder&&a.stereo===b.Bond.STEREO_NONE)&&this.sketcher.historyManager.pushUndo(new f.FlipBondAction(a)):
this.sketcher.historyManager.pushUndo(new f.ChangeBondAction(a,this.bondOrder,this.stereo))};e.innerexit=function(){this.removeStartAtom()};e.innerdrag=function(d){this.newMolAllowed=!1;this.removeStartAtom();if(this.sketcher.hovering instanceof b.Atom){if(15>d.p.distance(this.sketcher.hovering)){var j=this.getOptimumAngle(this.sketcher.hovering);d=this.sketcher.hovering.x+this.sketcher.specs.bondLength*c.cos(j);j=this.sketcher.hovering.y-this.sketcher.specs.bondLength*c.sin(j);this.sketcher.tempAtom=
new b.Atom("C",d,j,0)}else{for(var g=1E3,e=0,h=this.sketcher.molecules.length;e<h;e++)for(var k=this.sketcher.molecules[e],f=0,i=k.atoms.length;f<i;f++){var l=k.atoms[f],n=l.distance(d.p);if(5>n&&(!j||n<g))j=l,g=n}j?this.sketcher.tempAtom=new b.Atom("C",j.x,j.y,0):a.ALT&&a.SHIFT?this.sketcher.tempAtom=new b.Atom("C",d.p.x,d.p.y,0):(j=this.sketcher.hovering.angle(d.p),d=this.sketcher.hovering.distance(d.p),a.SHIFT||(d=this.sketcher.specs.bondLength),a.ALT||(j=c.floor((j+c.PI/12)/(c.PI/6))*c.PI/6),
this.sketcher.tempAtom=new b.Atom("C",this.sketcher.hovering.x+d*c.cos(j),this.sketcher.hovering.y-d*c.sin(j),0))}e=0;for(h=this.sketcher.molecules.length;e<h;e++){k=this.sketcher.molecules[e];f=0;for(i=k.atoms.length;f<i;f++)l=k.atoms[f],5>l.distance(this.sketcher.tempAtom)&&(this.sketcher.tempAtom.x=l.x,this.sketcher.tempAtom.y=l.y,this.sketcher.tempAtom.isOverlap=!0)}this.sketcher.repaint()}};e.innerclick=function(a){!this.sketcher.hovering&&(!this.sketcher.oneMolecule&&this.newMolAllowed)&&(this.sketcher.historyManager.pushUndo(new f.NewMoleculeAction(this.sketcher,
[new b.Atom("C",a.p.x,a.p.y)],[])),this.sketcher.isMobile||this.mousemove(a))};e.innermousedown=function(a){this.newMolAllowed=!0;if(this.sketcher.hovering instanceof b.Atom)this.sketcher.hovering.isHover=!1,this.sketcher.hovering.isSelected=!0,this.drag(a);else if(this.sketcher.hovering instanceof b.Bond){this.sketcher.hovering.isHover=!1;this.incrementBondOrder(this.sketcher.hovering);a=0;for(var c=this.sketcher.molecules.length;a<c;a++)this.sketcher.molecules[a].check();this.sketcher.repaint()}};
e.innermouseup=function(a){if(this.sketcher.tempAtom&&this.sketcher.hovering){var c=[],g=[],e=!0;if(this.sketcher.tempAtom.isOverlap){for(var h=0,k=this.sketcher.molecules.length;h<k;h++)for(var p=this.sketcher.molecules[h],i=0,l=p.atoms.length;i<l;i++){var n=p.atoms[i];5>n.distance(this.sketcher.tempAtom)&&(this.sketcher.tempAtom=n)}if(h=this.sketcher.getBond(this.sketcher.hovering,this.sketcher.tempAtom))this.incrementBondOrder(h),e=!1}else c.push(this.sketcher.tempAtom);e&&(g[0]=new b.Bond(this.sketcher.hovering,
this.sketcher.tempAtom,this.bondOrder),g[0].stereo=this.stereo,this.sketcher.historyManager.pushUndo(new f.AddAction(this.sketcher,g[0].a1,c,g)))}this.sketcher.tempAtom=void 0;this.sketcher.isMobile||this.mousemove(a)};e.innermousemove=function(a){this.sketcher.tempAtom||(this.findHoveredObject(a,!0,!0),this.sketcher.startAtom&&(this.sketcher.hovering?(this.sketcher.startAtom.x=-10,this.sketcher.startAtom.y=-10):(this.sketcher.startAtom.x=a.p.x,this.sketcher.startAtom.y=a.p.y)))};e.innermouseout=
function(){this.removeStartAtom()}})(ChemDoodle.monitor,ChemDoodle.sketcher.actions,ChemDoodle.sketcher.states,ChemDoodle.structures,Math);
(function(a,f,e,b,c,d){b.NewRingState=function(a){this.setup(a)};b=b.NewRingState.prototype=new b._State;b.numSides=6;b.unsaturated=!1;b.getRing=function(a,b,e,h,k){var f=d.PI-2*d.PI/b;h+=f/2;for(var i=[],l=0;l<b-1;l++){var n=0===l?new c.Atom("C",a.x,a.y):new c.Atom("C",i[i.length-1].x,i[i.length-1].y);n.x+=e*d.cos(h);n.y-=e*d.sin(h);i.push(n);h+=d.PI+f}l=0;for(a=this.sketcher.molecules.length;l<a;l++){b=this.sketcher.molecules[l];e=0;for(h=b.atoms.length;e<h;e++)b.atoms[e].isOverlap=!1}l=0;for(a=
i.length;l<a;l++){for(var f=Infinity,o,n=0,r=this.sketcher.molecules.length;n<r;n++){b=this.sketcher.molecules[n];e=0;for(h=b.atoms.length;e<h;e++){var q=b.atoms[e].distance(i[l]);q<f&&(f=q,o=b.atoms[e])}}5>f&&(i[l]=o,k&&(o.isOverlap=!0))}return i};b.getOptimalRing=function(a,c){for(var b=d.PI/2-d.PI/c,h=a.a1.distance(a.a2),e=this.getRing(a.a1,c,h,a.a1.angle(a.a2)-b,!1),b=this.getRing(a.a2,c,h,a.a2.angle(a.a1)-b,!1),f=h=0,i=1,l=e.length;i<l;i++)for(var n=0,o=this.sketcher.molecules.length;n<o;n++)for(var r=
this.sketcher.molecules[n],q=0,t=r.atoms.length;q<t;q++)var s=r.atoms[q].distance(e[i]),v=r.atoms[q].distance(b[i]),h=h+d.min(1E8,1/(s*s)),f=f+d.min(1E8,1/(v*v));return h<f?e:b};b.innerexit=function(){this.removeStartAtom()};b.innerdrag=function(b){this.newMolAllowed=!1;this.removeStartAtom();if(this.sketcher.hovering instanceof c.Atom){var g=0,e=0;if(15>b.p.distance(this.sketcher.hovering))b=this.sketcher.getMoleculeByAtom(this.sketcher.hovering).getAngles(this.sketcher.hovering),g=0===b.length?
3*d.PI/2:a.angleBetweenLargest(b).angle,e=this.sketcher.specs.bondLength;else if(g=this.sketcher.hovering.angle(b.p),e=this.sketcher.hovering.distance(b.p),!f.ALT||!f.SHIFT)f.SHIFT||(e=this.sketcher.specs.bondLength),f.ALT||(g=d.floor((g+d.PI/12)/(d.PI/6))*d.PI/6);this.sketcher.tempRing=this.getRing(this.sketcher.hovering,this.numSides,e,g,!0);this.sketcher.repaint()}else if(this.sketcher.hovering instanceof c.Bond){g=a.distanceFromPointToLineInclusive(b.p,this.sketcher.hovering.a1,this.sketcher.hovering.a2);
if(-1!==g&&7>=g)b=this.getOptimalRing(this.sketcher.hovering,this.numSides);else{for(var e=d.PI/2-d.PI/this.numSides,h=this.sketcher.hovering.a1.distance(this.sketcher.hovering.a2),g=this.getRing(this.sketcher.hovering.a1,this.numSides,h,this.sketcher.hovering.a1.angle(this.sketcher.hovering.a2)-e,!1),e=this.getRing(this.sketcher.hovering.a2,this.numSides,h,this.sketcher.hovering.a2.angle(this.sketcher.hovering.a1)-e,!1),k=new c.Point,h=new c.Point,p=1,i=g.length;p<i;p++)k.add(g[p]),h.add(e[p]);k.x/=
g.length-1;k.y/=g.length-1;h.x/=e.length-1;h.y/=e.length-1;k=k.distance(b.p);h=h.distance(b.p);b=e;k<h&&(b=g)}g=1;for(e=b.length;g<e;g++)-1!==this.sketcher.getAllAtoms().indexOf(b[g])&&(b[g].isOverlap=!0);this.sketcher.tempRing=b;this.sketcher.repaint()}};b.innerclick=function(a){!this.sketcher.hovering&&(!this.sketcher.oneMolecule&&this.newMolAllowed)&&(this.sketcher.historyManager.pushUndo(new e.NewMoleculeAction(this.sketcher,[new c.Atom("C",a.p.x,a.p.y)],[])),this.sketcher.isMobile||this.mousemove(a))};
b.innermousedown=function(a){this.newMolAllowed=!0;this.sketcher.hovering&&(this.sketcher.hovering.isHover=!1,this.sketcher.hovering.isSelected=!0,this.drag(a))};b.innermouseup=function(a){if(this.sketcher.tempRing&&this.sketcher.hovering){var b=[],d=[],h=this.sketcher.getAllAtoms();if(this.sketcher.hovering instanceof c.Atom){-1===h.indexOf(this.sketcher.tempRing[0])&&b.push(this.sketcher.tempRing[0]);this.sketcher.bondExists(this.sketcher.hovering,this.sketcher.tempRing[0])||d.push(new c.Bond(this.sketcher.hovering,
this.sketcher.tempRing[0]));for(var k=1,f=this.sketcher.tempRing.length;k<f;k++)-1===h.indexOf(this.sketcher.tempRing[k])&&b.push(this.sketcher.tempRing[k]),this.sketcher.bondExists(this.sketcher.tempRing[k-1],this.sketcher.tempRing[k])||d.push(new c.Bond(this.sketcher.tempRing[k-1],this.sketcher.tempRing[k],1===k%2&&this.unsaturated?2:1));this.sketcher.bondExists(this.sketcher.tempRing[this.sketcher.tempRing.length-1],this.sketcher.hovering)||d.push(new c.Bond(this.sketcher.tempRing[this.sketcher.tempRing.length-
1],this.sketcher.hovering,this.unsaturated?2:1))}else if(this.sketcher.hovering instanceof c.Bond){var k=this.sketcher.hovering.a2,i=this.sketcher.hovering.a1;this.sketcher.tempRing[0]===this.sketcher.hovering.a1&&(k=this.sketcher.hovering.a1,i=this.sketcher.hovering.a2);-1===h.indexOf(this.sketcher.tempRing[1])&&b.push(this.sketcher.tempRing[1]);this.sketcher.bondExists(k,this.sketcher.tempRing[1])||d.push(new c.Bond(k,this.sketcher.tempRing[1]));k=2;for(f=this.sketcher.tempRing.length;k<f;k++)-1===
h.indexOf(this.sketcher.tempRing[k])&&b.push(this.sketcher.tempRing[k]),this.sketcher.bondExists(this.sketcher.tempRing[k-1],this.sketcher.tempRing[k])||d.push(new c.Bond(this.sketcher.tempRing[k-1],this.sketcher.tempRing[k],0===k%2&&this.unsaturated?2:1));this.sketcher.bondExists(this.sketcher.tempRing[this.sketcher.tempRing.length-1],i)||d.push(new c.Bond(this.sketcher.tempRing[this.sketcher.tempRing.length-1],i))}(0!==b.length||0!==d.length)&&this.sketcher.historyManager.pushUndo(new e.AddAction(this.sketcher,
d[0].a1,b,d));b=0;for(d=h.length;b<d;b++)h[b].isOverlap=!1}this.sketcher.tempRing=void 0;this.sketcher.isMobile||this.mousemove(a)};b.innermousemove=function(a){this.sketcher.tempAtom||(this.findHoveredObject(a,!0,!0),this.sketcher.startAtom&&(this.sketcher.hovering?(this.sketcher.startAtom.x=-10,this.sketcher.startAtom.y=-10):(this.sketcher.startAtom.x=a.p.x,this.sketcher.startAtom.y=a.p.y)))};b.innermouseout=function(){this.removeStartAtom()}})(ChemDoodle.math,ChemDoodle.monitor,ChemDoodle.sketcher.actions,
ChemDoodle.sketcher.states,ChemDoodle.structures,Math);
(function(a,f,e,b,c){c.PusherState=function(a){this.setup(a)};c=c.PusherState.prototype=new c._State;c.numElectron=1;c.innermousedown=function(){this.sketcher.hovering&&(this.start=this.sketcher.hovering)};c.innerdrag=function(a){this.start&&(this.end=new f.Point(a.p.x,a.p.y),this.findHoveredObject(a,!0,!0),this.sketcher.repaint())};c.innermouseup=function(){if(this.start&&this.sketcher.hovering&&this.sketcher.hovering!==this.start){for(var a,c=!1,g=0,f=this.sketcher.shapes.length;g<f;g++){var h=
this.sketcher.shapes[g];h instanceof e.Pusher&&(h.o1===this.start&&h.o2===this.sketcher.hovering?a=h:h.o2===this.start&&h.o1===this.sketcher.hovering&&(a=h,c=!0))}a?(c&&this.sketcher.historyManager.pushUndo(new b.DeleteShapeAction(this.sketcher,a)),this.end=this.start=void 0,this.sketcher.repaint()):(a=new e.Pusher(this.start,this.sketcher.hovering,this.numElectron),this.end=this.start=void 0,this.sketcher.historyManager.pushUndo(new b.AddShapeAction(this.sketcher,a)))}else this.end=this.start=void 0,
this.sketcher.repaint()};c.innermousemove=function(a){this.findHoveredObject(a,!0,!0);this.sketcher.repaint()};c.draw=function(c){if(this.start&&this.end){c.strokeStyle="#00FF00";c.fillStyle="#00FF00";c.lineWidth=1;var b=this.start instanceof f.Atom?this.start:this.start.getCenter(),e=this.end;this.sketcher.hovering&&this.sketcher.hovering!==this.start&&(e=this.sketcher.hovering instanceof f.Atom?this.sketcher.hovering:this.sketcher.hovering.getCenter());c.beginPath();c.moveTo(b.x,b.y);a.contextHashTo(c,
b.x,b.y,e.x,e.y,2,2);c.stroke()}}})(ChemDoodle.extensions,ChemDoodle.structures,ChemDoodle.structures.d2,ChemDoodle.sketcher.actions,ChemDoodle.sketcher.states);
(function(a,f){f.RadicalState=function(a){this.setup(a)};var e=f.RadicalState.prototype=new f._State;e.delta=1;e.innermouseup=function(){0>this.delta&&1>this.sketcher.hovering.numRadical||this.sketcher.hovering&&this.sketcher.historyManager.pushUndo(new a.ChangeRadicalAction(this.sketcher.hovering,this.delta))};e.innermousemove=function(a){this.findHoveredObject(a,!0,!1)}})(ChemDoodle.sketcher.actions,ChemDoodle.sketcher.states);
(function(a,f,e,b,c,d,j,g){function m(a,c,i,b,d){b&&g.abs(b.t)===d&&(a.fillStyle="#885110",a.beginPath(),0<b.t?(a.moveTo(c,i),a.lineTo(c+6,i-6),a.lineTo(c+12,i)):(a.moveTo(c,i+6),a.lineTo(c+6,i+12),a.lineTo(c+12,i+6)),a.closePath(),a.fill());a.strokeStyle="blue";a.beginPath();a.moveTo(c,i);a.lineTo(c+6,i-6);a.lineTo(c+12,i);a.moveTo(c,i+6);a.lineTo(c+6,i+12);a.lineTo(c+12,i+6);a.stroke()}j.ShapeState=function(a){this.setup(a)};var h=j.ShapeState.prototype=new j._State;h.shapeType=j.ShapeState.LINE;
h.superDoubleClick=h.dblclick;h.dblclick=function(a){this.control||this.superDoubleClick(a)};h.innerexit=function(){this.shapeType=j.ShapeState.LINE;this.sketcher.repaint()};h.innermousemove=function(a){this.control=void 0;if(this.shapeType===j.ShapeState.BRACKET){for(var b=0,i=this.sketcher.shapes.length;b<i;b++){var d=this.sketcher.shapes[b];if(d instanceof c.Bracket){var h=g.min(d.p1.x,d.p2.x),e=g.max(d.p1.x,d.p2.x),m=g.min(d.p1.y,d.p2.y),q=g.max(d.p1.y,d.p2.y),t=[];t.push({x:e+5,y:m+15,v:1});
t.push({x:e+5,y:q+15,v:2});t.push({x:h-17,y:(m+q)/2+15,v:3});h=0;for(e=t.length;h<e;h++)if(m=t[h],f.isBetween(a.p.x,m.x,m.x+12)&&f.isBetween(a.p.y,m.y-6,m.y)){this.control={s:d,t:m.v};break}else if(f.isBetween(a.p.x,m.x,m.x+12)&&f.isBetween(a.p.y,m.y+6,m.y+12)){this.control={s:d,t:-1*m.v};break}if(this.control)break}}this.sketcher.repaint()}};h.innermousedown=function(a){this.control?(this.sketcher.historyManager.pushUndo(new d.ChangeBracketAttributeAction(this.control.s,this.control.t)),this.sketcher.repaint()):
this.end=this.start=new b.Point(a.p.x,a.p.y)};h.innerdrag=function(a){this.end=new b.Point(a.p.x,a.p.y);if(this.shapeType===j.ShapeState.BRACKET){if(e.SHIFT){a=this.end.x-this.start.x;var c=this.end.y-this.start.y;0>a&&0<c?c*=-1:0<a&&0>c&&(a*=-1);var i=c;g.abs(a)<g.abs(c)&&(i=a);this.end.x=this.start.x+i;this.end.y=this.start.y+i}}else e.ALT||(a=this.start.angle(this.end),c=this.start.distance(this.end),e.ALT||(a=g.floor((a+g.PI/12)/(g.PI/6))*g.PI/6),this.end.x=this.start.x+c*g.cos(a),this.end.y=
this.start.y-c*g.sin(a));this.sketcher.repaint()};h.innermouseup=function(){if(this.start&&this.end){var a;5<this.start.distance(this.end)&&(this.shapeType>=j.ShapeState.LINE&&this.shapeType<=j.ShapeState.ARROW_EQUILIBRIUM?(a=new c.Line(this.start,this.end),this.shapeType===j.ShapeState.ARROW_SYNTHETIC?a.arrowType=c.Line.ARROW_SYNTHETIC:this.shapeType===j.ShapeState.ARROW_RETROSYNTHETIC?a.arrowType=c.Line.ARROW_RETROSYNTHETIC:this.shapeType===j.ShapeState.ARROW_RESONANCE?a.arrowType=c.Line.ARROW_RESONANCE:
this.shapeType===j.ShapeState.ARROW_EQUILIBRIUM&&(a.arrowType=c.Line.ARROW_EQUILIBRIUM)):this.shapeType===j.ShapeState.BRACKET&&(a=new c.Bracket(this.start,this.end)));this.end=this.start=void 0;a&&this.sketcher.historyManager.pushUndo(new d.AddShapeAction(this.sketcher,a))}};h.draw=function(b){if(this.start&&this.end)b.strokeStyle="#00FF00",b.fillStyle="#00FF00",b.lineWidth=1,b.beginPath(),b.moveTo(this.start.x,this.start.y),this.shapeType===j.ShapeState.BRACKET?(a.contextHashTo(b,this.start.x,this.start.y,
this.end.x,this.start.y,2,2),a.contextHashTo(b,this.end.x,this.start.y,this.end.x,this.end.y,2,2),a.contextHashTo(b,this.end.x,this.end.y,this.start.x,this.end.y,2,2),a.contextHashTo(b,this.start.x,this.end.y,this.start.x,this.start.y,2,2)):a.contextHashTo(b,this.start.x,this.start.y,this.end.x,this.end.y,2,2),b.stroke();else if(this.shapeType===j.ShapeState.BRACKET){b.lineWidth=2;b.lineJoin="miter";b.lineCap="butt";for(var d=0,i=this.sketcher.shapes.length;d<i;d++){var h=this.sketcher.shapes[d];
if(h instanceof c.Bracket){var e=g.min(h.p1.x,h.p2.x),f=g.max(h.p1.x,h.p2.x),r=g.min(h.p1.y,h.p2.y),q=g.max(h.p1.y,h.p2.y),h=this.control&&this.control.s===h?this.control:void 0;m(b,f+5,r+15,h,1);m(b,f+5,q+15,h,2);m(b,e-17,(r+q)/2+15,h,3)}}}};j.ShapeState.LINE=1;j.ShapeState.ARROW_SYNTHETIC=2;j.ShapeState.ARROW_RETROSYNTHETIC=3;j.ShapeState.ARROW_RESONANCE=4;j.ShapeState.ARROW_EQUILIBRIUM=5;j.ShapeState.BRACKET=10})(ChemDoodle.extensions,ChemDoodle.math,ChemDoodle.monitor,ChemDoodle.structures,ChemDoodle.structures.d2,
ChemDoodle.sketcher.actions,ChemDoodle.sketcher.states,Math);
(function(a){a.StateManager=function(f){this.STATE_NEW_BOND=new a.NewBondState(f);this.STATE_NEW_RING=new a.NewRingState(f);this.STATE_CHARGE=new a.ChargeState(f);this.STATE_LONE_PAIR=new a.LonePairState(f);this.STATE_RADICAL=new a.RadicalState(f);this.STATE_MOVE=new a.MoveState(f);this.STATE_ERASE=new a.EraseState(f);this.STATE_LABEL=new a.LabelState(f);this.STATE_LASSO=new a.LassoState(f);this.STATE_SHAPE=new a.ShapeState(f);this.STATE_PUSHER=new a.PusherState(f);this.STATE_ATOM_QUERY=new a.AtomQueryState(f);
var e=this.STATE_NEW_BOND;this.setState=function(a){a!==e&&(e.exit(),e=a,e.enter())};this.getCurrentState=function(){return e}}})(ChemDoodle.sketcher.states);
ChemDoodle.sketcher.gui.imageDepot=function(){return{getURI:function(a){return"data:image/png;base64,"+a},ADD_LONE_PAIR:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAANElEQVR42mNgGAWjYHACGyB+DMTPgdiFDHkMAFL8H4qfkyFPewNtoApB2IMM+VEwCgYcAADjvBhZpYZJbQAAAABJRU5ErkJggg\x3d\x3d",ADD_RADICAL:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAL0lEQVR42mNgGAWjYGgAGyB+DMTPgdiFGgaCDPsPxc8HpYE2UINA2GM0BYyCoQAAdQgMLdlWmzIAAAAASUVORK5CYII\x3d",ANY_ELEMENT:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAABF0lEQVR42u3TsUtCURSA8ZePCJcgqCFwEomGNoWgpCFwaHHIv6CpJYqoxSWScAhqMopQKIjIpsYWoUkahCxahKaGqAjB9qK+C/fB4fBI6L3xHfiBHrgfvqs6TjQ+M4QEmvZ14FnDBYp4wnjQYBzr2MAsYmE88g0WsBvWPQ7859AMfpASuxG7y4rdCjZRx47YT6Alg4d4xZYKfuNO3J0XnEQPo3Z/hZx3cBDPWERHBR9wi2UVNHOKPczhWn66PM7h4g1pEWwjg3f7XgaT+MQ9pmTwEgX7EznCvgqaqaKigmZOcCZjw+jag8YjXuydyeAYPnCsgiWUZXAJB+obN/+IeRU0s4qvfsEGplVwGzWfoGuf4M9gNMHmF6UIOpc0VqXrAAAAAElFTkSuQmCC",
ARROW_DOWN:"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",
ARROW_EQUILIBRIUM:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAV0lEQVR42mNgGAXDArBQ28AKIL4GxAFAzEMtF/6H4s9AfBKIq4DYBFnRfyrhx0Mj1h5T0ctwYADERUB8FYh/APEvqAKqxCIHEHsA8Xkgbhj0iXgUDAAAAG9tMdQezXJsAAAAAElFTkSuQmCC",ARROW_RESONANCE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAWUlEQVR42mNgGAWjYPACFiBWwSOvAcQc+AzgAWIXIJ4BxP+h2AOPehMkdduAuAiIbaDmMNQgSVIDo7hwERkuPADEFUDsAHMhriBwgIYlNgDynshoUhsFVAIA/dMiIBsQRGUAAAAASUVORK5CYII\x3d",ARROW_RETROSYNTHETIC:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAYElEQVR42mNgGI5AhZqGKQDxbSA2oaahBrQ01ILahr4HYhtskv8pwF9xGUouAHn7MRA7UNNQG6hrPahtoA+1vPwc3XWURooPtZLNc2qFG8iw+9Q2zIFahQPV05zG0C59AY3IMME0CTYYAAAAAElFTkSuQmCC",
ARROW_SYNTHETIC:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAUklEQVR42mNgGAWjgC5ABoh5qGmgAhD/B+I7QJwAxALUMPQg1NAHQPwdiPegG/6fipgssA+q+REQ/wDivUCcAsQi5EYKLAzJNgQ9UmRGE/tIBgDIaCG7b3KulAAAAABJRU5ErkJggg\x3d\x3d",BENZENE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAA5klEQVR42s2VPwrCMBSH06k0o1MX6R2c7A08hDfRRdDVgp5BR71GvUKdtHNvIMRf4FcoIdgkzeCDD0r+fLyQl1ch3GMmIkUOzuADDkBOEVWgA0ewABfQgjVIQkU5x/vMlqAGD1CGiFKwBS+QcSxhli2znpsyvVAZIh0r8AQ3UFiS0FnvuDczJ9XgW2++g4bSsVC/BiWPt+FxXSRqbEHmmZVyTvtvhTKmUMvesS+lYO0Fl01f2JWlsJvQws75UjpDnPL4Xk/PRdzLSjaGmo3Cq30Nxbp9XXlhXu3LJj6xwe6nNNigX8AXVupH9hGtsNcAAAAASUVORK5CYII\x3d",
BOND_DOUBLE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAQUlEQVR42mNgoA7gZqAicADi+0DMRS3DXgGxPTVcim4YzKVUMwyZP2rYqGGjhg0Dw7ihpQRVDIMBLmoahsulZAEA2GgvCVlTJIIAAAAASUVORK5CYII\x3d",BOND_DOUBLE_AMBIGUOUS:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAwElEQVR42q2UsQ2DQBAE38EnBDQAJUBGA6YM04UD3n1AYhdhMkqAHpw4owgkJNbSfuLw904aIZLV3t/tOWdTmTOsGnytRHPwATcLpxcwgYH/HZ0mVwALXY10WqWKtWADDVjBm+0nVUmxO79BadPT0UyxqzrVF4V+b1eoYg+wgyedymIH6FUhzzZ3C7GSA9jYplRxz2YOwCtxCn97VihBn+ioUfesZhYHZnNVEpDxSsQTNDKbJhe3o9PcGVR0WikiJ/j5KxJqecPNAAAAAElFTkSuQmCC",
BOND_HALF:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAYklEQVR42mNgGAVkAA8g3k4tw0yA+DXUUIqBC9SwGGq57jYQ+1Az7FioYYgCtQwCAQMgvg/EKtQy7DG1YtMB6jKqRUAFtVxGVeBATVeBIuA5tcIMFptUMUyH2rHJAXXh4AIAvQ0O0wCO68MAAAAASUVORK5CYII\x3d",BOND_PROTRUDING:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAl0lEQVR42mNgoAwEAHEDA5WAChC/B+L/1DCUBYivQw37Tw1Dl6MZRpGhBTgM+w3EFaQaZgPEn7EY9hiIPUg1TAaI72Mx7DAQK5ATCbuxGNYPxDzkhFs3lvCKoCTxIht2G4g1qJF4QXg9uV5ET7xkJQlciZesJIEr8ZKVJHAl3n5Kwgs58d6mJEmgR8J0SpIENq/yMAx7AADDzz/MOB6JagAAAABJRU5ErkJggg\x3d\x3d",
BOND_RECESSED:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAQUlEQVR42mNgGGQghJqGBQDxbyBOoaahCYPSUGyaYYYOI28y4PDm4IxNBmp6k2JAE28OPvAdiBuoaaALwyggBQAA+tATdpIiCMcAAAAASUVORK5CYII\x3d",BOND_RESONANCE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAfUlEQVR42mNgoA7gZqAicADi+0DMRS3DXgGx/aA3zAOIt1PLMBMgfg01lGLDXKCGxVArzG4DsQ81I4CFGoYpkGsQNsMMoIlYhVqGPaZWbMKyF9UioIJaLqNqdnIg11W4IuA5uWHGDQ1w9Nj0ocS7sMJRh5LYxAY4oC4kGwAAJbAmYdoaIPoAAAAASUVORK5CYII\x3d",BOND_SINGLE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAMklEQVR42mNgGMSAm5qGOQDxfSDmopZhr4DYftSwUcNGDRs1jP6GcUPLM6oYBgNUKRwBiE8XjxDJvZUAAAAASUVORK5CYII\x3d",
BOND_TRIPLE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAUUlEQVR42mNgoAxwM1AROADxfSDmopZhr4DYnhouRTeMIpdiM4xslxIyDOZSqhmGzB81bNSwATeMG5rCqWIYDHBR0zBiXUoW4KKmYbhcShIAAA2MPiFy45L3AAAAAElFTkSuQmCC",BOND_ZERO:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAH0lEQVR42mNgGAVkgPtQPHgNHA2z0TAbDbPRMBsAAADVkQ3x7nq43wAAAABJRU5ErkJggg\x3d\x3d",BROMINE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAA3UlEQVR42mNgGAVUB8s0NDYu09T8D8LLNTVvA+lZKzQ1dSg18MRSTU2X5RoarUD2dyC+SKmBu+B8Tc0FQPx3prExK1UMXK6lNRPo2rNIFnQB1UwCikUs09K6DuQXEGXgQg0NYaCGGCD7xVItLX8kA5cD8R1QsADDOBZosCoxBv6F4v9AQxNR5CEGPl2kpydGkpdXqalJA+ksIH4AxLNRDASqITsMgV6yA7kUlnQoNhCYdBRABgINzqTEwINAA+SXq6ubANnrgfgfiE2Jgf+h+C0QrwSKBZMdhqNg4AEAUSSF6Clvq/4AAAAASUVORK5CYII\x3d",
CALCULATE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAKQ2lDQ1BJQ0MgUHJvZmlsZQAAeAGdlndUU1kTwO97L73QEkKREnoNTUoAkRJ6kV5FJSQBQgkYErBXRAVXFBVpiiKLIi64uhRZK6JYWBQUsC/IIqCsi6uIimVf9Bxl/9j9vrPzx5zfmztz79yZuec8ACi+gUJRJqwAQIZIIg7z8WDGxMYx8d0ABkSAA9YAcHnZWUHh3hEAFT8vDjMbdZKxTKDP+nX/F7jF8g1hMj+b/n+lyMsSS9CdQtCQuXxBNg/lPJTTcyVZMvskyvTENBnDGBmL0QRRVpVx8hc2/+zzhd1kzM8Q8VEfWc5Z/Ay+jDtQ3pIjFaCMBKKcnyMU5KJ8G2X9dGmGEOU3KNMzBNxsADAUmV0i4KWgbIUyRRwRxkF5HgAESvIsTpzFEsEyNE8AOJlZy8XC5BQJ05hnwrR2dGQzfQW56QKJhBXC5aVxxXwmJzMjiytaDsCXO8uigJKstky0yPbWjvb2LBsLtPxf5V8Xv3r9O8h6+8XjZejnnkGMrm+2b7HfbJnVALCn0Nrs+GZLLAOgZRMAqve+2fQPACCfB0DzjVn3YcjmJUUiyXKytMzNzbUQCngWsoJ+lf/p8NXzn2HWeRay877WjukpSOJK0yVMWVF5memZUjEzO4vLEzBZfxtidOv/HDgrrVl5mIcJkgRigQg9KgqdMqEoGW23iC+UCDNFTKHonzr8H8Nm5SDDL3ONAq3mI6AvsQAKN+gA+b0LYGhkgMTvR1egr30LJEYB2cuL1h79Mvcoo+uf9d8UXIR+wtnCZKbMzAmLYPKk4hwZo29CprCABOQBHagBLaAHjAEL2AAH4AzcgBfwB8EgAsSCxYAHUkAGEINcsAqsB/mgEOwAe0A5qAI1oA40gBOgBZwGF8BlcB3cBH3gPhgEI+AZmASvwQwEQXiICtEgNUgbMoDMIBuIDc2HvKBAKAyKhRKgZEgESaFV0EaoECqGyqGDUB30I3QKugBdhXqgu9AQNA79Cb2DEZgC02FN2BC2hNmwOxwAR8CL4GR4KbwCzoO3w6VwNXwMboYvwNfhPngQfgZPIQAhIwxEB2EhbISDBCNxSBIiRtYgBUgJUo00IG1IJ3ILGUQmkLcYHIaGYWJYGGeMLyYSw8MsxazBbMOUY45gmjEdmFuYIcwk5iOWitXAmmGdsH7YGGwyNhebjy3B1mKbsJewfdgR7GscDsfAGeEccL64WFwqbiVuG24frhF3HteDG8ZN4fF4NbwZ3gUfjOfiJfh8fBn+GP4cvhc/gn9DIBO0CTYEb0IcQUTYQCghHCWcJfQSRgkzRAWiAdGJGEzkE5cTi4g1xDbiDeIIcYakSDIiuZAiSKmk9aRSUgPpEukB6SWZTNYlO5JDyULyOnIp+Tj5CnmI/JaiRDGlcCjxFCllO+Uw5TzlLuUllUo1pLpR46gS6nZqHfUi9RH1jRxNzkLOT44vt1auQq5ZrlfuuTxR3kDeXX6x/Ar5EvmT8jfkJxSICoYKHAWuwhqFCoVTCgMKU4o0RWvFYMUMxW2KRxWvKo4p4ZUMlbyU+Ep5SoeULioN0xCaHo1D49E20mpol2gjdBzdiO5HT6UX0n+gd9MnlZWUbZWjlJcpVyifUR5kIAxDhh8jnVHEOMHoZ7xT0VRxVxGobFVpUOlVmVado+qmKlAtUG1U7VN9p8ZU81JLU9up1qL2UB2jbqoeqp6rvl/9kvrEHPoc5zm8OQVzTsy5pwFrmGqEaazUOKTRpTGlqaXpo5mlWaZ5UXNCi6HlppWqtVvrrNa4Nk17vrZQe7f2Oe2nTGWmOzOdWcrsYE7qaOj46kh1Dup068zoGulG6m7QbdR9qEfSY+sl6e3Wa9eb1NfWD9JfpV+vf8+AaMA2SDHYa9BpMG1oZBhtuNmwxXDMSNXIz2iFUb3RA2OqsavxUuNq49smOBO2SZrJPpObprCpnWmKaYXpDTPYzN5MaLbPrMcca+5oLjKvNh9gUVjurBxWPWvIgmERaLHBosXiuaW+ZZzlTstOy49WdlbpVjVW962VrP2tN1i3Wf9pY2rDs6mwuT2XOtd77tq5rXNf2JrZCmz3296xo9kF2W22a7f7YO9gL7ZvsB930HdIcKh0GGDT2SHsbewrjlhHD8e1jqcd3zrZO0mcTjj94cxyTnM+6jw2z2ieYF7NvGEXXReuy0GXwfnM+QnzD8wfdNVx5bpWuz5203Pju9W6jbqbuKe6H3N/7mHlIfZo8pjmOHFWc857Ip4+ngWe3V5KXpFe5V6PvHW9k73rvSd97HxW+pz3xfoG+O70HfDT9OP51flN+jv4r/bvCKAEhAeUBzwONA0UB7YFwUH+QbuCHiwwWCBa0BIMgv2CdwU/DDEKWRrycyguNCS0IvRJmHXYqrDOcFr4kvCj4a8jPCKKIu5HGkdKI9uj5KPio+qipqM9o4ujB2MsY1bHXI9VjxXGtsbh46LiauOmFnot3LNwJN4uPj++f5HRomWLri5WX5y++MwS+SXcJScTsAnRCUcT3nODudXcqUS/xMrESR6Ht5f3jO/G380fF7gIigWjSS5JxUljyS7Ju5LHU1xTSlImhBxhufBFqm9qVep0WnDa4bRP6dHpjRmEjISMUyIlUZqoI1Mrc1lmT5ZZVn7W4FKnpXuWTooDxLXZUPai7FYJHf2Z6pIaSzdJh3Lm51TkvMmNyj25THGZaFnXctPlW5ePrvBe8f1KzEreyvZVOqvWrxpa7b764BpoTeKa9rV6a/PWjqzzWXdkPWl92vpfNlhtKN7wamP0xrY8zbx1ecObfDbV58vli/MHNjtvrtqC2SLc0r117tayrR8L+AXXCq0KSwrfb+Ntu/ad9Xel333anrS9u8i+aP8O3A7Rjv6drjuPFCsWryge3hW0q3k3c3fB7ld7luy5WmJbUrWXtFe6d7A0sLS1TL9sR9n78pTyvgqPisZKjcqtldP7+Pt697vtb6jSrCqsendAeODOQZ+DzdWG1SWHcIdyDj2piarp/J79fV2tem1h7YfDosODR8KOdNQ51NUd1ThaVA/XS+vHj8Ufu/mD5w+tDayGg42MxsLj4Lj0+NMfE37sPxFwov0k+2TDTwY/VTbRmgqaoeblzZMtKS2DrbGtPaf8T7W3Obc1/Wzx8+HTOqcrziifKTpLOpt39tO5Feemzmedn7iQfGG4fUn7/YsxF293hHZ0Xwq4dOWy9+WLne6d5664XDl91enqqWvsay3X7a83d9l1Nf1i90tTt3138w2HG603HW+29czrOdvr2nvhluety7f9bl/vW9DX0x/Zf2cgfmDwDv/O2N30uy/u5dybub/uAfZBwUOFhyWPNB5V/2rya+Og/eCZIc+hrsfhj+8P84af/Zb92/uRvCfUJyWj2qN1YzZjp8e9x28+Xfh05FnWs5mJ/N8Vf698bvz8pz/c/uiajJkceSF+8enPbS/VXh5+ZfuqfSpk6tHrjNcz0wVv1N4cect+2/ku+t3oTO57/PvSDyYf2j4GfHzwKePTp78AA5vz/OzO54oAAAAJcEhZcwAACxMAAAsTAQCanBgAAAMtSURBVDgRnVXNTxNREP+1W6gW2oUKWNs0fAQUqCGNGjDB3iSmNhFJuPMHYLx5lpB4IRylV1M9E+RgbBMPJBpDxA8kNhUUAaUpFWiXtFDK9sM3D3ezS/HiJG/fvDczv52ZN2+eoVwugygcDntFUZwRBKHFZDJBO0guyzKOjo5weHiIdDqN1dVVKRaLDQWDwTmSK2RSmL29vYctjASjEaViEVarFbU2GywWC1fJZDLY2dkBzTTMZnNdIpF4woStCgbNKuDW1lZdh8eLdMmGz0sSFr/8QokpGGqM6Lokotldi5exLPL7VhQOrLiYe0WethCIlozKIpfLodEuQigbcPO6A5Yzx/9qEM0Y6nfBUiXgVncjVy+xNIn288jn84q5OquAtCMXSnj9dRtL39K40l3PlXw9DYh8TGLmUwLXmuv4XpNYjY4LZ1EqUQx60gH+TO1z6fJ6Blc9ds53tdrw4Xua8wdyETVmAXd6m7ASP9bVwwE6wGLx+I+7Uh40Ht3vQeTdlmoTjv7Gg0AbD/9HIqPuaxn1UGjzXJUMp0VGub6MNwtxvF1MwlRbjU5XLQqmIjvdLIIvliBLaTRV7WhxVF4HKBiAy4159DQZYGcHVGe3w8ZKhyiVSiEej2NtLYGN7AZSKKogWkYHSILHU1NgNYnbfj96+/owNjbG9YeHh8EKH6FQiK/b2tr4fPKjy+FJ4f+sKzy8NzoKo4FCtvOQp6enOa4S8sjICDY2WMgsBadRBeD27212X3Psihg4YDQa5XYULhUyu1GQJAlFdj1PowrA0LOn3JBymGfNYGJigtsFAgE4HA5EIhG+/lcOKwDb29uRzWbhdDrR2NAAj8fDAdxuN+84p3ml3asAvDs4qMvh+Pg416eczc/Pa21P5VVApS8+n53lHt7o74fX68Xk5CQ39Pl8OgC6x4qNVqACUuOkRK+srPDQPN3d2Gb9TzkU1ip5DsmY9Kgnks1JUgFZKUgL7xfQ1dnJGywpb25uYmBggNuQR1QuLpeL35jl5WXs7u6unwQ0KG77/X5vMpmcYSXBnwD2FMDIujcNIvKKRqFQ4BGwWWK2Q6xrz3GFv58/Du1jSFDkv4UAAAAASUVORK5CYII\x3d",
CARBON:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAA2klEQVR42mNgGAXYwMyZM1knTZqk1dvbK9vQ0MBEtkETJ06UmzBhwi4g/gXEn4D4L5R9jGTDQK4BanwPxNeArtP///8/4/z58zmAfFcg7iHZQKCmaUD8derUqRIUh9mqVauYgYb9ABlKlUiYPHmyItCw//39/QlUMRBokAPIQFB4UcXAvr4+XaiB4VQxsLu7mxtqYDPVEjM0/b0BJhk+qhgINMgQaOBvID4LS4fAXMIC5JsDw3gCuZFjBDTgPNT7n4H4O1DsApDuoMi1HR0d/MBsaAyiR0s22gMANJ6AxDvp00kAAAAASUVORK5CYII\x3d",CHARGE_BRACKET:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAYUlEQVR42mNgGAnACYhF0AX/Q3EDDk0NSGrQwUogNsZmIDEApk4MiOWheAsQ+yLxyTJwIhBfgOIPQHwLiU+WgVT3Mk0NlAZiDkoNXAjEz3Bgil1IkcJRA4e6geSWNkMMAAAxJTQf078zGQAAAABJRU5ErkJggg\x3d\x3d",
CHLORINE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAA9klEQVR42mNgGAXIwPi/MavcZzkt5bfKsgz/GZiQ5RTeKyTIfZBLI8ogpXdKcgofFHbJf5D/BcSfgPgvlH0MpgbIXq7wUWEjQcNArgEqfg/E1xTfK+oDXcao8F+BA+gaV6BYD8kGAhVOA+KvCl8UJAioI8LA/wzMQIU/QIYSYTFhA4GKFIH4PyjAqWIg0CAHkIGg8KKKgTLvZHTBLvygEE4VA8VfiHODDATGcTNVDAR7G5L+3qi8VeGjioFA1xkCFf8G4rOwdAjELEDN5kA8gWQDoYqNgPg82Psf5D8D8XcgvgB0fQdZBiJlQX5gjBuD6NGSjX4AAER4jBfAQ3QdAAAAAElFTkSuQmCC",CLEAR:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAKQ2lDQ1BJQ0MgUHJvZmlsZQAAeAGdlndUU1kTwO97L73QEkKREnoNTUoAkRJ6kV5FJSQBQgkYErBXRAVXFBVpiiKLIi64uhRZK6JYWBQUsC/IIqCsi6uIimVf9Bxl/9j9vrPzx5zfmztz79yZuec8ACi+gUJRJqwAQIZIIg7z8WDGxMYx8d0ABkSAA9YAcHnZWUHh3hEAFT8vDjMbdZKxTKDP+nX/F7jF8g1hMj+b/n+lyMsSS9CdQtCQuXxBNg/lPJTTcyVZMvskyvTENBnDGBmL0QRRVpVx8hc2/+zzhd1kzM8Q8VEfWc5Z/Ay+jDtQ3pIjFaCMBKKcnyMU5KJ8G2X9dGmGEOU3KNMzBNxsADAUmV0i4KWgbIUyRRwRxkF5HgAESvIsTpzFEsEyNE8AOJlZy8XC5BQJ05hnwrR2dGQzfQW56QKJhBXC5aVxxXwmJzMjiytaDsCXO8uigJKstky0yPbWjvb2LBsLtPxf5V8Xv3r9O8h6+8XjZejnnkGMrm+2b7HfbJnVALCn0Nrs+GZLLAOgZRMAqve+2fQPACCfB0DzjVn3YcjmJUUiyXKytMzNzbUQCngWsoJ+lf/p8NXzn2HWeRay877WjukpSOJK0yVMWVF5memZUjEzO4vLEzBZfxtidOv/HDgrrVl5mIcJkgRigQg9KgqdMqEoGW23iC+UCDNFTKHonzr8H8Nm5SDDL3ONAq3mI6AvsQAKN+gA+b0LYGhkgMTvR1egr30LJEYB2cuL1h79Mvcoo+uf9d8UXIR+wtnCZKbMzAmLYPKk4hwZo29CprCABOQBHagBLaAHjAEL2AAH4AzcgBfwB8EgAsSCxYAHUkAGEINcsAqsB/mgEOwAe0A5qAI1oA40gBOgBZwGF8BlcB3cBH3gPhgEI+AZmASvwQwEQXiICtEgNUgbMoDMIBuIDc2HvKBAKAyKhRKgZEgESaFV0EaoECqGyqGDUB30I3QKugBdhXqgu9AQNA79Cb2DEZgC02FN2BC2hNmwOxwAR8CL4GR4KbwCzoO3w6VwNXwMboYvwNfhPngQfgZPIQAhIwxEB2EhbISDBCNxSBIiRtYgBUgJUo00IG1IJ3ILGUQmkLcYHIaGYWJYGGeMLyYSw8MsxazBbMOUY45gmjEdmFuYIcwk5iOWitXAmmGdsH7YGGwyNhebjy3B1mKbsJewfdgR7GscDsfAGeEccL64WFwqbiVuG24frhF3HteDG8ZN4fF4NbwZ3gUfjOfiJfh8fBn+GP4cvhc/gn9DIBO0CTYEb0IcQUTYQCghHCWcJfQSRgkzRAWiAdGJGEzkE5cTi4g1xDbiDeIIcYakSDIiuZAiSKmk9aRSUgPpEukB6SWZTNYlO5JDyULyOnIp+Tj5CnmI/JaiRDGlcCjxFCllO+Uw5TzlLuUllUo1pLpR46gS6nZqHfUi9RH1jRxNzkLOT44vt1auQq5ZrlfuuTxR3kDeXX6x/Ar5EvmT8jfkJxSICoYKHAWuwhqFCoVTCgMKU4o0RWvFYMUMxW2KRxWvKo4p4ZUMlbyU+Ep5SoeULioN0xCaHo1D49E20mpol2gjdBzdiO5HT6UX0n+gd9MnlZWUbZWjlJcpVyifUR5kIAxDhh8jnVHEOMHoZ7xT0VRxVxGobFVpUOlVmVado+qmKlAtUG1U7VN9p8ZU81JLU9up1qL2UB2jbqoeqp6rvl/9kvrEHPoc5zm8OQVzTsy5pwFrmGqEaazUOKTRpTGlqaXpo5mlWaZ5UXNCi6HlppWqtVvrrNa4Nk17vrZQe7f2Oe2nTGWmOzOdWcrsYE7qaOj46kh1Dup068zoGulG6m7QbdR9qEfSY+sl6e3Wa9eb1NfWD9JfpV+vf8+AaMA2SDHYa9BpMG1oZBhtuNmwxXDMSNXIz2iFUb3RA2OqsavxUuNq49smOBO2SZrJPpObprCpnWmKaYXpDTPYzN5MaLbPrMcca+5oLjKvNh9gUVjurBxWPWvIgmERaLHBosXiuaW+ZZzlTstOy49WdlbpVjVW962VrP2tN1i3Wf9pY2rDs6mwuT2XOtd77tq5rXNf2JrZCmz3296xo9kF2W22a7f7YO9gL7ZvsB930HdIcKh0GGDT2SHsbewrjlhHD8e1jqcd3zrZO0mcTjj94cxyTnM+6jw2z2ieYF7NvGEXXReuy0GXwfnM+QnzD8wfdNVx5bpWuz5203Pju9W6jbqbuKe6H3N/7mHlIfZo8pjmOHFWc857Ip4+ngWe3V5KXpFe5V6PvHW9k73rvSd97HxW+pz3xfoG+O70HfDT9OP51flN+jv4r/bvCKAEhAeUBzwONA0UB7YFwUH+QbuCHiwwWCBa0BIMgv2CdwU/DDEKWRrycyguNCS0IvRJmHXYqrDOcFr4kvCj4a8jPCKKIu5HGkdKI9uj5KPio+qipqM9o4ujB2MsY1bHXI9VjxXGtsbh46LiauOmFnot3LNwJN4uPj++f5HRomWLri5WX5y++MwS+SXcJScTsAnRCUcT3nODudXcqUS/xMrESR6Ht5f3jO/G380fF7gIigWjSS5JxUljyS7Ju5LHU1xTSlImhBxhufBFqm9qVep0WnDa4bRP6dHpjRmEjISMUyIlUZqoI1Mrc1lmT5ZZVn7W4FKnpXuWTooDxLXZUPai7FYJHf2Z6pIaSzdJh3Lm51TkvMmNyj25THGZaFnXctPlW5ePrvBe8f1KzEreyvZVOqvWrxpa7b764BpoTeKa9rV6a/PWjqzzWXdkPWl92vpfNlhtKN7wamP0xrY8zbx1ecObfDbV58vli/MHNjtvrtqC2SLc0r117tayrR8L+AXXCq0KSwrfb+Ntu/ad9Xel333anrS9u8i+aP8O3A7Rjv6drjuPFCsWryge3hW0q3k3c3fB7ld7luy5WmJbUrWXtFe6d7A0sLS1TL9sR9n78pTyvgqPisZKjcqtldP7+Pt697vtb6jSrCqsendAeODOQZ+DzdWG1SWHcIdyDj2piarp/J79fV2tem1h7YfDosODR8KOdNQ51NUd1ThaVA/XS+vHj8Ufu/mD5w+tDayGg42MxsLj4Lj0+NMfE37sPxFwov0k+2TDTwY/VTbRmgqaoeblzZMtKS2DrbGtPaf8T7W3Obc1/Wzx8+HTOqcrziifKTpLOpt39tO5Feemzmedn7iQfGG4fUn7/YsxF293hHZ0Xwq4dOWy9+WLne6d5664XDl91enqqWvsay3X7a83d9l1Nf1i90tTt3138w2HG603HW+29czrOdvr2nvhluety7f9bl/vW9DX0x/Zf2cgfmDwDv/O2N30uy/u5dybub/uAfZBwUOFhyWPNB5V/2rya+Og/eCZIc+hrsfhj+8P84af/Zb92/uRvCfUJyWj2qN1YzZjp8e9x28+Xfh05FnWs5mJ/N8Vf698bvz8pz/c/uiajJkceSF+8enPbS/VXh5+ZfuqfSpk6tHrjNcz0wVv1N4cect+2/ku+t3oTO57/PvSDyYf2j4GfHzwKePTp78AA5vz/OzO54oAAAAJcEhZcwAACxMAAAsTAQCanBgAAAKZSURBVDgRlZTLTxNRFId/La2VkNCh0hQVZayatJGFxhAiqBnYyIaEjWt15QpS/gIhbBoXxrglaV36iAGf2+Kim66awIJUA0QXxr5mOtNpp9N26rmVaZgK03iTM/fc8/jmzJl7r6PVasFurK2t8bIsx0VRFPb29pBMJh/VarWXJ+Yw4EmyuLgYCYfDIiXvkzwk2SBJnBTP7MfClpaW+NnZ2QQlM9gKCdcO/qv/H3B+fj7icrkYKG6CzIoikcjKxMSELdBFSZ0xNDS0IUkSR4YbBDkwHdFoNE4V816vlw8Gg5wgCIl8Po9MJrOq6/qWGcdmC5BgqwRKHw1guqZpC/QyLpVKoVgsgn6SsLu7y9r1ntxbLMYcDjKa+rFzLBYTCoVCPDh2gee8g2hSeK1SxtNnL1AUxedut3s1nU5LZrItcH19XRj2+RLXQlcxejaAlrMPLYcT1bKMQi6L12/e4e2Hz1s7OzszJtBpKsfN1KcHl8dGcT7gh2EYlpCB/tOYuT0JzymXcNRh6eFRB9NzuRy/+fEL9a2AO9O3MDd3rxPCWiUrCup6vWNjii2wWq1CmJqE38fBHxixJLJFk6rurtwWyIK9I6MYvngJdTixrxhokE0tkyh0fOQ+1A2H5UW2QBaZ+ilCzdLW8XDQSSRVR4lEUh3IZtxQdCvQ9qcwoPTrB7Lft1Ep/mbLnqNnhfzNaZw7E0Re0dqV9SL2rLAXoNvfs8L0p1fIigq849MYHL/bnf/P2hao0D6buv8YocAVFOiT5crhnqM9aDR0NDUVRrNpgdoC6TaBJ/kVHv8+lIqGSq2JstaAWqV+iiVI37ahlTvHuA22PcuhUOg63SxPVFVdcPUPHF7GdClTaotV1qgdkLpZKpWW2zR6/AFFS6MWxt319AAAAABJRU5ErkJggg\x3d\x3d",
CYCLOBUTANE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAiklEQVR42q3UwQ2AIAwF0E7hOv4bTCN7uwIXG0MTYgRa2iYNF3lB+ECkr4MCK3NX7hSBgfvmvtp4RmCCnB4Ug8lbKBaTTCiUH6tQGH9nimJzw3/R7IyEoEluQG0581RpzlvJuUL0KyRnaKd7b0VVB6lFTalYoVsRG6HwHOAXRcQTJmiJwPqcql7sB1sQMyMuYZLDAAAAAElFTkSuQmCC",CYCLOHEPTANE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAA+UlEQVR42mNgIB4IMFABMAOxJxCvAeK/QLwAiA3IMUgTiDuB+CkQnwDiDCBWAuIKIH4ExIeAOASIWfAZIgzEmUB8EmpQBxBr4HA1yLCDUMMrgVgcXREPEP8D4pVA7AHVRAzQB+J5UL08yBKKQPyQgrAGuVQBWcARiA9QYCDI+w7IAonQGCQXLATiBGSBRiBuoMBADP0YNpAIMHyIEQYkAow4wIglEgFKKuGFpiMTCgw0gZrBCxMIgdogQYZhElC9IegS1dB8y0GCYRzQrFqNS8FSKCYWLCOkngPqymoiDKsh1kewMAnCoyaY1DA3BOL/BLAhqbHHRY4cAH9nN15emqC1AAAAAElFTkSuQmCC",
CYCLOHEXANE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAoElEQVR42mNgIB4IMVAJSADxZCD+A8StQMxFiUH9QPwWiPuA2AiIlwLxYyCOAWJGcg2SQJO3AOITQHwSiC0pMQgZMEJd+Rjqall0BZxA/J8Ig9ABKDwboXo50SX/UxBx/4kWHDVw1EDcemEJu5+aCVsCmlPeEmEwwaxHisGW0ILhBLSgIKn4QjYYVHwtA+JHpBZf2AyeBC1gWygpYMmqAgB+TzRkG9cEtwAAAABJRU5ErkJggg\x3d\x3d",CYCLOOCTANE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAABBElEQVR42q2UvQ6CMBSFSXS1g4PRzVUXeRGdHH0KWfQlINGB1VcgzJLokxB2B3dIPDWnSYO1QutJvkB/ONxL7yUIumsU/EFLEIECNCAHOyC6GozBBqSgJPJ+DaY0y8CTVzme2MxkFFewBwvLiwXNcj4zM23a0KyvLuBgWkgZWV+FoAKD9kL5I02b7mDbPs3Soxqk2U2fiJiyq4ZMe6UmCpaGj448oHcHNKwz3yao1UB1gI8ScFID1QGuktk99CwF20l4RBe3JzPHtD+i09POHQzPpugC/jUaHn3YMbIzT3b+bdOMjV5p7TQ0GCVMM7aZ6Rpo7VSxaJctI+e6XfEz1Kwzq9ELFZA4hr9lYwQAAAAASUVORK5CYII\x3d",
CYCLOPENTANE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAA0klEQVR42mNgIB6IMFAJMAFxKRD/BuI0Sg1TAeJDUOwOxFeBeAEQc5Hjqnwgfg3EeUDMCBUHGTQfarAWOa5SxqEmHohfAXECOa7CBbTwBYEWEa7CBpCDwAAmKAjEf6ExyUhm5KUD8R8gFoAJ7AHiIApSA0jvbmSBHKjTyQUgvdnIAvJA/BIaMeQksZdQM1DAJSC2IMNAS6heDNAKxaQCnPpw2kQA4PQZzrDAAwiGPUZsEQCg1DGPUHraQYKBOwmlXx4g/k8i5iFkKxsJLmRjoDUAAID6NQMa+if+AAAAAElFTkSuQmCC",CYCLOPROPANE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAjElEQVR42mNgGE5AgZqGiQDxfyCWoJaBk4H4ORBPp4ZhGkB8G4h5gPg6EBtQauB2IA6Asj2AeD8Qs5BrGDYDkC0gCbDg8CIsCDhINbAATySAIqmC1GRyH08yISRPlgsKiE1GxIYRC7HJiJRYJJiMyElnOB3AQmZOwBlEBRTkVYxIlICWJpRimcFfCgMA4CwtbAP2SjIAAAAASUVORK5CYII\x3d",
DECREASE_CHARGE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAs0lEQVR42mNgGAU4gAAQK0BpsgELEGcA8WUg/g3E/6H4NhCXQOVJMmw/EL8G4gYgdoC60AKIK4D4ORAfB2IeYg07DMT3gVgFhxoZID4PNZSDkIE5UJepEFAnA3VpCSEDL0O9SQyogIYp3tj8DQ0zUPhI4sE80DD9jy/2FaAKFKCu/I8H16Opp48LqR6GNIllWDq8jidsZKBqiEqHyIZSJacgG5oDdSly7N6HepNjwEubwQEAQdI454gPA8EAAAAASUVORK5CYII\x3d",ERASE:"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\x3d\x3d",
FLUORINE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAUElEQVR42mNgGAU0AxPuB26c8CDgPxr+SqmBpyc+DDCG4UkP/AwpNXAvtb08+A38A8SfYbj/ob8LpQae6Hvoqw3DU1+F8oxGygAaOAoGDgAAN7dbSHln+I0AAAAASUVORK5CYII\x3d",HYDROGEN:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAANElEQVR42mNgGAW0BBuBeC8W8SIg/jtqINEGngBiTTTcSYmB/4D4Jxr+Mxopw8jAUTBAAADIhCT11Q14ZwAAAABJRU5ErkJggg\x3d\x3d",INCREASE_CHARGE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAyklEQVR42mNgGAU4gAAQK0BpsgELEGcA8WUg/g3E/6H4NhCXQOVJMmw/EL8G4gYgdoC60AKIK4D4ORAfB2IeYg07DMT3gVgFKsYDNRhmgAwQn4caykHIwByoy1SQxCSh3pVEEpOBurSEkIGXoa5hIGAgA9T7twnF5m9omPFADQBhA6iBBkhiPNAw/Y8v9hWgChSgrvyPB9ejqaePC6kehjSJZVg6vI4UNjzQMENOh4eJTYfIhlIlpyAbmgN1KXLs3od6k2PAS5vBAQCFSEECjKrjagAAAABJRU5ErkJggg\x3d\x3d",
IODINE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAI0lEQVR42mNgGAV0AVMYpmyeyjB196iBowaOGkhXA0cBfQEADcspQU08dAAAAAAASUVORK5CYII\x3d",LASSO:"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\x3d",
LASSO_SHAPES:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAKQ2lDQ1BJQ0MgUHJvZmlsZQAAeAGdlndUU1kTwO97L73QEkKREnoNTUoAkRJ6kV5FJSQBQgkYErBXRAVXFBVpiiKLIi64uhRZK6JYWBQUsC/IIqCsi6uIimVf9Bxl/9j9vrPzx5zfmztz79yZuec8ACi+gUJRJqwAQIZIIg7z8WDGxMYx8d0ABkSAA9YAcHnZWUHh3hEAFT8vDjMbdZKxTKDP+nX/F7jF8g1hMj+b/n+lyMsSS9CdQtCQuXxBNg/lPJTTcyVZMvskyvTENBnDGBmL0QRRVpVx8hc2/+zzhd1kzM8Q8VEfWc5Z/Ay+jDtQ3pIjFaCMBKKcnyMU5KJ8G2X9dGmGEOU3KNMzBNxsADAUmV0i4KWgbIUyRRwRxkF5HgAESvIsTpzFEsEyNE8AOJlZy8XC5BQJ05hnwrR2dGQzfQW56QKJhBXC5aVxxXwmJzMjiytaDsCXO8uigJKstky0yPbWjvb2LBsLtPxf5V8Xv3r9O8h6+8XjZejnnkGMrm+2b7HfbJnVALCn0Nrs+GZLLAOgZRMAqve+2fQPACCfB0DzjVn3YcjmJUUiyXKytMzNzbUQCngWsoJ+lf/p8NXzn2HWeRay877WjukpSOJK0yVMWVF5memZUjEzO4vLEzBZfxtidOv/HDgrrVl5mIcJkgRigQg9KgqdMqEoGW23iC+UCDNFTKHonzr8H8Nm5SDDL3ONAq3mI6AvsQAKN+gA+b0LYGhkgMTvR1egr30LJEYB2cuL1h79Mvcoo+uf9d8UXIR+wtnCZKbMzAmLYPKk4hwZo29CprCABOQBHagBLaAHjAEL2AAH4AzcgBfwB8EgAsSCxYAHUkAGEINcsAqsB/mgEOwAe0A5qAI1oA40gBOgBZwGF8BlcB3cBH3gPhgEI+AZmASvwQwEQXiICtEgNUgbMoDMIBuIDc2HvKBAKAyKhRKgZEgESaFV0EaoECqGyqGDUB30I3QKugBdhXqgu9AQNA79Cb2DEZgC02FN2BC2hNmwOxwAR8CL4GR4KbwCzoO3w6VwNXwMboYvwNfhPngQfgZPIQAhIwxEB2EhbISDBCNxSBIiRtYgBUgJUo00IG1IJ3ILGUQmkLcYHIaGYWJYGGeMLyYSw8MsxazBbMOUY45gmjEdmFuYIcwk5iOWitXAmmGdsH7YGGwyNhebjy3B1mKbsJewfdgR7GscDsfAGeEccL64WFwqbiVuG24frhF3HteDG8ZN4fF4NbwZ3gUfjOfiJfh8fBn+GP4cvhc/gn9DIBO0CTYEb0IcQUTYQCghHCWcJfQSRgkzRAWiAdGJGEzkE5cTi4g1xDbiDeIIcYakSDIiuZAiSKmk9aRSUgPpEukB6SWZTNYlO5JDyULyOnIp+Tj5CnmI/JaiRDGlcCjxFCllO+Uw5TzlLuUllUo1pLpR46gS6nZqHfUi9RH1jRxNzkLOT44vt1auQq5ZrlfuuTxR3kDeXX6x/Ar5EvmT8jfkJxSICoYKHAWuwhqFCoVTCgMKU4o0RWvFYMUMxW2KRxWvKo4p4ZUMlbyU+Ep5SoeULioN0xCaHo1D49E20mpol2gjdBzdiO5HT6UX0n+gd9MnlZWUbZWjlJcpVyifUR5kIAxDhh8jnVHEOMHoZ7xT0VRxVxGobFVpUOlVmVado+qmKlAtUG1U7VN9p8ZU81JLU9up1qL2UB2jbqoeqp6rvl/9kvrEHPoc5zm8OQVzTsy5pwFrmGqEaazUOKTRpTGlqaXpo5mlWaZ5UXNCi6HlppWqtVvrrNa4Nk17vrZQe7f2Oe2nTGWmOzOdWcrsYE7qaOj46kh1Dup068zoGulG6m7QbdR9qEfSY+sl6e3Wa9eb1NfWD9JfpV+vf8+AaMA2SDHYa9BpMG1oZBhtuNmwxXDMSNXIz2iFUb3RA2OqsavxUuNq49smOBO2SZrJPpObprCpnWmKaYXpDTPYzN5MaLbPrMcca+5oLjKvNh9gUVjurBxWPWvIgmERaLHBosXiuaW+ZZzlTstOy49WdlbpVjVW962VrP2tN1i3Wf9pY2rDs6mwuT2XOtd77tq5rXNf2JrZCmz3296xo9kF2W22a7f7YO9gL7ZvsB930HdIcKh0GGDT2SHsbewrjlhHD8e1jqcd3zrZO0mcTjj94cxyTnM+6jw2z2ieYF7NvGEXXReuy0GXwfnM+QnzD8wfdNVx5bpWuz5203Pju9W6jbqbuKe6H3N/7mHlIfZo8pjmOHFWc857Ip4+ngWe3V5KXpFe5V6PvHW9k73rvSd97HxW+pz3xfoG+O70HfDT9OP51flN+jv4r/bvCKAEhAeUBzwONA0UB7YFwUH+QbuCHiwwWCBa0BIMgv2CdwU/DDEKWRrycyguNCS0IvRJmHXYqrDOcFr4kvCj4a8jPCKKIu5HGkdKI9uj5KPio+qipqM9o4ujB2MsY1bHXI9VjxXGtsbh46LiauOmFnot3LNwJN4uPj++f5HRomWLri5WX5y++MwS+SXcJScTsAnRCUcT3nODudXcqUS/xMrESR6Ht5f3jO/G380fF7gIigWjSS5JxUljyS7Ju5LHU1xTSlImhBxhufBFqm9qVep0WnDa4bRP6dHpjRmEjISMUyIlUZqoI1Mrc1lmT5ZZVn7W4FKnpXuWTooDxLXZUPai7FYJHf2Z6pIaSzdJh3Lm51TkvMmNyj25THGZaFnXctPlW5ePrvBe8f1KzEreyvZVOqvWrxpa7b764BpoTeKa9rV6a/PWjqzzWXdkPWl92vpfNlhtKN7wamP0xrY8zbx1ecObfDbV58vli/MHNjtvrtqC2SLc0r117tayrR8L+AXXCq0KSwrfb+Ntu/ad9Xel333anrS9u8i+aP8O3A7Rjv6drjuPFCsWryge3hW0q3k3c3fB7ld7luy5WmJbUrWXtFe6d7A0sLS1TL9sR9n78pTyvgqPisZKjcqtldP7+Pt697vtb6jSrCqsendAeODOQZ+DzdWG1SWHcIdyDj2piarp/J79fV2tem1h7YfDosODR8KOdNQ51NUd1ThaVA/XS+vHj8Ufu/mD5w+tDayGg42MxsLj4Lj0+NMfE37sPxFwov0k+2TDTwY/VTbRmgqaoeblzZMtKS2DrbGtPaf8T7W3Obc1/Wzx8+HTOqcrziifKTpLOpt39tO5Feemzmedn7iQfGG4fUn7/YsxF293hHZ0Xwq4dOWy9+WLne6d5664XDl91enqqWvsay3X7a83d9l1Nf1i90tTt3138w2HG603HW+29czrOdvr2nvhluety7f9bl/vW9DX0x/Zf2cgfmDwDv/O2N30uy/u5dybub/uAfZBwUOFhyWPNB5V/2rya+Og/eCZIc+hrsfhj+8P84af/Zb92/uRvCfUJyWj2qN1YzZjp8e9x28+Xfh05FnWs5mJ/N8Vf698bvz8pz/c/uiajJkceSF+8enPbS/VXh5+ZfuqfSpk6tHrjNcz0wVv1N4cect+2/ku+t3oTO57/PvSDyYf2j4GfHzwKePTp78AA5vz/OzO54oAAAAJcEhZcwAACxMAAAsTAQCanBgAAAT2SURBVDgRbZRdTBRXFMf/d2YW9oOP2eVrWdllEAFFtixasEqQ3ZQmfTCISW2TNo3QNulDH4Sm6WO3pg8+NC340jZNrKs16YtG2tpUqSkQbbTVKIpfWTGspewuLC6zH8N+zez0zrYYHzg3Nzd3zpzfnHPm3j8hhMBkMqGurg5OpxNbt25FZWUlWmo4l5zLDmTTqfYygyzk5QzdZ5BKZ6HTsTMrohLIZlLTCfGp76Mvz4r434jZbEZbWxs6OzshCAK22fSDyMW9SD4W9MnrSD4N4MwVCWs5IJVVgbyK9oYivN5TgjlpG6Q8L973Lx/77OTlTzUm2bt3L7q7u9HrsrugpE+wq9ddyb8n8MW5OPxBeZwipul7M3QGIkk1UFVCeJbApdfBba9gDg31lQrG8k349XJw3HcleoAMDw+jb2e9i1VWJ22ij393LCg+WVGOUcAYBTwrhe43tJ11ZHj/S6bRVkcRvv1FPMLtaeF5ZJYnE/e+4fefEmekDA5omWwUzbIstJ7LsvzMfWMhP3bAyWJ7fdEowzGHuGQsOtpYfoN/+4dYgMI8G2WlQSwWCxwOBziOQygUwsrKCv05ugK4eXvHFNEnkJbjAiOtBt03Z+5DyqgjG8G0CC3Qbrejq6sLnR8eHLS838uXlZWhvb29ANzcusNlKeMgZRFg9OpTIZZUUFWCgOatrq5GbW0tjEYjGIYplKidhKamJtTt38XXlFpGacbDNpsNPT09OP/9KG8uN3hv3P0HwagyzgWD4UCvc5NwddY/wNq6ZrRzqJXj9/sRiUQK0Obm5kK5LGGGG6wyT3Q4bHvP49tdWskr2cSJlvxZ4ZOJpCjncYSLiPLJ5Uydd+eucm9fdUOvo74C/rlMoKOiZmR63iparVa0tLTA3Nsq5JE6LLJhKCVJXrfKnYuvPnEp4d/x5rmEGJVUz3IiL3LVtvrxh4vEazWmUcHNuxkpjVfaWZyJFglv9NpHYobmmd2tta5HnM7LmiL88YUFhPPzuLskuyrmFvDbtcRUOochCiu0jDOVmb0VBgnmzCIuTMexY8sDzN/Tw1ZkcG+uNt4qrpLAFomIZOIQTWH440uIpWNgslGcXjYFMtGYR+v9unFVuiCvz0tYimbplH0X/koKO1rhvj4Xg/JHEHbLBB51e+DqseB0pAzxnASVDlKaRM5uFkjfFrd6aW5qHcic/elqILQ4DylHsKfNOOjuMLn9IRl/+rO+n2/nyFeONk+0FLht0GMpm4ai5guxRE/A2sMAb/Cuw7SVEdPqyPGLcd+FmylE14DJO2ncfJRGKK4ONTY24mD3q6OHXn4Bt5Ta5+NA6EBJDkyp5CYHnYPrTmb6sSreCalDF2ez5MHjNc+ubXo4qriCf9/RDwb3bKlxPWQNSOep3DxnWtkcw9HSV6jE5J9lyfX396OhoQFdm438anhutCR+CWuptSlN0vQ6xltjTeDrFRFrCvMcDlBVlZavgOhploY1gbzmHFbPzI6RH32f88UG04AUDXqt4gnh4+NLUHJKR+it/oGBF2u8V80BzPp1yGRKoKaSIAnat9giXZcplX5D5aBKJuQTFSKKdQ3k1NF35pvNC8LE5DV8d0kS6Z32RNodAVSa5psMWV56EkcuSdWFZrShUeHQ2pnIEqSNxUfIPid7KxBV+aWYepIG/KeBnkYqabIL4QSohGzI2fAhrxf/Bf2+NQqd2ZPzAAAAAElFTkSuQmCC",
MARQUEE:"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",
MOVE:"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\x3d",
NITROGEN:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAoElEQVR42mNgGAU0AwaBPzYaBPx4Z+z7SQRZXN/vlyFQ/L9l6H9Ocgz8b+D/YxY1DfwJxH8N/X6ZUMdAoOuAml8ZBPw8wcDwn5EaLuw09P8eBzJA3/97IlUMBLMDfuwH4pfGof/5qWKgUeBPTWh4TqCKgRD+91Yg/zcsCCg2EGQAkH8PiJ9SxUAQMAz44QlOm9QyEBzLAT/WkGXgKBg4AABF1poQYk+4pAAAAABJRU5ErkJggg\x3d\x3d",OPEN:"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",
OPTIMIZE:"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\x3d\x3d",
OXYGEN:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAABCklEQVR42mNgGAXYwH8pKa7/PDxa/xkY2CgzSFBQ7j8v7wEg/gPEn4H4JxBvAGJh0g3j4pICanwDxCf+8/MrgcW4uXWB/FtAfA/katIM5OGZCNT44b+AgACKOD+/MtTFxcQbxsDADNTwDWQoVnle3nVAfJt4A/n5FYEa/v/n44vF4fpqoPxfoiMJqMEBbCA3twsOFyaC5aFhS4yBOmANPDwhOAwsAssLCfERG4acQA3/gLgKqzwf33Sg3CvSYpmXdy0Q3wEazoQiLirKAxR/jyvC8BmoAY3pZTCvAcNUHCi2F5w+eXhESU/ckLC8CE13T8Axy8u7D5SDKMuCvLwiwBg1Bnl3tGSjPQAAoX15+BfxFYQAAAAASUVORK5CYII\x3d",PERIODIC_TABLE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAKQ2lDQ1BJQ0MgUHJvZmlsZQAAeAGdlndUU1kTwO97L73QEkKREnoNTUoAkRJ6kV5FJSQBQgkYErBXRAVXFBVpiiKLIi64uhRZK6JYWBQUsC/IIqCsi6uIimVf9Bxl/9j9vrPzx5zfmztz79yZuec8ACi+gUJRJqwAQIZIIg7z8WDGxMYx8d0ABkSAA9YAcHnZWUHh3hEAFT8vDjMbdZKxTKDP+nX/F7jF8g1hMj+b/n+lyMsSS9CdQtCQuXxBNg/lPJTTcyVZMvskyvTENBnDGBmL0QRRVpVx8hc2/+zzhd1kzM8Q8VEfWc5Z/Ay+jDtQ3pIjFaCMBKKcnyMU5KJ8G2X9dGmGEOU3KNMzBNxsADAUmV0i4KWgbIUyRRwRxkF5HgAESvIsTpzFEsEyNE8AOJlZy8XC5BQJ05hnwrR2dGQzfQW56QKJhBXC5aVxxXwmJzMjiytaDsCXO8uigJKstky0yPbWjvb2LBsLtPxf5V8Xv3r9O8h6+8XjZejnnkGMrm+2b7HfbJnVALCn0Nrs+GZLLAOgZRMAqve+2fQPACCfB0DzjVn3YcjmJUUiyXKytMzNzbUQCngWsoJ+lf/p8NXzn2HWeRay877WjukpSOJK0yVMWVF5memZUjEzO4vLEzBZfxtidOv/HDgrrVl5mIcJkgRigQg9KgqdMqEoGW23iC+UCDNFTKHonzr8H8Nm5SDDL3ONAq3mI6AvsQAKN+gA+b0LYGhkgMTvR1egr30LJEYB2cuL1h79Mvcoo+uf9d8UXIR+wtnCZKbMzAmLYPKk4hwZo29CprCABOQBHagBLaAHjAEL2AAH4AzcgBfwB8EgAsSCxYAHUkAGEINcsAqsB/mgEOwAe0A5qAI1oA40gBOgBZwGF8BlcB3cBH3gPhgEI+AZmASvwQwEQXiICtEgNUgbMoDMIBuIDc2HvKBAKAyKhRKgZEgESaFV0EaoECqGyqGDUB30I3QKugBdhXqgu9AQNA79Cb2DEZgC02FN2BC2hNmwOxwAR8CL4GR4KbwCzoO3w6VwNXwMboYvwNfhPngQfgZPIQAhIwxEB2EhbISDBCNxSBIiRtYgBUgJUo00IG1IJ3ILGUQmkLcYHIaGYWJYGGeMLyYSw8MsxazBbMOUY45gmjEdmFuYIcwk5iOWitXAmmGdsH7YGGwyNhebjy3B1mKbsJewfdgR7GscDsfAGeEccL64WFwqbiVuG24frhF3HteDG8ZN4fF4NbwZ3gUfjOfiJfh8fBn+GP4cvhc/gn9DIBO0CTYEb0IcQUTYQCghHCWcJfQSRgkzRAWiAdGJGEzkE5cTi4g1xDbiDeIIcYakSDIiuZAiSKmk9aRSUgPpEukB6SWZTNYlO5JDyULyOnIp+Tj5CnmI/JaiRDGlcCjxFCllO+Uw5TzlLuUllUo1pLpR46gS6nZqHfUi9RH1jRxNzkLOT44vt1auQq5ZrlfuuTxR3kDeXX6x/Ar5EvmT8jfkJxSICoYKHAWuwhqFCoVTCgMKU4o0RWvFYMUMxW2KRxWvKo4p4ZUMlbyU+Ep5SoeULioN0xCaHo1D49E20mpol2gjdBzdiO5HT6UX0n+gd9MnlZWUbZWjlJcpVyifUR5kIAxDhh8jnVHEOMHoZ7xT0VRxVxGobFVpUOlVmVado+qmKlAtUG1U7VN9p8ZU81JLU9up1qL2UB2jbqoeqp6rvl/9kvrEHPoc5zm8OQVzTsy5pwFrmGqEaazUOKTRpTGlqaXpo5mlWaZ5UXNCi6HlppWqtVvrrNa4Nk17vrZQe7f2Oe2nTGWmOzOdWcrsYE7qaOj46kh1Dup068zoGulG6m7QbdR9qEfSY+sl6e3Wa9eb1NfWD9JfpV+vf8+AaMA2SDHYa9BpMG1oZBhtuNmwxXDMSNXIz2iFUb3RA2OqsavxUuNq49smOBO2SZrJPpObprCpnWmKaYXpDTPYzN5MaLbPrMcca+5oLjKvNh9gUVjurBxWPWvIgmERaLHBosXiuaW+ZZzlTstOy49WdlbpVjVW962VrP2tN1i3Wf9pY2rDs6mwuT2XOtd77tq5rXNf2JrZCmz3296xo9kF2W22a7f7YO9gL7ZvsB930HdIcKh0GGDT2SHsbewrjlhHD8e1jqcd3zrZO0mcTjj94cxyTnM+6jw2z2ieYF7NvGEXXReuy0GXwfnM+QnzD8wfdNVx5bpWuz5203Pju9W6jbqbuKe6H3N/7mHlIfZo8pjmOHFWc857Ip4+ngWe3V5KXpFe5V6PvHW9k73rvSd97HxW+pz3xfoG+O70HfDT9OP51flN+jv4r/bvCKAEhAeUBzwONA0UB7YFwUH+QbuCHiwwWCBa0BIMgv2CdwU/DDEKWRrycyguNCS0IvRJmHXYqrDOcFr4kvCj4a8jPCKKIu5HGkdKI9uj5KPio+qipqM9o4ujB2MsY1bHXI9VjxXGtsbh46LiauOmFnot3LNwJN4uPj++f5HRomWLri5WX5y++MwS+SXcJScTsAnRCUcT3nODudXcqUS/xMrESR6Ht5f3jO/G380fF7gIigWjSS5JxUljyS7Ju5LHU1xTSlImhBxhufBFqm9qVep0WnDa4bRP6dHpjRmEjISMUyIlUZqoI1Mrc1lmT5ZZVn7W4FKnpXuWTooDxLXZUPai7FYJHf2Z6pIaSzdJh3Lm51TkvMmNyj25THGZaFnXctPlW5ePrvBe8f1KzEreyvZVOqvWrxpa7b764BpoTeKa9rV6a/PWjqzzWXdkPWl92vpfNlhtKN7wamP0xrY8zbx1ecObfDbV58vli/MHNjtvrtqC2SLc0r117tayrR8L+AXXCq0KSwrfb+Ntu/ad9Xel333anrS9u8i+aP8O3A7Rjv6drjuPFCsWryge3hW0q3k3c3fB7ld7luy5WmJbUrWXtFe6d7A0sLS1TL9sR9n78pTyvgqPisZKjcqtldP7+Pt697vtb6jSrCqsendAeODOQZ+DzdWG1SWHcIdyDj2piarp/J79fV2tem1h7YfDosODR8KOdNQ51NUd1ThaVA/XS+vHj8Ufu/mD5w+tDayGg42MxsLj4Lj0+NMfE37sPxFwov0k+2TDTwY/VTbRmgqaoeblzZMtKS2DrbGtPaf8T7W3Obc1/Wzx8+HTOqcrziifKTpLOpt39tO5Feemzmedn7iQfGG4fUn7/YsxF293hHZ0Xwq4dOWy9+WLne6d5664XDl91enqqWvsay3X7a83d9l1Nf1i90tTt3138w2HG603HW+29czrOdvr2nvhluety7f9bl/vW9DX0x/Zf2cgfmDwDv/O2N30uy/u5dybub/uAfZBwUOFhyWPNB5V/2rya+Og/eCZIc+hrsfhj+8P84af/Zb92/uRvCfUJyWj2qN1YzZjp8e9x28+Xfh05FnWs5mJ/N8Vf698bvz8pz/c/uiajJkceSF+8enPbS/VXh5+ZfuqfSpk6tHrjNcz0wVv1N4cect+2/ku+t3oTO57/PvSDyYf2j4GfHzwKePTp78AA5vz/OzO54oAAAAJcEhZcwAACxMAAAsTAQCanBgAAAKnSURBVDgRzVTPTxNBGH37g6WlTdmCNKJQTA/EAzF6aIyNCXKzMcazN27Em0dvEv0DPJiY+A+IJ403jdHgyRiUqohtRaTSSotlW0rbbffnOLONJLsVqTdfMpt937x5M998MwPt2V1SS16ZFwQBoiiC53kcBNYfiUQwNTWFRCKB6elpEEKcduvht/mzD9aIyPkbsKu7E6nI+OlTxdz7g8xYPBgMOmbxeBwjIyOwLMslf7O5AxGqAt+sOZu9Z51AETMuhYdIkgRZlhG6eH1ejvhuqrqNO8sKBI7DuiyBzy5BJFoNre0CVndUz/BuytKrVCpYkXjsCjxU1UTdsGHaQKpuQ9jI0BVaBngOCFEBQzQaRSwW63ajkcHBQQwPD4NNvdm2kVc0VDXqRqF9TwOtPWpIi9AfPo7LchH3B4aQTCadjXdUno/P50MgEECZppcnHAqgK/FAZJzzh2GMBi48mUwQ/9gxCEG/R9ahHC+A0EwWV5awejIOwyZdOpHWHMTS4BNCOFIsgxTS4Pr6uoQswPawZZpITZ5DZvwMDLZ5HjiGMHXYe3VYP03Y2589EjfVKM0PxFChxRjoXiAOPsVun57Z/28oknoRlWIOH+pHEdLbILT9DewMKsoWtPQyuKq+L9VLORC1Cu7F1Rh59FHBpzwH2+JAjNa+6E8/rK4b4VGUI1Hw9Or9BtFbMDUTYvl5e8avCwi3m6jprIaHo1+TYDbkjpBQU5Nm5WQmgmNPEbtq7Aawc/avWFhYcA3h5ubmcOnaeTI2RCcxm67OXohla9iqreHG49eLX2+/nRFLpRLqrSy22hKautKLh0tj2G28+pHGeqruxMVsNouVAjXK6yhvHv6EudwoMXWC9BdayFyjY5jJZPDy6QRW36mwm4ZX3xN33gits/+/AMFdJZghFwS8AAAAAElFTkSuQmCC",
PHOSPHORUS:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAeElEQVR42mNgGAU0A/8bGDYC8X8o/gLEV/43MqRSZmA9wwkgtgAalA/kXwSy//1vYtCnxIW74PxGBnewa+sZMqhjYD2DCtTAHOoY2MDQAjXQjBIDrwANKALS+4H4D5A9g9JY/gA1bC4Q+1Ej2eyidjocSQaOgoEDAIsaZcCSspZYAAAAAElFTkSuQmCC",PUSHER_DOUBLE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAA8klEQVR42mNgGACgA8QxQBwAxCKUGOQAxKeB+DwQzwfiw0D8HohzyDEM5JrXQBwBxCxI4hpQC7pJ9eJjIDbBIS8BxLeBOIFYA/cDcQUBNSZQS3mICbfbaN7EBZYDcQEhRYuJcB0MeEDDE6flPNBYVCDSQBYCYQ327mUSUwPI2ym4JEuAeDaRBskAsQpUz3SoK1WwhV8JkQaCguc/NOHfg7IxYhyUE1xI8O5zqEEwjAFuY3M2HpAJxP+ghu3FpgAUwwIkGAhS+xdqYC82Bf/JyPM3ofpiqGVgGVSfCbXKSgFsMXwfinHxCYF+dAFKDZRB5gAAj/I5E2fZy9MAAAAASUVORK5CYII\x3d",
PUSHER_SINGLE:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAA6ElEQVR42mNgGACgA8QxQBwAxCKUGOQAxKeB+DwQzwfiw0D8HohzyDEM5JrXQBwBxCxI4hpQC7pJ9eJjIDbBIS8BxLeBOIFYA/cDcQUBNSZQS3mICbfbaN7EBZYDcQEhRYuJcB0MeEDDE6flPNBYVCDSQBYCYQ327mUSUwPI2ym4JEuAeDaJBoL0TIeyZdB9txiqgBTgAU38O4H4P9RQOADlBBcSDVSAGvQPiO+gS4KSiwqJBgpADbyKLSzfQxWQCkAGfsFWcPwnsxAB6duOS4JcA1OoWV7+x1VO3odiUsFxXBLkGoiSdgEanzHP7ILArQAAAABJRU5ErkJggg\x3d\x3d",REDO:"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\x3d\x3d",
REMOVE_LONE_PAIR:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAN0lEQVR42mNgGAWjYHACBSDeD8T/gfg4lE+KPAYAKTaBsg2gmkiRxwD/KeTT3oVUD8NRMAoIAAADoBa5tWLP/wAAAABJRU5ErkJggg\x3d\x3d",REMOVE_RADICAL:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAM0lEQVR42mNgGAWjYGgABSDeD8T/gfg4lE8RABlmAmUbQA2lCPwnwB94F1I9DEfBKEADAAT6C11yCuPwAAAAAElFTkSuQmCC",RGROUP:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAA3UlEQVR42u3SPwsBcRzH8YtYFGVELBYGu0dgskgWSgyKJyB2k+wWZTPxCDwBLJikDJKShQlFeF/9Tte5u25U7luv4X736fO7Pz9Jsuf/ZosjzpigqpPpoqRZq+isfQpzcCCDO8KaTAsHuMV1FjN4zArlCeGJhCYTFBsVkcQaAbNXlguj6GNpkBtghY3Ohl+FF7wwh9cglxaZmpWfUkYKV8R1Mj4ssMPQSqHyDXuYwqm678JYPFkeD0SsFvrFEaqr7subdFTle7StFspTwA0xNDASR0qZJk5GR8aeH5k3G/QvyONoufAAAAAASUVORK5CYII\x3d",
SAVE:"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\x3d",
SEARCH:"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\x3d\x3d",
SULFUR:"iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAwUlEQVR42mNgGAXo4P9/Y7n///Wl//9nYKTQIAP///8NzwIN+w5k/wHir0BsQK6ruICa3wHxEiCbH8I3jPv/X1eJTAP1jICG/Qe6zoxK4WYmDDTwNxDXUzEyDOZBXGkw+/9/cz4qGMjACHIhEP8D4gdkRwgWl1oD8UNoLFtTKy2KAA17DcTzqRimhjuABh4jU7O+IdCAiP//VdihhpkADfsJpJvJdY0z0ICP0KTzDBoxi2EWUJiPDUxBYThaqtEPAAAQY5TwZ4cDHAAAAABJRU5ErkJggg\x3d\x3d",UNDO:"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\x3d",
ZOOM_IN:"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\x3d",
ZOOM_OUT:"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\x3d"}}();
(function(a,f,e){a.Button=function(a,c,d,e){this.id=a;this.icon=c;this.toggle=!1;this.tooltip=d?d:"";this.func=e?e:void 0};a=a.Button.prototype;a.getElement=function(){return e("#"+this.id)};a.getSource=function(a){var c=[];this.toggle?(c.push('\x3cinput type\x3d"radio" name\x3d"'),c.push(a),c.push('" id\x3d"'),c.push(this.id),c.push('" title\x3d"'),c.push(this.tooltip),c.push('" /\x3e\x3clabel for\x3d"'),c.push(this.id),c.push('"\x3e\x3cimg id\x3d"'),c.push(this.id),c.push('_icon" title\x3d"'),c.push(this.tooltip),
c.push('" width\x3d"20" height\x3d"20" src\x3d"'),c.push(f.getURI(this.icon)),c.push('"\x3e\x3c/label\x3e')):(c.push('\x3cbutton id\x3d"'),c.push(this.id),c.push('" onclick\x3d"return false;" title\x3d"'),c.push(this.tooltip),c.push('"\x3e\x3cimg title\x3d"'),c.push(this.tooltip),c.push('" width\x3d"20" height\x3d"20" src\x3d"'),c.push(f.getURI(this.icon)),c.push('"\x3e\x3c/button\x3e'));return c.join("")};a.setup=function(a){var c=this.getElement();(!this.toggle||a)&&c.button();c.click(this.func)};
a.disable=function(){var a=this.getElement();a.mouseout();a.button("disable")};a.enable=function(){this.getElement().button("enable")};a.select=function(){var a=this.getElement();a.attr("checked",!0);a.button("refresh")}})(ChemDoodle.sketcher.gui.desktop,ChemDoodle.sketcher.gui.imageDepot,jQuery);
(function(a,f){a.ButtonSet=function(a){this.id=a;this.buttons=[];this.toggle=!0};var e=a.ButtonSet.prototype;e.getElement=function(){return f("#"+this.id)};e.getSource=function(a){var c=[];c.push('\x3cspan id\x3d"');c.push(this.id);c.push('"\x3e');for(var d=0,e=this.buttons.length;d<e;d++)this.toggle&&(this.buttons[d].toggle=!0),c.push(this.buttons[d].getSource(a));this.dropDown&&c.push(this.dropDown.getButtonSource());c.push("\x3c/span\x3e");this.dropDown&&c.push(this.dropDown.getHiddenSource());
return c.join("")};e.setup=function(){this.getElement().buttonset();for(var a=0,c=this.buttons.length;a<c;a++)this.buttons[a].setup(!1);this.dropDown&&this.dropDown.setup()};e.addDropDown=function(b){this.dropDown=new a.DropDown(this.id+"_dd",b,this.buttons[this.buttons.length-1])}})(ChemDoodle.sketcher.gui.desktop,jQuery);
(function(a,f,e){a.Dialog=function(a,c,d){this.sketcherid=a;this.id=a+c;this.title=d?d:"Information"};a=a.Dialog.prototype;a.buttons=void 0;a.message=void 0;a.afterMessage=void 0;a.includeTextArea=!1;a.includeTextField=!1;a.getElement=function(){return f("#"+this.id)};a.getTextArea=function(){return f("#"+this.id+"_ta")};a.getTextField=function(){return f("#"+this.id+"_tf")};a.setup=function(){var a=[];a.push('\x3cdiv style\x3d"font-size:12px;" id\x3d"');a.push(this.id);a.push('" title\x3d"');a.push(this.title);
a.push('"\x3e');this.message&&(a.push("\x3cp\x3e"),a.push(this.message),a.push("\x3c/p\x3e"));this.includeTextField&&(a.push('\x3cinput type\x3d"text" style\x3d"font-family:\'Courier New\';" id\x3d"'),a.push(this.id),a.push('_tf"\x3e\x3c/input\x3e'));this.includeTextArea&&(a.push('\x3ctextarea style\x3d"font-family:\'Courier New\';" id\x3d"'),a.push(this.id),a.push('_ta" cols\x3d"55" rows\x3d"10"\x3e\x3c/textarea\x3e'));this.afterMessage&&(a.push("\x3cp\x3e"),a.push(this.afterMessage),a.push("\x3c/p\x3e"));
a.push("\x3c/div\x3e");e.getElementById(this.sketcherid)?f("#"+this.sketcherid).before(a.join("")):e.writeln(a.join(""));this.getElement().dialog({autoOpen:!1,width:435,buttons:this.buttons})}})(ChemDoodle.sketcher.gui.desktop,jQuery,document);
(function(a,f,e,b){f.MolGrabberDialog=function(a,b){this.sketcherid=a;this.id=a+b};a=f.MolGrabberDialog.prototype=new f.Dialog;a.title="MolGrabber";a.setup=function(){var a=[];a.push('\x3cdiv style\x3d"font-size:12px;text-align:center;" id\x3d"');a.push(this.id);a.push('" title\x3d"');a.push(this.title);a.push('"\x3e');this.message&&(a.push("\x3cp\x3e"),a.push(this.message),a.push("\x3c/p\x3e"));a.push('\x3ccanvas class\x3d"ChemDoodleWebComponent" id\x3d"');a.push(this.id);a.push('_mg"\x3e\x3c/canvas\x3e');
this.afterMessage&&(a.push("\x3cp\x3e"),a.push(this.afterMessage),a.push("\x3c/p\x3e"));a.push("\x3c/div\x3e");b.getElementById(this.sketcherid)?e("#"+this.sketcherid).before(a.join("")):b.writeln(a.join(""));this.canvas=new ChemDoodle.MolGrabberCanvas(this.id+"_mg",200,200);this.getElement().dialog({autoOpen:!1,width:250,buttons:this.buttons})}})(ChemDoodle,ChemDoodle.sketcher.gui.desktop,jQuery,document);
(function(a,f,e,b){f.PeriodicTableDialog=function(a,b){this.sketcherid=a;this.id=a+b};a=f.PeriodicTableDialog.prototype=new f.Dialog;a.title="Periodic Table";a.setup=function(){var a=[];a.push('\x3cdiv style\x3d"text-align:center;" id\x3d"');a.push(this.id);a.push('" title\x3d"');a.push(this.title);a.push('"\x3e');a.push('\x3ccanvas class\x3d"ChemDoodleWebComponents" id\x3d"');a.push(this.id);a.push('_pt"\x3e\x3c/canvas\x3e\x3c/div\x3e');b.getElementById(this.sketcherid)?e("#"+this.sketcherid).before(a.join("")):
b.writeln(a.join(""));this.canvas=new ChemDoodle.PeriodicTableCanvas(this.id+"_pt",20);this.getElement().dialog({autoOpen:!1,width:400,buttons:this.buttons})}})(ChemDoodle,ChemDoodle.sketcher.gui.desktop,jQuery,document);
(function(a,f,e,b){f.SaveFileDialog=function(a,b){this.id=a;this.sketcher=b};a=f.SaveFileDialog.prototype=new f.Dialog;a.title="Save File";a.clear=function(){e("#"+this.id+"_link").html("The file link will appear here.")};a.setup=function(){var a=[];a.push('\x3cdiv style\x3d"font-size:12px;" id\x3d"');a.push(this.id);a.push('" title\x3d"');a.push(this.title);a.push('"\x3e');a.push("\x3cp\x3eSelect the file format to save your structure to and click on the \x3cstrong\x3eGenerate File\x3c/strong\x3e button.\x3c/p\x3e");
a.push('\x3cselect id\x3d"');a.push(this.id);a.push('_select"\x3e');a.push('\x3coption value\x3d"sk2"\x3eACD/ChemSketch Document {sk2}');a.push('\x3coption value\x3d"ros"\x3eBeilstein ROSDAL {ros}');a.push('\x3coption value\x3d"cdx"\x3eCambridgesoft ChemDraw Exchange {cdx}');a.push('\x3coption value\x3d"cdxml"\x3eCambridgesoft ChemDraw XML {cdxml}');a.push('\x3coption value\x3d"mrv"\x3eChemAxon Marvin Document {mrv}');a.push('\x3coption value\x3d"cml"\x3eChemical Markup Language {cml}');a.push('\x3coption value\x3d"smiles"\x3eDaylight SMILES {smiles}');
a.push('\x3coption value\x3d"icl" selected\x3eiChemLabs ChemDoodle Document {icl}');a.push('\x3coption value\x3d"inchi"\x3eIUPAC InChI {inchi}');a.push('\x3coption value\x3d"jdx"\x3eIUPAC JCAMP-DX {jdx}');a.push('\x3coption value\x3d"skc"\x3eMDL ISIS Sketch {skc}');a.push('\x3coption value\x3d"tgf"\x3eMDL ISIS Sketch Transportable Graphics File {tgf}');a.push('\x3coption value\x3d"mol"\x3eMDL MOLFile {mol}');a.push('\x3coption value\x3d"sdf"\x3eMDL SDFile {sdf}');a.push('\x3coption value\x3d"jme"\x3eMolinspiration JME String {jme}');
a.push('\x3coption value\x3d"pdb"\x3eRCSB Protein Data Bank {pdb}');a.push('\x3coption value\x3d"mmd"\x3eSchr\x26ouml;dinger Macromodel {mmd}');a.push('\x3coption value\x3d"mae"\x3eSchr\x26ouml;dinger Maestro {mae}');a.push('\x3coption value\x3d"smd"\x3eStandard Molecular Data {smd}');a.push('\x3coption value\x3d"mol2"\x3eTripos Mol2 {mol2}');a.push('\x3coption value\x3d"sln"\x3eTripos SYBYL SLN {sln}');a.push('\x3coption value\x3d"xyz"\x3eXYZ {xyz}');a.push("\x3c/select\x3e");a.push('\x3cbutton id\x3d"');
a.push(this.id);a.push('_button"\x3e');a.push("Generate File\x3c/button\x3e");a.push("\x3cp\x3eWhen the file is written, a link will appear in the red-bordered box below, right-click on the link and choose the browser's \x3cstrong\x3eSave As...\x3c/strong\x3e function to save the file to your computer.\x3c/p\x3e");a.push('\x3cdiv style\x3d"width:100%;height:30px;border:1px solid #c10000;text-align:center;" id\x3d"');a.push(this.id);a.push('_link"\x3eThe file link will appear here.\x3c/div\x3e');a.push('\x3cp\x3e\x3ca href\x3d"http://www.chemdoodle.com" target\x3d"_blank"\x3eHow do I use these files?\x3c/a\x3e\x3c/p\x3e');
a.push("\x3c/div\x3e");b.getElementById(this.sketcher.id)?e("#"+this.sketcher.id).before(a.join("")):b.writeln(a.join(""));var d=this;e("#"+this.id+"_button").click(function(){e("#"+d.id+"_link").html("Generating file, please wait...");ChemDoodle.iChemLabs.saveFile(d.sketcher.oneMolecule?d.sketcher.molecules[0]:d.sketcher.lasso.getFirstMolecule(),{ext:e("#"+d.id+"_select").val()},function(a){e("#"+d.id+"_link").html('\x3ca href\x3d"'+a+'"\x3e\x3cspan style\x3d"text-decoration:underline;"\x3eFile is generated. Right-click on this link and Save As...\x3c/span\x3e\x3c/a\x3e')})});
this.getElement().dialog({autoOpen:!1,width:435,buttons:d.buttons})}})(ChemDoodle,ChemDoodle.sketcher.gui.desktop,jQuery,document);
(function(a,f,e,b,c){e.DialogManager=function(d){d.useServices?this.saveDialog=new b.SaveFileDialog(d.id+"_save_dialog",d):(this.saveDialog=new b.Dialog(d.id,"_save_dialog","Save Molecule"),this.saveDialog.message="Copy and paste the content of the textarea into a file and save it with the extension \x3cstrong\x3e.mol\x3c/strong\x3e.",this.saveDialog.includeTextArea=!0,this.saveDialog.afterMessage='\x3ca href\x3d"http://www.chemdoodle.com" target\x3d"_blank"\x3eHow do I use MOLFiles?\x3c/a\x3e');
this.saveDialog.setup();this.loadDialog=new b.Dialog(d.id,"_load_dialog","Load Molecule");this.loadDialog.message="Copy and paste the contents of a MOLFile (extension \x3cstrong\x3e.mol\x3c/strong\x3e) in the textarea below and then press the \x3cstrong\x3eLoad\x3c/strong\x3e button.";this.loadDialog.includeTextArea=!0;this.loadDialog.afterMessage='\x3ca href\x3d"http://www.chemdoodle.com" target\x3d"_blank"\x3eWhere do I get MOLFiles?\x3c/a\x3e';var e=this;this.loadDialog.buttons={Load:function(){c(this).dialog("close");
var b=a.readMOL(e.loadDialog.getTextArea().val());0<b.atoms.length?d.oneMolecule?d.historyManager.pushUndo(new f.SwitchMoleculeAction(d,b)):(d.historyManager.pushUndo(new f.NewMoleculeAction(d,b.atoms,b.bonds)),d.toolbarManager.buttonLasso.getElement().click(),d.lasso.select(b.atoms,[])):alert("No chemical content was recognized.")}};this.loadDialog.setup();this.searchDialog=new b.MolGrabberDialog(d.id,"_search_dialog");this.searchDialog.buttons={Load:function(){c(this).dialog("close");var a=e.searchDialog.canvas.molecules[0];
a&&0<a.atoms.length&&(d.oneMolecule?a!==d.molecule&&d.historyManager.pushUndo(new f.SwitchMoleculeAction(d,a)):(d.historyManager.pushUndo(new f.NewMoleculeAction(d,a.atoms,a.bonds)),d.toolbarManager.buttonLasso.getElement().click(),d.lasso.select(a.atoms,[])))}};this.searchDialog.setup();this.periodicTableDialog=new b.PeriodicTableDialog(d.id,"_periodicTable_dialog");this.periodicTableDialog.buttons={Close:function(){c(this).dialog("close")}};this.periodicTableDialog.setup();this.periodicTableDialog.canvas.click=
function(){if(this.hovered){this.selected=this.hovered;var a=this.getHoveredElement();d.stateManager.setState(d.stateManager.STATE_LABEL);d.stateManager.STATE_LABEL.label=a.symbol;d.toolbarManager.buttonLabel.select();this.repaint()}};this.calculateDialog=new b.Dialog(d.id,"_calculate_dialog","Calculations");this.calculateDialog.includeTextArea=!0;this.calculateDialog.afterMessage='\x3ca href\x3d"http://www.chemdoodle.com" target\x3d"_blank"\x3eWant more calculations?\x3c/a\x3e';this.calculateDialog.setup();
this.inputDialog=new b.Dialog(d.id,"_input_dialog","Input");this.inputDialog.message='Please input the rgroup number (must be a positive integer). Input "-1" to remove the rgroup.';this.inputDialog.includeTextField=!0;this.inputDialog.buttons={Done:function(){c(this).dialog("close");e.inputDialog.doneFunction&&e.inputDialog.doneFunction(e.inputDialog.getTextField().val())}};this.inputDialog.setup()}})(ChemDoodle,ChemDoodle.sketcher.actions,ChemDoodle.sketcher.gui,ChemDoodle.sketcher.gui.desktop,jQuery);
(function(a,f,e,b){a.DropDown=function(c,b,e){this.id=c;this.tooltip=b;this.dummy=e;this.buttonSet=new a.ButtonSet(c+"_set");this.buttonSet.buttonGroup=b;this.defaultButton=void 0};var c=a.DropDown.prototype;c.getButtonSource=function(){var a=[];a.push('\x3cbutton id\x3d"');a.push(this.id);a.push('" onclick\x3d"return false;" title\x3d"');a.push(this.tooltip);a.push('"\x3e\x3cimg title\x3d"');a.push(this.tooltip);a.push('" src\x3d"');a.push(f.getURI(f.ARROW_DOWN));a.push('"\x3e\x3c/button\x3e');return a.join("")};
c.getHiddenSource=function(){var a=[];a.push('\x3cdiv style\x3d"display:none;position:absolute;z-index:10;border:1px #C1C1C1 solid;background:#F5F5F5;padding:5px;border-bottom-left-radius:5px;-moz-border-radius-bottomleft:5px;border-bottom-right-radius:5px;-moz-border-radius-bottomright:5px;" id\x3d"');a.push(this.id);a.push('_hidden"\x3e');a.push(this.buttonSet.getSource(this.id+"_popup_set"));a.push("\x3c/div\x3e");return a.join("")};c.setup=function(){this.defaultButton||(this.defaultButton=this.buttonSet.buttons[0]);
var a="#"+this.id;e(a).button();e(a+"_hidden").hide();e(a).click(function(){var c=e(a+"_hidden");c.show().position({my:"center top",at:"center bottom",of:this,collision:"fit"});e(b).one("click",function(){c.hide()});return!1});this.buttonSet.setup();var c=this;e.each(this.buttonSet.buttons,function(a){c.buttonSet.buttons[a].getElement().click(function(){c.dummy.absorb(c.buttonSet.buttons[a]);c.dummy.select();c.dummy.func()})});c.dummy.absorb(this.defaultButton);this.defaultButton.select()}})(ChemDoodle.sketcher.gui.desktop,
ChemDoodle.sketcher.gui.imageDepot,jQuery,document);(function(a,f,e){a.DummyButton=function(a,c,d){this.id=a;this.icon=c;this.toggle=!1;this.tooltip=d?d:"";this.func=void 0};a=a.DummyButton.prototype=new a.Button;a.setup=function(){var a=this;this.getElement().click(function(){a.func()})};a.absorb=function(a){e("#"+this.id+"_icon").attr("src",f.getURI(a.icon));this.func=a.func}})(ChemDoodle.sketcher.gui.desktop,ChemDoodle.sketcher.gui.imageDepot,jQuery);
(function(a,f,e,b,c,d,j,g,m,h,k,p){d.ToolbarManager=function(i){this.sketcher=i;this.buttonOpen=new g.Button(i.id+"_button_open",j.OPEN,"Open",function(){i.dialogManager.loadDialog.getTextArea().val("");i.dialogManager.loadDialog.getElement().dialog("open")});this.buttonSave=new g.Button(i.id+"_button_save",j.SAVE,"Save",function(){i.useServices?i.dialogManager.saveDialog.clear():i.oneMolecule?i.dialogManager.saveDialog.getTextArea().val(a.writeMOL(i.molecules[0])):i.lasso.isActive()&&i.dialogManager.saveDialog.getTextArea().val(a.writeMOL(i.lasso.getFirstMolecule()));
i.dialogManager.saveDialog.getElement().dialog("open")});this.buttonSearch=new g.Button(i.id+"_button_search",j.SEARCH,"Search",function(){i.dialogManager.searchDialog.getElement().dialog("open")});this.buttonCalculate=new g.Button(i.id+"_button_calculate",j.CALCULATE,"Calculate",function(){var a=i.oneMolecule?i.molecules[0]:i.lasso.getFirstMolecule();a&&f.calculate(a,{descriptors:"mf mw miw deg_unsat hba hbd pol_miller cmr tpsa xlogp2".split(" ")},function(a){function c(a,i,h){b.push(a);b.push(": ");
for(a=a.length+2;30>a;a++)b.push(" ");b.push(i);b.push(" ");b.push(h);b.push("\n")}var b=[];c("Molecular Formula",a.mf,"");c("Molecular Mass",a.mw,"amu");c("Monoisotopic Mass",a.miw,"amu");c("Degree of Unsaturation",a.deg_unsat,"");c("Hydrogen Bond Acceptors",a.hba,"");c("Hydrogen Bond Donors",a.hbd,"");c("Molecular Polarizability",a.pol_miller,"????");c("Molar Refractivity",a.cmr,"cm??/mol");c("Polar Surface Area",a.tpsa,"????");c("logP",a.xlogp2,"");i.dialogManager.calculateDialog.getTextArea().val(b.join(""));
i.dialogManager.calculateDialog.getElement().dialog("open")})});this.buttonMove=new g.Button(i.id+"_button_move",j.MOVE,"Move",function(){i.stateManager.setState(i.stateManager.STATE_MOVE)});this.buttonMove.toggle=!0;this.buttonErase=new g.Button(i.id+"_button_erase",j.ERASE,"Erase",function(){i.stateManager.setState(i.stateManager.STATE_ERASE)});this.buttonErase.toggle=!0;this.buttonClear=new g.Button(i.id+"_button_clear",j.CLEAR,"Clear",function(){var a=!0;if(i.oneMolecule){if(1===i.molecules[0].atoms.length){var b=
i.molecules[0].atoms[0];"C"===b.label&&(0===b.charge&&-1===b.mass)&&(a=!1)}}else 0===i.molecules.length&&0===i.shapes.length&&(a=!1);a&&(i.stateManager.getCurrentState().clearHover(),i.lasso&&i.lasso.isActive()&&i.lasso.empty(),i.historyManager.pushUndo(new c.ClearAction(i)))});this.buttonClean=new g.Button(i.id+"_button_clean",j.OPTIMIZE,"Clean",function(){var a=i.oneMolecule?i.molecules[0]:i.lasso.getFirstMolecule();if(a){var h=new e.JSONInterpreter;f._contactServer("optimize",{mol:h.molTo(a)},
{dimension:2},function(d){d=h.molFrom(d.mol);var e=d.getCenter(),f=i.oneMolecule?new b.Point(i.width/2,i.height/2):a.getCenter();f.sub(e);for(var e=0,g=d.atoms.length;e<g;e++)d.atoms[e].add(f);i.historyManager.pushUndo(new c.ChangeCoordinatesAction(a.atoms,d.atoms))})}});this.makeLassoSet(this);this.makeScaleSet(this);this.makeHistorySet(this);this.makeLabelSet(this);this.makeBondSet(this);this.makeRingSet(this);this.makeAttributeSet(this);this.makeShapeSet(this)};d=d.ToolbarManager.prototype;d.write=
function(){var a=[],c=this.sketcher.id+"_main_group";this.sketcher.oneMolecule?a.push(this.buttonMove.getSource(c)):a.push(this.lassoSet.getSource(c));a.push(this.buttonClear.getSource());a.push(this.buttonErase.getSource(c));this.sketcher.useServices&&a.push(this.buttonClean.getSource());a.push(this.historySet.getSource());a.push(this.scaleSet.getSource());a.push(this.buttonOpen.getSource());a.push(this.buttonSave.getSource());this.sketcher.useServices&&(a.push(this.buttonSearch.getSource()),a.push(this.buttonCalculate.getSource()));
a.push("\x3cbr\x3e");a.push(this.labelSet.getSource(c));a.push(this.attributeSet.getSource(c));a.push(this.bondSet.getSource(c));a.push(this.ringSet.getSource(c));this.sketcher.oneMolecule||a.push(this.shapeSet.getSource(c));a.push("\x3cbr\x3e");p.getElementById(this.sketcher.id)?k("#"+this.sketcher.id).before(a.join("")):p.write(a.join(""))};d.setup=function(){this.sketcher.oneMolecule?this.buttonMove.setup(!0):this.lassoSet.setup();this.buttonClear.setup();this.buttonErase.setup(!0);this.sketcher.useServices&&
this.buttonClean.setup();this.historySet.setup();this.scaleSet.setup();this.buttonOpen.setup();this.buttonSave.setup();this.sketcher.useServices&&(this.buttonSearch.setup(),this.buttonCalculate.setup());this.labelSet.setup();this.attributeSet.setup();this.bondSet.setup();this.ringSet.setup();this.sketcher.oneMolecule||this.shapeSet.setup();this.buttonSingle.select();this.buttonUndo.disable();this.buttonRedo.disable();!this.sketcher.oneMolecule&&this.sketcher.useServices&&(this.buttonClean.disable(),
this.buttonCalculate.disable(),this.buttonSave.disable())};d.makeScaleSet=function(a){this.scaleSet=new g.ButtonSet(a.sketcher.id+"_buttons_scale");this.scaleSet.toggle=!1;this.buttonScalePlus=new g.Button(a.sketcher.id+"_button_scale_plus",j.ZOOM_IN,"Increase Scale",function(){a.sketcher.specs.scale*=1.5;a.sketcher.checkScale();a.sketcher.repaint()});this.scaleSet.buttons.push(this.buttonScalePlus);this.buttonScaleMinus=new g.Button(a.sketcher.id+"_button_scale_minus",j.ZOOM_OUT,"Decrease Scale",
function(){a.sketcher.specs.scale/=1.5;a.sketcher.checkScale();a.sketcher.repaint()});this.scaleSet.buttons.push(this.buttonScaleMinus)};d.makeLassoSet=function(a){this.lassoSet=new g.ButtonSet(a.sketcher.id+"_buttons_lasso");this.buttonLasso=new g.DummyButton(a.sketcher.id+"_button_lasso",j.LASSO,"Selection Tool");this.lassoSet.buttons.push(this.buttonLasso);this.lassoSet.addDropDown("More Selection Tools");this.lassoSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_lasso_lasso",
j.LASSO,"Lasso Tool",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_LASSO);a.sketcher.lasso.mode=m.Lasso.MODE_LASSO;0<a.sketcher.molecules.length&&!a.sketcher.lasso.isActive()&&a.sketcher.lasso.select(a.sketcher.molecules[a.sketcher.molecules.length-1].atoms,[])}));this.lassoSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_lasso_shapes",j.LASSO_SHAPES,"Lasso Tool (shapes only)",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_LASSO);
a.sketcher.lasso.mode=m.Lasso.MODE_LASSO_SHAPES;0<a.sketcher.shapes.length&&!a.sketcher.lasso.isActive()&&a.sketcher.lasso.select([],[a.sketcher.shapes[a.sketcher.shapes.length-1]])}));this.lassoSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_lasso_marquee",j.MARQUEE,"Marquee Tool",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_LASSO);a.sketcher.lasso.mode=m.Lasso.MODE_RECTANGLE_MARQUEE;0<a.sketcher.molecules.length&&!a.sketcher.lasso.isActive()&&
a.sketcher.lasso.select(a.sketcher.molecules[a.sketcher.molecules.length-1].atoms,[])}))};d.makeHistorySet=function(a){this.historySet=new g.ButtonSet(a.sketcher.id+"_buttons_history");this.historySet.toggle=!1;this.buttonUndo=new g.Button(a.sketcher.id+"_button_undo",j.UNDO,"Undo",function(){a.sketcher.historyManager.undo()});this.historySet.buttons.push(this.buttonUndo);this.buttonRedo=new g.Button(a.sketcher.id+"_button_redo",j.REDO,"Redo",function(){a.sketcher.historyManager.redo()});this.historySet.buttons.push(this.buttonRedo)};
d.makeLabelSet=function(a){this.labelSet=new g.ButtonSet(a.sketcher.id+"_buttons_label");this.buttonLabel=new g.DummyButton(a.sketcher.id+"_button_label",j.CARBON,"Set Label");this.labelSet.buttons.push(this.buttonLabel);this.labelSet.addDropDown("More Labels");this.labelSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_label_h",j.HYDROGEN,"Hydrogen",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_LABEL);a.sketcher.stateManager.STATE_LABEL.label="H"}));
this.labelSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_label_c",j.CARBON,"Carbon",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_LABEL);a.sketcher.stateManager.STATE_LABEL.label="C"}));this.labelSet.dropDown.defaultButton=this.labelSet.dropDown.buttonSet.buttons[this.labelSet.dropDown.buttonSet.buttons.length-1];this.labelSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_label_n",j.NITROGEN,"Nitrogen",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_LABEL);
a.sketcher.stateManager.STATE_LABEL.label="N"}));this.labelSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_label_o",j.OXYGEN,"Oxygen",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_LABEL);a.sketcher.stateManager.STATE_LABEL.label="O"}));this.labelSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_label_f",j.FLUORINE,"Fluorine",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_LABEL);a.sketcher.stateManager.STATE_LABEL.label=
"F"}));this.labelSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_label_cl",j.CHLORINE,"Chlorine",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_LABEL);a.sketcher.stateManager.STATE_LABEL.label="Cl"}));this.labelSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_label_br",j.BROMINE,"Bromine",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_LABEL);a.sketcher.stateManager.STATE_LABEL.label="Br"}));this.labelSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+
"_button_label_i",j.IODINE,"Iodine",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_LABEL);a.sketcher.stateManager.STATE_LABEL.label="I"}));this.labelSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_label_p",j.PHOSPHORUS,"Phosphorus",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_LABEL);a.sketcher.stateManager.STATE_LABEL.label="P"}));this.labelSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_label_s",
j.SULFUR,"Sulfur",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_LABEL);a.sketcher.stateManager.STATE_LABEL.label="S"}));this.labelSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_label_pt",j.PERIODIC_TABLE,"Choose Symbol",function(){for(var c=0,b=a.sketcher.dialogManager.periodicTableDialog.canvas.cells.length;c<b;c++){var h=a.sketcher.dialogManager.periodicTableDialog.canvas.cells[c];if(h.element.symbol===a.sketcher.stateManager.STATE_LABEL.label){a.sketcher.dialogManager.periodicTableDialog.canvas.selected=
h;a.sketcher.dialogManager.periodicTableDialog.canvas.repaint();break}}a.sketcher.dialogManager.periodicTableDialog.getElement().dialog("open")}))};d.makeBondSet=function(a){this.bondSet=new g.ButtonSet(a.sketcher.id+"_buttons_bond");this.buttonSingle=new g.Button(a.sketcher.id+"_button_bond_single",j.BOND_SINGLE,"Single Bond",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_BOND);a.sketcher.stateManager.STATE_NEW_BOND.bondOrder=1;a.sketcher.stateManager.STATE_NEW_BOND.stereo=
b.Bond.STEREO_NONE});this.bondSet.buttons.push(this.buttonSingle);this.buttonRecessed=new g.Button(a.sketcher.id+"_button_bond_recessed",j.BOND_RECESSED,"Recessed Bond",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_BOND);a.sketcher.stateManager.STATE_NEW_BOND.bondOrder=1;a.sketcher.stateManager.STATE_NEW_BOND.stereo=b.Bond.STEREO_RECESSED});this.bondSet.buttons.push(this.buttonRecessed);this.buttonProtruding=new g.Button(a.sketcher.id+"_button_bond_protruding",j.BOND_PROTRUDING,
"Protruding Bond",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_BOND);a.sketcher.stateManager.STATE_NEW_BOND.bondOrder=1;a.sketcher.stateManager.STATE_NEW_BOND.stereo=b.Bond.STEREO_PROTRUDING});this.bondSet.buttons.push(this.buttonProtruding);this.buttonDouble=new g.Button(a.sketcher.id+"_button_bond_double",j.BOND_DOUBLE,"Double Bond",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_BOND);a.sketcher.stateManager.STATE_NEW_BOND.bondOrder=
2;a.sketcher.stateManager.STATE_NEW_BOND.stereo=b.Bond.STEREO_NONE});this.bondSet.buttons.push(this.buttonDouble);this.buttonBond=new g.DummyButton(a.sketcher.id+"_button_bond",j.BOND_TRIPLE,"Other Bond");this.bondSet.buttons.push(this.buttonBond);this.bondSet.addDropDown("More Bonds");this.bondSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_bond_zero",j.BOND_ZERO,"Zero Bond (Ionic/Hydrogen)",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_BOND);
a.sketcher.stateManager.STATE_NEW_BOND.bondOrder=0;a.sketcher.stateManager.STATE_NEW_BOND.stereo=b.Bond.STEREO_NONE}));this.bondSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_bond_half",j.BOND_HALF,"Half Bond",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_BOND);a.sketcher.stateManager.STATE_NEW_BOND.bondOrder=0.5;a.sketcher.stateManager.STATE_NEW_BOND.stereo=b.Bond.STEREO_NONE}));this.bondSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+
"_button_bond_resonance",j.BOND_RESONANCE,"Resonance Bond",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_BOND);a.sketcher.stateManager.STATE_NEW_BOND.bondOrder=1.5;a.sketcher.stateManager.STATE_NEW_BOND.stereo=b.Bond.STEREO_NONE}));this.bondSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_bond_ambiguous_double",j.BOND_DOUBLE_AMBIGUOUS,"Ambiguous Double Bond",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_BOND);a.sketcher.stateManager.STATE_NEW_BOND.bondOrder=
2;a.sketcher.stateManager.STATE_NEW_BOND.stereo=b.Bond.STEREO_AMBIGUOUS}));this.bondSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_bond_triple",j.BOND_TRIPLE,"Triple Bond",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_BOND);a.sketcher.stateManager.STATE_NEW_BOND.bondOrder=3;a.sketcher.stateManager.STATE_NEW_BOND.stereo=b.Bond.STEREO_NONE}));this.bondSet.dropDown.defaultButton=this.bondSet.dropDown.buttonSet.buttons[this.bondSet.dropDown.buttonSet.buttons.length-
1]};d.makeRingSet=function(a){this.ringSet=new g.ButtonSet(a.sketcher.id+"_buttons_ring");this.buttonCyclohexane=new g.Button(a.sketcher.id+"_button_ring_cyclohexane",j.CYCLOHEXANE,"Cyclohexane Ring",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_RING);a.sketcher.stateManager.STATE_NEW_RING.numSides=6;a.sketcher.stateManager.STATE_NEW_RING.unsaturated=!1});this.ringSet.buttons.push(this.buttonCyclohexane);this.buttonBenzene=new g.Button(a.sketcher.id+"_button_ring_benzene",
j.BENZENE,"Benzene Ring",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_RING);a.sketcher.stateManager.STATE_NEW_RING.numSides=6;a.sketcher.stateManager.STATE_NEW_RING.unsaturated=!0});this.ringSet.buttons.push(this.buttonBenzene);this.buttonRing=new g.DummyButton(a.sketcher.id+"_button_ring",j.CYCLOPENTANE,"Other Ring");this.ringSet.buttons.push(this.buttonRing);this.ringSet.addDropDown("More Rings");this.ringSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+
"_button_ring_cyclopropane",j.CYCLOPROPANE,"Cyclopropane Ring",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_RING);a.sketcher.stateManager.STATE_NEW_RING.numSides=3;a.sketcher.stateManager.STATE_NEW_RING.unsaturated=!1}));this.ringSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_ring_cyclobutane",j.CYCLOBUTANE,"Cyclobutane Ring",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_RING);a.sketcher.stateManager.STATE_NEW_RING.numSides=
4;a.sketcher.stateManager.STATE_NEW_RING.unsaturated=!1}));this.ringSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_ring_cyclopentane",j.CYCLOPENTANE,"Cyclopentane Ring",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_RING);a.sketcher.stateManager.STATE_NEW_RING.numSides=5;a.sketcher.stateManager.STATE_NEW_RING.unsaturated=!1}));this.ringSet.dropDown.defaultButton=this.ringSet.dropDown.buttonSet.buttons[this.ringSet.dropDown.buttonSet.buttons.length-
1];this.ringSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_ring_cycloheptane",j.CYCLOHEPTANE,"Cycloheptane Ring",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_RING);a.sketcher.stateManager.STATE_NEW_RING.numSides=7;a.sketcher.stateManager.STATE_NEW_RING.unsaturated=!1}));this.ringSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_ring_cyclooctane",j.CYCLOOCTANE,"Cyclooctane Ring",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_NEW_RING);
a.sketcher.stateManager.STATE_NEW_RING.numSides=8;a.sketcher.stateManager.STATE_NEW_RING.unsaturated=!1}))};d.makeAttributeSet=function(a){this.attributeSet=new g.ButtonSet(a.sketcher.id+"_buttons_attribute");this.buttonAttribute=new g.DummyButton(a.sketcher.id+"_button_attribute",j.INCREASE_CHARGE,"Attributes");this.attributeSet.buttons.push(this.buttonAttribute);this.attributeSet.addDropDown("More Attributes");this.attributeSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_attribute_charge_increment",
j.INCREASE_CHARGE,"Increase Charge",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_CHARGE);a.sketcher.stateManager.STATE_CHARGE.delta=1}));this.attributeSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_attribute_charge_decrement",j.DECREASE_CHARGE,"Decrease Charge",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_CHARGE);a.sketcher.stateManager.STATE_CHARGE.delta=-1}));this.attributeSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+
"_button_attribute_lonePair_increment",j.ADD_LONE_PAIR,"Add Lone Pair",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_LONE_PAIR);a.sketcher.stateManager.STATE_LONE_PAIR.delta=1}));this.attributeSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_attribute_lonePair_decrement",j.REMOVE_LONE_PAIR,"Remove Lone Pair",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_LONE_PAIR);a.sketcher.stateManager.STATE_LONE_PAIR.delta=-1}));this.attributeSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+
"_button_attribute_radical_increment",j.ADD_RADICAL,"Add Radical",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_RADICAL);a.sketcher.stateManager.STATE_RADICAL.delta=1}));this.attributeSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_attribute_radical_decrement",j.REMOVE_RADICAL,"Remove Radical",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_RADICAL);a.sketcher.stateManager.STATE_RADICAL.delta=-1}));this.attributeSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+
"_button_label_any",j.ANY_ELEMENT,"Any Element",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_ATOM_QUERY);a.sketcher.stateManager.STATE_ATOM_QUERY.mode=h.AtomQueryState.MODE_ANY}));this.attributeSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_label_rgroup",j.RGROUP,"Rgroup",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_ATOM_QUERY);a.sketcher.stateManager.STATE_ATOM_QUERY.mode=h.AtomQueryState.MODE_RGROUP}))};d.makeShapeSet=
function(a){this.shapeSet=new g.ButtonSet(a.sketcher.id+"_buttons_shape");this.buttonShape=new g.DummyButton(a.sketcher.id+"_button_shape",j.ARROW_SYNTHETIC,"Add Shape");this.shapeSet.buttons.push(this.buttonShape);this.shapeSet.addDropDown("More Shapes");this.shapeSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_shape_arrow_synthetic",j.ARROW_SYNTHETIC,"Synthetic Arrow",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_SHAPE);a.sketcher.stateManager.STATE_SHAPE.shapeType=
h.ShapeState.ARROW_SYNTHETIC}));this.shapeSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_shape_arrow_retrosynthetic",j.ARROW_RETROSYNTHETIC,"Retrosynthetic Arrow",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_SHAPE);a.sketcher.stateManager.STATE_SHAPE.shapeType=h.ShapeState.ARROW_RETROSYNTHETIC}));this.shapeSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_shape_arrow_resonance",j.ARROW_RESONANCE,"Resonance Arrow",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_SHAPE);
a.sketcher.stateManager.STATE_SHAPE.shapeType=h.ShapeState.ARROW_RESONANCE}));this.shapeSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_shape_arrow_equilibrium",j.ARROW_EQUILIBRIUM,"Equilibrium Arrow",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_SHAPE);a.sketcher.stateManager.STATE_SHAPE.shapeType=h.ShapeState.ARROW_EQUILIBRIUM}));this.shapeSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_shape_pusher_1",j.PUSHER_SINGLE,"Single Electron Pusher",
function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_PUSHER);a.sketcher.stateManager.STATE_PUSHER.numElectron=1}));this.shapeSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_shape_pusher_2",j.PUSHER_DOUBLE,"Electron Pair Pusher",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_PUSHER);a.sketcher.stateManager.STATE_PUSHER.numElectron=2}));this.shapeSet.dropDown.buttonSet.buttons.push(new g.Button(a.sketcher.id+"_button_shape_charge_bracket",
j.CHARGE_BRACKET,"Bracket",function(){a.sketcher.stateManager.setState(a.sketcher.stateManager.STATE_SHAPE);a.sketcher.stateManager.STATE_SHAPE.shapeType=h.ShapeState.BRACKET;a.sketcher.repaint()}))}})(ChemDoodle,ChemDoodle.iChemLabs,ChemDoodle.io,ChemDoodle.structures,ChemDoodle.sketcher.actions,ChemDoodle.sketcher.gui,ChemDoodle.sketcher.gui.imageDepot,ChemDoodle.sketcher.gui.desktop,ChemDoodle.sketcher.tools,ChemDoodle.sketcher.states,jQuery,document);
(function(a,f,e){e.Lasso=function(a){this.sketcher=a;this.atoms=[];this.shapes=[];this.bounds=void 0;this.mode=e.Lasso.MODE_LASSO;this.points=[]};e.Lasso.MODE_LASSO="lasso";e.Lasso.MODE_LASSO_SHAPES="shapes";e.Lasso.MODE_RECTANGLE_MARQUEE="rectangle";var b=e.Lasso.prototype;b.select=function(c,b){if(!this.block){f.SHIFT||this.empty();if(c)this.atoms=c.slice(0),this.shapes=b.slice(0);else{if(this.mode!==e.Lasso.MODE_LASSO_SHAPES){for(var j=[],g=0,m=this.sketcher.molecules.length;g<m;g++)for(var h=
this.sketcher.molecules[g],k=0,p=h.atoms.length;k<p;k++){var i=h.atoms[k];this.mode===e.Lasso.MODE_RECTANGLE_MARQUEE?2===this.points.length&&a.isBetween(i.x,this.points[0].x,this.points[1].x)&&a.isBetween(i.y,this.points[0].y,this.points[1].y)&&j.push(i):1<this.points.length&&a.isPointInPoly(this.points,i)&&j.push(i)}if(0===this.atoms.length)this.atoms=j;else{for(var l=[],g=0,m=this.atoms.length;g<m;g++)i=this.atoms[g],-1===j.indexOf(i)?l.push(i):i.isLassoed=!1;g=0;for(m=j.length;g<m;g++)-1===this.atoms.indexOf(j[g])&&
l.push(j[g]);this.atoms=l}}j=[];g=0;for(m=this.sketcher.shapes.length;g<m;g++){for(var h=this.sketcher.shapes[g],i=h.getPoints(),n=0<i.length,k=0,p=i.length;k<p;k++){var o=i[k];if(this.mode===e.Lasso.MODE_RECTANGLE_MARQUEE)if(2===this.points.length){if(!a.isBetween(o.x,this.points[0].x,this.points[1].x)||!a.isBetween(o.y,this.points[0].y,this.points[1].y)){n=!1;break}}else{n=!1;break}else if(1<this.points.length){if(!a.isPointInPoly(this.points,o)){n=!1;break}}else{n=!1;break}}n&&j.push(h)}if(0===
this.shapes.length)this.shapes=j;else{k=[];g=0;for(m=this.shapes.length;g<m;g++)h=this.shapes[g],-1===j.indexOf(h)?l.push(h):h.isLassoed=!1;g=0;for(m=j.length;g<m;g++)-1===this.shapes.indexOf(j[g])&&k.push(j[g]);this.shapes=k}}g=0;for(m=this.atoms.length;g<m;g++)this.atoms[g].isLassoed=!0;g=0;for(m=this.shapes.length;g<m;g++)this.shapes[g].isLassoed=!0;this.setBounds();this.bounds&&Infinity===this.bounds.minX&&this.empty();this.points=[];this.sketcher.stateManager.getCurrentState().clearHover();this.enableButtons();
this.sketcher.repaint()}};b.enableButtons=function(){this.sketcher.useServices&&(0<this.atoms.length?(this.sketcher.toolbarManager.buttonClean.enable(),this.sketcher.toolbarManager.buttonCalculate.enable(),this.sketcher.toolbarManager.buttonSave.enable()):(this.sketcher.toolbarManager.buttonClean.disable(),this.sketcher.toolbarManager.buttonCalculate.disable(),this.sketcher.toolbarManager.buttonSave.disable()))};b.setBounds=function(){if(this.isActive()){this.sketcher.repaint();this.bounds=new a.Bounds;
for(var c=0,b=this.atoms.length;c<b;c++)this.bounds.expand(this.atoms[c].getBounds());c=0;for(b=this.shapes.length;c<b;c++)this.bounds.expand(this.shapes[c].getBounds());this.bounds.minX-=5;this.bounds.minY-=5;this.bounds.maxX+=5;this.bounds.maxY+=5}else this.bounds=void 0};b.empty=function(){for(var a=0,b=this.atoms.length;a<b;a++)this.atoms[a].isLassoed=!1;a=0;for(b=this.shapes.length;a<b;a++)this.shapes[a].isLassoed=!1;this.atoms=[];this.shapes=[];this.bounds=void 0;this.enableButtons();this.sketcher.repaint()};
b.draw=function(a,b){a.strokeStyle="blue";a.lineWidth=0.5/b.scale;if(0<this.points.length)if(this.mode===e.Lasso.MODE_RECTANGLE_MARQUEE){if(2===this.points.length){var f=this.points[0],g=this.points[1];a.beginPath();a.rect(f.x,f.y,g.x-f.x,g.y-f.y);a.stroke()}}else if(1<this.points.length){a.beginPath();a.moveTo(this.points[0].x,this.points[0].y);f=1;for(g=this.points.length;f<g;f++)a.lineTo(this.points[f].x,this.points[f].y);a.closePath();a.stroke()}this.bounds&&(a.beginPath(),a.rect(this.bounds.minX,
this.bounds.minY,this.bounds.maxX-this.bounds.minX,this.bounds.maxY-this.bounds.minY),a.stroke())};b.isActive=function(){return 0<this.atoms.length||0<this.shapes.length};b.getFirstMolecule=function(){if(0<this.atoms.length)return this.sketcher.getMoleculeByAtom(this.atoms[0])};b.getAllPoints=function(){for(var a=this.atoms,b=0,e=this.shapes.length;b<e;b++)a=a.concat(this.shapes[b].getPoints());return a};b.addPoint=function(a){if(this.mode===e.Lasso.MODE_RECTANGLE_MARQUEE)if(2>this.points.length)this.points.push(a);
else{var b=this.points[1];b.x=a.x;b.y=a.y}else this.points.push(a)}})(ChemDoodle.math,ChemDoodle.monitor,ChemDoodle.sketcher.tools);
(function(a,f,e,b,c,d,j,g,m){a.SketcherCanvas=function(a,f,g,i){this.isMobile=void 0===i.isMobile?e.supports_touch():i.isMobile;this.useServices=void 0===i.useServices?!1:i.useServices;this.oneMolecule=void 0===i.oneMolecule?!1:i.oneMolecule;this.includeToolbar=void 0===i.includeToolbar?!0:i.includeToolbar;this.id=a;this.toolbarManager=new b.gui.ToolbarManager(this);if(this.includeToolbar){this.toolbarManager.write();var l=this;document.getElementById(this.id)?j("#"+a+"_button_attribute_lonePair_decrement_icon").load(function(){l.toolbarManager.setup()}):
j(m).load(function(){l.toolbarManager.setup()});this.dialogManager=new b.gui.DialogManager(this)}this.stateManager=new b.states.StateManager(this);this.historyManager=new b.actions.HistoryManager(this);a&&this.create(a,f,g);this.specs.atoms_circleDiameter_2D=7;this.specs.atoms_circleBorderWidth_2D=0;this.isHelp=!1;this.helpPos=new c.Point(this.width-20,20);this.lastPinchScale=1;this.lastGestureRotate=0;this.inGesture=!1;this.oneMolecule?(a=new c.Molecule,a.atoms.push(new c.Atom),this.loadMolecule(a)):
(this.startAtom=new c.Atom("C",-10,-10),this.startAtom.isLone=!0,this.lasso=new d.Lasso(this))};a=a.SketcherCanvas.prototype=new a._Canvas;a.drawSketcherDecorations=function(a){a.save();a.translate(this.width/2,this.height/2);a.rotate(this.specs.rotateAngle);a.scale(this.specs.scale,this.specs.scale);a.translate(-this.width/2,-this.height/2);this.hovering&&this.hovering.drawDecorations(a,this.specs);this.startAtom&&(-10!=this.startAtom.x&&!this.isMobile)&&this.startAtom.draw(a,this.specs);this.tempAtom&&
(a.strokeStyle="#00FF00",a.fillStyle="#00FF00",a.lineWidth=1,a.beginPath(),a.moveTo(this.hovering.x,this.hovering.y),f.contextHashTo(a,this.hovering.x,this.hovering.y,this.tempAtom.x,this.tempAtom.y,2,2),a.stroke(),a.beginPath(),a.arc(this.tempAtom.x,this.tempAtom.y,3,0,2*g.PI,!1),a.fill(),this.tempAtom.isOverlap&&(a.strokeStyle="#C10000",a.lineWidth=1.2,a.beginPath(),a.arc(this.tempAtom.x,this.tempAtom.y,7,0,2*g.PI,!1),a.stroke()));if(this.tempRing){a.strokeStyle="#00FF00";a.fillStyle="#00FF00";
a.lineWidth=1;a.beginPath();if(this.hovering instanceof c.Atom){a.moveTo(this.hovering.x,this.hovering.y);f.contextHashTo(a,this.hovering.x,this.hovering.y,this.tempRing[0].x,this.tempRing[0].y,2,2);for(var b=1,d=this.tempRing.length;b<d;b++)f.contextHashTo(a,this.tempRing[b-1].x,this.tempRing[b-1].y,this.tempRing[b].x,this.tempRing[b].y,2,2);f.contextHashTo(a,this.tempRing[this.tempRing.length-1].x,this.tempRing[this.tempRing.length-1].y,this.hovering.x,this.hovering.y,2,2)}else if(this.hovering instanceof
c.Bond){var b=this.hovering.a2,e=this.hovering.a1;this.tempRing[0]===this.hovering.a1&&(b=this.hovering.a1,e=this.hovering.a2);a.moveTo(b.x,b.y);f.contextHashTo(a,b.x,b.y,this.tempRing[1].x,this.tempRing[1].y,2,2);b=2;for(d=this.tempRing.length;b<d;b++)f.contextHashTo(a,this.tempRing[b-1].x,this.tempRing[b-1].y,this.tempRing[b].x,this.tempRing[b].y,2,2);f.contextHashTo(a,this.tempRing[this.tempRing.length-1].x,this.tempRing[this.tempRing.length-1].y,e.x,e.y,2,2)}a.stroke()}this.lasso&&this.lasso.draw(a,
this.specs);this.stateManager.getCurrentState().draw&&this.stateManager.getCurrentState().draw(a);a.restore()};a.drawChildExtras=function(a){this.drawSketcherDecorations(a);if(!this.hideHelp){var b=a.createRadialGradient(this.width-20,20,10,this.width-20,20,2);b.addColorStop(0,"#00680F");b.addColorStop(1,"#FFFFFF");a.fillStyle=b;a.beginPath();a.arc(this.helpPos.x,this.helpPos.y,10,0,2*g.PI,!1);a.fill();this.isHelp&&(a.lineWidth=2,a.strokeStyle="black",a.stroke());a.fillStyle=this.isHelp?"red":"black";
a.textAlign="center";a.textBaseline="middle";a.font="14px sans-serif";a.fillText("?",this.helpPos.x,this.helpPos.y)}this.paidToHideTrademark||(b=a.measureText("ChemDoodle").width,a.textAlign="left",a.textBaseline="bottom",a.font="14px sans-serif",a.fillStyle="rgba(0, 60, 0, 0.5)",a.fillText("ChemDoodle",this.width-b-13,this.height-4),a.font="8px sans-serif",a.fillText("\u00ae",this.width-13,this.height-12))};a.scaleEvent=function(a){a.op=new c.Point(a.p.x,a.p.y);1!==this.specs.scale&&(a.p.x=this.width/
2+(a.p.x-this.width/2)/this.specs.scale,a.p.y=this.height/2+(a.p.y-this.height/2)/this.specs.scale)};a.checkScale=function(){0.5>this.specs.scale?this.specs.scale=0.5:10<this.specs.scale&&(this.specs.scale=10)};a.click=function(a){this.scaleEvent(a);this.stateManager.getCurrentState().click(a)};a.rightclick=function(a){this.scaleEvent(a);this.stateManager.getCurrentState().rightclick(a)};a.dblclick=function(a){this.scaleEvent(a);this.stateManager.getCurrentState().dblclick(a)};a.mousedown=function(a){this.scaleEvent(a);
this.stateManager.getCurrentState().mousedown(a)};a.rightmousedown=function(a){this.scaleEvent(a);this.stateManager.getCurrentState().rightmousedown(a)};a.mousemove=function(a){this.isHelp=!1;10>a.p.distance(this.helpPos)&&(this.isHelp=!0);this.scaleEvent(a);this.stateManager.getCurrentState().mousemove(a)};a.mouseout=function(a){this.scaleEvent(a);this.stateManager.getCurrentState().mouseout(a)};a.mouseover=function(a){this.scaleEvent(a);this.stateManager.getCurrentState().mouseover(a)};a.mouseup=
function(a){this.scaleEvent(a);this.stateManager.getCurrentState().mouseup(a)};a.rightmouseup=function(a){this.scaleEvent(a);this.stateManager.getCurrentState().rightmouseup(a)};a.mousewheel=function(a,b){this.scaleEvent(a);this.stateManager.getCurrentState().mousewheel(a,b)};a.drag=function(a){this.scaleEvent(a);this.stateManager.getCurrentState().drag(a)};a.keydown=function(a){this.scaleEvent(a);this.stateManager.getCurrentState().keydown(a)};a.keypress=function(a){this.scaleEvent(a);this.stateManager.getCurrentState().keypress(a)};
a.keyup=function(a){this.scaleEvent(a);this.stateManager.getCurrentState().keyup(a)};a.touchstart=function(a){if(a.originalEvent.touches&&1<a.originalEvent.touches.length){if(this.tempAtom||this.tempRing)this.hovering=this.tempRing=this.tempAtom=void 0,this.repaint();this.lastPoint=void 0}else this.scaleEvent(a),this.stateManager.getCurrentState().mousemove(a),this.stateManager.getCurrentState().mousedown(a)};a.touchmove=function(a){this.scaleEvent(a);this.inGesture||this.stateManager.getCurrentState().drag(a)};
a.touchend=function(a){this.scaleEvent(a);this.stateManager.getCurrentState().mouseup(a);this.hovering&&(this.stateManager.getCurrentState().clearHover(),this.repaint())};a.gesturechange=function(a){this.inGesture=!0;if(1!==a.originalEvent.scale-this.lastPinchScale){if(!this.lasso||!this.lasso.isActive())this.specs.scale*=a.originalEvent.scale/this.lastPinchScale,this.checkScale();this.lastPinchScale=a.originalEvent.scale}if(0!==this.lastGestureRotate-a.originalEvent.rotation){var d=(this.lastGestureRotate-
a.originalEvent.rotation)/180*g.PI;if(this.parentAction){this.parentAction.dif+=d;for(var e=0,f=this.parentAction.ps.length;e<f;e++){var j=this.parentAction.ps[e],m=this.parentAction.center.distance(j),o=this.parentAction.center.angle(j)+d;j.x=this.parentAction.center.x+m*g.cos(o);j.y=this.parentAction.center.y-m*g.sin(o)}e=0;for(f=this.molecules.length;e<f;e++)this.molecules[e].check();this.lasso&&this.lasso.isActive()&&this.lasso.setBounds()}else e=this.lasso&&this.lasso.isActive()?this.lasso.getAllPoints():
this.getAllPoints(),f=this.lasso&&this.lasso.isActive()?new c.Point((this.lasso.bounds.minX+this.lasso.bounds.maxX)/2,(this.lasso.bounds.minY+this.lasso.bounds.maxY)/2):new c.Point(this.width/2,this.height/2),this.parentAction=new b.actions.RotateAction(e,d,f),this.historyManager.pushUndo(this.parentAction);this.lastGestureRotate=a.originalEvent.rotation}this.repaint()};a.gestureend=function(){this.inGesture=!1;this.lastPinchScale=1;this.lastGestureRotate=0;this.parentAction=void 0}})(ChemDoodle,
ChemDoodle.extensions,ChemDoodle.featureDetection,ChemDoodle.sketcher,ChemDoodle.structures,ChemDoodle.sketcher.tools,jQuery,Math,window);