/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.utils.converters;

import java.util.Locale;
import nc.ird.cantharella.utils.NumberTools;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.AbstractDecimalConverter;

public final class DoubleConverterImpl
extends AbstractDecimalConverter<Double> {
    public static final int DECIMAL_MIN_FRACTION_DIGIT = 0;
    public static final IConverter<Double> INSTANCE = new DoubleConverterImpl();

    public Double convertToObject(String value, Locale locale) {
        if (value == null || value.trim().equals("")) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            return NumberTools.parseDouble((String)value, (Locale)locale, (int)3);
        }
        catch (Exception e) {
            throw new ConversionException((Throwable)e);
        }
    }

    public String convertToString(Double value, Locale locale) {
        try {
            return NumberTools.doubleToString((Double)value, (Locale)locale, (int)0, (int)3);
        }
        catch (Exception e) {
            throw new ConversionException((Throwable)e);
        }
    }

    protected Class<Double> getTargetType() {
        return Double.class;
    }
}

