/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.utilisateur;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.CampagnePersonneDroits;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.LotPersonneDroits;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.CampagneService;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.utils.BeanTools;
import nc.ird.cantharella.utils.CollectionTools;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.document.panel.ManageListDocumentsPanel;
import nc.ird.cantharella.web.pages.domain.personne.panels.ManagePersonnePanel;
import nc.ird.cantharella.web.pages.model.ManageUtilisateurModel;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.renderers.EnumChoiceRenderer;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthRoles(value={AuthRole.ADMIN})
public final class ManageUtilisateurPage
extends TemplatePage {
    private static final String ACTION_DELETE = "Delete";
    private static final String ACTION_REJECT = "Reject";
    private static final String ACTION_UPDATE = "Update";
    private static final String ACTION_VALID = "Valid";
    private static final Logger LOG = LoggerFactory.getLogger(ManageUtilisateurPage.class);
    private final Button addAuthorization;
    private final AbstractSingleSelectChoice<Campagne> availableCampagnes;
    private final AbstractSingleSelectChoice<Lot> availableLots;
    private final IModel<CampagnePersonneDroits> campagnePersonneDroitsModel;
    private final List<Campagne> campagnes;
    @SpringBean
    private CampagneService campagneService;
    @SpringBean
    private LotService lotService;
    private final IModel<LotPersonneDroits> lotsPersonneDroitsModel;
    private final IModel<ManageUtilisateurModel> manageUtilisateurModel;
    @SpringBean
    private PersonneService personneService;
    private final IModel<Utilisateur> utilisateurModel;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;

    public ManageUtilisateurPage(Integer idPersonne, CallerPage callerPage) {
        super(ManageUtilisateurPage.class);
        CallerPage currentPage = new CallerPage((TemplatePage)this);
        try {
            this.utilisateurModel = new Model((Serializable)this.personneService.loadUtilisateur(idPersonne));
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        this.manageUtilisateurModel = new Model((Serializable)new ManageUtilisateurModel());
        ((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).setCampagnesDroits(((Utilisateur)this.utilisateurModel.getObject()).getCampagnesDroits());
        ((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getCampagnes().addAll(((Utilisateur)this.utilisateurModel.getObject()).getCampagnesDroits().keySet());
        ((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).setLotsDroits(((Utilisateur)this.utilisateurModel.getObject()).getLotsDroits());
        ((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getLots().addAll(((Utilisateur)this.utilisateurModel.getObject()).getLotsDroits().keySet());
        this.campagnePersonneDroitsModel = new Model((Serializable)new CampagnePersonneDroits());
        ((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getId().setPk2((AbstractModel)this.utilisateurModel.getObject());
        ((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getDroits().setDroitExtrait(Boolean.TRUE);
        ((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getDroits().setDroitPuri(Boolean.TRUE);
        ((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getDroits().setDroitRecolte(Boolean.TRUE);
        ((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getDroits().setDroitTestBio(Boolean.TRUE);
        this.lotsPersonneDroitsModel = new Model((Serializable)new LotPersonneDroits());
        ((LotPersonneDroits)this.lotsPersonneDroitsModel.getObject()).getId().setPk2((AbstractModel)this.utilisateurModel.getObject());
        ((LotPersonneDroits)this.lotsPersonneDroitsModel.getObject()).getDroits().setDroitExtrait(Boolean.TRUE);
        ((LotPersonneDroits)this.lotsPersonneDroitsModel.getObject()).getDroits().setDroitPuri(Boolean.TRUE);
        ((LotPersonneDroits)this.lotsPersonneDroitsModel.getObject()).getDroits().setDroitRecolte(Boolean.TRUE);
        ((LotPersonneDroits)this.lotsPersonneDroitsModel.getObject()).getDroits().setDroitTestBio(Boolean.TRUE);
        this.campagnes = Collections.unmodifiableList(this.campagneService.listCampagnes(this.getSession().getUtilisateur()));
        Form formView = new Form("Form");
        ManagePersonnePanel personnePanel = new ManagePersonnePanel("ManagePersonnePanel", this.utilisateurModel);
        formView.add(new Component[]{personnePanel});
        formView.add(new Component[]{new RadioChoice("Utilisateur.typeDroit", (IModel)new PropertyModel((Object)this.utilisateurModel, "typeDroit"), Arrays.asList(Utilisateur.TypeDroit.values()), (IChoiceRenderer)new EnumChoiceRenderer((TemplatePage)this))});
        WebMarkupContainer campagnesContainer = new WebMarkupContainer(this.getResource() + ".Authorizations.Campagnes.Table");
        campagnesContainer.setOutputMarkupId(true);
        campagnesContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        campagnesContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.availableCampagnes = new DropDownChoice(this.getResource() + ".Authorizations.Campagnes.Campagne", (IModel)new PropertyModel((Object)this.campagnePersonneDroitsModel, "id.pk1"), new ArrayList());
        this.availableCampagnes.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        campagnesContainer.add(new Component[]{this.availableCampagnes});
        this.availableLots = new DropDownChoice(this.getResource() + ".Authorizations.Campagnes.Lot", (IModel)new PropertyModel((Object)this.lotsPersonneDroitsModel, "id.pk1"), new ArrayList());
        this.availableLots.setOutputMarkupId(true);
        campagnesContainer.add(new Component[]{this.availableLots});
        this.addAuthorization = new /* Unavailable Anonymous Inner Class!! */;
        campagnesContainer.add(new Component[]{this.addAuthorization});
        this.updateAvailableCampagnes();
        formView.add(new Component[]{campagnesContainer});
        ManageListDocumentsPanel manageListDocumentsPanel = new ManageListDocumentsPanel("ManageListDocumentsPanel", this.utilisateurModel, currentPage);
        formView.add(new Component[]{manageListDocumentsPanel});
        SubmittableButton updateButton = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        updateButton.setVisibilityAllowed(this.utilisateurEstValide());
        formView.add(new Component[]{updateButton});
        SubmittableButton validButton = new SubmittableButton(ACTION_VALID, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        validButton.setVisibilityAllowed(!this.utilisateurEstValide());
        formView.add(new Component[]{validButton});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(this.utilisateurEstValide() && this.getSession().getUtilisateur().getIdPersonne() != ((Utilisateur)this.utilisateurModel.getObject()).getIdPersonne());
        deleteButton.setDefaultFormProcessing(false);
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        formView.add(new Component[]{deleteButton});
        SubmittableButton rejectButton = new SubmittableButton(ACTION_REJECT, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        rejectButton.setVisibilityAllowed(!this.utilisateurEstValide());
        rejectButton.setDefaultFormProcessing(false);
        rejectButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        formView.add(new Component[]{rejectButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{formView});
    }

    private void updateAvailableCampagnes() {
        CollectionTools.setter((Collection)((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getCampagnes(), ((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getCampagnesDroits().keySet());
        Collections.sort(((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getCampagnes(), BeanTools.createPropertyComparator((String)"nom"));
        CollectionTools.setter((Collection)((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getLots(), ((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getLotsDroits().keySet());
        ComparatorChain campagneComp = new ComparatorChain(BeanTools.createPropertyComparator((String)"campagne.nom"));
        campagneComp.addComparator(BeanTools.createPropertyComparator((String)"ref"));
        Collections.sort(((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getLots(), campagneComp);
        ArrayList campagnesList = new ArrayList(this.campagnes);
        CollectionTools.removeAllWithValue(campagnesList, (String)"nom", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Collection)CollectionTools.valuesFromList((Collection)((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getCampagnes(), (String)"nom", (BeanTools.AccessType)BeanTools.AccessType.GETTER));
        this.availableCampagnes.setChoices(campagnesList);
        ((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getId().setPk1(campagnesList.isEmpty() ? null : (Campagne)this.availableCampagnes.getModelObject());
        this.availableCampagnes.setEnabled(!campagnesList.isEmpty());
        ArrayList lotsList = new ArrayList();
        this.availableLots.setEnabled(((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getId().getPk1() != null);
        if (this.availableLots.isEnabled()) {
            this.campagneService.refreshCampagne((Campagne)((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getId().getPk1());
            lotsList.addAll(((Campagne)((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getId().getPk1()).getLots());
            CollectionTools.removeAllWithValue(lotsList, (String)"ref", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Collection)CollectionTools.valuesFromList((Collection)((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getLots(), (String)"ref", (BeanTools.AccessType)BeanTools.AccessType.GETTER));
            this.availableLots.setChoices(lotsList);
        }
        ((LotPersonneDroits)this.lotsPersonneDroitsModel.getObject()).getId().setPk1(null);
        this.addAuthorization.setEnabled(!campagnesList.isEmpty());
    }

    private boolean utilisateurEstValide() {
        return ((Utilisateur)this.utilisateurModel.getObject()).isValide();
    }

    static /* synthetic */ String access$000(ManageUtilisateurPage x0) {
        return x0.getResource();
    }

    static /* synthetic */ IModel access$100(ManageUtilisateurPage x0) {
        return x0.manageUtilisateurModel;
    }

    static /* synthetic */ void access$200(ManageUtilisateurPage x0) {
        x0.updateAvailableCampagnes();
    }

    static /* synthetic */ String access$300(ManageUtilisateurPage x0) {
        return x0.getResource();
    }

    static /* synthetic */ String access$400(ManageUtilisateurPage x0) {
        return x0.getResource();
    }

    static /* synthetic */ AbstractSingleSelectChoice access$500(ManageUtilisateurPage x0) {
        return x0.availableLots;
    }

    static /* synthetic */ IModel access$600(ManageUtilisateurPage x0) {
        return x0.campagnePersonneDroitsModel;
    }

    static /* synthetic */ IModel access$700(ManageUtilisateurPage x0) {
        return x0.lotsPersonneDroitsModel;
    }

    static /* synthetic */ Logger access$800() {
        return LOG;
    }

    static /* synthetic */ CampagneService access$900(ManageUtilisateurPage x0) {
        return x0.campagneService;
    }

    static /* synthetic */ LotService access$1000(ManageUtilisateurPage x0) {
        return x0.lotService;
    }

    static /* synthetic */ IModel access$1100(ManageUtilisateurPage x0) {
        return x0.utilisateurModel;
    }

    static /* synthetic */ PersonneService access$1200(ManageUtilisateurPage x0) {
        return x0.personneService;
    }

    static /* synthetic */ ModelValidator access$1300(ManageUtilisateurPage x0) {
        return x0.validator;
    }
}

