/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.station;

import java.io.Serializable;
import java.util.Map;
import nc.ird.cantharella.data.config.DataContext;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.service.services.StationService;
import nc.ird.cantharella.web.config.WebContext;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.document.panel.ReadListDocumentsPanel;
import nc.ird.cantharella.web.pages.domain.station.ManageStationPage;
import nc.ird.cantharella.web.pages.domain.station.ReadStationPage;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.behaviors.ReplaceEmptyLabelBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.models.DisplayMapValuePropertyModel;
import nc.ird.cantharella.web.utils.models.GenericLoadableDetachableModel;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public final class ReadStationPage
extends TemplatePage {
    public static final String ACTION_DELETE = "Delete";
    private final CallerPage callerPage;
    private final IModel<Station> stationModel;
    @SpringBean
    private StationService stationService;

    public ReadStationPage(Integer idStation, CallerPage callerPage) {
        super(ReadStationPage.class);
        CallerPage currentPage = new CallerPage((TemplatePage)this.getPage());
        this.callerPage = callerPage;
        this.stationModel = new GenericLoadableDetachableModel(Station.class, (Serializable)idStation);
        Station station = (Station)this.stationModel.getObject();
        this.add(new Component[]{new Label("Station.nom", (IModel)new PropertyModel((Object)this.stationModel, "nom")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Station.codePays", (IModel)new DisplayMapValuePropertyModel((Object)this.stationModel, "codePays", (Map)WebContext.COUNTRIES.get(this.getSession().getLocale()))).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Station.localite", (IModel)new PropertyModel((Object)this.stationModel, "localite")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{new MultiLineLabel("Station.complement", (IModel)new PropertyModel((Object)this.stationModel, "complement")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Station.latitude", (IModel)new PropertyModel((Object)this.stationModel, "latitude")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Station.longitude", (IModel)new PropertyModel((Object)this.stationModel, "longitude")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Station.referentiel", (IModel)new DisplayMapValuePropertyModel((Object)this.stationModel, "referentiel", DataContext.REFERENTIELS)).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        ReadListDocumentsPanel readListDocumentsPanel = new ReadListDocumentsPanel("ReadListDocumentsPanel", this.stationModel, currentPage);
        this.add(new Component[]{readListDocumentsPanel});
        Form formView = new Form("Form");
        2 updateLink = new /* Unavailable Anonymous Inner Class!! */;
        updateLink.setVisibilityAllowed(this.stationService.updateOrdeleteStationEnabled(station, this.getSession().getUtilisateur()));
        formView.add(new Component[]{updateLink});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, ManageStationPage.class, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(this.stationService.updateOrdeleteStationEnabled(station, this.getSession().getUtilisateur()));
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        formView.add(new Component[]{deleteButton});
        this.add(new Component[]{formView});
    }

    private void redirect() {
        this.callerPage.responsePage((TemplatePage)this);
    }

    static /* synthetic */ void access$000(ReadStationPage x0) {
        x0.redirect();
    }

    static /* synthetic */ StationService access$100(ReadStationPage x0) {
        return x0.stationService;
    }
}

