/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.molecule;

import java.io.Serializable;
import nc.ird.cantharella.data.model.Molecule;
import nc.ird.cantharella.service.services.MoleculeService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.document.panel.ReadListDocumentsPanel;
import nc.ird.cantharella.web.pages.domain.lot.ManageLotPage;
import nc.ird.cantharella.web.pages.domain.molecule.ReadMoleculePage;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.behaviors.MoleculeViewBehavior;
import nc.ird.cantharella.web.utils.behaviors.ReplaceEmptyLabelBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.models.DisplayBooleanPropertyModel;
import nc.ird.cantharella.web.utils.models.DisplayDecimalPropertyModel;
import nc.ird.cantharella.web.utils.models.GenericLoadableDetachableModel;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.ResourceLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.resource.ByteArrayResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.spring.injection.annot.SpringBean;

@AuthRoles(value={AuthRole.ADMIN, AuthRole.USER})
public class ReadMoleculePage
extends TemplatePage {
    public static final String ACTION_DELETE = "Delete";
    private IModel<Molecule> moleculeModel;
    @SpringBean
    private MoleculeService moleculeService;
    private CallerPage callerPage;

    public ReadMoleculePage(Integer idMolecule, CallerPage callerPage) {
        super(ReadMoleculePage.class);
        this.callerPage = callerPage;
        CallerPage currentPage = new CallerPage((TemplatePage)this);
        this.moleculeModel = new GenericLoadableDetachableModel(Molecule.class, (Serializable)idMolecule);
        this.initProvenanceFields(currentPage);
        this.add(new Component[]{new Label("Molecule.idMolecule", (IModel)new PropertyModel((Object)this.moleculeModel, "idMolecule"))});
        this.add(new Component[]{new Label("Molecule.nomCommun", (IModel)new PropertyModel((Object)this.moleculeModel, "nomCommun")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Molecule.familleChimique", (IModel)new PropertyModel((Object)this.moleculeModel, "familleChimique")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Molecule.formuleDevMol", (IModel)new PropertyModel((Object)this.moleculeModel, "formuleDevMol")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()}).add(new Behavior[]{new MoleculeViewBehavior((IModel)new PropertyModel((Object)this.moleculeModel, "formuleDevMol"), true)})});
        this.add(new Component[]{new ResourceLink("DownloadMolFile", (IResource)new ByteArrayResource("chemical/x-mdl-molfile", ((Molecule)this.moleculeModel.getObject()).getFormuleDevMol().getBytes(), "molecule.mol"))});
        this.add(new Component[]{new Label("Molecule.nomIupca", (IModel)new PropertyModel((Object)this.moleculeModel, "nomIupca")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Molecule.formuleBrute", (IModel)new PropertyModel((Object)this.moleculeModel, "formuleBrute")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Molecule.masseMolaire", (IModel)new DisplayDecimalPropertyModel((Object)this.moleculeModel, "masseMolaire", DisplayDecimalPropertyModel.DecimalDisplFormat.SMALL, this.getLocale())).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Molecule.nouvMolecul", (IModel)new DisplayBooleanPropertyModel((Object)this.moleculeModel, "nouvMolecul", (TemplatePage)this)).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        WebMarkupContainer nouvMoleculRefresh = new WebMarkupContainer("Molecule.nouvMolecul.Refresh");
        nouvMoleculRefresh.setOutputMarkupId(true);
        nouvMoleculRefresh.setVisible(((Molecule)this.moleculeModel.getObject()).isNouvMolecul());
        nouvMoleculRefresh.add(new Component[]{new Label("Molecule.campagne", (IModel)new PropertyModel((Object)this.moleculeModel, "campagne")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        nouvMoleculRefresh.add(new Component[]{new Label("Molecule.identifieePar", (IModel)new PropertyModel((Object)this.moleculeModel, "identifieePar")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        nouvMoleculRefresh.add(new Component[]{new MultiLineLabel("Molecule.publiOrigine", (IModel)new PropertyModel((Object)this.moleculeModel, "publiOrigine")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{nouvMoleculRefresh});
        this.add(new Component[]{new MultiLineLabel("Molecule.complement", (IModel)new PropertyModel((Object)this.moleculeModel, "complement")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        ReadListDocumentsPanel readListDocumentsPanel = new ReadListDocumentsPanel("ReadListDocumentsPanel", this.moleculeModel, currentPage);
        this.add(new Component[]{readListDocumentsPanel});
        Form formView = new Form("Form");
        2 updateLink = new /* Unavailable Anonymous Inner Class!! */;
        formView.add(new Component[]{updateLink});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, ManageLotPage.class, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(this.moleculeService.updateOrdeleteMoleculeEnabled((Molecule)this.moleculeModel.getObject(), this.getSession().getUtilisateur()));
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        deleteButton.setDefaultFormProcessing(false);
        formView.add(new Component[]{deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{formView});
    }

    private void redirect() {
        this.callerPage.responsePage((TemplatePage)this);
    }

    private void initProvenanceFields(CallerPage currentPage) {
        WebMarkupContainer provenanceTable = new WebMarkupContainer("Molecule.provenance.Table");
        provenanceTable.setOutputMarkupId(true);
        WebMarkupContainer resultNotAccessibleCont = new WebMarkupContainer("Molecule.provenance.resultsNotAccessibles");
        resultNotAccessibleCont.setOutputMarkupPlaceholderTag(true);
        provenanceTable.add(new Component[]{resultNotAccessibleCont});
        5 listProvenanceModel = new /* Unavailable Anonymous Inner Class!! */;
        6 provenanceListView = new /* Unavailable Anonymous Inner Class!! */;
        provenanceTable.add(new Component[]{provenanceListView});
        this.add(new Component[]{provenanceTable});
        7 noTableProvenances = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{noTableProvenances});
    }

    static /* synthetic */ IModel access$000(ReadMoleculePage x0) {
        return x0.moleculeModel;
    }

    static /* synthetic */ MoleculeService access$100(ReadMoleculePage x0) {
        return x0.moleculeService;
    }

    static /* synthetic */ void access$200(ReadMoleculePage x0) {
        x0.redirect();
    }
}

