/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.molecule;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.Molecule;
import nc.ird.cantharella.data.model.MoleculeProvenance;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.CampagneService;
import nc.ird.cantharella.service.services.MoleculeService;
import nc.ird.cantharella.service.services.ProduitService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.document.panel.ManageListDocumentsPanel;
import nc.ird.cantharella.web.pages.domain.molecule.ManageMoleculePage;
import nc.ird.cantharella.web.pages.renderers.ProduitRenderer;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.behaviors.MoleculeEditorBehavior;
import nc.ird.cantharella.web.utils.behaviors.MoleculeViewBehavior;
import nc.ird.cantharella.web.utils.forms.AutoCompleteTextFieldString;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.panels.SimpleTooltipPanel;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthRoles(value={AuthRole.USER, AuthRole.ADMIN})
public final class ManageMoleculePage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_DELETE = "Delete";
    private static final String ACTION_UPDATE = "Update";
    private static final Logger LOG = LoggerFactory.getLogger(ManageMoleculePage.class);
    private final List<Campagne> campagnes;
    @SpringBean
    private CampagneService campagneService;
    @SpringBean
    private ProduitService produitService;
    private final IModel<Molecule> moleculeModel;
    private Model<MoleculeProvenance> newProvenanceModel;
    @SpringBean
    private MoleculeService moleculeService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private final CallerPage callerPage;
    protected Button addProvenanceButton;

    public ManageMoleculePage(CallerPage callerPage) {
        this(null, callerPage);
    }

    public ManageMoleculePage(Integer idMolecule, CallerPage callerPage) {
        super(ManageMoleculePage.class);
        boolean createMode;
        this.callerPage = callerPage;
        CallerPage currentPage = new CallerPage((TemplatePage)this);
        this.newProvenanceModel = new Model((Serializable)new MoleculeProvenance());
        try {
            this.moleculeModel = new Model((Serializable)(idMolecule == null ? new Molecule() : this.moleculeService.loadMolecule(idMolecule)));
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        boolean bl = createMode = idMolecule == null;
        if (createMode) {
            ((Molecule)this.moleculeModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        List organismes = this.moleculeService.listMoleculeOrganisme();
        this.campagnes = this.campagneService.listCampagnes(this.getSession().getUtilisateur());
        Form formView = new Form("Form");
        this.initProvenanceFields(formView, currentPage);
        Utilisateur utilisateur = this.getSession().getUtilisateur();
        boolean updateOrDeleteEnabled = createMode || this.moleculeService.updateOrdeleteMoleculeEnabled((Molecule)this.moleculeModel.getObject(), utilisateur);
        formView.add(new Component[]{new TextField("Molecule.nomCommun", (IModel)new PropertyModel((Object)this.moleculeModel, "nomCommun")).setEnabled(updateOrDeleteEnabled)});
        formView.add(new Component[]{new TextField("Molecule.familleChimique", (IModel)new PropertyModel((Object)this.moleculeModel, "familleChimique")).setEnabled(updateOrDeleteEnabled)});
        if (updateOrDeleteEnabled) {
            formView.add(new Component[]{new HiddenField("Molecule.formuleDevMol", (IModel)new PropertyModel((Object)this.moleculeModel, "formuleDevMol")).add(new Behavior[]{new MoleculeEditorBehavior((IModel)new PropertyModel((Object)this.moleculeModel, "formuleDevMol"))})});
        } else {
            formView.add(new Component[]{new HiddenField("Molecule.formuleDevMol", (IModel)new PropertyModel((Object)this.moleculeModel, "formuleDevMol")).setEnabled(false).add(new Behavior[]{new MoleculeViewBehavior((IModel)new PropertyModel((Object)this.moleculeModel, "formuleDevMol"), true)})});
        }
        formView.add(new Component[]{new TextField("Molecule.nomIupca", (IModel)new PropertyModel((Object)this.moleculeModel, "nomIupca")).setEnabled(updateOrDeleteEnabled)});
        formView.add(new Component[]{new SimpleTooltipPanel("Molecule.formuleBrute.info", this.getStringModel("Molecule.formuleBrute.info", new Object[0]))});
        formView.add(new Component[]{new TextField("Molecule.formuleBrute", (IModel)new PropertyModel((Object)this.moleculeModel, "formuleBrute")).setEnabled(updateOrDeleteEnabled)});
        TextField masseMolaireField = new TextField("Molecule.masseMolaire", (IModel)new PropertyModel((Object)this.moleculeModel, "masseMolaire"));
        masseMolaireField.setRequired(true);
        masseMolaireField.setEnabled(updateOrDeleteEnabled);
        formView.add(new Component[]{masseMolaireField});
        WebMarkupContainer nouvMoleculRefresh = new WebMarkupContainer("Molecule.nouvMolecul.Refresh");
        nouvMoleculRefresh.setOutputMarkupPlaceholderTag(true);
        nouvMoleculRefresh.setVisible(((Molecule)this.moleculeModel.getObject()).isNouvMolecul());
        formView.add(new Component[]{nouvMoleculRefresh});
        formView.add(new Component[]{new SimpleTooltipPanel("Molecule.nouvMolecul.info", this.getStringModel("Molecule.nouvMolecul.info", new Object[0]))});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */.setEnabled(updateOrDeleteEnabled)});
        AutoCompleteTextFieldString identifieeParInput = new AutoCompleteTextFieldString("Molecule.identifieePar", (IModel)new PropertyModel((Object)this.moleculeModel, "identifieePar"), organismes, AutoCompleteTextFieldString.ComparisonMode.CONTAINS);
        identifieeParInput.setEnabled(updateOrDeleteEnabled);
        nouvMoleculRefresh.add(new Component[]{identifieeParInput});
        DropDownChoice campagnesInput = new DropDownChoice("Molecule.campagne", (IModel)new PropertyModel((Object)this.moleculeModel, "campagne"), this.campagnes);
        campagnesInput.setEnabled(updateOrDeleteEnabled);
        nouvMoleculRefresh.add(new Component[]{campagnesInput});
        nouvMoleculRefresh.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */.setVisibilityAllowed(updateOrDeleteEnabled)});
        nouvMoleculRefresh.add(new Component[]{new TextArea("Molecule.publiOrigine", (IModel)new PropertyModel((Object)this.moleculeModel, "publiOrigine")).setEnabled(updateOrDeleteEnabled)});
        formView.add(new Component[]{new TextArea("Molecule.complement", (IModel)new PropertyModel((Object)this.moleculeModel, "complement")).setEnabled(updateOrDeleteEnabled)});
        formView.add(new Component[]{new TextField("Molecule.createur", (IModel)new PropertyModel((Object)this.moleculeModel, "createur")).setEnabled(false)});
        ManageListDocumentsPanel manageListDocumentsPanel = new ManageListDocumentsPanel("ManageListDocumentsPanel", this.moleculeModel, currentPage);
        manageListDocumentsPanel.setUpdateOrDeleteEnabled(updateOrDeleteEnabled);
        formView.add(new Component[]{manageListDocumentsPanel});
        SubmittableButton createButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        createButton.setVisibilityAllowed(createMode);
        formView.add(new Component[]{createButton});
        SubmittableButton updateButton = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        updateButton.setVisibilityAllowed(!createMode);
        formView.add(new Component[]{updateButton});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(!createMode && updateOrDeleteEnabled);
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        deleteButton.setDefaultFormProcessing(false);
        formView.add(new Component[]{deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{formView});
    }

    private void initProvenanceFields(Form<Void> formView, CallerPage currentPage) {
        WebMarkupContainer provenanceTable = new WebMarkupContainer("Molecule.provenance.Table");
        provenanceTable.setOutputMarkupId(true);
        WebMarkupContainer resultNotAccessibleCont = new WebMarkupContainer("Molecule.provenance.resultsNotAccessibles");
        resultNotAccessibleCont.setOutputMarkupPlaceholderTag(true);
        provenanceTable.add(new Component[]{resultNotAccessibleCont});
        Utilisateur utilisateur = this.getSession().getUtilisateur();
        List utilisateurProduits = this.produitService.listProduits(utilisateur);
        7 listProvenanceModel = new /* Unavailable Anonymous Inner Class!! */;
        provenanceTable.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        DropDownChoice produitChoice = new DropDownChoice("Molecule.provenance.produit.ref", (IModel)new PropertyModel((Object)this.newProvenanceModel, "produit"), utilisateurProduits, (IChoiceRenderer)new ProduitRenderer());
        produitChoice.setNullValid(false);
        provenanceTable.add(new Component[]{produitChoice});
        TextField presenceInput = new TextField("Molecule.provenance.presence", (IModel)new PropertyModel((Object)this.newProvenanceModel, "pourcentage"));
        presenceInput.setOutputMarkupId(true);
        provenanceTable.add(new Component[]{presenceInput});
        Label lotRefLabel = new Label("Molecule.provenance.lot.ref", (IModel)new /* Unavailable Anonymous Inner Class!! */);
        lotRefLabel.setOutputMarkupId(true);
        provenanceTable.add(new Component[]{lotRefLabel});
        Label genreLabel = new Label("Molecule.provenance.genre", (IModel)new /* Unavailable Anonymous Inner Class!! */);
        genreLabel.setOutputMarkupId(true);
        provenanceTable.add(new Component[]{genreLabel});
        Label especeLabel = new Label("Molecule.provenance.espece", (IModel)new /* Unavailable Anonymous Inner Class!! */);
        especeLabel.setOutputMarkupId(true);
        provenanceTable.add(new Component[]{especeLabel});
        Label campagneLabel = new Label("Molecule.provenance.campagne", (IModel)new /* Unavailable Anonymous Inner Class!! */);
        campagneLabel.setOutputMarkupId(true);
        provenanceTable.add(new Component[]{campagneLabel});
        produitChoice.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        this.addProvenanceButton = new /* Unavailable Anonymous Inner Class!! */;
        provenanceTable.add(new Component[]{this.addProvenanceButton});
        formView.add(new Component[]{provenanceTable});
    }

    private void redirect() {
        if (this.callerPage != null) {
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void validateModel() {
        if (((Molecule)this.moleculeModel.getObject()).getCreateur() == null) {
            ((Molecule)this.moleculeModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.addValidationErrors((Collection)this.validator.validate(this.moleculeModel.getObject(), this.getSession().getLocale(), new String[0]));
    }

    static /* synthetic */ IModel access$000(ManageMoleculePage x0) {
        return x0.moleculeModel;
    }

    static /* synthetic */ MoleculeService access$100(ManageMoleculePage x0) {
        return x0.moleculeService;
    }

    static /* synthetic */ void access$200(ManageMoleculePage x0) {
        x0.redirect();
    }

    static /* synthetic */ void access$300(ManageMoleculePage x0) {
        x0.validateModel();
    }

    static /* synthetic */ Model access$400(ManageMoleculePage x0) {
        return x0.newProvenanceModel;
    }

    static /* synthetic */ ModelValidator access$500(ManageMoleculePage x0) {
        return x0.validator;
    }

    static /* synthetic */ Logger access$600() {
        return LOG;
    }
}

