/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.extraction;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Extraction;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.MethodeExtraction;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.TypeExtrait;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.ExtractionService;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.service.services.ProduitService;
import nc.ird.cantharella.utils.BeanTools;
import nc.ird.cantharella.utils.CollectionTools;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.document.panel.ManageListDocumentsPanel;
import nc.ird.cantharella.web.pages.domain.extraction.ManageExtractionPage;
import nc.ird.cantharella.web.pages.renderers.PersonneRenderer;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.panels.SimpleTooltipPanel;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.StringValueConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthRoles(value={AuthRole.ADMIN, AuthRole.USER})
public final class ManageExtractionPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_UPDATE = "Update";
    private static final String ACTION_DELETE = "Delete";
    private static final Logger LOG = LoggerFactory.getLogger(ManageExtractionPage.class);
    private final IModel<Extraction> extractionModel;
    private IModel<Extrait> newExtraitModel;
    @SpringBean
    private ExtractionService extractionService;
    @SpringBean
    private PersonneService personneService;
    @SpringBean
    private ProduitService produitService;
    @SpringBean
    private LotService lotService;
    private final List<Personne> personnes;
    private final List<MethodeExtraction> methodes;
    private List<TypeExtrait> typesExtrait;
    private List<Lot> lots;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private final CallerPage callerPage;
    private boolean multipleEntry;
    private boolean createMode;
    private HashMap<String, Integer> extraitsDeleted;
    private MarkupContainer extraitsTable;
    private AbstractSingleSelectChoice<TypeExtrait> typeExtraitInput;
    private SimpleTooltipPanel typeExtraitTooltip;
    private FormComponent<String> refInput;
    private FormComponent<BigDecimal> masseObtenueInput;
    private Button addExtraitButton;
    private static final String PATTERN_REF_EXTRAIT = "%s%s";

    public ManageExtractionPage(CallerPage callerPage, boolean multipleEntry) {
        this(null, null, callerPage, multipleEntry);
    }

    public ManageExtractionPage(Integer idManip, CallerPage callerPage) {
        this(idManip, null, callerPage, false);
    }

    public ManageExtractionPage(Extraction manip, CallerPage callerPage) {
        this(null, manip, callerPage, true);
    }

    private ManageExtractionPage(Integer idManip, Extraction manip, CallerPage callerPage, boolean multipleEntry) {
        super(ManageExtractionPage.class);
        assert (idManip == null || manip == null);
        this.callerPage = callerPage;
        CallerPage currentPage = new CallerPage((TemplatePage)this);
        this.multipleEntry = multipleEntry;
        this.extraitsDeleted = new HashMap();
        this.newExtraitModel = new Model((Serializable)new Extrait());
        try {
            this.extractionModel = new Model((Serializable)(idManip == null && manip == null ? new Extraction() : (manip != null ? manip : this.extractionService.loadExtraction(idManip))));
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        boolean bl = this.createMode = idManip == null;
        if (this.createMode) {
            ((Extraction)this.extractionModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.personnes = this.personneService.listPersonnes();
        this.methodes = this.extractionService.listMethodesExtraction();
        this.lots = this.lotService.listLots(this.getSession().getUtilisateur());
        if (manip != null) {
            ((Extraction)this.extractionModel.getObject()).setManipulateur((Personne)CollectionTools.findWithValue((List)this.personnes, (String)"idPersonne", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Extraction)this.extractionModel.getObject()).getManipulateur().getIdPersonne()));
            ((Extraction)this.extractionModel.getObject()).setMethode((MethodeExtraction)CollectionTools.findWithValue((List)this.methodes, (String)"idMethodeExtraction", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Extraction)this.extractionModel.getObject()).getMethode().getIdMethodeExtraction()));
        }
        this.typesExtrait = new ArrayList();
        Form formView = new Form("Form");
        this.initPrincipalFields(formView);
        this.initMethodeFields(formView);
        this.initExtraitsFields(formView);
        ManageListDocumentsPanel manageListDocumentsPanel = new ManageListDocumentsPanel("ManageListDocumentsPanel", this.extractionModel, currentPage);
        formView.add(new Component[]{manageListDocumentsPanel});
        SubmittableButton createButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        createButton.setVisibilityAllowed(this.createMode);
        formView.add(new Component[]{createButton});
        SubmittableButton updateButton = new SubmittableButton(ACTION_UPDATE, ManageExtractionPage.class, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        updateButton.setVisibilityAllowed(!this.createMode);
        formView.add(new Component[]{updateButton});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(!this.createMode);
        deleteButton.setDefaultFormProcessing(false);
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        formView.add(new Component[]{deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.setDefaultButton((IFormSubmittingComponent)this.addExtraitButton);
        this.add(new Component[]{formView});
    }

    private void initPrincipalFields(Form<Void> formView) {
        formView.add(new Component[]{new TextField("Extraction.ref", (IModel)new PropertyModel((Object)this.extractionModel, "ref"))});
        DropDownChoice pers = new DropDownChoice("Extraction.manipulateur", (IModel)new PropertyModel((Object)this.extractionModel, "manipulateur"), this.personnes, (IChoiceRenderer)new PersonneRenderer());
        pers.setNullValid(false);
        pers.setModelObject((Object)((Extraction)this.extractionModel.getObject()).getManipulateur());
        formView.add(new Component[]{pers});
        pers.getChoices().indexOf(pers.getModelObject());
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{new DateTextField("Extraction.date", (IModel)new PropertyModel((Object)this.extractionModel, "date")).add(new Behavior[]{new DatePicker()})});
        DropDownChoice lotsChoice = new DropDownChoice("Extraction.lot", (IModel)new PropertyModel((Object)this.extractionModel, "lot"), this.lots);
        lotsChoice.setNullValid(false);
        lotsChoice.setEnabled(this.createMode);
        lotsChoice.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{lotsChoice});
        7 newLot = new /* Unavailable Anonymous Inner Class!! */;
        newLot.setOutputMarkupPlaceholderTag(true);
        newLot.setVisibilityAllowed(this.createMode);
        formView.add(new Component[]{newLot});
        TextField masseDepartInput = new TextField("Extraction.masseDepart", (IModel)new PropertyModel((Object)this.extractionModel, "masseDepart"));
        masseDepartInput.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{masseDepartInput});
        formView.add(new Component[]{new TextArea("Extraction.complement", (IModel)new PropertyModel((Object)this.extractionModel, "complement"))});
        formView.add(new Component[]{new TextField("Extraction.createur", (IModel)new PropertyModel((Object)this.extractionModel, "createur")).setEnabled(false)});
    }

    private void initMethodeFields(Form<Void> formView) {
        9 descriptionMethoContainer = new /* Unavailable Anonymous Inner Class!! */;
        descriptionMethoContainer.setOutputMarkupId(true);
        descriptionMethoContainer.setOutputMarkupPlaceholderTag(true);
        formView.add(new Component[]{descriptionMethoContainer});
        descriptionMethoContainer.add(new Component[]{new MultiLineLabel("Extraction.methode.description", (IModel)new PropertyModel((Object)this.extractionModel, "methode.description"))});
        DropDownChoice methodeChoice = new DropDownChoice("Extraction.methode.nom", (IModel)new PropertyModel((Object)this.extractionModel, "methode"), this.methodes);
        methodeChoice.setNullValid(false);
        methodeChoice.setOutputMarkupId(true);
        methodeChoice.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{methodeChoice});
    }

    private void initExtraitsFields(Form<Void> formView) {
        this.extraitsTable = new WebMarkupContainer("Extraction.extraits.Table");
        this.extraitsTable.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.extraitsTable.setOutputMarkupId(true);
        this.typeExtraitInput = new DropDownChoice("Extraction.extraits.typeExtrait", (IModel)new PropertyModel((Object)this.newExtraitModel, "typeExtrait"), this.typesExtrait).setNullValid(false);
        this.typeExtraitTooltip = new SimpleTooltipPanel("Extraction.extraits.typeExtrait.info", (IModel)new PropertyModel((Object)this.newExtraitModel, "typeExtrait.description"));
        this.typeExtraitTooltip.setOutputMarkupId(true);
        this.typeExtraitTooltip.setOutputMarkupPlaceholderTag(true);
        this.extraitsTable.add(new Component[]{this.typeExtraitTooltip});
        this.typeExtraitInput.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        this.extraitsTable.add(new Component[]{this.typeExtraitInput});
        this.refInput = new TextField("Extraction.extraits.ref", (IModel)new PropertyModel((Object)this.newExtraitModel, "ref"));
        this.refInput.setOutputMarkupId(true);
        this.extraitsTable.add(new Component[]{this.refInput});
        this.masseObtenueInput = new TextField("Extraction.extraits.masseObtenue", (IModel)new PropertyModel((Object)this.newExtraitModel, "masseObtenue"));
        this.masseObtenueInput.setOutputMarkupId(true);
        this.extraitsTable.add(new Component[]{this.masseObtenueInput});
        this.addExtraitButton = new /* Unavailable Anonymous Inner Class!! */;
        this.addExtraitButton.setOutputMarkupId(true);
        this.extraitsTable.add(new Component[]{this.addExtraitButton});
        formView.add(new Component[]{this.extraitsTable});
        this.updateTypesExtrait(true, null);
    }

    protected void onBeforeRender() {
        this.refreshModel();
        super.onBeforeRender();
    }

    private void redirect() {
        if (this.multipleEntry) {
            Extraction nextManip = new Extraction();
            nextManip.setManipulateur(((Extraction)this.extractionModel.getObject()).getManipulateur());
            nextManip.setMethode(((Extraction)this.extractionModel.getObject()).getMethode());
            nextManip.setMasseDepart(((Extraction)this.extractionModel.getObject()).getMasseDepart());
            this.setResponsePage((Page)new ManageExtractionPage(nextManip, this.callerPage));
        } else if (this.callerPage != null) {
            this.callerPage.addPageParameter(Extraction.class.getSimpleName(), (Object)((Extraction)this.extractionModel.getObject()).getIdExtraction());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void refreshModel() {
        String key = Personne.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(key)) {
            CollectionTools.setter((Collection)this.personnes, (Collection)this.personneService.listPersonnes());
            try {
                Personne createdPersonne = this.personneService.loadPersonne(Integer.valueOf(this.getPageParameters().get(key).toInt()));
                ((Extraction)this.extractionModel.getObject()).setManipulateur(createdPersonne);
            }
            catch (StringValueConversionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            catch (DataNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            this.getPageParameters().remove(key, new String[0]);
        }
        key = Lot.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(key)) {
            CollectionTools.setter((Collection)this.lots, (Collection)this.lotService.listLots(this.getSession().getUtilisateur()));
            try {
                Lot createdLot = this.lotService.loadLot(Integer.valueOf(this.getPageParameters().get(key).toInt()));
                ((Extraction)this.extractionModel.getObject()).setLot(createdLot);
            }
            catch (StringValueConversionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            catch (DataNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            this.getPageParameters().remove(key, new String[0]);
        }
        this.updateRefExtrait(null);
    }

    private void updateRefExtrait(AjaxRequestTarget target) {
        if (((Extraction)this.extractionModel.getObject()).getLot() != null && ((Extrait)this.newExtraitModel.getObject()).getTypeExtrait() != null) {
            ((Extrait)this.newExtraitModel.getObject()).setRef(String.format(PATTERN_REF_EXTRAIT, ((Extraction)this.extractionModel.getObject()).getLot().getRef(), ((Extrait)this.newExtraitModel.getObject()).getTypeExtrait().getInitiales()));
            if (target != null) {
                target.add(new Component[]{this.refInput});
            }
        }
    }

    private void updateTypesExtrait(boolean selectFirstTypeExtrait, AjaxRequestTarget target) {
        if (((Extraction)this.extractionModel.getObject()).getMethode() != null) {
            CollectionTools.setter((Collection)this.typesExtrait, (Collection)((Extraction)this.extractionModel.getObject()).getMethode().getSortedTypesEnSortie());
            for (Extrait curExtrait : ((Extraction)this.extractionModel.getObject()).getExtraits()) {
                this.typesExtrait.remove(curExtrait.getTypeExtrait());
            }
        }
        this.configureExtraitInputs();
        if (selectFirstTypeExtrait) {
            ((Extrait)this.newExtraitModel.getObject()).setTypeExtrait(this.typeExtraitInput.getChoices().isEmpty() ? null : (TypeExtrait)this.typeExtraitInput.getChoices().get(0));
        }
        this.updateRefExtrait(target);
        if (target != null) {
            target.add(new Component[]{this.typeExtraitInput, this.typeExtraitTooltip, this.refInput, this.masseObtenueInput, this.addExtraitButton});
        }
    }

    private void configureExtraitInputs() {
        if (((Extraction)this.extractionModel.getObject()).getMethode() == null || ((Extraction)this.extractionModel.getObject()).getExtraits() != null && ((Extraction)this.extractionModel.getObject()).getExtraits().size() == ((Extraction)this.extractionModel.getObject()).getMethode().getTypesEnSortie().size()) {
            this.disableExtraitAdding();
        } else {
            this.enableExtraitAdding();
        }
    }

    private void enableExtraitAdding() {
        this.typeExtraitInput.setEnabled(true);
        this.typeExtraitTooltip.setVisibilityAllowed(true);
        this.refInput.setEnabled(true);
        this.masseObtenueInput.setEnabled(true);
        this.addExtraitButton.setEnabled(true);
    }

    private void disableExtraitAdding() {
        this.typeExtraitInput.setEnabled(false);
        this.typeExtraitTooltip.setVisibilityAllowed(false);
        this.refInput.setEnabled(false);
        this.masseObtenueInput.setEnabled(false);
        this.addExtraitButton.setEnabled(false);
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.extractionModel.getObject(), this.getSession().getLocale(), new String[0]));
        if (!this.extractionService.isExtractionUnique((Extraction)this.extractionModel.getObject())) {
            this.error((Serializable)((Object)this.getString("Extraction.notUnique")));
        }
    }

    static /* synthetic */ IModel access$000(ManageExtractionPage x0) {
        return x0.extractionModel;
    }

    static /* synthetic */ ExtractionService access$100(ManageExtractionPage x0) {
        return x0.extractionService;
    }

    static /* synthetic */ void access$200(ManageExtractionPage x0) {
        x0.redirect();
    }

    static /* synthetic */ void access$300(ManageExtractionPage x0) {
        x0.validateModel();
    }

    static /* synthetic */ void access$400(ManageExtractionPage x0, AjaxRequestTarget x1) {
        x0.updateRefExtrait(x1);
    }

    static /* synthetic */ List access$500(ManageExtractionPage x0) {
        return x0.typesExtrait;
    }

    static /* synthetic */ void access$600(ManageExtractionPage x0, boolean x1, AjaxRequestTarget x2) {
        x0.updateTypesExtrait(x1, x2);
    }

    static /* synthetic */ ProduitService access$700(ManageExtractionPage x0) {
        return x0.produitService;
    }

    static /* synthetic */ HashMap access$800(ManageExtractionPage x0) {
        return x0.extraitsDeleted;
    }

    static /* synthetic */ MarkupContainer access$900(ManageExtractionPage x0) {
        return x0.extraitsTable;
    }

    static /* synthetic */ SimpleTooltipPanel access$1000(ManageExtractionPage x0) {
        return x0.typeExtraitTooltip;
    }

    static /* synthetic */ IModel access$1100(ManageExtractionPage x0) {
        return x0.newExtraitModel;
    }

    static /* synthetic */ ModelValidator access$1200(ManageExtractionPage x0) {
        return x0.validator;
    }

    static /* synthetic */ Logger access$1300() {
        return LOG;
    }
}

