/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.document;

import java.io.Serializable;
import java.util.Map;
import nc.ird.cantharella.data.model.Document;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.DocumentAttachable;
import nc.ird.cantharella.service.services.DocumentService;
import nc.ird.cantharella.web.config.WebContext;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.document.panel.DocumentLinkPanel;
import nc.ird.cantharella.web.pages.domain.lot.ManageLotPage;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.behaviors.ReplaceEmptyLabelBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.models.DisplayMapValuePropertyModel;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ReadDocumentPage
extends TemplatePage {
    public static final String ACTION_DELETE_LATER = "DeleteLater";
    public static final String ACTION_DELETE = "Delete";
    private final IModel<Document> documentModel;
    @SpringBean
    private DocumentService documentService;
    private final CallerPage callerPage;
    protected boolean updateOrDeleteEnabled;
    protected Link<Document> updateLink;
    protected Button deleteButton;

    public ReadDocumentPage(Document document, DocumentAttachable documentAttachable, CallerPage callerPage, boolean fromEditEntity) {
        super(ReadDocumentPage.class);
        this.callerPage = callerPage;
        CallerPage currentPage = new CallerPage((TemplatePage)this);
        Utilisateur utilisateur = this.getSession().getUtilisateur();
        boolean updateOrDelete = this.documentService.updateOrdeleteDocumentEnabled(document, utilisateur);
        this.documentModel = new Model((Serializable)document);
        this.add(new Component[]{new Label("Document.titre", (IModel)new PropertyModel((Object)this.documentModel, "titre")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Document.createur", (IModel)new PropertyModel((Object)this.documentModel, "createur")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Document.dateCreation", (IModel)new PropertyModel((Object)this.documentModel, "dateCreation")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Document.editeur", (IModel)new PropertyModel((Object)this.documentModel, "editeur")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new MultiLineLabel("Document.description", (IModel)new PropertyModel((Object)this.documentModel, "description")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Document.langue", (IModel)new DisplayMapValuePropertyModel((Object)this.documentModel, "langue", (Map)WebContext.LANGUAGES.get(this.getSession().getLocale()))).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Document.contrainteLegale", (IModel)new PropertyModel((Object)this.documentModel, "contrainteLegale")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Document.ajoutePar", (IModel)new PropertyModel((Object)this.documentModel, "ajoutePar")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("TypeDocument.nom", (IModel)new PropertyModel((Object)this.documentModel, "typeDocument.nom")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("TypeDocument.domaine", (IModel)new PropertyModel((Object)this.documentModel, "typeDocument.domaine")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("TypeDocument.description", (IModel)new PropertyModel((Object)this.documentModel, "typeDocument.description")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Document.file", (IModel)new PropertyModel((Object)this.documentModel, "fileName")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Document.fileMimetype", (IModel)new PropertyModel((Object)this.documentModel, "fileMimetype")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new DocumentLinkPanel("Document.link", this.documentModel)});
        Form formView = new Form("Form");
        this.updateLink = new /* Unavailable Anonymous Inner Class!! */;
        this.updateLink.setVisibilityAllowed(updateOrDelete);
        formView.add(new Component[]{this.updateLink});
        this.deleteButton = new SubmittableButton(ACTION_DELETE, ManageLotPage.class, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        this.deleteButton.setDefaultFormProcessing(false);
        this.deleteButton.setVisibilityAllowed(updateOrDelete);
        formView.add(new Component[]{this.deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{formView});
    }

    private void redirect() {
        this.callerPage.responsePage((TemplatePage)this);
    }

    public void setUpdateOrDeleteEnabled(boolean updateOrDeleteEnabled) {
        this.updateOrDeleteEnabled = updateOrDeleteEnabled;
        this.updateLink.setVisibilityAllowed(updateOrDeleteEnabled);
        this.deleteButton.setVisibilityAllowed(updateOrDeleteEnabled);
    }

    static /* synthetic */ IModel access$000(ReadDocumentPage x0) {
        return x0.documentModel;
    }

    static /* synthetic */ DocumentService access$100(ReadDocumentPage x0) {
        return x0.documentService;
    }

    static /* synthetic */ void access$200(ReadDocumentPage x0) {
        x0.redirect();
    }
}

