/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.document;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import nc.ird.cantharella.data.model.Document;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.TypeDocument;
import nc.ird.cantharella.data.model.utils.DocumentAttachable;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.DocumentService;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.utils.BeanTools;
import nc.ird.cantharella.utils.CollectionTools;
import nc.ird.cantharella.web.config.WebApplicationImpl;
import nc.ird.cantharella.web.config.WebContext;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.renderers.PersonneRenderer;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.AutoCompleteTextFieldString;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.panels.SimpleTooltipPanel;
import nc.ird.cantharella.web.utils.renderers.MapChoiceRenderer;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.lang.Bytes;

public class ManageDocumentPage
extends TemplatePage {
    private static final String ACTION_CREATE_LATER = "CreateLater";
    private static final String ACTION_DELETE_LATER = "DeleteLater";
    private static final String ACTION_UPDATE_LATER = "UpdateLater";
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_DELETE = "Delete";
    private static final String ACTION_UPDATE = "Update";
    private IModel<Document> documentModel;
    @SpringBean
    private DocumentService documentService;
    @SpringBean
    private PersonneService personneService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private final CallerPage callerPage;

    public ManageDocumentPage(CallerPage callerPage, DocumentAttachable documentAttachable, boolean multipleEntry) {
        this(null, documentAttachable, callerPage, multipleEntry, false);
    }

    public ManageDocumentPage(Document document, DocumentAttachable documentAttachable, CallerPage callerPage, boolean updateWithService) {
        this(document, documentAttachable, callerPage, false, updateWithService);
    }

    private ManageDocumentPage(Document document, DocumentAttachable documentAttachable, CallerPage callerPage, boolean multipleEntry, boolean updateWithService) {
        super(ManageDocumentPage.class);
        boolean createMode;
        this.callerPage = callerPage;
        CallerPage currentPage = new CallerPage((TemplatePage)this);
        long documentMaxUploadSize = ((WebApplicationImpl)this.getApplication()).getDocumentMaxUploadSize();
        String documentExtensionAllowed = ((WebApplicationImpl)this.getApplication()).getDocumentExtensionAllowed();
        this.documentModel = new Model((Serializable)(document == null ? new Document() : document));
        boolean bl = createMode = document == null;
        if (createMode) {
            ((Document)this.documentModel.getObject()).setDateCreation(new Date());
            ((Document)this.documentModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
            ((Document)this.documentModel.getObject()).setEditeur(this.getSession().getUtilisateur().getOrganisme());
            ((Document)this.documentModel.getObject()).setAjoutePar((Personne)this.getSession().getUtilisateur());
        }
        List personnes = this.personneService.listPersonnes();
        List typeDocuments = this.documentService.listTypeDocuments();
        List editeurs = this.documentService.listDocumentEditeurs();
        List containteLegales = this.documentService.listDocumentContrainteLegales();
        if (document != null) {
            ((Document)this.documentModel.getObject()).setCreateur((Personne)CollectionTools.findWithValue((List)personnes, (String)"idPersonne", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Document)this.documentModel.getObject()).getCreateur().getIdPersonne()));
            ((Document)this.documentModel.getObject()).setTypeDocument((TypeDocument)CollectionTools.findWithValue((List)typeDocuments, (String)"idTypeDocument", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Document)this.documentModel.getObject()).getTypeDocument().getIdTypeDocument()));
        }
        FileUploadField fileUploadField = new FileUploadField("Document.file");
        Form formView = new Form("ManageDocumentPage.Form");
        formView.setMultiPart(true);
        formView.setMaxSize(Bytes.megabytes((long)documentMaxUploadSize));
        formView.add(new Component[]{new TextField("Document.titre", (IModel)new PropertyModel((Object)this.documentModel, "titre"))});
        DropDownChoice createurInput = new DropDownChoice("Document.createur", (IModel)new PropertyModel((Object)this.documentModel, "createur"), personnes, (IChoiceRenderer)new PersonneRenderer());
        createurInput.setOutputMarkupId(true);
        createurInput.setNullValid(false);
        formView.add(new Component[]{createurInput});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{new DateTextField("Document.dateCreation", (IModel)new PropertyModel((Object)this.documentModel, "dateCreation")).add(new Behavior[]{new DatePicker()})});
        AutoCompleteTextFieldString editeurInput = new AutoCompleteTextFieldString("Document.editeur", (IModel)new PropertyModel((Object)this.documentModel, "editeur"), editeurs, AutoCompleteTextFieldString.ComparisonMode.CONTAINS);
        formView.add(new Component[]{editeurInput});
        formView.add(new Component[]{new TextArea("Document.description", (IModel)new PropertyModel((Object)this.documentModel, "description"))});
        formView.add(new Component[]{new DropDownChoice("Document.langue", (IModel)new PropertyModel((Object)this.documentModel, "langue"), (List)WebContext.LANGUAGE_CODES.get(this.getSession().getLocale()), (IChoiceRenderer)new MapChoiceRenderer((Map)WebContext.LANGUAGES.get(this.getSession().getLocale())))});
        AutoCompleteTextFieldString containteLegalesInput = new AutoCompleteTextFieldString("Document.contrainteLegale", (IModel)new PropertyModel((Object)this.documentModel, "contrainteLegale"), containteLegales, AutoCompleteTextFieldString.ComparisonMode.CONTAINS);
        formView.add(new Component[]{containteLegalesInput});
        formView.add(new Component[]{new TextField("Document.ajoutePar", (IModel)new PropertyModel((Object)this.documentModel, "ajoutePar")).setEnabled(false)});
        DropDownChoice typeDocumentChoice = new DropDownChoice("TypeDocument.nom", (IModel)new PropertyModel((Object)this.documentModel, "typeDocument"), typeDocuments);
        typeDocumentChoice.setOutputMarkupId(true);
        typeDocumentChoice.setNullValid(false);
        formView.add(new Component[]{typeDocumentChoice});
        Label typeDocumentDomainLabel = new Label("TypeDocument.domaine", (IModel)new PropertyModel((Object)this.documentModel, "typeDocument.domaine"));
        typeDocumentDomainLabel.setOutputMarkupId(true);
        formView.add(new Component[]{typeDocumentDomainLabel});
        Label typeDocumentDescriptionLabel = new Label("TypeDocument.description", (IModel)new PropertyModel((Object)this.documentModel, "typeDocument.description"));
        typeDocumentDescriptionLabel.setOutputMarkupId(true);
        formView.add(new Component[]{typeDocumentDescriptionLabel});
        typeDocumentChoice.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{new SimpleTooltipPanel("Document.file.info", (IModel)new Model((Serializable)((Object)this.getString("Document.file.info", (IModel)Model.of((Serializable)new Object[]{documentMaxUploadSize, documentExtensionAllowed})))))});
        formView.add(new Component[]{fileUploadField});
        SubmittableButton createButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        createButton.setVisibilityAllowed(createMode);
        formView.add(new Component[]{createButton});
        SubmittableButton updateButton = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        updateButton.setVisibilityAllowed(!createMode);
        formView.add(new Component[]{updateButton});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(!createMode);
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        deleteButton.setDefaultFormProcessing(false);
        formView.add(new Component[]{deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{formView});
    }

    private void redirect() {
        if (this.callerPage != null) {
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void validateModel() {
        if (((Document)this.documentModel.getObject()).getCreateur() == null) {
            ((Document)this.documentModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        List errors = this.validator.validate(this.documentModel.getObject(), this.getSession().getLocale(), new String[0]);
        this.addValidationErrors((Collection)errors);
    }

    static /* synthetic */ IModel access$000(ManageDocumentPage x0) {
        return x0.documentModel;
    }

    static /* synthetic */ DocumentService access$100(ManageDocumentPage x0) {
        return x0.documentService;
    }

    static /* synthetic */ void access$200(ManageDocumentPage x0) {
        x0.validateModel();
    }

    static /* synthetic */ void access$300(ManageDocumentPage x0) {
        x0.redirect();
    }
}

