/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.config;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.MethodePurification;
import nc.ird.cantharella.data.model.ParamMethoPuri;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.PurificationService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.config.ManageMethodePurificationPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthRoles(value={AuthRole.ADMIN})
public final class ManageMethodePurificationPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_UPDATE = "Update";
    public static final String ACTION_DELETE = "Delete";
    private final String[] RETURN_PARAM = new String[]{"methodePurification", "opened"};
    private static final Logger LOG = LoggerFactory.getLogger(ManageMethodePurificationPage.class);
    private final IModel<MethodePurification> methodePurificationModel;
    private IModel<ParamMethoPuri> newParamModel;
    @SpringBean
    private PurificationService purificationService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private HashMap<String, ParamMethoPuri> paramsDeleted = new HashMap();

    public ManageMethodePurificationPage() {
        this(null);
    }

    public ManageMethodePurificationPage(Integer idMethode) {
        super(ManageMethodePurificationPage.class);
        boolean createMode;
        this.newParamModel = new Model((Serializable)new ParamMethoPuri());
        if (idMethode == null) {
            this.methodePurificationModel = new Model((Serializable)new MethodePurification());
            createMode = true;
        } else {
            try {
                this.methodePurificationModel = new Model((Serializable)this.purificationService.loadMethodePurification(idMethode));
            }
            catch (DataNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            createMode = false;
        }
        Form formView = new Form("Form");
        formView.add(new Component[]{new TextField("MethodePurification.nom", (IModel)new PropertyModel((Object)this.methodePurificationModel, "nom"))});
        formView.add(new Component[]{new TextArea("MethodePurification.description", (IModel)new PropertyModel((Object)this.methodePurificationModel, "description"))});
        WebMarkupContainer typesEnSortieTable = new WebMarkupContainer("MethodePurification.parametres.Table");
        typesEnSortieTable.setOutputMarkupId(true);
        typesEnSortieTable.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        TextField nomParamInput = new TextField("MethodePurification.parametres.nom", (IModel)new PropertyModel((Object)this.newParamModel, "nom"));
        typesEnSortieTable.add(new Component[]{nomParamInput});
        TextField descriptionParamInput = new TextField("MethodePurification.parametres.description", (IModel)new PropertyModel((Object)this.newParamModel, "description"));
        typesEnSortieTable.add(new Component[]{descriptionParamInput});
        TextField indexParamInput = new TextField("MethodePurification.parametres.index", (IModel)new PropertyModel((Object)this.newParamModel, "index"));
        typesEnSortieTable.add(new Component[]{indexParamInput});
        2 addButton = new /* Unavailable Anonymous Inner Class!! */;
        typesEnSortieTable.add(new Component[]{addButton});
        SubmittableButton createButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        createButton.setVisibilityAllowed(createMode);
        formView.add(new Component[]{createButton});
        formView.add(new Component[]{typesEnSortieTable});
        SubmittableButton updateButton = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        updateButton.setVisibilityAllowed(!createMode);
        formView.add(new Component[]{updateButton});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(!createMode);
        deleteButton.setDefaultFormProcessing(false);
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        formView.add(new Component[]{deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.setDefaultButton((IFormSubmittingComponent)addButton);
        this.add(new Component[]{formView});
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.methodePurificationModel.getObject(), this.getSession().getLocale(), new String[0]));
        for (ParamMethoPuri curDelParam : this.paramsDeleted.values()) {
            if (!this.purificationService.isParamMethoPuriReferenced(curDelParam)) continue;
            this.getPage().error((Serializable)((Object)this.getString("ParamMethoPuri.isReferenced", (IModel)new Model((Serializable)new Serializable[]{curDelParam.getNom()}))));
        }
    }

    static /* synthetic */ IModel access$000(ManageMethodePurificationPage x0) {
        return x0.methodePurificationModel;
    }

    static /* synthetic */ HashMap access$100(ManageMethodePurificationPage x0) {
        return x0.paramsDeleted;
    }

    static /* synthetic */ IModel access$200(ManageMethodePurificationPage x0) {
        return x0.newParamModel;
    }

    static /* synthetic */ ModelValidator access$300(ManageMethodePurificationPage x0) {
        return x0.validator;
    }

    static /* synthetic */ Logger access$400() {
        return LOG;
    }

    static /* synthetic */ PurificationService access$500(ManageMethodePurificationPage x0) {
        return x0.purificationService;
    }

    static /* synthetic */ String[] access$600(ManageMethodePurificationPage x0) {
        return x0.RETURN_PARAM;
    }

    static /* synthetic */ void access$700(ManageMethodePurificationPage x0) {
        x0.validateModel();
    }
}

