/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.config;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.MethodeExtraction;
import nc.ird.cantharella.data.model.TypeExtrait;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.ExtractionService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.config.ManageMethodeExtractionPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthRoles(value={AuthRole.ADMIN})
public final class ManageMethodeExtractionPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_UPDATE = "Update";
    public static final String ACTION_DELETE = "Delete";
    private final String[] RETURN_PARAM = new String[]{"methodeExtraction", "opened"};
    private static final Logger LOG = LoggerFactory.getLogger(ManageMethodeExtractionPage.class);
    private final IModel<MethodeExtraction> methodeExtractionModel;
    private IModel<TypeExtrait> newTypeExtraitModel;
    @SpringBean
    private ExtractionService extraitService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private HashMap<String, TypeExtrait> typesDeleted = new HashMap();

    public ManageMethodeExtractionPage() {
        this(null);
    }

    public ManageMethodeExtractionPage(Integer idMethode) {
        super(ManageMethodeExtractionPage.class);
        boolean createMode;
        this.newTypeExtraitModel = new Model((Serializable)new TypeExtrait());
        if (idMethode == null) {
            this.methodeExtractionModel = new Model((Serializable)new MethodeExtraction());
            createMode = true;
        } else {
            try {
                this.methodeExtractionModel = new Model((Serializable)this.extraitService.loadMethodeExtraction(idMethode));
            }
            catch (DataNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            createMode = false;
        }
        Form formView = new Form("Form");
        formView.add(new Component[]{new TextField("MethodeExtraction.nom", (IModel)new PropertyModel((Object)this.methodeExtractionModel, "nom"))});
        formView.add(new Component[]{new TextArea("MethodeExtraction.description", (IModel)new PropertyModel((Object)this.methodeExtractionModel, "description"))});
        WebMarkupContainer typesEnSortieTable = new WebMarkupContainer("MethodeExtraction.typesEnSortie.Table");
        typesEnSortieTable.setOutputMarkupId(true);
        typesEnSortieTable.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        TextField initialesInput = new TextField("MethodeExtraction.typesEnSortie.initiales", (IModel)new PropertyModel((Object)this.newTypeExtraitModel, "initiales"));
        typesEnSortieTable.add(new Component[]{initialesInput});
        TextField descriptionInput = new TextField("MethodeExtraction.typesEnSortie.description", (IModel)new PropertyModel((Object)this.newTypeExtraitModel, "description"));
        typesEnSortieTable.add(new Component[]{descriptionInput});
        2 addButton = new /* Unavailable Anonymous Inner Class!! */;
        typesEnSortieTable.add(new Component[]{addButton});
        SubmittableButton createButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        createButton.setVisibilityAllowed(createMode);
        formView.add(new Component[]{createButton});
        formView.add(new Component[]{typesEnSortieTable});
        SubmittableButton updateButton = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        updateButton.setVisibilityAllowed(!createMode);
        formView.add(new Component[]{updateButton});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(!createMode);
        deleteButton.setDefaultFormProcessing(false);
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        formView.add(new Component[]{deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.setDefaultButton((IFormSubmittingComponent)addButton);
        this.add(new Component[]{formView});
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.methodeExtractionModel.getObject(), this.getSession().getLocale(), new String[0]));
        for (TypeExtrait curDelType : this.typesDeleted.values()) {
            if (!this.extraitService.isTypeExtraitReferenced(curDelType)) continue;
            this.getPage().error((Serializable)((Object)this.getString("TypeExtrait.isReferenced", (IModel)new Model((Serializable)new Serializable[]{curDelType.getInitiales()}))));
        }
    }

    static /* synthetic */ IModel access$000(ManageMethodeExtractionPage x0) {
        return x0.methodeExtractionModel;
    }

    static /* synthetic */ HashMap access$100(ManageMethodeExtractionPage x0) {
        return x0.typesDeleted;
    }

    static /* synthetic */ IModel access$200(ManageMethodeExtractionPage x0) {
        return x0.newTypeExtraitModel;
    }

    static /* synthetic */ ModelValidator access$300(ManageMethodeExtractionPage x0) {
        return x0.validator;
    }

    static /* synthetic */ Logger access$400() {
        return LOG;
    }

    static /* synthetic */ ExtractionService access$500(ManageMethodeExtractionPage x0) {
        return x0.extraitService;
    }

    static /* synthetic */ String[] access$600(ManageMethodeExtractionPage x0) {
        return x0.RETURN_PARAM;
    }

    static /* synthetic */ void access$700(ManageMethodeExtractionPage x0) {
        x0.validateModel();
    }
}

