/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.campagne;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.CampagnePersonneParticipant;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.CampagneService;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.service.services.StationService;
import nc.ird.cantharella.utils.CollectionTools;
import nc.ird.cantharella.web.config.WebContext;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.document.panel.ManageListDocumentsPanel;
import nc.ird.cantharella.web.pages.renderers.PersonneRenderer;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.AutoCompleteTextFieldString;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.models.DisplayMapValuePropertyModel;
import nc.ird.cantharella.web.utils.panels.SimpleTooltipPanel;
import nc.ird.cantharella.web.utils.renderers.MapChoiceRenderer;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.StringValueConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthRoles(value={AuthRole.ADMIN, AuthRole.USER})
public final class ManageCampagnePage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_DELETE = "Delete";
    private static final String ACTION_UPDATE = "Update";
    private static final Logger LOG = LoggerFactory.getLogger(ManageCampagnePage.class);
    private Button addParticipant;
    private Button addStation;
    private AbstractSingleSelectChoice<Personne> availablePersonnes;
    private AbstractSingleSelectChoice<Station> availableStations;
    private final CallerPage callerPage;
    private final IModel<Campagne> campagneModel;
    @SpringBean
    private CampagneService campagneService;
    @SpringBean
    private StationService stationService;
    private final IModel<CampagnePersonneParticipant> participantModel;
    private final IModel<Station> stationModel;
    private final List<Personne> personnes;
    private final List<Station> stations;
    @SpringBean
    private PersonneService personneService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    FormComponent<String> complementView;
    private boolean multipleEntry;

    public ManageCampagnePage(CallerPage callerPage, boolean multipleEntry) {
        this(null, null, callerPage, multipleEntry);
    }

    public ManageCampagnePage(Integer idCampagne, CallerPage callerPage) {
        this(idCampagne, null, callerPage, false);
    }

    public ManageCampagnePage(Campagne campagne, CallerPage callerPage) {
        this(null, campagne, callerPage, true);
    }

    private ManageCampagnePage(Integer idCampagne, Campagne campagne, CallerPage callerPage, boolean multipleEntry) {
        super(ManageCampagnePage.class);
        boolean createMode;
        assert (idCampagne == null || campagne == null);
        this.callerPage = callerPage;
        CallerPage currentPage = new CallerPage((TemplatePage)this);
        this.multipleEntry = multipleEntry;
        try {
            this.campagneModel = new Model((Serializable)(idCampagne == null && campagne == null ? new Campagne() : (campagne != null ? campagne : this.campagneService.loadCampagne(idCampagne))));
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        boolean bl = createMode = idCampagne == null;
        if (createMode) {
            ((Campagne)this.campagneModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.participantModel = new Model((Serializable)new CampagnePersonneParticipant());
        ((CampagnePersonneParticipant)this.participantModel.getObject()).getId().setPk1((AbstractModel)this.campagneModel.getObject());
        this.stationModel = new Model((Serializable)new Station());
        List programmes = this.campagneService.listCampagneProgrammes();
        this.personnes = this.personneService.listPersonnes();
        this.stations = this.stationService.listStations(this.getSession().getUtilisateur());
        Form formView = new Form("Form");
        formView.add(new Component[]{new TextField("Campagne.nom", (IModel)new PropertyModel((Object)this.campagneModel, "nom"))});
        formView.add(new Component[]{new DropDownChoice("Campagne.codePays", (IModel)new PropertyModel((Object)this.campagneModel, "codePays"), (List)WebContext.COUNTRY_CODES.get(this.getSession().getLocale()), (IChoiceRenderer)new MapChoiceRenderer((Map)WebContext.COUNTRIES.get(this.getSession().getLocale())))});
        if (((Campagne)this.campagneModel.getObject()).getCodePays() == null) {
            ((Campagne)this.campagneModel.getObject()).setCodePays((String)((Map)WebContext.COUNTRIES.get(this.getSession().getLocale())).entrySet().iterator().next().getKey());
        }
        formView.add(new Component[]{new DateTextField("Campagne.dateDeb", (IModel)new PropertyModel((Object)this.campagneModel, "dateDeb")).add(new Behavior[]{new DatePicker()})});
        formView.add(new Component[]{new DateTextField("Campagne.dateFin", (IModel)new PropertyModel((Object)this.campagneModel, "dateFin")).add(new Behavior[]{new DatePicker()})});
        formView.add(new Component[]{new TextArea("Campagne.mentionLegale", (IModel)new PropertyModel((Object)this.campagneModel, "mentionLegale"))});
        formView.add(new Component[]{new SimpleTooltipPanel("Campagne.mentionLegale.info", this.getStringModel("Campagne.mentionLegale.info", new Object[0]))});
        formView.add(new Component[]{new TextArea("Campagne.complement", (IModel)new PropertyModel((Object)this.campagneModel, "complement"))});
        formView.add(new Component[]{new SimpleTooltipPanel("Campagne.complement.info", this.getStringModel("Campagne.complement.info", new Object[0]))});
        formView.add(new Component[]{new TextField("Campagne.createur", (IModel)new PropertyModel((Object)this.campagneModel, "createur")).setEnabled(false)});
        formView.add(new Component[]{new AutoCompleteTextFieldString("Campagne.programme", (IModel)new PropertyModel((Object)this.campagneModel, "programme"), programmes, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        this.initParticipantsFields(formView);
        this.initStationsFields(formView);
        ManageListDocumentsPanel manageListDocumentsPanel = new ManageListDocumentsPanel("ManageListDocumentsPanel", this.campagneModel, currentPage);
        manageListDocumentsPanel.setUpdateOrDeleteEnabled(createMode || this.campagneService.updateOrdeleteCampagneEnabled((Campagne)this.campagneModel.getObject(), this.getSession().getUtilisateur()));
        formView.add(new Component[]{manageListDocumentsPanel});
        SubmittableButton createButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        createButton.setVisibilityAllowed(createMode);
        formView.add(new Component[]{createButton});
        SubmittableButton updateButton = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        updateButton.setVisibilityAllowed(!createMode && this.campagneService.updateOrdeleteCampagneEnabled((Campagne)this.campagneModel.getObject(), this.getSession().getUtilisateur()));
        formView.add(new Component[]{updateButton});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(!createMode && this.campagneService.updateOrdeleteCampagneEnabled((Campagne)this.campagneModel.getObject(), this.getSession().getUtilisateur()));
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        deleteButton.setDefaultFormProcessing(false);
        formView.add(new Component[]{deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.cleanPersonnesChoice();
        this.cleanStationsChoice();
        this.add(new Component[]{formView});
    }

    private void initParticipantsFields(Form<Void> formView) {
        WebMarkupContainer participantsTable = new WebMarkupContainer("Campagne.participants.Table");
        participantsTable.setOutputMarkupId(true);
        participantsTable.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.availablePersonnes = new DropDownChoice("Campagne.participant", (IModel)new PropertyModel((Object)this.participantModel, "id.pk2"), new ArrayList(), (IChoiceRenderer)new PersonneRenderer());
        this.availablePersonnes.setNullValid(false);
        this.availablePersonnes.setOutputMarkupId(true);
        participantsTable.add(new Component[]{this.availablePersonnes});
        this.complementView = new TextField("CampagnePersonneParticipant.complement", (IModel)new PropertyModel((Object)this.participantModel, "complement"));
        participantsTable.add(new Component[]{this.complementView});
        this.addParticipant = new /* Unavailable Anonymous Inner Class!! */;
        participantsTable.add(new Component[]{this.addParticipant});
        formView.add(new Component[]{participantsTable});
        participantsTable.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private void initStationsFields(Form<Void> formView) {
        WebMarkupContainer stationsTable = new WebMarkupContainer("Campagne.stations.Table");
        stationsTable.setOutputMarkupId(true);
        stationsTable.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.availableStations = new DropDownChoice("Campagne.station", this.stationModel, new ArrayList());
        this.availableStations.setNullValid(false);
        this.availableStations.setOutputMarkupId(true);
        stationsTable.add(new Component[]{this.availableStations});
        Label codePaysLabel = new Label("Campagne.station.codePays", (IModel)new DisplayMapValuePropertyModel((Object)this.stationModel, "codePays", (Map)WebContext.COUNTRIES.get(this.getSession().getLocale())));
        codePaysLabel.setOutputMarkupId(true);
        stationsTable.add(new Component[]{codePaysLabel});
        Label localiteLabel = new Label("Campagne.station.localite", (IModel)new PropertyModel((Object)this.stationModel, "localite"));
        localiteLabel.setOutputMarkupId(true);
        stationsTable.add(new Component[]{localiteLabel});
        Label latitudeLabel = new Label("Campagne.station.latitude", (IModel)new PropertyModel((Object)this.stationModel, "latitude"));
        latitudeLabel.setOutputMarkupId(true);
        stationsTable.add(new Component[]{latitudeLabel});
        Label longitudeLabel = new Label("Campagne.station.longitude", (IModel)new PropertyModel((Object)this.stationModel, "longitude"));
        longitudeLabel.setOutputMarkupId(true);
        stationsTable.add(new Component[]{longitudeLabel});
        this.availableStations.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        this.addStation = new /* Unavailable Anonymous Inner Class!! */;
        stationsTable.add(new Component[]{this.addStation});
        formView.add(new Component[]{stationsTable});
        stationsTable.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    protected void onBeforeRender() {
        this.refreshModel();
        super.onBeforeRender();
    }

    private void redirect() {
        if (this.multipleEntry) {
            Campagne nextCampagne = new Campagne();
            nextCampagne.setCodePays(((Campagne)this.campagneModel.getObject()).getCodePays());
            nextCampagne.setProgramme(((Campagne)this.campagneModel.getObject()).getProgramme());
            nextCampagne.setMentionLegale(((Campagne)this.campagneModel.getObject()).getMentionLegale());
            this.setResponsePage((Page)new ManageCampagnePage(nextCampagne, this.callerPage));
        } else if (this.callerPage != null) {
            this.callerPage.addPageParameter(Campagne.class.getSimpleName(), (Object)((Campagne)this.campagneModel.getObject()).getIdCampagne());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void refreshModel() {
        String key = Personne.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(key)) {
            CollectionTools.setter((Collection)this.personnes, (Collection)this.personneService.listPersonnes());
            this.cleanPersonnesChoice();
            try {
                Personne createdPersonne = this.personneService.loadPersonne(Integer.valueOf(this.getPageParameters().get(key).toInt()));
                ((CampagnePersonneParticipant)this.participantModel.getObject()).getId().setPk2((AbstractModel)createdPersonne);
            }
            catch (StringValueConversionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            catch (DataNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            this.getPageParameters().remove(key, new String[0]);
        }
        key = Station.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(key)) {
            CollectionTools.setter((Collection)this.stations, (Collection)this.stationService.listStations(this.getSession().getUtilisateur()));
            this.cleanStationsChoice();
            try {
                Station createdStation = this.stationService.loadStation(Integer.valueOf(this.getPageParameters().get(key).toInt()));
                this.stationModel.setObject((Object)createdStation);
            }
            catch (StringValueConversionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            catch (DataNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            this.getPageParameters().remove(key, new String[0]);
        }
    }

    private void cleanPersonnesChoice() {
        ArrayList choices = new ArrayList(this.personnes);
        for (CampagnePersonneParticipant participant : ((Campagne)this.campagneModel.getObject()).getParticipants()) {
            for (Personne personne : this.personnes) {
                if (((Personne)participant.getId().getPk2()).getIdPersonne() != personne.getIdPersonne()) continue;
                choices.remove(personne);
            }
        }
        this.availablePersonnes.setChoices(choices);
        this.availablePersonnes.setEnabled(!choices.isEmpty());
        this.addParticipant.setEnabled(!choices.isEmpty());
        this.complementView.setEnabled(!choices.isEmpty());
    }

    private void cleanStationsChoice() {
        ArrayList choices = new ArrayList(this.stations);
        for (Station curStationAdded : ((Campagne)this.campagneModel.getObject()).getStations()) {
            for (Station curStation : this.stations) {
                if (curStationAdded.getIdStation() != curStation.getIdStation()) continue;
                choices.remove(curStation);
            }
        }
        this.availableStations.setChoices(choices);
        this.availableStations.setEnabled(!choices.isEmpty());
        this.addStation.setEnabled(!choices.isEmpty());
        this.availableStations.setEnabled(!choices.isEmpty());
    }

    private void validateModel() {
        if (((Campagne)this.campagneModel.getObject()).getCreateur() == null) {
            ((Campagne)this.campagneModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.addValidationErrors((Collection)this.validator.validate(this.campagneModel.getObject(), this.getSession().getLocale(), new String[]{"nom", "codePays", "programme", "complement", "createur"}));
        List dateErrors = this.validator.validate(this.campagneModel.getObject(), this.getSession().getLocale(), new String[]{"dateDeb", "dateFin"});
        this.addValidationErrors((Collection)dateErrors);
        if (dateErrors.isEmpty() && (((Campagne)this.campagneModel.getObject()).getDateDeb() == null || ((Campagne)this.campagneModel.getObject()).getDateFin() == null || !((Campagne)this.campagneModel.getObject()).getDateDeb().before(((Campagne)this.campagneModel.getObject()).getDateFin()))) {
            this.getPage().error((Serializable)this.getStringModel("Campagne.dates.KO", new Object[0]));
        }
    }

    static /* synthetic */ IModel access$000(ManageCampagnePage x0) {
        return x0.campagneModel;
    }

    static /* synthetic */ CampagneService access$100(ManageCampagnePage x0) {
        return x0.campagneService;
    }

    static /* synthetic */ void access$200(ManageCampagnePage x0) {
        x0.redirect();
    }

    static /* synthetic */ void access$300(ManageCampagnePage x0) {
        x0.validateModel();
    }

    static /* synthetic */ void access$400(ManageCampagnePage x0) {
        x0.cleanPersonnesChoice();
    }

    static /* synthetic */ void access$500(ManageCampagnePage x0) {
        x0.refreshModel();
    }

    static /* synthetic */ AbstractSingleSelectChoice access$600(ManageCampagnePage x0) {
        return x0.availablePersonnes;
    }

    static /* synthetic */ IModel access$700(ManageCampagnePage x0) {
        return x0.participantModel;
    }

    static /* synthetic */ Logger access$800() {
        return LOG;
    }

    static /* synthetic */ void access$900(ManageCampagnePage x0) {
        x0.cleanStationsChoice();
    }

    static /* synthetic */ AbstractSingleSelectChoice access$1000(ManageCampagnePage x0) {
        return x0.availableStations;
    }

    static /* synthetic */ IModel access$1100(ManageCampagnePage x0) {
        return x0.stationModel;
    }
}

