/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.utils.models;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import nc.ird.cantharella.data.config.DataContext;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.utils.AssertTools;
import nc.ird.cantharella.web.utils.models.GenericLoadableDetachableModel;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadableDetachableSortableListDataProvider<M extends AbstractModel>
extends SortableDataProvider<M, String> {
    private static final Logger LOG = LoggerFactory.getLogger(LoadableDetachableSortableListDataProvider.class);
    private final Comparator<Object> comparator;
    private List<M> list;
    private final Locale locale;
    static final String CODE_PAYS_PROPERTY = "codePays";

    public LoadableDetachableSortableListDataProvider(List<M> list, Locale locale) {
        AssertTools.assertNotNull(list);
        AssertTools.assertIn((Object)locale, (Collection)DataContext.LOCALES);
        this.list = list;
        this.locale = locale;
        this.comparator = new NullComparator(true);
    }

    public Iterator<? extends M> iterator(long first, long count) {
        if (this.getSort() != null && !StringUtils.isEmpty((CharSequence)((CharSequence)this.getSort().getProperty()))) {
            Collections.sort(this.list, new /* Unavailable Anonymous Inner Class!! */);
        }
        return this.list.subList((int)first, (int)Math.min(first + count, this.size())).iterator();
    }

    public GenericLoadableDetachableModel<M> model(M object) {
        return new GenericLoadableDetachableModel(object);
    }

    public long size() {
        return this.list.size();
    }

    public List<M> getList() {
        return this.list;
    }

    public void setList(List<M> list) {
        this.list = list;
    }

    static /* synthetic */ Locale access$000(LoadableDetachableSortableListDataProvider x0) {
        return x0.locale;
    }

    static /* synthetic */ Comparator access$100(LoadableDetachableSortableListDataProvider x0) {
        return x0.comparator;
    }

    static /* synthetic */ Logger access$200() {
        return LOG;
    }
}

