/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.utils.columns;

import java.util.Map;
import nc.ird.cantharella.web.utils.models.DisplayMapValuePropertyModel;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.export.IExportableColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;

public class MapValuePropertyColumn<T, S, U>
extends AbstractColumn<T, S>
implements IExportableColumn<T, S, Object> {
    private final String propertyExpression;
    private final Map<U, String> map;

    public MapValuePropertyColumn(IModel<String> displayModel, S sortProperty, String propertyExpression, Map<U, String> map) {
        super(displayModel, sortProperty);
        this.propertyExpression = propertyExpression;
        this.map = map;
    }

    public void populateItem(Item<ICellPopulator<T>> cellItem, String componentId, IModel<T> rowModel) {
        cellItem.add(new Component[]{new Label(componentId, this.getDataModel(rowModel))});
    }

    public IModel<Object> getDataModel(IModel<T> rowModel) {
        return new DisplayMapValuePropertyModel(rowModel.getObject(), this.propertyExpression, this.map);
    }
}

