/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.specimen;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Specimen;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.service.services.SpecimenService;
import nc.ird.cantharella.service.services.StationService;
import nc.ird.cantharella.utils.BeanTools;
import nc.ird.cantharella.utils.CollectionTools;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.document.panel.ManageListDocumentsPanel;
import nc.ird.cantharella.web.pages.renderers.PersonneRenderer;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.AutoCompleteTextFieldString;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.renderers.EnumChoiceRenderer;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.StringValueConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthRoles(value={AuthRole.USER, AuthRole.ADMIN})
public final class ManageSpecimenPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_DELETE = "Delete";
    private static final String ACTION_UPDATE = "Update";
    private static final Logger LOG = LoggerFactory.getLogger(ManageSpecimenPage.class);
    private final IModel<Specimen> specimenModel;
    @SpringBean
    private SpecimenService specimenService;
    private final List<Personne> personnes;
    private final List<Station> stations;
    @SpringBean
    private PersonneService personneService;
    @SpringBean
    private StationService stationService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private final CallerPage callerPage;
    private boolean multipleEntry;

    public ManageSpecimenPage(CallerPage callerPage, boolean multipleEntry) {
        this(null, null, callerPage, multipleEntry);
    }

    public ManageSpecimenPage(Integer idSpecimen, CallerPage callerPage) {
        this(idSpecimen, null, callerPage, false);
    }

    public ManageSpecimenPage(Specimen specimen, CallerPage callerPage) {
        this(null, specimen, callerPage, true);
    }

    private ManageSpecimenPage(Integer idSpecimen, Specimen specimen, CallerPage callerPage, boolean multipleEntry) {
        super(ManageSpecimenPage.class);
        boolean createMode;
        assert (idSpecimen == null || specimen == null);
        this.callerPage = callerPage;
        this.multipleEntry = multipleEntry;
        CallerPage currentPage = new CallerPage((TemplatePage)this);
        try {
            this.specimenModel = new Model((Serializable)(idSpecimen == null && specimen == null ? new Specimen() : (specimen != null ? specimen : this.specimenService.loadSpecimen(idSpecimen))));
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        boolean bl = createMode = idSpecimen == null;
        if (createMode) {
            ((Specimen)this.specimenModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.personnes = this.personneService.listPersonnes();
        this.stations = this.stationService.listStations(this.getSession().getUtilisateur());
        List embranchements = this.specimenService.listSpecimenEmbranchements();
        List familles = this.specimenService.listSpecimenFamilles();
        List genres = this.specimenService.listSpecimenGenres();
        List especes = this.specimenService.listSpecimenEspeces();
        List sousEspeces = this.specimenService.listSpecimenSousEspeces();
        List varietes = this.specimenService.listSpecimenVarietes();
        List lieuxDepot = this.specimenService.listLieuxDepot();
        if (specimen != null) {
            if (((Specimen)this.specimenModel.getObject()).getIdentificateur() != null) {
                ((Specimen)this.specimenModel.getObject()).setIdentificateur((Personne)CollectionTools.findWithValue((List)this.personnes, (String)"idPersonne", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Specimen)this.specimenModel.getObject()).getIdentificateur().getIdPersonne()));
            }
            if (((Specimen)this.specimenModel.getObject()).getStation() != null) {
                ((Specimen)this.specimenModel.getObject()).setStation((Station)CollectionTools.findWithValue((List)this.stations, (String)"idStation", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Specimen)this.specimenModel.getObject()).getStation().getIdStation()));
            }
        }
        Form formView = new Form("Form");
        formView.add(new Component[]{new TextField("Specimen.ref", (IModel)new PropertyModel((Object)this.specimenModel, "ref"))});
        formView.add(new Component[]{new AutoCompleteTextFieldString("Specimen.embranchement", (IModel)new PropertyModel((Object)this.specimenModel, "embranchement"), embranchements, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        formView.add(new Component[]{new AutoCompleteTextFieldString("Specimen.famille", (IModel)new PropertyModel((Object)this.specimenModel, "famille"), familles, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        formView.add(new Component[]{new AutoCompleteTextFieldString("Specimen.genre", (IModel)new PropertyModel((Object)this.specimenModel, "genre"), genres, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        formView.add(new Component[]{new AutoCompleteTextFieldString("Specimen.espece", (IModel)new PropertyModel((Object)this.specimenModel, "espece"), especes, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        formView.add(new Component[]{new AutoCompleteTextFieldString("Specimen.sousEspece", (IModel)new PropertyModel((Object)this.specimenModel, "sousEspece"), sousEspeces, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        formView.add(new Component[]{new AutoCompleteTextFieldString("Specimen.variete", (IModel)new PropertyModel((Object)this.specimenModel, "variete"), varietes, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        DropDownChoice typeOrganismeInput = new DropDownChoice("Specimen.typeOrganisme", (IModel)new PropertyModel((Object)this.specimenModel, "typeOrganisme"), Arrays.asList(Specimen.TypeOrganisme.values()), (IChoiceRenderer)new EnumChoiceRenderer((TemplatePage)this));
        typeOrganismeInput.setNullValid(false);
        formView.add(new Component[]{typeOrganismeInput});
        formView.add(new Component[]{new DropDownChoice("Specimen.identificateur", (IModel)new PropertyModel((Object)this.specimenModel, "identificateur"), this.personnes, (IChoiceRenderer)new PersonneRenderer()).setNullValid(true)});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{new DropDownChoice("Specimen.station", (IModel)new PropertyModel((Object)this.specimenModel, "station"), this.stations).setNullValid(true)});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{new TextArea("Specimen.complement", (IModel)new PropertyModel((Object)this.specimenModel, "complement"))});
        formView.add(new Component[]{new TextField("Specimen.createur", (IModel)new PropertyModel((Object)this.specimenModel, "createur")).setEnabled(false)});
        formView.add(new Component[]{new TextField("Specimen.numDepot", (IModel)new PropertyModel((Object)this.specimenModel, "numDepot"))});
        formView.add(new Component[]{new DateTextField("Specimen.dateDepot", (IModel)new PropertyModel((Object)this.specimenModel, "dateDepot")).add(new Behavior[]{new DatePicker()})});
        formView.add(new Component[]{new AutoCompleteTextFieldString("Specimen.lieuDepot", (IModel)new PropertyModel((Object)this.specimenModel, "lieuDepot"), lieuxDepot, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        ManageListDocumentsPanel manageListDocumentsPanel = new ManageListDocumentsPanel("ManageListDocumentsPanel", this.specimenModel, currentPage);
        manageListDocumentsPanel.setUpdateOrDeleteEnabled(createMode || this.specimenService.updateOrdeleteSpecimenEnabled((Specimen)this.specimenModel.getObject(), this.getSession().getUtilisateur()));
        formView.add(new Component[]{manageListDocumentsPanel});
        SubmittableButton createButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        createButton.setVisibilityAllowed(createMode);
        formView.add(new Component[]{createButton});
        SubmittableButton updateButton = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        updateButton.setVisibilityAllowed(!createMode && this.specimenService.updateOrdeleteSpecimenEnabled((Specimen)this.specimenModel.getObject(), this.getSession().getUtilisateur()));
        formView.add(new Component[]{updateButton});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(!createMode && this.specimenService.updateOrdeleteSpecimenEnabled((Specimen)this.specimenModel.getObject(), this.getSession().getUtilisateur()));
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        deleteButton.setDefaultFormProcessing(false);
        formView.add(new Component[]{deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{formView});
    }

    protected void onBeforeRender() {
        this.refreshModel();
        super.onBeforeRender();
    }

    private void redirect() {
        if (this.multipleEntry) {
            Specimen nextSpecimen = new Specimen();
            nextSpecimen.setTypeOrganisme(((Specimen)this.specimenModel.getObject()).getTypeOrganisme());
            nextSpecimen.setEmbranchement(((Specimen)this.specimenModel.getObject()).getEmbranchement());
            nextSpecimen.setIdentificateur(((Specimen)this.specimenModel.getObject()).getIdentificateur());
            nextSpecimen.setStation(((Specimen)this.specimenModel.getObject()).getStation());
            nextSpecimen.setLieuDepot(((Specimen)this.specimenModel.getObject()).getLieuDepot());
            this.setResponsePage((Page)new ManageSpecimenPage(nextSpecimen, this.callerPage));
        } else if (this.callerPage != null) {
            this.callerPage.addPageParameter(Specimen.class.getSimpleName(), (Object)((Specimen)this.specimenModel.getObject()).getIdSpecimen());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void refreshModel() {
        String key = Personne.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(key)) {
            CollectionTools.setter((Collection)this.personnes, (Collection)this.personneService.listPersonnes());
            try {
                Personne createdPersonne = this.personneService.loadPersonne(Integer.valueOf(this.getPageParameters().get(key).toInt()));
                ((Specimen)this.specimenModel.getObject()).setIdentificateur(createdPersonne);
            }
            catch (StringValueConversionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            catch (DataNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            this.getPageParameters().remove(key, new String[0]);
        }
        key = Station.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(key)) {
            CollectionTools.setter((Collection)this.stations, (Collection)this.stationService.listStations(this.getSession().getUtilisateur()));
            try {
                Station createdStation = this.stationService.loadStation(Integer.valueOf(this.getPageParameters().get(key).toInt()));
                ((Specimen)this.specimenModel.getObject()).setStation(createdStation);
            }
            catch (StringValueConversionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            catch (DataNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            this.getPageParameters().remove(key, new String[0]);
        }
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.specimenModel.getObject(), this.getSession().getLocale(), new String[0]));
    }

    static /* synthetic */ IModel access$000(ManageSpecimenPage x0) {
        return x0.specimenModel;
    }

    static /* synthetic */ SpecimenService access$100(ManageSpecimenPage x0) {
        return x0.specimenService;
    }

    static /* synthetic */ void access$200(ManageSpecimenPage x0) {
        x0.redirect();
    }

    static /* synthetic */ void access$300(ManageSpecimenPage x0) {
        x0.validateModel();
    }
}

