/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.search;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.model.SearchBean;
import nc.ird.cantharella.service.model.SearchResult;
import nc.ird.cantharella.service.services.ExtractionService;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.cantharella.service.services.MoleculeService;
import nc.ird.cantharella.service.services.PurificationService;
import nc.ird.cantharella.service.services.SearchService;
import nc.ird.cantharella.service.services.SpecimenService;
import nc.ird.cantharella.service.services.StationService;
import nc.ird.cantharella.service.services.TestBioService;
import nc.ird.cantharella.web.config.WebContext;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.extraction.ListExtractionsPage;
import nc.ird.cantharella.web.pages.domain.lot.ListLotsPage;
import nc.ird.cantharella.web.pages.domain.molecule.ListMoleculesPage;
import nc.ird.cantharella.web.pages.domain.purification.ListPurificationsPage;
import nc.ird.cantharella.web.pages.domain.search.SearchPage;
import nc.ird.cantharella.web.pages.domain.specimen.ListSpecimensPage;
import nc.ird.cantharella.web.pages.domain.station.ListStationsPage;
import nc.ird.cantharella.web.pages.domain.testBio.ListTestsBioPage;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.renderers.MapChoiceRenderer;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

@AuthRoles(value={AuthRole.ADMIN, AuthRole.USER})
public class SearchPage
extends TemplatePage {
    protected Model<SearchBean> queryModel;
    @SpringBean
    protected SearchService searchService;
    @SpringBean
    protected SpecimenService specimenService;
    @SpringBean
    protected LotService lotService;
    @SpringBean
    protected ExtractionService extractionService;
    @SpringBean
    protected PurificationService purificationService;
    @SpringBean
    protected TestBioService testBioService;
    @SpringBean
    protected StationService stationService;
    @SpringBean
    protected MoleculeService moleculeService;

    public SearchPage() {
        this(null);
    }

    public SearchPage(SearchBean queryBean) {
        super(SearchPage.class);
        CallerPage currentPage = new CallerPage((TemplatePage)this);
        ExternalLink link = new ExternalLink("advancedLink", "http://lucene.apache.org/core/3_6_2/queryparsersyntax.html");
        this.add(new Component[]{link});
        this.queryModel = Model.of((Serializable)(queryBean == null ? new SearchBean() : queryBean));
        1 searchForm = new /* Unavailable Anonymous Inner Class!! */;
        searchForm.add(new Component[]{new TextField("SearchPage.Query", (IModel)new PropertyModel((Object)this.queryModel, "query"))});
        searchForm.add(new Component[]{new DropDownChoice("SearchPage.Country", (IModel)new PropertyModel((Object)this.queryModel, "country"), (List)WebContext.COUNTRY_CODES.get(this.getSession().getLocale()), (IChoiceRenderer)new MapChoiceRenderer((Map)WebContext.COUNTRIES.get(this.getSession().getLocale())))});
        this.add(new Component[]{searchForm});
        Utilisateur utilisateur = this.getSession().getUtilisateur();
        SearchResult searchResult = this.searchService.search((SearchBean)this.queryModel.getObject(), utilisateur);
        List molecules = searchResult.getMolecules();
        List moleculeProvenances = this.moleculeService.listMoleculeProvenances(molecules, utilisateur);
        DataTable specimensDataTable = ListSpecimensPage.initSpecimensDataTable((TemplatePage)this, (String)"SearchPage.Specimens.Results", (CallerPage)currentPage, (List)searchResult.getSpecimens(), (SpecimenService)this.specimenService);
        this.add(new Component[]{specimensDataTable});
        DataTable lotsDataTable = ListLotsPage.initLotsDataTable((TemplatePage)this, (String)"SearchPage.Lots.Results", (CallerPage)currentPage, (List)searchResult.getLots(), (LotService)this.lotService);
        this.add(new Component[]{lotsDataTable});
        DataTable extractionsDataTable = ListExtractionsPage.initExtractionsDataTable((TemplatePage)this, (String)"SearchPage.Extractions.Results", (CallerPage)currentPage, (List)searchResult.getExtractions(), (ExtractionService)this.extractionService);
        this.add(new Component[]{extractionsDataTable});
        DataTable purificationsDataTable = ListPurificationsPage.initPurificationsDataTable((TemplatePage)this, (String)"SearchPage.Purifications.Results", (CallerPage)currentPage, (List)searchResult.getPurifications(), (PurificationService)this.purificationService);
        this.add(new Component[]{purificationsDataTable});
        DataTable testBiosDataTable = ListTestsBioPage.initTestsBioDataTable((TemplatePage)this, (String)"SearchPage.ResultatTestBios.Results", (CallerPage)currentPage, (List)searchResult.getResultatTestBios(), (TestBioService)this.testBioService);
        this.add(new Component[]{testBiosDataTable});
        DataTable stationsDataTable = ListStationsPage.initStationsDataTable((TemplatePage)this, (String)"SearchPage.Stations.Results", (CallerPage)currentPage, (List)searchResult.getStations(), (StationService)this.stationService);
        this.add(new Component[]{stationsDataTable});
        DataTable moleculesDataTable = ListMoleculesPage.initMoleculesDataTable((TemplatePage)this, (String)"SearchPage.Molecules.Results", (CallerPage)currentPage, (List)moleculeProvenances);
        this.add(new Component[]{moleculesDataTable});
    }
}

